/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.inspector.task;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.ide.inspector.task.GuiExecutor;

public abstract class BackgroundTask<V>
implements Runnable,
Future<V> {
    private final FutureTask<V> computation = new Computation(new Callable<V>(){

        @Override
        public V call() throws Exception {
            return BackgroundTask.this.compute();
        }
    });

    protected void setProgress(final int current, final int max) {
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                BackgroundTask.this.onProgress(current, max);
            }
        });
    }

    protected abstract V compute() throws Exception;

    protected void onCompletion(V result, Throwable exception, boolean cancelled) {
    }

    protected void onProgress(int current, int max) {
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.computation.cancel(mayInterruptIfRunning);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.computation.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.computation.get(timeout, unit);
    }

    @Override
    public boolean isCancelled() {
        return this.computation.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.computation.isDone();
    }

    @Override
    public void run() {
        this.computation.run();
    }

    private class Computation
    extends FutureTask<V> {
        public Computation(Callable<V> callable) {
            super(callable);
        }

        @Override
        protected final void done() {
            GuiExecutor.instance().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object value = null;
                    Throwable thrown = null;
                    boolean cancelled = false;
                    try {
                        value = Computation.this.get();
                    }
                    catch (ExecutionException e) {
                        thrown = e.getCause();
                    }
                    catch (CancellationException e) {
                        cancelled = true;
                    }
                    catch (InterruptedException consumed) {
                    }
                    finally {
                        BackgroundTask.this.onCompletion(value, thrown, cancelled);
                    }
                }
            });
        }
    }
}

