/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import oracle.bali.inspector.editor.EditorComponentFactory;
import oracle.bali.inspector.editor.EditorComponentFactoryRegistry;
import oracle.bali.inspector.editor.EditorComponentSetup;
import oracle.bali.inspector.editor.EditorComponentSetupRegistry;
import oracle.bali.inspector.editor.TextFieldEditorBehavior;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.inspector.InspectableViewRegistry;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.inspector.editor.CheckBoxEditorFactory;
import oracle.ide.inspector.editor.CheckBoxEditorSetup;
import oracle.ide.inspector.editor.ExtendedTextFieldEditorFactory;
import oracle.ide.inspector.editor.ExtendedTextFieldEditorSetup;
import oracle.ide.inspector.layout.PropertyFormLayoutFactory;
import oracle.ide.layout.ViewId;
import oracle.ide.util.ClassUtils;
import oracle.ide.view.Pinnable;
import oracle.ide.view.View;
import oracle.ideimpl.docking.AutoExpander;
import oracle.ideimpl.inspector.InspectorWindowImpl;
import oracle.ideimpl.inspector.PIHook;
import oracle.javatools.util.ModelUtil;

public class InspectorManagerImpl
extends InspectorManager
implements Addin {
    public static final int TOGGLE_TOOLBAR_CMD_ID;
    public static final int TOGGLE_PAGE_CMD_ID;
    public static final int CUSTOMIZER_CMD_ID;
    public static final int AUTO_EXTEND_CMD_ID;
    public static final int HELP_CMD_ID;
    private static IdeAction CUSTOMIZER_CMD_ACTION;
    private static IdeAction AUTO_EXTEND_CMD_ACTION;
    private static IdeAction HELP_CMD_ACTION;
    public static final String SINGLETON = "SingletonInspectorWindow";
    private static final String SUPPORTERS_PROP = "Inspector.inspectedViews";
    private static final String DETRACTORS_PROP = "Inspector.nonInspectedViews";
    private static final Logger LOGGER;

    protected InspectorManagerImpl() {
        InspectorManager.setInspectorManager(this);
    }

    public DockableView showLastView(Context context) {
        return this._showView(super.showLastView(context));
    }

    public DockableView showView(Context context) {
        return this._showView(super.showView(context));
    }

    private DockableView _showView(DockableView view) {
        if (!(view instanceof InspectorWindowImpl)) {
            return view;
        }
        InspectorWindowImpl window = (InspectorWindowImpl)view;
        if (!window.isToolbarVisible()) {
            window.setToolbarVisible(true);
        }
        AutoExpander.instance().autoExpand((Dockable)view);
        return view;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int id;
        InspectorWindowImpl window;
        View view = context.getView();
        InspectorWindowImpl inspectorWindowImpl = window = view instanceof InspectorWindowImpl ? (InspectorWindowImpl)view : null;
        if (window == null) {
            return super.handleEvent(action, context);
        }
        int n = id = action != null ? action.getCommandId() : -1;
        if (id == CUSTOMIZER_CMD_ID) {
            window.showCustomizer();
            return true;
        }
        if (id == AUTO_EXTEND_CMD_ID) {
            window.enableOrDisableAutoExtend(action.getState());
            return true;
        }
        if (id == HELP_CMD_ID) {
            window.showHelp();
            return true;
        }
        switch (id) {
            case 11: 
            case 13: {
                this.fireFocusLost();
            }
            default: {
                return super.handleEvent(action, context);
            }
            case 67: 
        }
        this.newWindow(this.currentEditorContext());
        return true;
    }

    private void fireFocusLost() {
        FocusListener[] fListeners;
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component fcomp = kfm.getFocusOwner();
        if (fcomp != null && (fListeners = fcomp.getFocusListeners()) != null) {
            for (FocusListener flistener : fListeners) {
                if (!(flistener instanceof TextFieldEditorBehavior)) continue;
                FocusEvent fakeEvent = new FocusEvent(fcomp, 1005, false);
                flistener.focusLost(fakeEvent);
            }
        }
    }

    private InspectorWindowImpl newWindow(Context context) {
        InspectorWindowImpl window = (InspectorWindowImpl)this.showView(null);
        if (window != null) {
            window.viewSelectionChanged(context);
        }
        return window;
    }

    private Context currentEditorContext() {
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager == null) {
            return null;
        }
        Editor editor = editorManager.getCurrentEditor();
        if (editor == null) {
            return null;
        }
        View editorView = editor.getViewWithoutDecoration();
        if (editorView == null) {
            return null;
        }
        return editorView.getContext();
    }

    public boolean update(IdeAction action, Context context) {
        if (action == null) {
            return false;
        }
        int cmdId = action.getCommandId();
        View view = context.getView();
        if (cmdId == 70) {
            if (!(view instanceof InspectorWindowImpl)) {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == 71) {
            if (!(view instanceof InspectorWindowImpl)) {
                action.setEnabled(false);
            }
            return true;
        }
        boolean updateValue = super.update(action, context);
        return updateValue;
    }

    public void initialize() {
        super.initialize();
        PropertyFormLayoutFactory.addFormLayoutFactory(PIHook.getPIHook());
    }

    protected String getViewCategory() {
        return "InspectorWindow";
    }

    protected String getAcceleratorFile() {
        return null;
    }

    protected String getDefaultName() {
        return SINGLETON;
    }

    protected DockableFactory getDockableFactory() {
        return null;
    }

    protected IdeAction createShowAction() {
        IdeAction action = IdeAction.find((String)"Ide.INSPECTOR_CMD_ID");
        return action;
    }

    protected float getToggleToolbarMenuWeight() {
        return MenuConstants.WEIGHT_VIEW_PROPERTY_INSPECTOR;
    }

    protected IdeAction createToggleToolbarAction() {
        return IdeAction.find((int)TOGGLE_TOOLBAR_CMD_ID);
    }

    protected DockableView createDockableView(Context context, ViewId viewId) {
        InspectorWindowImpl view = new InspectorWindowImpl(viewId.getId());
        if (view != null && context != null) {
            view.setContext(context);
        }
        return view;
    }

    protected DockableView getRelativeView(Context context, ViewId viewId) {
        DockableView lastView = this.getLastView();
        if (lastView != null) {
            return lastView;
        }
        Dockable palette = DockStation.getDockStation().findDockable(new ViewId("PALETTEFACTORY.PALETTE"));
        if (palette instanceof DockableView) {
            return (DockableView)palette;
        }
        return null;
    }

    protected int getOrientation(ViewId viewId, DockableView relative) {
        return relative != null ? 4 : 1;
    }

    @Override
    public boolean supportsInspection(View view) {
        if (view == null) {
            return false;
        }
        Class<?> viewType = view.getClass();
        String viewTypeName = viewType.getName();
        Class<?> closest = null;
        for (MetaClass supporterClassMeta : InspectableViewRegistry.instance().supporters()) {
            String supporterClassName = supporterClassMeta.getClassName();
            if (ModelUtil.areEqual((Object)viewTypeName, (Object)supporterClassName)) {
                return true;
            }
            if (!ClassUtils.isInstanceOf(viewType, (String)supporterClassName)) continue;
            closest = viewType;
            break;
        }
        for (MetaClass detractorClassMeta : InspectableViewRegistry.instance().detractors()) {
            if (ModelUtil.areEqual((Object)viewTypeName, (Object)detractorClassMeta.getClassName())) {
                return false;
            }
            Class detractor = null;
            try {
                detractor = detractorClassMeta.toClass();
            }
            catch (Exception e) {
                continue;
            }
            if (viewType == detractor) {
                return false;
            }
            if (!detractor.isAssignableFrom(viewType)) continue;
            if (closest == null) {
                return false;
            }
            if (!closest.isAssignableFrom(detractor)) continue;
            return false;
        }
        return closest != null;
    }

    static IdeAction getCustomizerCmdAction() {
        return IdeAction.find((int)CUSTOMIZER_CMD_ID);
    }

    static IdeAction getAutoExtendCmdAction() {
        return IdeAction.find((int)AUTO_EXTEND_CMD_ID);
    }

    static IdeAction getHelpAction() {
        return IdeAction.find((int)HELP_CMD_ID);
    }

    public DockableView getLastView() {
        DockableView defaultView;
        ArrayList<DockableView> views = new ArrayList<DockableView>(this.getViews());
        if (!views.contains(defaultView = this.getDefaultView(null))) {
            views.add(defaultView);
        }
        if (views.size() > 1) {
            Collections.reverse(views);
        }
        for (DockableView view : views) {
            if (view instanceof Pinnable && 0 != ((Pinnable)view).getPinState()) continue;
            return view;
        }
        return null;
    }

    static {
        StringTokenizer tokenizer;
        TOGGLE_TOOLBAR_CMD_ID = Ide.findOrCreateCmdID((String)"Inspector.TOGGLE_TOOLBAR_CMD_ID");
        TOGGLE_PAGE_CMD_ID = Ide.findOrCreateCmdID((String)"Inspector.TOGGLE_PAGE_CMD_ID");
        CUSTOMIZER_CMD_ID = Ide.findOrCreateCmdID((String)"Inspector.CUSTOMIZER_CMD_ID");
        AUTO_EXTEND_CMD_ID = Ide.findOrCreateCmdID((String)"Inspector.AUTO_EXTEND_CMD_ID");
        HELP_CMD_ID = Ide.findOrCreateCmdID((String)"Inspector.HELP_CMD_ID");
        LOGGER = Logger.getLogger(InspectorManagerImpl.class.getName());
        String views = Ide.getProperty((String)SUPPORTERS_PROP);
        InspectableViewRegistry registry = InspectableViewRegistry.instance();
        if (views != null) {
            if ("OSGi".equalsIgnoreCase(System.getProperty("oracle.ide.classload.layer"))) {
                LOGGER.warning("Inspector.inspectedViews system property is set to " + Ide.getProperty((String)SUPPORTERS_PROP) + " but will be ignored as this is no longer the way to register Properties window supporters");
            } else {
                tokenizer = new StringTokenizer(views, ";");
                while (tokenizer.hasMoreTokens()) {
                    registry.registerSupporter(tokenizer.nextToken());
                }
            }
        }
        if ((views = Ide.getProperty((String)DETRACTORS_PROP)) != null) {
            if ("OSGi".equalsIgnoreCase(System.getProperty("oracle.ide.classload.layer"))) {
                LOGGER.warning("Inspector.nonInspectedViews system property is set to " + Ide.getProperty((String)DETRACTORS_PROP) + " but will be ignored as this is no longer the way to register property inspector detractors");
            } else {
                tokenizer = new StringTokenizer(views, ";");
                while (tokenizer.hasMoreTokens()) {
                    registry.registerDetractor(tokenizer.nextToken());
                }
            }
        }
        ExtendedTextFieldEditorFactory extTextFieldEditorFactory = new ExtendedTextFieldEditorFactory();
        EditorComponentFactoryRegistry factoryRegistry = EditorComponentFactoryRegistry.instance();
        factoryRegistry.register((EditorComponentFactory)extTextFieldEditorFactory);
        factoryRegistry.addDefaultEditorFactory((EditorComponentFactory)extTextFieldEditorFactory);
        factoryRegistry.register((EditorComponentFactory)new CheckBoxEditorFactory());
        EditorComponentSetupRegistry setupRegistry = EditorComponentSetupRegistry.instance();
        setupRegistry.register((EditorComponentSetup)new ExtendedTextFieldEditorSetup());
        setupRegistry.register((EditorComponentSetup)new CheckBoxEditorSetup());
    }
}

