/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.inspector.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ide.util.MetaClass;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.inspector.layout.AutoExpandPreferredSize;
import oracle.ide.inspector.layout.Element;
import oracle.ide.inspector.layout.PropertyFormLayout;
import oracle.ideimpl.inspector.layout.DefaultCategoryLayout;
import oracle.javatools.data.HashStructure;

public final class DefaultPropertyFormLayout
extends PropertyFormLayout {
    private final HashStructure _hash;
    private final MetaClass _mclass;
    private final AutoExpandPreferredSize autoExpandPreferredSize;
    private ClassLoader _classLoader = null;
    private List<Element> _categoryLayouts;

    public DefaultPropertyFormLayout(HashStructure hash) {
        this._hash = hash;
        this._mclass = LazyClassAdapter.getInstance((HashStructure)this._hash).getMetaClass("property-model-class");
        this.autoExpandPreferredSize = AutoExpandPreferredSize.find(this._hash.getString("auto-extend-preferred-size"));
    }

    public DefaultPropertyFormLayout(HashStructure hash, ClassLoader classLoader) {
        this(hash);
        this._classLoader = classLoader;
    }

    @Override
    public AutoExpandPreferredSize getAutoExtendPreferredSize() {
        return this.autoExpandPreferredSize;
    }

    @Override
    public MetaClass getPropertyModelClass() {
        return this._mclass;
    }

    @Override
    public List<Element> getChildren() {
        if (null == this._categoryLayouts) {
            this._categoryLayouts = new ArrayList<Element>();
            List list = this._hash.getAsList("category-layout");
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    HashStructure hs = (HashStructure)list.get(i);
                    this._categoryLayouts.add(new DefaultCategoryLayout(hs, this._classLoader));
                }
            }
        }
        return Collections.unmodifiableList(this._categoryLayouts);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultPropertyFormLayout)) {
            return false;
        }
        DefaultPropertyFormLayout that = (DefaultPropertyFormLayout)object;
        if (!(this._hash != null ? this._hash.equals((Object)that._hash) : that._hash == null)) {
            return false;
        }
        if (!(this._mclass != null ? this._mclass.equals((Object)that._mclass) : that._mclass == null)) {
            return false;
        }
        if (!(this.autoExpandPreferredSize != null ? this.autoExpandPreferredSize.equals(that.autoExpandPreferredSize) : that.autoExpandPreferredSize == null)) {
            return false;
        }
        List<Element> ours = this.getChildren();
        List<Element> theirs = that.getChildren();
        return ours != null ? ours.equals(theirs) : theirs == null;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = super.hashCode();
        result = 37 * result + (this._hash == null ? 0 : this._hash.hashCode());
        result = 37 * result + (this._mclass == null ? 0 : this._mclass.hashCode());
        result = 37 * result + (this.autoExpandPreferredSize == null ? 0 : this.autoExpandPreferredSize.hashCode());
        List<Element> children = this.getChildren();
        result = 37 * result + (children == null ? 0 : children.hashCode());
        return result;
    }
}

