/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools.program;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.externaltools.ExternalProgramToolProperties;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolBaseProperties;
import oracle.ide.externaltools.ExternalToolOptionsEnvironment;
import oracle.ide.externaltools.ExternalToolOptionsPage;
import oracle.ide.externaltools.macro.MacroExpander;
import oracle.ide.externaltools.macro.MacroTextField;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.externaltools.ExternalToolsArb;
import oracle.ideimpl.externaltools.ExternalToolsBundle;
import oracle.javatools.dialogs.ExceptionDialog;

public class ExternalProgramOptions
extends JPanel
implements ExternalToolOptionsPage {
    private static URL s_lastExecutablePath;
    private static URL s_lastRunDirectory;
    private transient ExternalToolOptionsEnvironment m_env;
    private GridBagLayout gblDetailsPanel = new GridBagLayout();
    private JLabel labHint = new JLabel();
    private JLabel labExecutable = new JLabel();
    private MacroTextField tfExecutable;
    private JButton btnBrowseExecutable = new JButton();
    private JLabel labArguments = new JLabel();
    private MacroTextField tfArguments;
    private JButton btnBrowseArguments = new JButton();
    private JLabel labRunInDirectory = new JLabel();
    private MacroTextField tfRunInDirectory;
    private JButton btnBrowseDirectory = new JButton();
    private JButton btnDirectoryMacros = new JButton();
    private JPanel dummyPanel = new JPanel();
    private boolean _isRunDirectoryModified = false;
    private boolean _isAutoSettingRunDirectory = false;

    public ExternalProgramOptions() {
        this.jbInit();
    }

    @Override
    public String getHelpTopicID() {
        return "f1_idedexternaltools2_html";
    }

    private void jbInit() {
        this.tfRunInDirectory = new MacroTextField(true, false);
        this.tfArguments = new MacroTextField();
        this.tfExecutable = new MacroTextField(false, true);
        this.tfExecutable.getDocument().addDocumentListener(new DocumentListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doIt() {
                try {
                    boolean isComplete;
                    if (!ExternalProgramOptions.this._isRunDirectoryModified) {
                        try {
                            File f;
                            ExternalProgramOptions.this._isAutoSettingRunDirectory = true;
                            if (ExternalProgramOptions.this.tfExecutable.getText().trim().length() == 0) {
                                ExternalProgramOptions.this.tfRunInDirectory.setText("");
                            }
                            if ((f = new File(ExternalProgramOptions.this.tfExecutable.getText())) != null) {
                                String parentPath = f.getParent();
                                if (parentPath != null) {
                                    ExternalProgramOptions.this.tfRunInDirectory.setText(parentPath);
                                }
                            } else {
                                ExternalProgramOptions.this.tfRunInDirectory.setText("");
                            }
                        }
                        finally {
                            ExternalProgramOptions.this._isAutoSettingRunDirectory = false;
                        }
                    }
                    ExternalProgramOptions.this.firePropertyChange("isComplete", !(isComplete = ExternalProgramOptions.this.isComplete()), isComplete);
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)ExternalProgramOptions.this.getGUI(), (Throwable)re);
                }
            }

            @Override
            public void insertUpdate(DocumentEvent de) {
                this.doIt();
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                this.doIt();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                this.doIt();
            }
        });
        this.tfRunInDirectory.getDocument().addDocumentListener(new DocumentListener(){

            private void doIt() {
                if (!ExternalProgramOptions.this._isAutoSettingRunDirectory) {
                    ExternalProgramOptions.this._isRunDirectoryModified = true;
                }
            }

            @Override
            public void insertUpdate(DocumentEvent de) {
                this.doIt();
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                this.doIt();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                this.doIt();
            }
        });
        ActionDispatcher al = new ActionDispatcher();
        this.btnBrowseDirectory.addActionListener(al);
        this.btnBrowseExecutable.addActionListener(al);
        this.btnBrowseArguments.addActionListener(al);
        this.btnDirectoryMacros.addActionListener(al);
        this.setLayout(this.gblDetailsPanel);
        this.btnBrowseArguments.setEnabled(false);
        this.labHint.setText("<html>" + ExternalToolsBundle.get("PROGRAM_HINT") + "</html>");
        ResourceUtils.resLabel((JLabel)this.labExecutable, (Component)((Object)this.tfExecutable), (String)ExternalToolsArb.getString(20));
        ResourceUtils.resButton((AbstractButton)this.btnBrowseExecutable, (String)ExternalToolsArb.getString(21));
        ResourceUtils.resLabel((JLabel)this.labArguments, (Component)((Object)this.tfArguments), (String)ExternalToolsArb.getString(22));
        ResourceUtils.resButton((AbstractButton)this.btnBrowseArguments, (String)ExternalToolsArb.getString(23));
        ResourceUtils.resLabel((JLabel)this.labRunInDirectory, (Component)((Object)this.tfRunInDirectory), (String)ExternalToolsArb.getString(24));
        ResourceUtils.resButton((AbstractButton)this.btnBrowseDirectory, (String)ExternalToolsArb.getString(25));
        ResourceUtils.resButton((AbstractButton)this.btnDirectoryMacros, (String)ExternalToolsArb.getString(26));
        this.add((Component)this.labHint, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.labExecutable, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)((Object)this.tfExecutable), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.btnBrowseExecutable, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add((Component)this.labArguments, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)((Object)this.tfArguments), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.btnBrowseArguments, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add((Component)this.labRunInDirectory, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)((Object)this.tfRunInDirectory), new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.btnBrowseDirectory, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add((Component)this.btnDirectoryMacros, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add((Component)this.dummyPanel, new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public Component getInitialFocus() {
        return this.tfExecutable;
    }

    private void doBrowseExecutable() {
        URL url = null;
        url = this.tfExecutable.getText().trim().length() == 0 ? (s_lastExecutablePath == null ? URLFactory.newFileURL((String)Ide.getProductHomeDirectory()) : s_lastExecutablePath) : URLFactory.newFileURL((String)this.tfExecutable.getText());
        URLChooser urc = url != null && URLFileSystem.exists((URL)url) ? DialogUtil.newURLChooser((URL)url) : DialogUtil.newURLChooser();
        urc.setSelectionMode(0);
        if (urc.showOpenDialog((Component)this, ExternalToolsArb.getString(27)) == 0) {
            URL result = urc.getSelectedURL();
            this.tfExecutable.setText(URLFileSystem.getPlatformPathName((URL)result));
        }
        s_lastExecutablePath = urc.getSelectedURL();
    }

    private void doBrowseDirectory() {
        URL url = null;
        url = this.tfRunInDirectory.getText().trim().length() == 0 ? (s_lastRunDirectory == null ? URLFactory.newFileURL((String)Ide.getProductHomeDirectory()) : s_lastRunDirectory) : URLFactory.newFileURL((String)this.tfRunInDirectory.getText());
        URLChooser urc = url != null && URLFileSystem.exists((URL)url) && URLFileSystem.isDirectory((URL)url) ? DialogUtil.newURLChooser((URL)url) : DialogUtil.newURLChooser();
        urc.setSelectionScope(1);
        urc.setSelectionMode(0);
        if (urc.showOpenDialog((Component)this, ExternalToolsArb.getString(29)) == 0) {
            URL result = urc.getSelectedURL();
            this.tfRunInDirectory.setText(URLFileSystem.getPlatformPathName((URL)result));
        }
        s_lastRunDirectory = urc.getSelectedURL();
    }

    private void doBrowseArguments() {
        this.runMacroPicker(false, (JTextField)((Object)this.tfArguments));
    }

    private void doBrowseDirectoryMacros() {
        this.runMacroPicker(true, (JTextField)((Object)this.tfRunInDirectory));
    }

    private void runMacroPicker(boolean directories, JTextField field) {
        MacroExpander macro;
        if (this.m_env != null && (macro = this.m_env.getMacroPicker(directories).runDialog(this)) != null) {
            try {
                field.getDocument().insertString(field.getCaretPosition(), macro.toMacroString(), null);
            }
            catch (BadLocationException ble) {
                ExceptionDialog.showExceptionDialog((Component)this.getGUI(), (Throwable)ble);
            }
            field.requestFocus();
        }
    }

    @Override
    public void setEnvironment(ExternalToolOptionsEnvironment env) {
        this.m_env = env;
        this.tfExecutable.configure(env.getMacroRegistry(), env.getType(), false);
        this.tfRunInDirectory.configure(env.getMacroRegistry(), env.getType(), true);
        this.tfArguments.configure(env.getMacroRegistry(), env.getType(), false);
        this.btnBrowseArguments.setEnabled(true);
    }

    @Override
    public JComponent getGUI() {
        return this;
    }

    @Override
    public String getPageName() {
        return ExternalToolsBundle.get("PROGRAM_PAGE_NAME");
    }

    @Override
    public boolean isComplete() {
        boolean complete = this.tfExecutable.getText().trim().length() > 0;
        this.m_env.setUserCanFinishNow(complete);
        return complete;
    }

    @Override
    public boolean validateOptions() {
        return true;
    }

    @Override
    public void saveOptions(ExternalTool tool, boolean isCreateMode) {
        ExternalProgramToolProperties programProps = ExternalProgramToolProperties.getInstance(tool);
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(tool);
        programProps.setExecutable(this.tfExecutable.getText());
        programProps.setRunDirectory(this.tfRunInDirectory.getText());
        programProps.setArguments(this.tfArguments.getText());
        if (isCreateMode) {
            String executable = this.tfExecutable.getText().trim();
            if (props.getCaption() == null) {
                String toolName = executable;
                if (!this.m_env.isUniqueToolName(toolName = ExternalProgramOptions.createDefaultToolName(toolName))) {
                    toolName = this.m_env.makeUniqueName(toolName);
                }
                props.setCaption(toolName);
            }
            if (props.getIconURL() == null) {
                props.setIconURL(this.m_env.getType().getDefaultIconURL(tool));
            }
        }
    }

    private static String createDefaultToolName(String executableName) {
        int lastDot;
        int lastSep = executableName.lastIndexOf(File.separatorChar);
        if (lastSep > 1) {
            executableName = executableName.substring(lastSep + 1);
        }
        if ((lastDot = executableName.lastIndexOf(46)) != -1) {
            executableName = executableName.substring(0, lastDot);
        }
        if (executableName.length() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(executableName.toLowerCase());
        buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
        executableName = buffer.toString();
        return executableName;
    }

    @Override
    public void loadOptions(ExternalTool tool, boolean isCreateMode) {
        ExternalProgramToolProperties programProps = ExternalProgramToolProperties.getInstance(tool);
        this.tfExecutable.setText(programProps.getExecutable());
        this.tfRunInDirectory.setText(programProps.getRunDirectory());
        this.tfArguments.setText(programProps.getArguments());
        if (!isCreateMode) {
            this._isRunDirectoryModified = true;
        }
    }

    private class ActionDispatcher
    implements ActionListener {
        private ActionDispatcher() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                JButton button = (JButton)ae.getSource();
                if (ExternalProgramOptions.this.btnBrowseExecutable == button) {
                    ExternalProgramOptions.this.doBrowseExecutable();
                } else if (ExternalProgramOptions.this.btnBrowseDirectory == button) {
                    ExternalProgramOptions.this.doBrowseDirectory();
                } else if (ExternalProgramOptions.this.btnBrowseArguments == button) {
                    ExternalProgramOptions.this.doBrowseArguments();
                } else if (ExternalProgramOptions.this.btnDirectoryMacros == button) {
                    ExternalProgramOptions.this.doBrowseDirectoryMacros();
                }
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Component)ExternalProgramOptions.this, (Throwable)re);
            }
        }
    }
}

