/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.util.collections.IlvCollections;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IlvGraphicVector
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8015494179570726991L;
    private static final int a = 10;
    private static final int b = 0;
    private static final String c = "Location of recent modification";
    private static final String d = "The IlvGraphicVector was modified while enumerating its contents. If you are using multiple threads, probably some synchronization is missing. Synchronize adding, removing, accessing and enumerating over elements.\n If you are using only a single thread, probably some objects were added or removed while enumerating over elements. In this case consider using ilog.views.IlvBufferedGraphicEnumeration.\n To debug this situation, check the cause of the exception in the stack trace.";
    private static final String e = "The IlvGraphicVector was modified while enumerating its contents. If you are using multiple threads, probably some synchronization is missing. Synchronize adding, removing, accessing and enumerating over elements.\n If you are using only a single thread, probably some objects were added or removed while enumerating over elements. In this case consider using ilog.views.IlvBufferedGraphicEnumeration.\n To debug this situation, set the static flag ilog.views.IlvGraphicVector.DEBUG to true and check the stack trace.";
    protected int capacityIncrement = 0;
    public static boolean checkConcurrentModification = true;
    public static boolean DEBUG;
    protected int elementCount;
    protected IlvGraphic[] elementData;
    transient int f = 0;
    private transient Exception g = null;

    public IlvGraphicVector() {
        this(10, 0);
    }

    public IlvGraphicVector(int n2) {
        this(n2, 0);
    }

    public IlvGraphicVector(int n2, int n3) {
        this.capacityIncrement = n3;
        this.f = 0;
        this.elementData = new IlvGraphic[n2];
        this.elementCount = 0;
    }

    final void a(Comparator<? super IlvGraphic> comparator) {
        Arrays.sort(this.elementData, 0, this.elementCount, comparator);
        this.a();
    }

    public final boolean contains(IlvGraphic ilvGraphic) {
        return this.indexOf(ilvGraphic, 0) != -1;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public boolean removeElement(IlvGraphic ilvGraphic) {
        int n2 = this.indexOf(ilvGraphic, 0);
        if (n2 == -1) {
            return false;
        }
        this.removeElementAt(n2);
        this.a();
        return true;
    }

    public IlvGraphic elementAt(int n2) {
        if (n2 < this.elementCount) {
            return this.elementData[n2];
        }
        throw new ArrayIndexOutOfBoundsException(n2);
    }

    public IlvGraphicEnumeration elements() {
        return new IlvGraphicEnumeration(){
            int a = 0;
            int b;
            {
                this.b = IlvGraphicVector.this.f;
            }

            public boolean hasMoreElements() {
                return this.a < IlvGraphicVector.this.elementCount;
            }

            public IlvGraphic nextElement() {
                IlvGraphicVector.this.a(this.b);
                if (this.a < IlvGraphicVector.this.elementCount) {
                    return IlvGraphicVector.this.elementData[this.a++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public final IlvGraphic firstElement() {
        if (this.elementCount > 0) {
            return this.elementData[0];
        }
        throw new NoSuchElementException();
    }

    public final IlvGraphic lastElement() {
        try {
            return this.elementData[this.elementCount - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException();
        }
    }

    public final IlvGraphic setElementAt(IlvGraphic ilvGraphic, int n2) {
        if (n2 < this.elementCount) {
            IlvGraphic ilvGraphic2 = this.elementData[n2];
            this.elementData[n2] = ilvGraphic;
            this.a();
            return ilvGraphic2;
        }
        throw new ArrayIndexOutOfBoundsException(n2);
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public int indexOf(IlvGraphic ilvGraphic) {
        return this.indexOf(ilvGraphic, 0);
    }

    public final int indexOf(IlvGraphic ilvGraphic, int n2) {
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (ilvGraphic != null) {
            for (int i2 = n2; i2 < this.elementCount; ++i2) {
                if (!ilvGraphic.equals(this.elementData[i2])) continue;
                return i2;
            }
        } else {
            for (int i3 = n2; i3 < this.elementCount; ++i3) {
                if (this.elementData[i3] != null) continue;
                return i3;
            }
        }
        return -1;
    }

    public final int lastIndexOf(IlvGraphic ilvGraphic) {
        return this.lastIndexOf(ilvGraphic, this.elementCount - 1);
    }

    public final int lastIndexOf(IlvGraphic ilvGraphic, int n2) {
        if (n2 < this.elementCount) {
            if (ilvGraphic != null) {
                for (int i2 = n2; i2 >= 0; --i2) {
                    if (!ilvGraphic.equals(this.elementData[i2])) continue;
                    return i2;
                }
            } else {
                for (int i3 = n2; i3 >= 0; --i3) {
                    if (this.elementData[i3] != null) continue;
                    return i3;
                }
            }
            return -1;
        }
        throw new ArrayIndexOutOfBoundsException(n2);
    }

    public final int size() {
        return this.elementCount;
    }

    public final String toString() {
        if (this.elementCount == 0) {
            return "[]";
        }
        int n2 = this.elementCount - 1;
        StringBuffer stringBuffer = new StringBuffer(this.elementCount * 16);
        stringBuffer.append('[');
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(this.elementData[i2].toString());
            stringBuffer.append(", ");
        }
        stringBuffer.append(this.elementData[n2].toString());
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void addElement(IlvGraphic ilvGraphic) {
        if (this.elementCount == this.elementData.length) {
            this.b();
        }
        this.elementData[this.elementCount++] = ilvGraphic;
        this.a();
    }

    public final void copyInto(IlvGraphic[] ilvGraphicArray) {
        if (ilvGraphicArray.length < this.elementCount) {
            throw new ArrayIndexOutOfBoundsException("Array parameter must hold at least " + this.elementCount + " elements.");
        }
        System.arraycopy(this.elementData, 0, ilvGraphicArray, 0, this.elementCount);
    }

    public void ensureCapacity(int n2) {
        int n3 = this.f;
        if (this.elementData.length < n2) {
            int n4;
            int n5;
            for (n4 = this.elementData.length; n4 < n2; n4 += n5) {
                n5 = (int)Math.ceil((double)n4 * 0.5);
                if (n5 > 1) continue;
                n5 = 1;
            }
            this.b(n4);
        }
        this.a(n3);
    }

    public void insertElementAt(IlvGraphic ilvGraphic, int n2) {
        if (0 <= n2 && n2 <= this.elementCount) {
            int n3;
            if (this.elementCount == this.elementData.length) {
                this.b();
            }
            if ((n3 = this.elementCount - n2) > 0) {
                System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, n3);
            }
            this.elementData[n2] = ilvGraphic;
            ++this.elementCount;
        } else {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        this.a();
    }

    public final void removeAllElements() {
        Arrays.fill(this.elementData, 0, this.elementCount, null);
        this.elementCount = 0;
        this.a();
    }

    public void removeElementAt(int n2) {
        if (0 <= n2 && n2 < this.elementCount) {
            --this.elementCount;
            int n3 = this.elementCount - n2;
            if (n3 > 0) {
                System.arraycopy(this.elementData, n2 + 1, this.elementData, n2, n3);
            }
        } else {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        this.elementData[this.elementCount] = null;
        this.a();
    }

    public final void setSize(int n2) {
        if (n2 == this.elementData.length) {
            return;
        }
        this.b(n2);
    }

    public final void trimToSize() {
        if (this.elementData.length != this.elementCount) {
            this.b(this.elementCount);
        }
    }

    public Object clone() {
        IlvGraphicVector ilvGraphicVector = new IlvGraphicVector(this.elementData.length, this.capacityIncrement);
        ilvGraphicVector.elementData = (IlvGraphic[])this.elementData.clone();
        ilvGraphicVector.elementCount = this.elementCount;
        return ilvGraphicVector;
    }

    final void a() {
        ++this.f;
        if (DEBUG) {
            this.g = new Exception(c);
        }
    }

    final void a(int n2) {
        if (checkConcurrentModification && this.f != n2) {
            String string = e;
            if (DEBUG) {
                string = d;
            }
            throw IlvCollections.concurrentModificationException(string, this.g);
        }
    }

    private void b() {
        int n2 = 0;
        n2 = this.capacityIncrement <= 0 ? (int)((double)this.elementData.length * 0.5) : this.capacityIncrement;
        if (n2 < 1) {
            n2 = 1;
        }
        this.b(this.elementData.length + n2);
    }

    private void b(int n2) {
        Object[] objectArray = new IlvGraphic[n2];
        int n3 = Math.min(n2, this.elementCount);
        System.arraycopy(this.elementData, 0, objectArray, 0, n3);
        if (n2 > this.elementCount) {
            Arrays.fill(objectArray, this.elementCount, n2, null);
        }
        this.elementCount = n3;
        this.elementData = objectArray;
    }
}

