/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvGraphic;
import ilog.views.IlvObjectInteractorContext;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public abstract class IlvHandlesSelection
extends IlvSelection {
    public static final int FILLED_SQUARE_SHAPE = 0;
    public static final int SQUARE_SHAPE = 1;
    public static final int FILLED_CIRCLE_SHAPE = 2;
    public static final int CIRCLE_SHAPE = 3;
    public static int defaultHandleShape = 0;
    public static Color defaultHandleColor = Color.black;
    public static Color defaultHandleBackgroundColor = Color.white;
    public static float defaultHandleSize = 3.0f;
    private int a = defaultHandleShape;
    private float b = defaultHandleSize;
    private Color c = defaultHandleColor;
    private Color d = new Color(0, 0, 200);
    private boolean e = false;

    public IlvHandlesSelection(IlvGraphic ilvGraphic) {
        super(ilvGraphic);
    }

    public Color getHandlesColor() {
        return this.c;
    }

    public void setHandlesColor(Color color) {
        this.c = color;
    }

    public Color getActiveHandlesColor() {
        return this.d;
    }

    public void setActiveHandlesColor(Color color) {
        this.d = color;
    }

    public boolean isActive() {
        return this.e;
    }

    public final float getHandlesSize() {
        return this.b;
    }

    public final void setHandlesSize(float f2) {
        this.b = Math.max(1.0f, f2);
    }

    public final int getHandlesShape() {
        return this.a;
    }

    public final void setHandlesShape(int n2) {
        this.a = n2;
    }

    public abstract IlvPoint getHandle(int var1, IlvTransformer var2);

    public abstract int getHandleCardinal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHandle(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        int n2 = this.getHandleCardinal();
        float f2 = 2.0f * this.b + 1.0f;
        float f3 = ilvPoint.x;
        float f4 = ilvPoint.y;
        this.beforeLoopAllHandles(ilvTransformer);
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                IlvPoint ilvPoint2 = this.getHandle(i2, ilvTransformer);
                if (!(f3 >= ilvPoint2.x - this.b) || !(f3 <= ilvPoint2.x - this.b + f2) || !(f4 >= ilvPoint2.y - this.b) || !(f4 <= ilvPoint2.y - this.b + f2)) continue;
                int n3 = i2;
                return n3;
            }
        }
        finally {
            this.afterLoopAllHandles();
        }
        return -1;
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        return this.getHandle(ilvPoint2, ilvTransformer) != -1;
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (this.a < 2) {
            if (object != RenderingHints.VALUE_ANTIALIAS_OFF) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            } else {
                object = null;
            }
        } else if (object != RenderingHints.VALUE_ANTIALIAS_ON) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            object = null;
        }
        int n2 = this.getHandleCardinal();
        float f2 = 0.0f;
        float f3 = 0.0f;
        this.beforeLoopAllHandles(ilvTransformer);
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvPoint ilvPoint = this.getHandle(i2, ilvTransformer);
            if (i2 == 0 || f2 != ilvPoint.x || f3 != ilvPoint.y) {
                this.a(graphics, ilvPoint.x, ilvPoint.y);
            }
            f2 = ilvPoint.x;
            f3 = ilvPoint.y;
        }
        this.afterLoopAllHandles();
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    public void drawWithoutHandles(Graphics graphics, IlvTransformer ilvTransformer) {
    }

    void a(Graphics graphics, float f2, float f3) {
        int n2 = (int)Math.floor(f2 - this.b);
        int n3 = (int)Math.floor(f3 - this.b);
        int n4 = (int)Math.floor(2.0f * this.b + 1.0f);
        if (this.a == 0 || this.a == 2) {
            graphics.setColor(this.getHandlesColor());
        } else {
            graphics.setColor(defaultHandleBackgroundColor);
        }
        if (this.a < 2) {
            graphics.fillRect(n2, n3, n4, n4);
            if (this.a == 1) {
                graphics.setColor(this.getHandlesColor());
                graphics.drawRect(n2, n3, n4 - 1, n4 - 1);
            }
        } else {
            graphics.fillArc(n2, n3, n4 - 1, n4 - 1, 0, 360);
            if (this.a == 3) {
                graphics.setColor(this.getHandlesColor());
                graphics.drawArc(n2, n3, n4 - 1, n4 - 1, 0, 360);
            }
        }
    }

    public boolean zoomable() {
        return false;
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        int n2 = this.getHandleCardinal();
        if (n2 == 0) {
            IlvRect ilvRect = new IlvRect(0.0f, 0.0f, 1.0E-20f, 1.0E-20f);
            return ilvRect;
        }
        this.beforeLoopAllHandles(ilvTransformer);
        float f2 = 2.0f * this.b + 1.0f;
        IlvPoint ilvPoint = this.getHandle(0, ilvTransformer);
        IlvRect ilvRect = new IlvRect(ilvPoint.x - this.b, ilvPoint.y - this.b, f2, f2);
        IlvRect ilvRect2 = new IlvRect(0.0f, 0.0f, f2, f2);
        for (int i2 = 1; i2 < n2; ++i2) {
            ilvPoint = this.getHandle(i2, ilvTransformer);
            ilvRect2.x = ilvPoint.x - this.b;
            ilvRect2.y = ilvPoint.y - this.b;
            ilvRect.add(ilvRect2);
        }
        this.afterLoopAllHandles();
        return ilvRect;
    }

    protected void beforeLoopAllHandles(IlvTransformer ilvTransformer) {
    }

    protected void afterLoopAllHandles() {
    }

    public void onEnter(IlvObjectInteractorContext ilvObjectInteractorContext) {
        super.onEnter(ilvObjectInteractorContext);
        Color color = this.d;
        this.d = this.c;
        this.c = color;
        this.e = true;
        this.reDraw();
    }

    public void onExit(IlvObjectInteractorContext ilvObjectInteractorContext) {
        super.onExit(ilvObjectInteractorContext);
        Color color = this.d;
        this.d = this.c;
        this.c = color;
        this.e = false;
        this.reDraw();
    }
}

