/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImageSelection;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsInterface;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.internal.IlvUtility;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;

public class IlvLinkImage
extends IlvGraphic
implements IlvPolyPointsInterface {
    IlvGraphic a;
    IlvGraphic b;
    private boolean c;
    private Color d;
    private static final IlvPoint[] e = new IlvPoint[3];

    public IlvLinkImage(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl) {
        this.a = ilvGraphic;
        this.b = ilvGraphic2;
        this.c = bl;
    }

    public IlvLinkImage(IlvLinkImage ilvLinkImage) {
        super(ilvLinkImage);
        this.setForeground(ilvLinkImage.d);
        this.a = ilvLinkImage.a;
        this.b = ilvLinkImage.b;
        this.c = ilvLinkImage.c;
        this.setLineWidth(ilvLinkImage.getLineWidth());
        this.setLineJoin(ilvLinkImage.getLineJoin());
        this.setMaximumLineWidth(ilvLinkImage.getMaximumLineWidth());
        this.setEndCap(ilvLinkImage.getEndCap());
        this.setLineStyle(ilvLinkImage.getLineStyle());
    }

    public IlvLinkImage(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setForeground(ilvInputStream.readColor("foreground"));
        this.setOriented(ilvInputStream.readBoolean("oriented"));
        this.a = ilvInputStream.readObject("from");
        this.b = ilvInputStream.readObject("to");
        try {
            this.setLineWidth(ilvInputStream.readFloat("lineWidth"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setMaximumLineWidth(ilvInputStream.readFloat("maximumLineWidth"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setLineJoin(ilvInputStream.readInt("lineJoin"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setEndCap(ilvInputStream.readInt("endCap"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setLineStyle(ilvInputStream.readFloatArray("lineStyle"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.a(ilvInputStream);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    private void a(IlvInputStream ilvInputStream) throws IlvReadFileException {
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached(this.getFrom());
        if (ilvLinkConnector != null) {
            ilvLinkConnector.read(ilvInputStream, this, true);
        }
        if ((ilvLinkConnector = IlvLinkConnector.GetAttached(this.getTo())) != null) {
            ilvLinkConnector.read(ilvInputStream, this, false);
        }
        ilvLinkConnector = null;
        try {
            ilvLinkConnector = (IlvLinkConnector)ilvInputStream.readPersistentObject("fromLinkConnector");
            ilvLinkConnector.attach(this, true, false);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        if (ilvLinkConnector != null) {
            ilvLinkConnector.read(ilvInputStream, this, true);
        }
        ilvLinkConnector = null;
        try {
            ilvLinkConnector = (IlvLinkConnector)ilvInputStream.readPersistentObject("toLinkConnector");
            ilvLinkConnector.attach(this, false, false);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        if (ilvLinkConnector != null) {
            ilvLinkConnector.read(ilvInputStream, this, false);
        }
    }

    public IlvGraphic copy() {
        return new IlvLinkImage(this);
    }

    public final IlvGraphic getFrom() {
        return this.a;
    }

    public final void setFrom(IlvGraphic ilvGraphic) {
        this.a = ilvGraphic;
    }

    public final IlvGraphic getTo() {
        return this.b;
    }

    public final void setTo(IlvGraphic ilvGraphic) {
        this.b = ilvGraphic;
    }

    public final IlvGraphic getOpposite(IlvGraphic ilvGraphic) {
        if (ilvGraphic == this.b) {
            return this.a;
        }
        if (ilvGraphic == this.a) {
            return this.b;
        }
        throw new IllegalArgumentException("node is not the origin object, nor the destination object");
    }

    public int getPointsCardinal() {
        return 2;
    }

    public boolean allowsPointInsertion() {
        return false;
    }

    public boolean allowsPointRemoval() {
        return false;
    }

    public boolean allowsPointMove(int n2) {
        if (n2 == 0) {
            IlvLinkConnector ilvLinkConnector = IlvLinkConnector.Get(this, true);
            return ilvLinkConnector != null ? ilvLinkConnector.allowsConnectionPointMove(this, true) : false;
        }
        if (n2 == this.getPointsCardinal() - 1) {
            IlvLinkConnector ilvLinkConnector = IlvLinkConnector.Get(this, false);
            return ilvLinkConnector != null ? ilvLinkConnector.allowsConnectionPointMove(this, false) : false;
        }
        return true;
    }

    public void insertPoint(int n2, float f2, float f3, IlvTransformer ilvTransformer) {
    }

    public void removePoint(int n2, IlvTransformer ilvTransformer) {
    }

    public IlvPoint getPointAt(int n2, IlvTransformer ilvTransformer) {
        IlvPoint[] ilvPointArray = this.getLinkPoints(ilvTransformer);
        try {
            return ilvPointArray[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("" + n2);
        }
    }

    public void movePoint(int n2, float f2, float f3, IlvTransformer ilvTransformer) {
        if (n2 == 0) {
            IlvGraphic ilvGraphic = this.a(this.a);
            IlvGraphic ilvGraphic2 = this.a(this.b);
            IlvLinkConnector ilvLinkConnector = IlvLinkConnector.a(this, ilvGraphic, true);
            if (ilvLinkConnector != null) {
                IlvPoint ilvPoint = new IlvPoint(f2, f3);
                if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                    ilvTransformer.apply(ilvPoint);
                }
                IlvTransformer ilvTransformer2 = this.a(ilvGraphic, ilvTransformer);
                IlvPoint ilvPoint2 = ilvLinkConnector.getClosestConnectionPoint(ilvPoint, ilvGraphic, ilvGraphic2, this, true, ilvTransformer2);
                ilvLinkConnector.connectLink(this, ilvPoint2, true, ilvTransformer2);
            }
        } else if (n2 == this.getPointsCardinal() - 1) {
            IlvGraphic ilvGraphic = this.a(this.a);
            IlvGraphic ilvGraphic3 = this.a(this.b);
            IlvLinkConnector ilvLinkConnector = IlvLinkConnector.a(this, ilvGraphic3, false);
            if (ilvLinkConnector != null) {
                IlvPoint ilvPoint = new IlvPoint(f2, f3);
                if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                    ilvTransformer.apply(ilvPoint);
                }
                IlvTransformer ilvTransformer3 = this.a(ilvGraphic3, ilvTransformer);
                IlvPoint ilvPoint3 = ilvLinkConnector.getClosestConnectionPoint(ilvPoint, ilvGraphic, ilvGraphic3, this, false, ilvTransformer3);
                ilvLinkConnector.connectLink(this, ilvPoint3, false, ilvTransformer3);
            }
        }
    }

    public void setIntermediateLinkPoints(IlvPoint[] ilvPointArray, int n2, int n3) {
    }

    public boolean pointsInBBox() {
        return true;
    }

    public IlvPoint getConnectionReferencePoint(boolean bl, IlvTransformer ilvTransformer) {
        if (bl) {
            if (this.getPointsCardinal() <= 2) {
                IlvRect ilvRect = this.getToBoundingBox(ilvTransformer);
                return new IlvPoint(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height / 2.0f);
            }
            return this.getPointAt(1, ilvTransformer);
        }
        if (this.getPointsCardinal() <= 2) {
            IlvRect ilvRect = this.getFromBoundingBox(ilvTransformer);
            return new IlvPoint(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height / 2.0f);
        }
        return this.getPointAt(this.getPointsCardinal() - 2, ilvTransformer);
    }

    private void a(IlvPoint ilvPoint, IlvRect ilvRect, IlvPoint ilvPoint2) {
        if (ilvRect.x + ilvRect.width <= ilvPoint.x) {
            ilvPoint2.x = ilvRect.x + ilvRect.width;
            ilvPoint2.y = ilvRect.y + ilvRect.height / 2.0f;
        } else if (ilvRect.x >= ilvPoint.x) {
            ilvPoint2.x = ilvRect.x;
            ilvPoint2.y = ilvRect.y + ilvRect.height / 2.0f;
        } else if (ilvRect.y >= ilvPoint.y) {
            ilvPoint2.x = ilvRect.x + ilvRect.width / 2.0f;
            ilvPoint2.y = ilvRect.y;
        } else if (ilvRect.y + ilvRect.height <= ilvPoint.y) {
            ilvPoint2.x = ilvRect.x + ilvRect.width / 2.0f;
            ilvPoint2.y = ilvRect.y + ilvRect.height;
        } else {
            ilvPoint2.x = ilvRect.x + ilvRect.width / 2.0f;
            ilvPoint2.y = ilvRect.y + ilvRect.height / 2.0f;
        }
    }

    public void getConnectionPoints(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        boolean bl = this.getLinkConnectorConnectionPoint(true, ilvPoint, ilvTransformer);
        boolean bl2 = this.getLinkConnectorConnectionPoint(false, ilvPoint2, ilvTransformer);
        if (!bl || !bl2) {
            if (this.getPointsCardinal() == 2) {
                if (!bl && !bl2) {
                    IlvRect ilvRect;
                    IlvRect ilvRect2;
                    boolean bl3;
                    boolean bl4 = bl3 = this.a.b == ((IlvGraphic)this).b && this.b.b == ((IlvGraphic)this).b;
                    if (bl3) {
                        ilvRect2 = this.b.boundingBox(ilvTransformer);
                        ilvRect = this.a.boundingBox(ilvTransformer);
                    } else {
                        ilvRect2 = this.getToBoundingBox(ilvTransformer);
                        ilvRect = this.getFromBoundingBox(ilvTransformer);
                    }
                    if (ilvRect.x + ilvRect.width <= ilvRect2.x) {
                        ilvPoint.x = ilvRect.x + ilvRect.width;
                        ilvPoint.y = ilvRect.y + ilvRect.height / 2.0f;
                        ilvPoint2.x = ilvRect2.x;
                        ilvPoint2.y = ilvRect2.y + ilvRect2.height / 2.0f;
                    } else if (ilvRect.x >= ilvRect2.x + ilvRect2.width) {
                        ilvPoint.x = ilvRect.x;
                        ilvPoint.y = ilvRect.y + ilvRect.height / 2.0f;
                        ilvPoint2.x = ilvRect2.x + ilvRect2.width;
                        ilvPoint2.y = ilvRect2.y + ilvRect2.height / 2.0f;
                    } else if (ilvRect.y >= ilvRect2.y + ilvRect2.height) {
                        ilvPoint.x = ilvRect.x + ilvRect.width / 2.0f;
                        ilvPoint.y = ilvRect.y;
                        ilvPoint2.x = ilvRect2.x + ilvRect2.width / 2.0f;
                        ilvPoint2.y = ilvRect2.y + ilvRect2.height;
                    } else if (ilvRect.y + ilvRect.height <= ilvRect2.y) {
                        ilvPoint.x = ilvRect.x + ilvRect.width / 2.0f;
                        ilvPoint.y = ilvRect.y + ilvRect.height;
                        ilvPoint2.x = ilvRect2.x + ilvRect2.width / 2.0f;
                        ilvPoint2.y = ilvRect2.y;
                    } else {
                        ilvPoint.x = ilvRect.x + ilvRect.width / 2.0f;
                        ilvPoint.y = ilvRect.y + ilvRect.height / 2.0f;
                        ilvPoint2.x = ilvRect2.x + ilvRect2.width / 2.0f;
                        ilvPoint2.y = ilvRect2.y + ilvRect2.height / 2.0f;
                    }
                } else if (!bl) {
                    IlvRect ilvRect = this.getFromBoundingBox(ilvTransformer);
                    this.a(ilvPoint2, ilvRect, ilvPoint);
                } else {
                    IlvRect ilvRect = this.getToBoundingBox(ilvTransformer);
                    this.a(ilvPoint, ilvRect, ilvPoint2);
                }
            } else {
                IlvRect ilvRect;
                IlvPoint ilvPoint3;
                if (!bl) {
                    ilvPoint3 = this.getConnectionReferencePoint(true, ilvTransformer);
                    ilvRect = this.getFromBoundingBox(ilvTransformer);
                    this.a(ilvPoint3, ilvRect, ilvPoint);
                }
                if (!bl2) {
                    ilvPoint3 = this.getConnectionReferencePoint(false, ilvTransformer);
                    ilvRect = this.getToBoundingBox(ilvTransformer);
                    this.a(ilvPoint3, ilvRect, ilvPoint2);
                }
            }
        }
    }

    public final boolean getLinkConnectorConnectionPoint(boolean bl, IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint2;
        IlvGraphic ilvGraphic = bl ? this.a : this.b;
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.a(this, ilvGraphic = this.a(ilvGraphic), bl);
        if (ilvLinkConnector != null && (ilvPoint2 = ilvLinkConnector.getConnectionPoint(this, bl, this.a(ilvGraphic, ilvTransformer))) != null) {
            ilvPoint.x = ilvPoint2.x;
            ilvPoint.y = ilvPoint2.y;
            return true;
        }
        return false;
    }

    public final IlvRect getToBoundingBox(IlvTransformer ilvTransformer) {
        IlvGraphic ilvGraphic = this.a(this.b);
        ilvTransformer = this.a(ilvGraphic, ilvTransformer);
        return ilvGraphic.boundingBox(ilvTransformer);
    }

    public final IlvRect getFromBoundingBox(IlvTransformer ilvTransformer) {
        IlvGraphic ilvGraphic = this.a(this.a);
        ilvTransformer = this.a(ilvGraphic, ilvTransformer);
        return ilvGraphic.boundingBox(ilvTransformer);
    }

    public final IlvGraphic getVisibleFrom() {
        return this.a(this.a);
    }

    public final IlvGraphic getVisibleTo() {
        return this.a(this.b);
    }

    private final IlvGraphic a(IlvGraphic ilvGraphic) {
        return IlvUtility.getRealVisibleObject(((IlvGraphic)this).b, ilvGraphic);
    }

    public final IlvTransformer getFromTransformer(IlvTransformer ilvTransformer) {
        return this.a(this.a(this.a), ilvTransformer);
    }

    public final IlvTransformer getToTransformer(IlvTransformer ilvTransformer) {
        return this.a(this.a(this.b), ilvTransformer);
    }

    private final IlvTransformer a(IlvGraphic ilvGraphic, IlvTransformer ilvTransformer) {
        return IlvLinkImage.getLocalTransformerOf(ilvGraphic, ((IlvGraphic)this).b, ilvTransformer);
    }

    public static IlvTransformer getLocalTransformerOf(IlvGraphic ilvGraphic, IlvGraphicBag ilvGraphicBag, IlvTransformer ilvTransformer) {
        IlvGraphicBag ilvGraphicBag2 = ilvGraphicBag;
        IlvGraphicBag ilvGraphicBag3 = null;
        while (ilvGraphicBag != null && !(ilvGraphicBag instanceof IlvManager)) {
            ilvGraphicBag3 = ilvGraphicBag.getGraphicBag();
            if (ilvGraphicBag == ilvGraphicBag3) {
                throw new RuntimeException("Illegal bag of " + ilvGraphicBag + " . The bag of an object must not be " + "the object itself!");
            }
            if (ilvGraphicBag3 == ilvGraphicBag2) {
                throw new RuntimeException("The ancestor bag of " + ilvGraphicBag + " must not be the bag itself!");
            }
            ilvGraphicBag = ilvGraphicBag3;
        }
        return IlvLinkImage.a(ilvGraphic, ilvGraphicBag, ilvTransformer);
    }

    private static IlvTransformer a(IlvGraphic ilvGraphic, IlvGraphicBag ilvGraphicBag, IlvTransformer ilvTransformer) {
        IlvGraphicBag ilvGraphicBag2 = ilvGraphic.b;
        if (ilvGraphicBag == ilvGraphicBag2) {
            return ilvTransformer;
        }
        if (ilvGraphicBag2 instanceof IlvManager) {
            IlvManager ilvManager = (IlvManager)ilvGraphicBag2;
            IlvTransformer ilvTransformer2 = IlvLinkImage.getLocalTransformerOf(ilvManager, ilvGraphicBag, ilvTransformer);
            if (ilvTransformer2 != null) {
                if (ilvTransformer2 == ilvTransformer) {
                    ilvTransformer2 = new IlvTransformer(ilvTransformer2);
                }
                ilvTransformer2.postCompose(ilvManager.j());
                return ilvTransformer2;
            }
            return ilvManager.getTransformer();
        }
        return ilvTransformer;
    }

    public boolean isSpline() {
        return false;
    }

    protected void drawArrow(Graphics graphics, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.c) {
            IlvUtility.drawArrow(graphics, ilvPoint.x, ilvPoint.y, ilvPoint2.x, ilvPoint2.y, 1.0f, this.getArrowSize(this.a(ilvTransformer, false), ilvTransformer));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void draw(Graphics var1_1, IlvTransformer var2_2) {
        block4: {
            block6: {
                block5: {
                    var3_3 = this.getLinkPoints(var2_2);
                    var4_4 = var3_3.length;
                    if (var4_4 <= 1) break block4;
                    var1_1.setColor(this.getForeground());
                    var5_5 = this.getLineWidth();
                    var6_6 = this.getLineStyle();
                    if (var5_5 != 0.0f || var6_6 != null) break block5;
                    IlvGraphicUtil.a(var1_1, var3_3, var4_4, null);
                    break block6;
                }
                var7_7 = this.getMaximumLineWidth();
                var8_8 = this.getArrowSize(this.a(var2_2, false), var2_2);
                var6_6 = IlvStrokeInfo.zoomedLineStyle(var6_6, var5_5, var7_7, var2_2);
                var5_5 = IlvStrokeInfo.zoomedLineWidth(var5_5, var7_7, var2_2, false);
                var9_9 = this.getEndCap();
                if (!this.c) ** GOTO lbl-1000
                if (var8_8 > 4.0f) {
                    var10_10 = var3_3[var4_4 - 1].x;
                    var12_12 = var10_10 - var3_3[var4_4 - 2].x;
                    var11_11 = var3_3[var4_4 - 1].y;
                    var14_13 = var11_11 - var3_3[var4_4 - 2].y;
                    var16_14 = Math.sqrt(var12_12 * var12_12 + var14_13 * var14_13);
                    if ((double)(2.0f * var8_8) > var16_14) {
                        var8_8 = (float)var16_14 / 2.0f;
                    }
                    var18_15 = var9_9 != 0 ? 2.0 * (double)var8_8 : 1.5 * (double)var8_8;
                    var20_16 = 0.0;
                    var22_17 = 0.0;
                    if (var16_14 != 0.0) {
                        var20_16 = -var18_15 * var14_13 / var16_14;
                        var22_17 = var18_15 * var12_12 / var16_14;
                    }
                    var3_3[var4_4 - 1].x += (float)(-var22_17);
                    var3_3[var4_4 - 1].y += (float)var20_16;
                    IlvGraphicUtil.DrawPolyline(var1_1, var3_3, var4_4, var5_5, this.getLineJoin(), var9_9, var6_6, var2_2, true);
                    var3_3[var4_4 - 1].x = var10_10;
                    var3_3[var4_4 - 1].y = var11_11;
                } else lbl-1000:
                // 2 sources

                {
                    IlvGraphicUtil.DrawPolyline(var1_1, var3_3, var4_4, var5_5, this.getLineJoin(), var9_9, var6_6, var2_2, true);
                }
            }
            this.drawArrow(var1_1, var3_3[var4_4 - 2], var3_3[var4_4 - 1], var2_2);
        }
    }

    protected float getArrowSize(float f2, IlvTransformer ilvTransformer) {
        return IlvUtility.arrowSize(f2, ilvTransformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IlvRect arrowBBox(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvPoint[] ilvPointArray = e;
        synchronized (e) {
            IlvUtility.ComputeArrow(ilvPoint.x, ilvPoint.y, ilvPoint2.x, ilvPoint2.y, 1.0f, e, this.getArrowSize(this.a(ilvTransformer, true), ilvTransformer));
            IlvRect ilvRect = new IlvRect();
            IlvUtil.BoundingBox(ilvRect, e, 3);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return ilvRect;
        }
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect;
        float f2 = this.getLineWidth();
        IlvPoint[] ilvPointArray = this.getLinkPoints(ilvTransformer);
        int n2 = ilvPointArray.length;
        if (f2 == 0.0f) {
            ilvRect = IlvGraphicUtil.a(ilvPointArray, n2, null);
        } else {
            f2 = IlvStrokeInfo.zoomedLineWidth(f2, this.getMaximumLineWidth(), ilvTransformer, true);
            double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            ilvRect = IlvGraphicUtil.PolylineBBox(ilvPointArray, n2, (float)((double)f2 * d2), this.getLineJoin(), this.getEndCap(), null);
        }
        if (this.c) {
            ilvRect.add(this.arrowBBox(ilvPointArray[n2 - 2], ilvPointArray[n2 - 1], ilvTransformer));
        }
        if (ilvRect.width < 1.0E-20f) {
            ilvRect.width = 1.0E-20f;
        }
        if (ilvRect.height < 1.0E-20f) {
            ilvRect.height = 1.0E-20f;
        }
        return ilvRect;
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvPoint[] ilvPointArray = this.getLinkPoints(ilvTransformer);
        float f2 = this.getLineWidth();
        if (f2 == 0.0f) {
            return IlvGraphicUtil.a(ilvPoint2, ilvPointArray, ilvPointArray.length, null, true);
        }
        f2 = IlvStrokeInfo.zoomedLineWidth(f2, this.getMaximumLineWidth(), ilvTransformer, false);
        double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        return IlvGraphicUtil.PointInPolyline(ilvPoint2, ilvPointArray, ilvPointArray.length, (float)((double)f2 * d2), this.getLineJoin(), this.getEndCap(), null);
    }

    public boolean zoomable() {
        IlvGraphic ilvGraphic;
        IlvGraphic ilvGraphic2 = this.a(this.a);
        if (!ilvGraphic2.zoomable() || !(ilvGraphic = this.a(this.b)).zoomable()) {
            return false;
        }
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.a(this, ilvGraphic2, true);
        if (ilvLinkConnector != null && !ilvLinkConnector.zoomable()) {
            return false;
        }
        ilvLinkConnector = IlvLinkConnector.a(this, ilvGraphic, false);
        return ilvLinkConnector == null || ilvLinkConnector.zoomable();
    }

    public boolean isOriented() {
        return this.c;
    }

    public void setOriented(boolean bl) {
        this.c = bl;
    }

    public void setForeground(Color color) {
        Color color2 = this.d;
        this.d = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getForeground() {
        return this.d == null ? Color.black : this.d;
    }

    public float getLineWidth() {
        return IlvStrokeInfo.GetLineWidth(this);
    }

    public float getLineWidth(IlvTransformer ilvTransformer) {
        float f2 = this.getLineWidth();
        if (f2 == 0.0f) {
            return 1.0f;
        }
        f2 = IlvStrokeInfo.zoomedLineWidth(f2, this.getMaximumLineWidth(), ilvTransformer, false);
        double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        return Math.max(1.0f, (float)((double)f2 * d2));
    }

    public void setLineWidth(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("bad line Width " + f2);
        }
        if (f2 != this.getLineWidth()) {
            IlvStrokeInfo.SetLineWidth(this, f2);
        }
    }

    public int getEndCap() {
        return IlvStrokeInfo.GetEndCap(this);
    }

    public void setEndCap(int n2) {
        if (n2 != 1 && n2 != 2 && n2 != 0) {
            throw new IllegalArgumentException("bad end cap");
        }
        if (n2 != this.getEndCap()) {
            IlvStrokeInfo.SetEndCap(this, n2);
        }
    }

    public int getLineJoin() {
        return IlvStrokeInfo.GetLineJoin(this);
    }

    public void setLineJoin(int n2) {
        if (n2 != 0 && n2 != 2 && n2 != 1) {
            throw new IllegalArgumentException("bad line join");
        }
        if (n2 != this.getLineJoin()) {
            IlvStrokeInfo.SetLineJoin(this, n2);
        }
    }

    public float getMaximumLineWidth() {
        return IlvStrokeInfo.GetMaximumLineWidth(this);
    }

    public void setMaximumLineWidth(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("limit must be greater than 0 " + f2);
        }
        if (f2 != this.getMaximumLineWidth()) {
            IlvStrokeInfo.SetMaximumLineWidth(this, f2);
        }
    }

    public float[] getLineStyle() {
        return IlvStrokeInfo.GetLineStyle(this);
    }

    public void setLineStyle(float[] fArray) {
        IlvStrokeInfo.SetLineStyle(this, fArray);
    }

    public IlvPoint[] getLinkPoints(IlvTransformer ilvTransformer) {
        IlvPoint[] ilvPointArray = new IlvPoint[]{new IlvPoint(), new IlvPoint()};
        this.getConnectionPoints(ilvPointArray[0], ilvPointArray[1], ilvTransformer);
        return ilvPointArray;
    }

    public IlvSelection makeSelection() {
        return new IlvLinkImageSelection(this);
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        float[] fArray;
        int n2;
        int n3;
        float f2;
        super.write(ilvOutputStream);
        ilvOutputStream.write("foreground", this.getForeground());
        ilvOutputStream.write("oriented", this.isOriented());
        ilvOutputStream.write("from", this.a);
        ilvOutputStream.write("to", this.b);
        float f3 = this.getLineWidth();
        if (f3 != 0.0f) {
            ilvOutputStream.write("lineWidth", f3);
        }
        if ((f2 = this.getMaximumLineWidth()) != 0.0f) {
            ilvOutputStream.write("maximumLineWidth", f2);
        }
        if ((n3 = this.getLineJoin()) != 1) {
            ilvOutputStream.write("lineJoin", n3);
        }
        if ((n2 = this.getEndCap()) != 2) {
            ilvOutputStream.write("endCap", n2);
        }
        if ((fArray = this.getLineStyle()) != null) {
            ilvOutputStream.write("lineStyle", fArray);
        }
        this.a(ilvOutputStream);
    }

    private void a(IlvOutputStream ilvOutputStream) throws IOException {
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached(this.getFrom());
        if (ilvLinkConnector != null && ilvLinkConnector.isPersistent()) {
            ilvLinkConnector.write(ilvOutputStream, this, true);
        }
        if ((ilvLinkConnector = IlvLinkConnector.GetAttached(this.getTo())) != null && ilvLinkConnector.isPersistent()) {
            ilvLinkConnector.write(ilvOutputStream, this, false);
        }
        if ((ilvLinkConnector = IlvLinkConnector.GetAttached(this, true)) != null && ilvLinkConnector.isPersistent()) {
            ilvOutputStream.write("fromLinkConnector", ilvLinkConnector);
            ilvLinkConnector.write(ilvOutputStream, this, true);
        }
        if ((ilvLinkConnector = IlvLinkConnector.GetAttached(this, false)) != null && ilvLinkConnector.isPersistent()) {
            ilvOutputStream.write("toLinkConnector", ilvLinkConnector);
            ilvLinkConnector.write(ilvOutputStream, this, false);
        }
    }

    public boolean isPersistent() {
        return this.a.isPersistent() && this.b.isPersistent();
    }

    protected void finalize() throws Throwable {
        IlvStrokeInfo.DisposeStroke(this);
    }

    private float a(IlvTransformer ilvTransformer, boolean bl) {
        float f2 = this.getLineWidth();
        return f2 == 0.0f ? 0.0f : IlvStrokeInfo.zoomedLineWidth(f2, this.getMaximumLineWidth(), ilvTransformer, bl);
    }

    static {
        for (int i2 = 0; i2 < 3; ++i2) {
            IlvLinkImage.e[i2] = new IlvPoint(0.0f, 0.0f);
        }
    }
}

