/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.form.internal.controller.io;

import ilog.views.appframe.form.internal.controller.IlvEditionContext;
import ilog.views.appframe.form.internal.controller.IlvFormEditor;
import ilog.views.appframe.form.internal.controller.IlvFormSingleEditor;
import ilog.views.appframe.form.internal.controller.io.Util;
import ilog.views.appframe.util.IlvUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public interface IlvStringEvaluatorFunction {
    public static final IlvStringEvaluatorFunction SUM_OPERATOR = new ArithmeticBinaryFunction("+"){

        public double evaluateValues(double d2, double d3) {
            return d2 + d3;
        }

        public String evaluateString(String string, String string2) {
            return string + string2;
        }
    };
    public static final IlvStringEvaluatorFunction MINUS_OPERATOR = new ArithmeticBinaryFunction("-"){

        public double evaluateValues(double d2, double d3) {
            return d2 - d3;
        }
    };
    public static final IlvStringEvaluatorFunction DIV_OPERATOR = new ArithmeticBinaryFunction("/"){

        public double evaluateValues(double d2, double d3) {
            return d2 / d3;
        }
    };
    public static final IlvStringEvaluatorFunction MULT_OPERATOR = new ArithmeticBinaryFunction("*"){

        public double evaluateValues(double d2, double d3) {
            return d2 * d3;
        }
    };
    public static final IlvStringEvaluatorFunction UNARY_MINUS_OPERATOR = new IlvStringEvaluatorFunction(){

        public Object initialize(IlvFormEditor ilvFormEditor, IlvEditionContext ilvEditionContext) {
            return null;
        }

        public void connectUI(IlvFormEditor ilvFormEditor, Object object, IlvEditionContext ilvEditionContext) {
        }

        public void disconnectUI(IlvFormEditor ilvFormEditor, Object object, IlvEditionContext ilvEditionContext) {
        }

        public Object evaluate(Object[] objectArray, Object object, IlvEditionContext ilvEditionContext) {
            if (objectArray[0] instanceof Number) {
                return new Double(-((Number)objectArray[0]).doubleValue());
            }
            throw new IllegalStateException("Cannot apply the unary minus operator to a " + objectArray[0].getClass().getName());
        }

        public String toString() {
            return "-";
        }
    };
    public static final IlvStringEvaluatorFunction EQUALITY_OPERATOR = new IlvStringEvaluatorFunction(){

        public void connectUI(IlvFormEditor ilvFormEditor, Object object, IlvEditionContext ilvEditionContext) {
        }

        public void disconnectUI(IlvFormEditor ilvFormEditor, Object object, IlvEditionContext ilvEditionContext) {
        }

        public Object initialize(IlvFormEditor ilvFormEditor, IlvEditionContext ilvEditionContext) {
            return null;
        }

        public Object evaluate(Object[] objectArray, Object object, IlvEditionContext ilvEditionContext) {
            if (objectArray.length < 2 || objectArray.length > 2) {
                throw new IllegalStateException("The equality function must have too parameters");
            }
            return Util.EqualObjects(objectArray[0], objectArray[1]) ? Boolean.TRUE : Boolean.FALSE;
        }
    };
    public static final IlvStringEvaluatorFunction INEQUALITY_OPERATOR = new IlvStringEvaluatorFunction(){

        public void connectUI(IlvFormEditor ilvFormEditor, Object object, IlvEditionContext ilvEditionContext) {
        }

        public void disconnectUI(IlvFormEditor ilvFormEditor, Object object, IlvEditionContext ilvEditionContext) {
        }

        public Object initialize(IlvFormEditor ilvFormEditor, IlvEditionContext ilvEditionContext) {
            return null;
        }

        public Object evaluate(Object[] objectArray, Object object, IlvEditionContext ilvEditionContext) {
            if (objectArray.length < 2 || objectArray.length > 2) {
                throw new IllegalStateException("The inequality function must have too parameters");
            }
            return Util.EqualObjects(objectArray[0], objectArray[1]) ? Boolean.FALSE : Boolean.TRUE;
        }
    };
    public static final IlvStringEvaluatorFunction NOT_OPERATOR = new IlvStringEvaluatorFunction(){

        public void connectUI(IlvFormEditor ilvFormEditor, Object object, IlvEditionContext ilvEditionContext) {
        }

        public void disconnectUI(IlvFormEditor ilvFormEditor, Object object, IlvEditionContext ilvEditionContext) {
        }

        public Object initialize(IlvFormEditor ilvFormEditor, IlvEditionContext ilvEditionContext) {
            return null;
        }

        public Object evaluate(Object[] objectArray, Object object, IlvEditionContext ilvEditionContext) {
            if (objectArray.length > 1) {
                throw new IllegalStateException("The not operator must only have one parameter");
            }
            return Util.BooleanValue(objectArray[0]) ? Boolean.FALSE : Boolean.TRUE;
        }

        public String toString() {
            return "!";
        }
    };
    public static final IlvStringEvaluatorFunction RELATIVE_PATH_FUNCTION = new IlvStringEvaluatorFunction(){

        public void connectUI(IlvFormEditor ilvFormEditor, Object object, IlvEditionContext ilvEditionContext) {
        }

        public void disconnectUI(IlvFormEditor ilvFormEditor, Object object, IlvEditionContext ilvEditionContext) {
        }

        public Object initialize(IlvFormEditor ilvFormEditor, IlvEditionContext ilvEditionContext) {
            return null;
        }

        public Object evaluate(Object[] objectArray, Object object, IlvEditionContext ilvEditionContext) {
            if (objectArray.length < 2 || objectArray.length > 2) {
                throw new IllegalStateException("The relative path function must have too parameters");
            }
            return IlvUtil.GetRelativePath(objectArray[0].toString(), objectArray[1].toString());
        }
    };
    public static final IlvStringEvaluatorFunction ABSOLUTE_PATH_FUNCTION = new IlvStringEvaluatorFunction(){

        public void connectUI(IlvFormEditor ilvFormEditor, Object object, IlvEditionContext ilvEditionContext) {
        }

        public void disconnectUI(IlvFormEditor ilvFormEditor, Object object, IlvEditionContext ilvEditionContext) {
        }

        public Object initialize(IlvFormEditor ilvFormEditor, IlvEditionContext ilvEditionContext) {
            return null;
        }

        public Object evaluate(Object[] objectArray, Object object, IlvEditionContext ilvEditionContext) {
            if (objectArray.length < 2 || objectArray.length > 2) {
                throw new IllegalStateException("The absolute path function must have too parameters");
            }
            URL uRL = null;
            String string = objectArray[1].toString();
            if (objectArray[0] == null) {
                return string;
            }
            String string2 = objectArray[0].toString();
            if (string2.length() == 0) {
                return string;
            }
            char c2 = string2.charAt(string2.length() - 1);
            if (c2 != File.separatorChar && c2 != '\\' && c2 != '/') {
                string2 = string2 + File.separatorChar;
            }
            try {
                uRL = new URL("file:" + string2);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return string;
            }
            URL uRL2 = null;
            try {
                uRL2 = new URL(uRL, string);
            }
            catch (MalformedURLException malformedURLException) {
                return string;
            }
            return uRL2.getPath();
        }
    };
    public static final IlvStringEvaluatorFunction EDITOR_VALUE_FUNCTION = new IlvStringEvaluatorFunction(){

        public Object initialize(IlvFormEditor ilvFormEditor, IlvEditionContext ilvEditionContext) {
            return new RefEditorContext(ilvFormEditor);
        }

        public void connectUI(IlvFormEditor ilvFormEditor, Object object, IlvEditionContext ilvEditionContext) {
            RefEditorContext refEditorContext = (RefEditorContext)object;
            refEditorContext.connectUI();
        }

        public void disconnectUI(IlvFormEditor ilvFormEditor, Object object, IlvEditionContext ilvEditionContext) {
            RefEditorContext refEditorContext = (RefEditorContext)object;
            refEditorContext.disconnectUI();
        }

        public Object evaluate(Object[] objectArray, Object object, IlvEditionContext ilvEditionContext) {
            RefEditorContext refEditorContext = (RefEditorContext)object;
            if (refEditorContext.refEditor == null) {
                refEditorContext.refEditor = (IlvFormSingleEditor)refEditorContext.editor.getParent().getEditor(objectArray[0].toString());
                if (refEditorContext.refEditor == null) {
                    throw new IllegalStateException("Could not find the form editor " + objectArray[0]);
                }
                refEditorContext.connectUI();
            }
            return refEditorContext.refEditor.getDisplayedValue();
        }
    };

    public Object initialize(IlvFormEditor var1, IlvEditionContext var2);

    public void connectUI(IlvFormEditor var1, Object var2, IlvEditionContext var3);

    public void disconnectUI(IlvFormEditor var1, Object var2, IlvEditionContext var3);

    public Object evaluate(Object[] var1, Object var2, IlvEditionContext var3);

    public static class RefEditorContext {
        private boolean a;
        public IlvFormEditor editor;
        public IlvFormSingleEditor refEditor;

        public RefEditorContext(IlvFormEditor ilvFormEditor) {
            this.editor = ilvFormEditor;
        }

        public void connectUI() {
            if (!this.a && this.refEditor != null) {
                this.refEditor.addValueDependentEditor(this.editor);
                this.a = true;
            }
        }

        public void disconnectUI() {
            if (this.a && this.refEditor != null) {
                this.refEditor.addValueDependentEditor(this.editor);
                this.a = false;
            }
        }
    }

    public static abstract class ArithmeticBinaryFunction
    implements IlvStringEvaluatorFunction {
        private String a;

        public ArithmeticBinaryFunction(String string) {
            this.a = string;
        }

        public void connectUI(IlvFormEditor ilvFormEditor, Object object, IlvEditionContext ilvEditionContext) {
        }

        public void disconnectUI(IlvFormEditor ilvFormEditor, Object object, IlvEditionContext ilvEditionContext) {
        }

        public Object initialize(IlvFormEditor ilvFormEditor, IlvEditionContext ilvEditionContext) {
            return null;
        }

        public Object evaluate(Object[] objectArray, Object object, IlvEditionContext ilvEditionContext) {
            if (objectArray[0] instanceof Number) {
                if (objectArray[1] instanceof Number) {
                    return new Double(this.evaluateValues(((Number)objectArray[0]).doubleValue(), (Double)objectArray[1]));
                }
                throw new IllegalStateException("The " + this.a + " cannot process a number with a " + objectArray[1].getClass().getName());
            }
            return this.evaluateString(objectArray[0].toString(), objectArray[1].toString());
        }

        public abstract double evaluateValues(double var1, double var3);

        public String evaluateString(String string, String string2) {
            throw new IllegalStateException("The " + this.a + " cannot process a strings");
        }
    }
}

