/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.beans.editor;

import ilog.views.IlvAccelerator;
import ilog.views.accelerator.IlvDeleteSelectionAccelerator;
import ilog.views.accelerator.IlvDuplicateSelectionAccelerator;
import ilog.views.accelerator.IlvFitToSizeAccelerator;
import ilog.views.accelerator.IlvIdentityAccelerator;
import ilog.views.accelerator.IlvRotateAccelerator;
import ilog.views.accelerator.IlvScrollDownAccelerator;
import ilog.views.accelerator.IlvScrollLeftAccelerator;
import ilog.views.accelerator.IlvScrollRightAccelerator;
import ilog.views.accelerator.IlvScrollUpAccelerator;
import ilog.views.accelerator.IlvSelectAllAccelerator;
import ilog.views.accelerator.IlvZoomInAccelerator;
import ilog.views.accelerator.IlvZoomOutAccelerator;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;

public class IlvAcceleratorEditor
extends Panel
implements PropertyEditor {
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected IlvAccelerator[] value;
    protected List acceleratorList;
    protected List choiceList;
    protected Object[] accelerators;

    public IlvAcceleratorEditor() {
        Object[] objectArray = new Object[24];
        objectArray[0] = "Zoom In (CTRL+Z)";
        objectArray[1] = new IlvZoomInAccelerator(401, 90, 2);
        objectArray[2] = "Zoom Out (CTRL+U)";
        objectArray[3] = new IlvZoomOutAccelerator(401, 85, 2);
        objectArray[4] = "Fit To Size (CTRL+F)";
        objectArray[5] = new IlvFitToSizeAccelerator(401, 70, 2);
        objectArray[6] = "Rotate (CTRL+R)";
        objectArray[7] = new IlvRotateAccelerator(401, 82, 2);
        objectArray[8] = "Pan Up (UP ARROW)";
        objectArray[9] = new IlvScrollUpAccelerator(401, 38, 0);
        objectArray[10] = "Pan Down (DOWN ARROW)";
        objectArray[11] = new IlvScrollDownAccelerator(401, 40, 0);
        objectArray[12] = "pan Right (RIGHT ARROW)";
        objectArray[13] = new IlvScrollRightAccelerator(401, 39, 0);
        objectArray[14] = "pan Left (LEFT ARROW)";
        objectArray[15] = new IlvScrollLeftAccelerator(401, 37, 0);
        objectArray[16] = "Identity (CTRL+I)";
        objectArray[17] = new IlvIdentityAccelerator(401, 73, 2);
        objectArray[18] = "Select All (CTRL+A)";
        objectArray[19] = new IlvSelectAllAccelerator(401, 65, 2);
        objectArray[20] = "Duplicate Selection (CTRL+D)";
        objectArray[21] = new IlvDuplicateSelectionAccelerator(401, 68, 2);
        objectArray[22] = "Delete Selection (CTRL+X)";
        objectArray[23] = new IlvDeleteSelectionAccelerator(401, 88, 2);
        this.accelerators = objectArray;
        this.setLayout(new BorderLayout(4, 4));
        this.choiceList = new List();
        this.acceleratorList = new List();
        for (int i2 = 0; i2 < this.accelerators.length / 2; ++i2) {
            this.acceleratorList.add((String)this.accelerators[i2 * 2]);
        }
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(4, 4));
        panel.add((Component)this.acceleratorList, "Before");
        Panel panel2 = new Panel();
        panel.add((Component)panel2, "Center");
        Button button = new Button("Add>");
        panel2.add(button);
        Button button2 = new Button("<Remove");
        panel2.add(button2);
        panel2.setLayout(new GridLayout(2, 1));
        this.add((Component)this.choiceList, "Center");
        this.add((Component)panel, "Before");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n2 = IlvAcceleratorEditor.this.acceleratorList.getSelectedIndex();
                if (n2 != -1) {
                    String string = IlvAcceleratorEditor.this.acceleratorList.getSelectedItem();
                    IlvAcceleratorEditor.this.acceleratorList.remove(string);
                    IlvAcceleratorEditor.this.choiceList.add(string);
                    IlvAcceleratorEditor.this.addAccelerator(string);
                }
            }
        });
        button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n2 = IlvAcceleratorEditor.this.choiceList.getSelectedIndex();
                if (n2 != -1) {
                    String string = IlvAcceleratorEditor.this.choiceList.getSelectedItem();
                    IlvAcceleratorEditor.this.choiceList.remove(string);
                    IlvAcceleratorEditor.this.acceleratorList.add(string);
                    IlvAcceleratorEditor.this.removeAccelerator(string);
                }
            }
        });
    }

    public void setValue(Object object) {
        this.value = (IlvAccelerator[])object;
        this.updateLists();
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    private String a(int n2) {
        switch (n2) {
            case 38: {
                return "VK_UP";
            }
            case 40: {
                return "VK_DOWN";
            }
            case 37: {
                return "VK_LEFT";
            }
            case 39: {
                return "VK_RIGHT";
            }
        }
        return "VK_" + KeyEvent.getKeyText(n2);
    }

    private String a(IlvAccelerator[] ilvAcceleratorArray) {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("[");
        if (ilvAcceleratorArray != null) {
            for (int i2 = 0; i2 < ilvAcceleratorArray.length; ++i2) {
                IlvAccelerator ilvAccelerator = ilvAcceleratorArray[i2];
                if (ilvAccelerator != null) {
                    if (ilvAccelerator.getModifier() == 2) {
                        stringBuffer.append("Control+");
                    }
                    stringBuffer.append(this.a(ilvAccelerator.getKeyCode()) + ":");
                    stringBuffer.append(ilvAccelerator.getClass().getName());
                }
                if (i2 >= ilvAcceleratorArray.length - 1) continue;
                stringBuffer.append(" , ");
            }
        }
        String string = new String(stringBuffer) + "]";
        return string;
    }

    public String getJavaInitializationString() {
        IlvAccelerator[] ilvAcceleratorArray = this.value;
        if (this.value == null) {
            return "null )";
        }
        StringBuffer stringBuffer = new StringBuffer(ilvAcceleratorArray.length);
        for (int i2 = 0; i2 < ilvAcceleratorArray.length; ++i2) {
            IlvAccelerator ilvAccelerator = ilvAcceleratorArray[i2];
            if (ilvAccelerator != null) {
                stringBuffer.append("new ");
                stringBuffer.append(ilvAccelerator.getClass().getName());
                stringBuffer.append("( java.awt.event.KeyEvent.KEY_PRESSED,");
                stringBuffer.append("java.awt.event.KeyEvent." + this.a(ilvAccelerator.getKeyCode()) + ",");
                if (ilvAccelerator.getModifier() == 2) {
                    stringBuffer.append("java.awt.event.KeyEvent.CTRL_MASK");
                } else {
                    stringBuffer.append("0");
                }
                stringBuffer.append(") ");
            }
            if (i2 >= ilvAcceleratorArray.length - 1) continue;
            stringBuffer.append(" , \n");
        }
        return "new ilog.views.IlvAccelerator[] { \n" + new String(stringBuffer) + " }";
    }

    public String getAsText() {
        return this.a(this.value);
    }

    public void setAsText(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException(string);
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void addAccelerator(String string) {
        int n2 = this.value != null ? this.value.length : 0;
        IlvAccelerator[] ilvAcceleratorArray = new IlvAccelerator[n2 + 1];
        if (n2 != 0) {
            System.arraycopy(this.value, 0, ilvAcceleratorArray, 0, this.value.length);
        }
        ilvAcceleratorArray[n2] = this.findAccelerator(string);
        this.value = ilvAcceleratorArray;
        this.support.firePropertyChange(null, this.value, ilvAcceleratorArray);
    }

    public void removeAccelerator(String string) {
        int n2;
        int n3 = n2 = this.value != null ? this.value.length : 0;
        if (n2 == 0) {
            return;
        }
        IlvAccelerator[] ilvAcceleratorArray = new IlvAccelerator[n2 - 1];
        IlvAccelerator ilvAccelerator = this.findAccelerator(string);
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.value[i2].getClass() == ilvAccelerator.getClass()) continue;
            ilvAcceleratorArray[n4] = this.value[i2];
            ++n4;
        }
        this.value = ilvAcceleratorArray;
        this.support.firePropertyChange(null, this.value, ilvAcceleratorArray);
    }

    public IlvAccelerator findAccelerator(String string) {
        for (int i2 = 0; i2 < this.accelerators.length / 2; ++i2) {
            if (!string.equals(this.accelerators[i2 * 2])) continue;
            return (IlvAccelerator)this.accelerators[i2 * 2 + 1];
        }
        return null;
    }

    public void updateLists() {
        int n2;
        int n3 = this.choiceList.getItemCount();
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            this.choiceList.remove(this.choiceList.getItem(n2));
        }
        n3 = this.acceleratorList.getItemCount();
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            this.acceleratorList.remove(this.acceleratorList.getItem(n2));
        }
        for (n2 = 0; n2 < this.accelerators.length / 2; ++n2) {
            this.acceleratorList.add((String)this.accelerators[n2 * 2]);
        }
        if (this.value != null) {
            block3: for (n2 = 0; n2 < this.value.length; ++n2) {
                int n4 = 0;
                while (n2 < this.accelerators.length / 2) {
                    if (this.value[n2].getClass().equals(this.accelerators[n4 * 2 + 1].getClass())) {
                        this.acceleratorList.remove((String)this.accelerators[n4 * 2]);
                        this.choiceList.add((String)this.accelerators[n4 * 2]);
                        continue block3;
                    }
                    ++n4;
                }
            }
        }
    }
}

