/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.dxf;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.dxf.DXFBulgeUtil;
import ilog.views.dxf.DXFElement;
import ilog.views.dxf.DXFGroup;
import ilog.views.dxf.IlvDXFGraphicFactory;
import ilog.views.dxf.IlvDXFReaderConfigurator;
import ilog.views.graphic.IlvPolyline;
import ilog.views.graphic.IlvText;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;

public class IlvDXFReader {
    private IlvDXFReaderConfigurator a;
    private IlvGraphicBag b;
    private IlvManager c;
    private IlvDXFGraphicFactory d;
    private BufferedReader e;
    private IlvTransformer f;
    private IlvPoint g = new IlvPoint();
    private IlvPoint h = new IlvPoint();
    private boolean i;
    private DXFGroup j;
    private boolean k;
    private int l;
    private ArrayList m;
    private LinkedHashMap n;
    private HashMap o;
    private ArrayList p;
    private ArrayList q;
    private ArrayList r;
    private Color s;
    private float t;
    private boolean u;
    private DXFElement v;
    private short w;
    private boolean x = false;
    private ArrayList y;
    private HashMap z;
    private Color[] aa;
    private boolean ab = true;
    private static final String ac = "AutoCAD Binary DXF\r\n\u001a";
    private static final String ad = "Monospaced";
    private static final Font ae = new Font("Monospaced", 0, 12);

    public IlvDXFReader() {
        this(new IlvDXFReaderConfigurator());
    }

    public IlvDXFReader(IlvDXFReaderConfigurator ilvDXFReaderConfigurator) {
        this.a = ilvDXFReaderConfigurator;
    }

    public final IlvDXFReaderConfigurator getConfigurator() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(URL uRL, IlvGraphicBag ilvGraphicBag) throws IOException {
        InputStream inputStream = uRL.openStream();
        try {
            this.read(inputStream, ilvGraphicBag);
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(String string, IlvGraphicBag ilvGraphicBag) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            this.read(fileInputStream, ilvGraphicBag);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream inputStream, IlvGraphicBag ilvGraphicBag) throws IOException {
        block7: {
            if (inputStream == null) {
                throw new IllegalArgumentException("dxfStream cannot be null");
            }
            if (ilvGraphicBag == null) {
                throw new IllegalArgumentException("bag cannot be null");
            }
            this.d = this.getConfigurator().getGraphicFactory();
            this.b = ilvGraphicBag;
            this.c = ilvGraphicBag instanceof IlvManager ? (IlvManager)ilvGraphicBag : null;
            DXFGroup dXFGroup = new DXFGroup();
            dXFGroup.a(0, "POLYLINE");
            this.v = new DXFElement(dXFGroup);
            try {
                this.a(inputStream);
                this.a();
                while (true) {
                    this.l();
                    if (this.j.b(0, "EOF")) {
                        break block7;
                    }
                    if (!this.j.b(0, "SECTION")) break;
                    this.c();
                }
                throw new IOException("Bad group code " + this.j.b() + " at offset " + this.l + ". Should be [0 - SECTION]");
            }
            finally {
                this.b = null;
                this.c = null;
                this.d = null;
            }
        }
    }

    private void a(InputStream inputStream) {
        this.e = new BufferedReader(new InputStreamReader(inputStream));
        this.f = new IlvTransformer(1.0, 0.0, 0.0, -1.0, 0.0, 0.0);
        this.ab = true;
        this.g.move(0.0f, 0.0f);
        this.h.move(0.0f, 0.0f);
        this.i = false;
        this.j = new DXFGroup();
        this.k = false;
        this.l = 0;
        this.m = null;
        this.n = null;
        this.o = null;
        this.p = null;
        this.q = new ArrayList();
        this.r = new ArrayList();
        this.u = false;
        this.y = null;
        this.z = new HashMap();
    }

    private void a() throws IOException {
        int n2;
        int n3 = ac.length();
        this.e.mark(n3 + 10);
        try {
            char[] cArray = new char[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                cArray[n2] = (char)this.e.read();
                if (ac.charAt(n2) == cArray[n2]) {
                    continue;
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            n2 = 0;
        }
        if (n2 == n3) {
            this.i = true;
            this.l = n3;
            this.e.read();
        } else {
            this.e.reset();
        }
    }

    private static boolean a(char c2) {
        return c2 == ' ' || c2 == '\t';
    }

    private void b() {
        IlvRect ilvRect = this.getConfigurator().getExtents();
        if (ilvRect == null) {
            return;
        }
        if (ilvRect.width == 0.0f || ilvRect.height == 0.0f) {
            throw new IllegalArgumentException("Cannot set empty rectangle");
        }
        float f2 = ilvRect.width / (this.h.x - this.g.x);
        float f3 = ilvRect.height / (this.h.y - this.g.y);
        if (this.getConfigurator().isKeepAspectRatio() && f2 < f3) {
            f3 = f2;
        }
        float f4 = ilvRect.x - f2 * this.g.x;
        float f5 = ilvRect.y + ilvRect.height + f3 * this.g.y;
        this.f.setValues(f2, 0.0, 0.0, -f3, f4, f5);
        this.ab = false;
    }

    private IlvPoint a(float f2, float f3) {
        if (this.ab) {
            return new IlvPoint(f2, -f3);
        }
        IlvPoint ilvPoint = new IlvPoint(f2, f3);
        this.f.apply(ilvPoint);
        return ilvPoint;
    }

    private void a(IlvPoint[] ilvPointArray) {
        int n2 = ilvPointArray != null ? ilvPointArray.length : 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.a(ilvPointArray[i2]);
        }
    }

    private IlvPoint a(IlvPoint ilvPoint) {
        if (ilvPoint == null) {
            return null;
        }
        if (this.ab) {
            ilvPoint.y = -ilvPoint.y;
        } else {
            this.f.apply(ilvPoint);
        }
        return ilvPoint;
    }

    private double a(double d2) {
        return this.ab ? d2 : d2 * this.f.zoomFactor();
    }

    private void c() throws IOException {
        while (true) {
            this.l();
            if (this.j.b(0, "ENDSEC")) {
                return;
            }
            if (this.j.b(2, "HEADER")) {
                this.d();
                this.b();
            }
            if (this.j.b(2, "TABLES")) {
                this.e();
            }
            if (this.j.b(2, "BLOCKS")) {
                this.i();
            }
            if (!this.j.b(2, "ENTITIES")) continue;
            this.a(false);
        }
    }

    private void d() throws IOException {
        block0: do {
            this.l();
            if (this.j.b(9, "$ANGBASE")) {
                this.l();
                continue;
            }
            if (this.j.b(9, "$ANGDIR")) {
                this.l();
                continue;
            }
            if (this.j.b(9, "$EXTMIN")) {
                while (true) {
                    this.l();
                    if (this.j.b() == 9 || this.j.b() == 0) {
                        this.k();
                        continue block0;
                    }
                    if (this.j.b() == 10) {
                        this.g.x = (float)this.j.d();
                    }
                    if (this.j.b() != 20) continue;
                    this.g.y = (float)this.j.d();
                }
            }
            if (!this.j.b(9, "$EXTMAX")) continue;
            while (true) {
                this.l();
                if (this.j.b() == 9 || this.j.b() == 0) {
                    this.k();
                    continue block0;
                }
                if (this.j.b() == 10) {
                    this.h.x = (float)this.j.d();
                }
                if (this.j.b() != 20) continue;
                this.h.y = (float)this.j.d();
            }
        } while (!this.j.b(0, "ENDSEC"));
        this.k();
    }

    private void e() throws IOException {
        do {
            this.l();
            if (!this.j.b(0, "TABLE")) continue;
            this.l();
            if (this.j.b() != 2) {
                throw new IOException("Should be a 2 group at line/byte " + this.l);
            }
            this.a(this.j.e());
        } while (!this.j.b(0, "ENDSEC"));
        this.k();
        this.f();
    }

    private void a(String string) throws IOException {
        while (true) {
            this.l();
            if (this.j.b(0, "LTYPE")) {
                this.g();
                continue;
            }
            if (this.j.b(0, "LAYER")) {
                this.h();
                continue;
            }
            if (this.j.b(0, "ENDTAB")) break;
        }
        this.k();
    }

    private void f() {
        int n2;
        Set set;
        if (this.c == null) {
            return;
        }
        Set set2 = set = this.n != null ? this.n.keySet() : null;
        if (set == null) {
            return;
        }
        Object[] objectArray = set.toArray();
        int n3 = n2 = objectArray != null ? objectArray.length : 0;
        if (n2 == 0) {
            return;
        }
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            String string = (String)objectArray[i2];
            this.b(string);
        }
    }

    private int b(String string) {
        IlvManagerLayer ilvManagerLayer = this.d.prepareLayer(this.c, string);
        if (!this.a.isQuadTreeEnabled()) {
            ilvManagerLayer.setQuadtreeEnabled(false);
        }
        int n2 = ilvManagerLayer.getIndex();
        this.z.put(string, new Integer(n2));
        return n2;
    }

    private void g() throws IOException {
        DXFElement dXFElement = new DXFElement(new DXFGroup(this.j));
        if (this.m == null) {
            this.m = new ArrayList(10);
        }
        this.m.add(dXFElement);
        while (true) {
            this.l();
            if (this.j.b() == 0) {
                this.k();
                return;
            }
            dXFElement.a(this.j);
        }
    }

    private void h() throws IOException {
        DXFElement dXFElement = new DXFElement(new DXFGroup(this.j));
        if (this.n == null) {
            this.n = new LinkedHashMap();
        }
        while (true) {
            this.l();
            if (this.j.b() == 0) break;
            dXFElement.a(this.j);
        }
        this.k();
        DXFGroup dXFGroup = dXFElement.a(2);
        if (dXFGroup != null) {
            Object object = dXFGroup.f();
            this.n.put(object, dXFElement);
        }
    }

    private void i() throws IOException {
        while (true) {
            this.l();
            if (this.j.b(0, "BLOCK")) {
                this.l();
                this.j();
                continue;
            }
            if (this.j.b(0, "ENDSEC")) break;
        }
    }

    private void j() throws IOException {
        DXFElement dXFElement = new DXFElement(new DXFGroup(this.j));
        if (this.o == null) {
            this.o = new HashMap();
        }
        while (true) {
            this.l();
            if (this.j.b(0, "ENDBLK")) break;
            if (this.j.b() == 0) {
                this.k();
                try {
                    this.a(true);
                    dXFElement.a(this.p);
                    this.p = null;
                }
                catch (IOException iOException) {}
                continue;
            }
            dXFElement.a(this.j);
        }
        DXFGroup dXFGroup = dXFElement.a(2);
        if (dXFGroup != null) {
            this.o.put(dXFGroup.f(), dXFElement);
        }
    }

    private void a(boolean bl) throws IOException {
        DXFElement dXFElement = null;
        this.b(true);
        try {
            while (true) {
                block20: {
                    Object object;
                    block22: {
                        block21: {
                            this.a(dXFElement);
                            if (this.j.b() != 0) break block20;
                            if (dXFElement != null) {
                                if (bl) {
                                    if (this.p == null) {
                                        this.p = new ArrayList(100);
                                    }
                                    this.p.add(dXFElement);
                                } else {
                                    object = this.c(dXFElement);
                                    if (object != null) {
                                        if (this.u) {
                                            this.a((IlvGraphic)object, this.b(this.v));
                                            this.u = false;
                                        } else {
                                            this.a((IlvGraphic)object, this.b(dXFElement));
                                        }
                                    }
                                }
                            }
                            if (this.j.b(0, "ENDBLK")) break block21;
                            if (!this.j.b(0, "ENDSEC")) break block22;
                        }
                        this.k();
                        return;
                    }
                    if (!bl && dXFElement != null) {
                        dXFElement.a();
                        dXFElement.a(this.j);
                    } else {
                        dXFElement = new DXFElement(new DXFGroup(this.j));
                    }
                    object = this.j.e();
                    if (((String)object).equalsIgnoreCase("LWPOLYLINE")) {
                        dXFElement.f();
                        continue;
                    }
                    if (((String)object).equalsIgnoreCase("SPLINE")) {
                        dXFElement.g();
                        continue;
                    }
                    dXFElement.h();
                    continue;
                }
                if (dXFElement == null) {
                    throw new IOException("Group 0 in entities expected at line/byte %ld" + this.l);
                }
                dXFElement.a(this.j);
            }
        }
        finally {
            this.b(false);
        }
    }

    private void b(boolean bl) {
        if (this.c != null) {
            this.c.setContentsAdjusting(bl);
        }
    }

    private void a(IlvGraphic ilvGraphic, int n2) {
        if (this.c != null) {
            this.d.addObject(ilvGraphic, this.c, n2);
        } else {
            this.d.addObject(ilvGraphic, this.b);
        }
    }

    private void k() {
        this.k = true;
    }

    private void l() throws IOException {
        this.a((DXFElement)null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(DXFElement dXFElement) throws IOException {
        int n2;
        int n3;
        String string;
        if (this.k) {
            this.k = false;
            return;
        }
        this.j.a();
        if (this.i) {
            int n4 = this.e.read();
            ++this.l;
            if (n4 < 0) {
                throw new IOException();
            }
            if (n4 < 10 || n4 >= 1000 && n4 < 1010) {
                int n5;
                StringBuffer stringBuffer = new StringBuffer(10);
                while ((n5 = this.e.read()) != 0) {
                    stringBuffer.append((char)n5);
                }
                String string2 = stringBuffer.toString();
                int n6 = string2.lastIndexOf(13, string2.length());
                if (n6 != -1) {
                    string2 = string2.substring(0, n6);
                }
                this.j.a(n4, string2);
                this.l += string2.length() + 1;
                return;
            } else if (n4 >= 10 && n4 < 60 || n4 >= 140 && n4 < 148 || n4 >= 210 && n4 < 240 || n4 >= 1010 && n4 < 1060) {
                int n7 = this.e.read();
                int n8 = this.e.read();
                int n9 = this.e.read();
                int n10 = this.e.read();
                int n11 = this.e.read();
                int n12 = this.e.read();
                int n13 = this.e.read();
                int n14 = this.e.read();
                long l2 = ((long)n14 << 56) + ((long)n13 << 48) + ((long)n12 << 40) + ((long)n11 << 32) + ((long)n10 << 24) + ((long)n9 << 16) + ((long)n8 << 8) + (long)n7;
                this.j.a(n4, Double.longBitsToDouble(l2));
                this.l += 8;
                return;
            } else {
                if (!(n4 >= 60 && n4 < 80 || n4 >= 170 && n4 < 176)) {
                    if (n4 < 1060) return;
                    if (n4 >= 1080) return;
                }
                int n15 = this.e.read();
                int n16 = this.e.read();
                short s2 = (short)((n16 << 8) + n15);
                this.j.a(n4, s2);
                this.l += 2;
            }
            return;
        }
        do {
            int n17;
            string = this.e.readLine();
            ++this.l;
            if (string == null) {
                throw new EOFException();
            }
            n3 = string.length();
            for (n2 = 0; n2 < n3 && IlvDXFReader.a(string.charAt(n2)); ++n2) {
            }
            for (n17 = n3 - 1; n17 >= 0 && IlvDXFReader.a(string.charAt(n17)); --n17) {
            }
            if (n2 <= n17) {
                if (n2 == 0 && n17 == n3 - 1) continue;
                string = string.substring(n2, n17 + 1);
                continue;
            }
            string = null;
        } while (string == null);
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("number expected instead of " + string);
        }
        string = this.e.readLine();
        if (string == null) {
            throw new EOFException();
        }
        ++this.l;
        if (n3 == 999) {
            this.l();
            return;
        }
        if (n3 < 0) {
            throw new IOException("bad code for group");
        }
        if (n3 < 10 || n3 == 100 || n3 == 102 || n3 >= 410 && n3 < 420 || n3 >= 1000 && n3 < 1010) {
            this.j.a(n3, string);
            return;
        }
        if (n3 >= 10 && n3 < 60 || n3 >= 110 && n3 < 140 || n3 >= 210 && n3 < 240 || n3 >= 460 && n3 < 470 || n3 >= 1010 && n3 < 1060) {
            try {
                string = string.trim();
                double d2 = Double.valueOf(string);
                boolean bl = false;
                if (dXFElement != null) {
                    if (dXFElement.d()) {
                        if (n3 == 10) {
                            dXFElement.a(d2);
                            return;
                        }
                        if (n3 == 20) {
                            dXFElement.b(d2);
                            return;
                        }
                        if (n3 == 42) {
                            dXFElement.g(d2);
                            return;
                        }
                    } else if (dXFElement.e()) {
                        if (n3 == 10) {
                            dXFElement.c(d2);
                            return;
                        }
                        if (n3 == 20) {
                            dXFElement.d(d2);
                            return;
                        }
                        if (n3 == 11) {
                            dXFElement.e(d2);
                            return;
                        }
                        if (n3 == 21) {
                            dXFElement.f(d2);
                            return;
                        }
                    }
                }
                if (bl) return;
                this.j.a(n3, d2);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("invalid format double expected in group " + string);
            }
        }
        if (n3 == 90) {
            string = string.trim();
            n2 = Integer.valueOf(string);
            if (dXFElement == null) return;
            if (!dXFElement.d()) return;
            dXFElement.b(n2);
            return;
        }
        if (!(n3 >= 60 && n3 < 80 || n3 >= 170 && n3 < 180 || n3 >= 270 && n3 < 290 || n3 >= 370 && n3 < 390 || n3 >= 400 && n3 < 410)) {
            if (n3 < 1060) return;
            if (n3 >= 1080) return;
        }
        try {
            string = string.trim();
            n2 = Short.valueOf(string).shortValue();
            if (dXFElement != null && dXFElement.e()) {
                switch (n3) {
                    case 73: {
                        dXFElement.c(n2);
                        break;
                    }
                    case 74: {
                        dXFElement.d(n2);
                    }
                }
            }
            this.j.a(n3, (short)n2);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("invalid format short expected in group " + string);
        }
    }

    private Color a(int n2) {
        return this.m()[n2 & 0xFF];
    }

    private Color[] m() {
        if (this.aa == null) {
            boolean bl = this.a.isInvertBlackAndWhite();
            this.aa = new Color[256];
            this.aa[1] = Color.red;
            this.aa[2] = Color.yellow;
            this.aa[3] = Color.green;
            this.aa[4] = Color.cyan;
            this.aa[5] = Color.blue;
            this.aa[6] = Color.magenta;
            this.aa[8] = Color.gray;
            this.aa[9] = Color.lightGray;
            if (bl) {
                this.aa[0] = Color.white;
                this.aa[7] = Color.white;
            } else {
                this.aa[0] = Color.black;
                this.aa[7] = Color.black;
            }
            this.aa[10] = new Color(255, 0, 0);
            this.aa[11] = new Color(255, 127, 127);
            this.aa[12] = new Color(165, 0, 0);
            this.aa[13] = new Color(165, 82, 82);
            this.aa[14] = new Color(127, 0, 0);
            this.aa[15] = new Color(127, 63, 63);
            this.aa[16] = new Color(76, 0, 0);
            this.aa[17] = new Color(76, 38, 38);
            this.aa[18] = new Color(38, 0, 0);
            this.aa[19] = new Color(38, 19, 19);
            this.aa[20] = new Color(255, 63, 0);
            this.aa[21] = new Color(255, 159, 127);
            this.aa[22] = new Color(165, 41, 0);
            this.aa[23] = new Color(165, 103, 82);
            this.aa[24] = new Color(127, 31, 0);
            this.aa[25] = new Color(127, 79, 63);
            this.aa[26] = new Color(76, 19, 0);
            this.aa[27] = new Color(76, 47, 38);
            this.aa[28] = new Color(38, 9, 0);
            this.aa[29] = new Color(38, 23, 19);
            this.aa[30] = new Color(255, 127, 0);
            this.aa[31] = new Color(255, 191, 127);
            this.aa[32] = new Color(165, 82, 0);
            this.aa[33] = new Color(165, 124, 82);
            this.aa[34] = new Color(127, 63, 0);
            this.aa[35] = new Color(127, 95, 63);
            this.aa[36] = new Color(76, 38, 0);
            this.aa[37] = new Color(76, 57, 38);
            this.aa[38] = new Color(38, 19, 0);
            this.aa[39] = new Color(38, 28, 19);
            this.aa[40] = new Color(255, 191, 0);
            this.aa[41] = new Color(255, 223, 127);
            this.aa[42] = new Color(165, 124, 0);
            this.aa[43] = new Color(165, 145, 82);
            this.aa[44] = new Color(127, 95, 0);
            this.aa[45] = new Color(127, 111, 63);
            this.aa[46] = new Color(76, 57, 0);
            this.aa[47] = new Color(76, 66, 38);
            this.aa[48] = new Color(38, 28, 0);
            this.aa[49] = new Color(38, 33, 19);
            this.aa[50] = new Color(255, 255, 0);
            this.aa[51] = new Color(255, 255, 127);
            this.aa[52] = new Color(165, 165, 0);
            this.aa[53] = new Color(165, 165, 82);
            this.aa[54] = new Color(127, 127, 0);
            this.aa[55] = new Color(127, 127, 63);
            this.aa[56] = new Color(76, 76, 0);
            this.aa[57] = new Color(76, 76, 38);
            this.aa[58] = new Color(38, 38, 0);
            this.aa[59] = new Color(38, 38, 19);
            this.aa[60] = new Color(191, 255, 0);
            this.aa[61] = new Color(223, 255, 127);
            this.aa[62] = new Color(124, 165, 0);
            this.aa[63] = new Color(145, 165, 82);
            this.aa[64] = new Color(95, 127, 0);
            this.aa[65] = new Color(111, 127, 63);
            this.aa[66] = new Color(57, 76, 0);
            this.aa[67] = new Color(66, 76, 38);
            this.aa[68] = new Color(28, 38, 0);
            this.aa[69] = new Color(33, 38, 19);
            this.aa[70] = new Color(127, 255, 0);
            this.aa[71] = new Color(191, 255, 127);
            this.aa[72] = new Color(82, 165, 0);
            this.aa[73] = new Color(124, 165, 82);
            this.aa[74] = new Color(63, 127, 0);
            this.aa[75] = new Color(95, 127, 63);
            this.aa[76] = new Color(38, 76, 0);
            this.aa[77] = new Color(57, 76, 38);
            this.aa[78] = new Color(19, 38, 0);
            this.aa[79] = new Color(28, 38, 19);
            this.aa[80] = new Color(63, 255, 0);
            this.aa[81] = new Color(159, 255, 127);
            this.aa[82] = new Color(41, 165, 0);
            this.aa[83] = new Color(103, 165, 82);
            this.aa[84] = new Color(31, 127, 0);
            this.aa[85] = new Color(79, 127, 63);
            this.aa[86] = new Color(19, 76, 0);
            this.aa[87] = new Color(47, 76, 38);
            this.aa[88] = new Color(9, 38, 0);
            this.aa[89] = new Color(23, 38, 19);
            this.aa[90] = new Color(0, 255, 0);
            this.aa[91] = new Color(127, 255, 127);
            this.aa[92] = new Color(0, 165, 0);
            this.aa[93] = new Color(82, 165, 82);
            this.aa[94] = new Color(0, 127, 0);
            this.aa[95] = new Color(63, 127, 63);
            this.aa[96] = new Color(0, 76, 0);
            this.aa[97] = new Color(38, 76, 38);
            this.aa[98] = new Color(0, 38, 0);
            this.aa[99] = new Color(19, 38, 19);
            this.aa[100] = new Color(0, 255, 63);
            this.aa[101] = new Color(127, 255, 159);
            this.aa[102] = new Color(0, 165, 41);
            this.aa[103] = new Color(82, 165, 103);
            this.aa[104] = new Color(0, 127, 31);
            this.aa[105] = new Color(63, 127, 79);
            this.aa[106] = new Color(0, 76, 19);
            this.aa[107] = new Color(38, 76, 47);
            this.aa[108] = new Color(0, 38, 9);
            this.aa[109] = new Color(19, 38, 23);
            this.aa[110] = new Color(0, 255, 127);
            this.aa[111] = new Color(127, 255, 191);
            this.aa[112] = new Color(0, 165, 82);
            this.aa[113] = new Color(82, 165, 124);
            this.aa[114] = new Color(0, 127, 63);
            this.aa[115] = new Color(63, 127, 95);
            this.aa[116] = new Color(0, 76, 38);
            this.aa[117] = new Color(38, 76, 57);
            this.aa[118] = new Color(0, 38, 19);
            this.aa[119] = new Color(19, 38, 28);
            this.aa[120] = new Color(0, 255, 191);
            this.aa[121] = new Color(127, 255, 223);
            this.aa[122] = new Color(0, 165, 124);
            this.aa[123] = new Color(82, 165, 145);
            this.aa[124] = new Color(0, 127, 95);
            this.aa[125] = new Color(63, 127, 111);
            this.aa[126] = new Color(0, 76, 57);
            this.aa[127] = new Color(38, 76, 66);
            this.aa[128] = new Color(0, 38, 28);
            this.aa[129] = new Color(19, 38, 33);
            this.aa[130] = new Color(0, 255, 191);
            this.aa[131] = new Color(127, 255, 255);
            this.aa[132] = new Color(0, 165, 165);
            this.aa[133] = new Color(82, 165, 165);
            this.aa[134] = new Color(0, 127, 127);
            this.aa[135] = new Color(63, 127, 127);
            this.aa[136] = new Color(0, 76, 76);
            this.aa[137] = new Color(38, 76, 76);
            this.aa[138] = new Color(0, 38, 38);
            this.aa[139] = new Color(19, 38, 38);
            this.aa[140] = new Color(0, 191, 255);
            this.aa[141] = new Color(127, 223, 255);
            this.aa[142] = new Color(0, 124, 165);
            this.aa[143] = new Color(82, 145, 165);
            this.aa[144] = new Color(0, 95, 127);
            this.aa[145] = new Color(63, 111, 127);
            this.aa[146] = new Color(0, 57, 76);
            this.aa[147] = new Color(38, 66, 76);
            this.aa[148] = new Color(0, 28, 38);
            this.aa[149] = new Color(19, 33, 38);
            this.aa[150] = new Color(0, 127, 255);
            this.aa[151] = new Color(127, 191, 255);
            this.aa[152] = new Color(0, 82, 165);
            this.aa[153] = new Color(82, 124, 165);
            this.aa[154] = new Color(0, 63, 127);
            this.aa[155] = new Color(63, 95, 127);
            this.aa[156] = new Color(0, 38, 76);
            this.aa[157] = new Color(38, 57, 76);
            this.aa[158] = new Color(0, 19, 38);
            this.aa[159] = new Color(19, 28, 38);
            this.aa[160] = new Color(0, 63, 255);
            this.aa[161] = new Color(127, 159, 255);
            this.aa[162] = new Color(0, 41, 165);
            this.aa[163] = new Color(82, 103, 165);
            this.aa[164] = new Color(0, 31, 127);
            this.aa[165] = new Color(63, 79, 127);
            this.aa[166] = new Color(0, 19, 76);
            this.aa[167] = new Color(38, 47, 76);
            this.aa[168] = new Color(0, 9, 38);
            this.aa[169] = new Color(19, 23, 38);
            this.aa[170] = new Color(0, 0, 255);
            this.aa[171] = new Color(127, 127, 255);
            this.aa[172] = new Color(0, 0, 165);
            this.aa[173] = new Color(82, 82, 165);
            this.aa[174] = new Color(0, 0, 127);
            this.aa[175] = new Color(63, 63, 127);
            this.aa[176] = new Color(0, 0, 76);
            this.aa[177] = new Color(38, 38, 76);
            this.aa[178] = new Color(0, 0, 38);
            this.aa[179] = new Color(19, 19, 38);
            this.aa[180] = new Color(63, 0, 255);
            this.aa[181] = new Color(159, 127, 255);
            this.aa[182] = new Color(41, 0, 165);
            this.aa[183] = new Color(103, 82, 165);
            this.aa[184] = new Color(31, 0, 127);
            this.aa[185] = new Color(79, 63, 127);
            this.aa[186] = new Color(19, 0, 76);
            this.aa[187] = new Color(47, 38, 76);
            this.aa[188] = new Color(9, 0, 38);
            this.aa[189] = new Color(23, 19, 38);
            this.aa[190] = new Color(127, 0, 255);
            this.aa[191] = new Color(191, 127, 255);
            this.aa[192] = new Color(82, 0, 165);
            this.aa[193] = new Color(124, 82, 165);
            this.aa[194] = new Color(63, 0, 127);
            this.aa[195] = new Color(95, 63, 127);
            this.aa[196] = new Color(38, 0, 76);
            this.aa[197] = new Color(57, 38, 76);
            this.aa[198] = new Color(19, 0, 38);
            this.aa[199] = new Color(28, 19, 38);
            this.aa[200] = new Color(191, 0, 255);
            this.aa[201] = new Color(223, 127, 255);
            this.aa[202] = new Color(124, 0, 165);
            this.aa[203] = new Color(145, 82, 165);
            this.aa[204] = new Color(95, 0, 127);
            this.aa[205] = new Color(111, 63, 127);
            this.aa[206] = new Color(57, 0, 76);
            this.aa[207] = new Color(66, 38, 76);
            this.aa[208] = new Color(28, 0, 38);
            this.aa[209] = new Color(33, 19, 38);
            this.aa[210] = new Color(255, 0, 255);
            this.aa[211] = new Color(255, 127, 255);
            this.aa[212] = new Color(165, 0, 165);
            this.aa[213] = new Color(165, 82, 165);
            this.aa[214] = new Color(127, 0, 127);
            this.aa[215] = new Color(127, 63, 127);
            this.aa[216] = new Color(76, 0, 76);
            this.aa[217] = new Color(76, 38, 76);
            this.aa[218] = new Color(38, 0, 38);
            this.aa[219] = new Color(38, 19, 38);
            this.aa[220] = new Color(255, 0, 191);
            this.aa[221] = new Color(255, 127, 223);
            this.aa[222] = new Color(165, 0, 124);
            this.aa[223] = new Color(165, 82, 145);
            this.aa[224] = new Color(127, 0, 95);
            this.aa[225] = new Color(127, 63, 111);
            this.aa[226] = new Color(76, 0, 57);
            this.aa[227] = new Color(76, 38, 66);
            this.aa[228] = new Color(38, 0, 28);
            this.aa[229] = new Color(38, 19, 33);
            this.aa[230] = new Color(255, 0, 127);
            this.aa[231] = new Color(255, 127, 191);
            this.aa[232] = new Color(165, 0, 82);
            this.aa[233] = new Color(165, 82, 124);
            this.aa[234] = new Color(127, 0, 63);
            this.aa[235] = new Color(127, 63, 95);
            this.aa[236] = new Color(76, 0, 38);
            this.aa[237] = new Color(76, 38, 57);
            this.aa[238] = new Color(38, 0, 19);
            this.aa[239] = new Color(38, 19, 28);
            this.aa[240] = new Color(255, 0, 63);
            this.aa[241] = new Color(255, 127, 159);
            this.aa[242] = new Color(165, 0, 41);
            this.aa[243] = new Color(165, 82, 103);
            this.aa[244] = new Color(127, 0, 31);
            this.aa[245] = new Color(127, 63, 79);
            this.aa[246] = new Color(76, 0, 19);
            this.aa[247] = new Color(76, 38, 47);
            this.aa[248] = new Color(38, 0, 9);
            this.aa[249] = new Color(38, 19, 23);
            if (bl) {
                this.aa[250] = new Color(51, 51, 51);
                this.aa[251] = new Color(91, 91, 91);
                this.aa[252] = new Color(132, 132, 132);
                this.aa[253] = new Color(173, 173, 173);
                this.aa[254] = new Color(214, 214, 214);
                this.aa[255] = new Color(255, 255, 255);
            } else {
                this.aa[250] = new Color(0, 0, 0);
                this.aa[251] = new Color(45, 45, 45);
                this.aa[252] = new Color(91, 91, 91);
                this.aa[253] = new Color(137, 137, 137);
                this.aa[254] = new Color(183, 183, 183);
                this.aa[255] = new Color(179, 179, 179);
            }
        }
        return this.aa;
    }

    private Color a(String string, int n2) {
        Color color;
        Color color2 = color = n2 == -1 ? null : this.a(n2);
        if (color != null || this.n == null) {
            return color;
        }
        DXFElement dXFElement = (DXFElement)this.n.get(string.toLowerCase());
        if (dXFElement != null) {
            if (dXFElement.c() != null) {
                Color color3 = (Color)dXFElement.c();
                return color3;
            }
            DXFGroup dXFGroup = dXFElement.a(62);
            color = dXFGroup != null ? this.a(dXFGroup.c()) : (this.a.isInvertBlackAndWhite() ? Color.white : Color.black);
            dXFElement.a(color);
        }
        return color;
    }

    private ArrayList c(String string) {
        if (this.o == null) {
            return null;
        }
        DXFElement dXFElement = (DXFElement)this.o.get(string.toLowerCase());
        return dXFElement != null ? (ArrayList)dXFElement.c() : null;
    }

    private int b(DXFElement dXFElement) {
        if (this.c == null) {
            return -1;
        }
        DXFGroup dXFGroup = dXFElement.a(0);
        if (dXFGroup == null) {
            return 0;
        }
        DXFGroup dXFGroup2 = dXFElement.a(8);
        if (dXFGroup2 != null) {
            Object object = dXFGroup2.f();
            Integer n2 = (Integer)this.z.get(object);
            if (n2 == null) {
                if (object instanceof String) {
                    String string = (String)object;
                    return this.b(string);
                }
                throw new RuntimeException("Internal error: unexpected layer group key type");
            }
            return n2;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private IlvGraphic c(DXFElement var1_1) throws IOException {
        var2_2 = var1_1.a(0);
        if (var2_2 == null) {
            return null;
        }
        var3_3 = var2_2.e();
        var4_4 = var1_1.a(6);
        if (var4_4 == null) ** GOTO lbl-1000
        if (var4_4.e().equalsIgnoreCase("bylayer")) {
            v0 = null;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var1_1.a(62);
        }
        var5_5 = v0;
        var6_6 = var1_1.a(8);
        v1 = var7_7 = var6_6 != null ? var6_6.e() : null;
        v2 = var7_7 != null ? (var5_5 != null ? this.a(var7_7, (int)var5_5.c()) : this.a(var7_7, -1)) : (var8_8 = null);
        if (var8_8 == null) {
            var8_8 = this.a.isInvertBlackAndWhite() != false ? Color.white : Color.black;
        }
        var9_9 = null;
        if (var3_3.equalsIgnoreCase("POINT")) {
            var10_10 = this.a((float)var1_1.getDouble(10), (float)var1_1.getDouble(20));
            var11_23 = (float)this.a(var1_1.getDouble(39));
            var9_9 = this.d.createPoint(var10_10, var11_23, var8_8);
        } else if (var3_3.equalsIgnoreCase("LINE")) {
            var10_11 = this.a((float)var1_1.getDouble(10), (float)var1_1.getDouble(20));
            var11_24 = this.a((float)var1_1.getDouble(11), (float)var1_1.getDouble(21));
            var12_33 = (float)this.a(var1_1.getDouble(39));
            var9_9 = this.d.createLine(var10_11, var11_24, var12_33, var8_8);
        } else if (var3_3.equalsIgnoreCase("ARC")) {
            var10_12 = var1_1.getDouble(50);
            if (var10_12 == (var12_34 = var1_1.getDouble(51))) {
                return null;
            }
            var14_41 = this.a((float)var1_1.getDouble(10), (float)var1_1.getDouble(20));
            var15_44 = (float)Math.abs(this.a(var1_1.getDouble(40)));
            var16_45 = (float)this.a(var1_1.getDouble(39));
            if (var10_12 > 180.0) {
                var10_12 -= 360.0;
            }
            if (var10_12 < -180.0) {
                var10_12 += 360.0;
            }
            if ((var17_47 = var12_34 - var10_12) > 180.0) {
                var17_47 -= 360.0;
            }
            if (var17_47 < -180.0) {
                var17_47 += 360.0;
            }
            var9_9 = this.d.createArc(var14_41, var15_44, (float)var10_12, (float)var17_47, var16_45, var8_8);
        } else if (var3_3.equalsIgnoreCase("CIRCLE")) {
            var10_13 = this.a((float)var1_1.getDouble(10), (float)var1_1.getDouble(20));
            var11_25 = (float)Math.abs(this.a(var1_1.getDouble(40)));
            var12_35 = (float)this.a(var1_1.getDouble(39));
            var9_9 = this.d.createCircle(var10_13, var11_25, var12_35, var8_8);
        } else if (var3_3.equalsIgnoreCase("POLYLINE")) {
            this.s = var8_8;
            this.t = (float)this.a(var1_1.getDouble(39));
            var10_14 = (float)this.a(var1_1.getDouble(40));
            var12_36 = (var10_14 + (var11_26 = (float)this.a(var1_1.getDouble(41)))) / 2.0f;
            if (var12_36 > this.t) {
                this.t = var12_36;
            }
            this.v.a();
            this.v.a(var1_1.a(0));
            if (var6_6 != null) {
                this.v.a(var6_6);
            }
            this.u = true;
            this.w = var1_1.getShort(70);
        } else if (var3_3.equalsIgnoreCase("LWPOLYLINE")) {
            var10_15 = (float)this.a(var1_1.getDouble(39));
            var11_27 = var1_1.getShort(70);
            var12_37 = (var11_27 & 1) != 0;
            var13_48 = var1_1.i();
            this.a(var13_48);
            if (var1_1.m()) {
                var14_42 = var1_1.l();
                var13_48 = DXFBulgeUtil.createPointsWithBulge(var13_48, var14_42, (int)var11_27);
            }
            var9_9 = this.d.createPolyline(var13_48, var12_37, false, var10_15, var8_8);
        } else if (var3_3.equalsIgnoreCase("SPLINE")) {
            var10_16 = var1_1.getShort(70);
            var11_28 = this.d(var1_1);
            this.a(var11_28);
            var12_38 = 0.0f;
            var13_49 = (var10_16 & 1) != 0;
            var9_9 = this.d.createSpline(var11_28, var13_49, var12_38, var8_8);
        } else if (var3_3.equalsIgnoreCase("VERTEX")) {
            if (this.u) {
                this.q.add(this.a((float)var1_1.getDouble(10), (float)var1_1.getDouble(20)));
                var10_17 = var1_1.getDouble(42);
                if (var10_17 > 0.0) {
                    this.x = true;
                }
                this.r.add(var10_17 == 0.0 ? null : new Double(var10_17));
            }
        } else if (var3_3.equalsIgnoreCase("SEQEND")) {
            if (this.u) {
                var10_18 = (this.w & 1) != 0;
                var11_29 = (this.w & 16) != 0;
                var12_39 = new IlvPoint[this.q.size()];
                this.q.toArray(var12_39);
                if (this.x) {
                    var13_50 = new Double[this.r.size()];
                    this.r.toArray(var13_50);
                    var12_39 = DXFBulgeUtil.createPointsWithBulge(var12_39, var13_50, (int)this.w);
                }
                var9_9 = this.d.createPolyline(var12_39, var10_18, var11_29, this.t, this.s);
                if (this.x && var9_9 instanceof IlvPolyline) {
                    ((IlvPolyline)var9_9).setEndCap(1);
                }
                this.q.clear();
                this.x = false;
                this.r.clear();
                this.s = null;
            } else {
                if (this.y != null) {
                    this.y = null;
                    return null;
                }
                this.d("Unexpected SEQEND entity");
            }
        } else if (var3_3.equalsIgnoreCase("DIMENSION")) {
            var9_9 = this.c(var1_1, var8_8);
        } else if (var3_3.equalsIgnoreCase("TEXT")) {
            var9_9 = this.a(var1_1, var8_8);
        } else if (var3_3.equalsIgnoreCase("MTEXT")) {
            var9_9 = this.b(var1_1, var8_8);
        } else if (var3_3.equalsIgnoreCase("TRACE")) {
            var10_19 = new IlvPoint[4];
            var10_19[0] = this.a((float)var1_1.getDouble(10), (float)var1_1.getDouble(20));
            var10_19[1] = this.a((float)var1_1.getDouble(11), (float)var1_1.getDouble(21));
            var10_19[3] = this.a((float)var1_1.getDouble(12), (float)var1_1.getDouble(22));
            var10_19[2] = this.a((float)var1_1.getDouble(13), (float)var1_1.getDouble(23));
            var11_30 = (float)this.a(var1_1.getDouble(39));
            var9_9 = this.d.createTrace(var10_19, var11_30, var8_8);
        } else if (var3_3.equalsIgnoreCase("SOLID")) {
            var10_20 = new IlvPoint[4];
            var10_20[0] = this.a((float)var1_1.getDouble(10), (float)var1_1.getDouble(20));
            var10_20[1] = this.a((float)var1_1.getDouble(11), (float)var1_1.getDouble(21));
            var10_20[3] = this.a((float)var1_1.getDouble(12), (float)var1_1.getDouble(22));
            var10_20[2] = this.a((float)var1_1.getDouble(13), (float)var1_1.getDouble(23));
            var11_31 = (float)this.a(var1_1.getDouble(39));
            var9_9 = this.d.createSolid(var10_20, var11_31, var8_8);
        } else if (var3_3.equalsIgnoreCase("3DFACE")) {
            var10_21 = new IlvPoint[]{this.a((float)var1_1.getDouble(10), (float)var1_1.getDouble(20)), this.a((float)var1_1.getDouble(11), (float)var1_1.getDouble(21)), this.a((float)var1_1.getDouble(12), (float)var1_1.getDouble(22)), this.a((float)var1_1.getDouble(13), (float)var1_1.getDouble(23))};
            var9_9 = this.d.create3DFace(var10_21, var8_8);
        } else if (var3_3.equalsIgnoreCase("INSERT")) {
            var10_22 = var1_1.getString(2);
            var11_32 = this.o == null ? null : this.c(var10_22);
            v3 = var12_40 = var11_32 == null ? null : (DXFElement)this.o.get(var1_1.getString(2).toLowerCase());
            if (var12_40 != null) {
                var13_51 = var1_1.a(41);
                var14_43 = var13_51 != null ? var13_51.d() : 1.0;
                var13_51 = var1_1.a(42);
                var16_46 = var13_51 != null ? var13_51.d() : 1.0;
                var13_51 = var1_1.a(70);
                if (var13_51 != null && var13_51.c() != 1) {
                    this.d("Column count " + var13_51.c() + " for INSERT not supported");
                }
                if ((var13_51 = var1_1.a(71)) != null && var13_51.c() != 1) {
                    this.d("Row count " + var13_51.c() + " for INSERT not supported");
                }
                if ((var13_51 = var1_1.a(44)) != null && var13_51.d() != 0.0) {
                    this.d("Column spacing " + var13_51.d() + " for INSERT not supported");
                }
                if ((var13_51 = var1_1.a(45)) != null && var13_51.d() != 0.0) {
                    this.d("Row spacing " + var13_51.d() + " for INSERT not supported");
                }
                if ((var18_52 = var1_1.a(66)) != null && (var18_52.c() & 1) != 0) {
                    this.y = var11_32;
                }
                var19_53 = new IlvTransformer(this.f);
                var20_54 = new IlvTransformer();
                var20_54.translate(-((float)var12_40.getDouble(10)), -((float)var12_40.getDouble(20)));
                var20_54.scale(0.0, 0.0, (float)var14_43, (float)var16_46);
                var13_51 = var1_1.a(50);
                if (var13_51 != null) {
                    var20_54.rotate(0.0, 0.0, (float)var13_51.d());
                }
                var20_54.translate((float)var1_1.getDouble(10), (float)var1_1.getDouble(20));
                var21_55 = this.ab;
                var20_54.compose(this.f);
                this.ab = false;
                this.f = var20_54;
                if (var11_32 != null) {
                    var22_56 = null;
                    for (DXFElement var24_58 : var11_32) {
                        var25_60 = this.c(var24_58);
                        if (var25_60 == null) continue;
                        if (var22_56 == null) {
                            var22_56 = new IlvGraphicVector();
                        }
                        var22_56.addElement(var25_60);
                    }
                    v4 = var24_59 = var22_56 != null ? var22_56.size() : 0;
                    if (var24_59 > 0) {
                        var9_9 = this.d.createInsert(var22_56, var10_22, var8_8);
                    }
                }
                this.f = var19_53;
                this.ab = var21_55;
            }
        } else if (var3_3.equalsIgnoreCase("ATTRIB")) {
            if (this.y != null) {
                return null;
            }
            this.d("Unexpected ATTRIB entity");
        } else if (var3_3.equalsIgnoreCase("ATTDEF")) {
            return null;
        }
        return var9_9;
    }

    private IlvPoint[] d(DXFElement dXFElement) {
        IlvPoint[] ilvPointArray = dXFElement.j();
        if (ilvPointArray != null && ilvPointArray.length > 0) {
            return ilvPointArray;
        }
        return dXFElement.k();
    }

    private void d(String string) {
        System.err.println(string);
    }

    /*
     * Unable to fully structure code
     */
    private IlvGraphic a(DXFElement var1_1, Color var2_2) {
        block13: {
            block12: {
                var3_3 = var1_1.getString(1);
                var4_4 = this.a(var1_1.getDouble(40));
                var6_5 = 1.0;
                if (var1_1.a(41) != null) {
                    var6_5 = var1_1.getDouble(41);
                }
                var8_6 = var1_1.getShort(72);
                var9_7 = var1_1.getShort(73);
                var10_8 = var8_6 == 0 && var9_7 == 0 || var1_1.a(11) == null || var1_1.a(21) == null;
                var11_9 = new IlvPoint(this.a((float)var1_1.getDouble(10), (float)var1_1.getDouble(20)));
                var12_10 = var10_8 != false ? null : new IlvPoint(this.a((float)var1_1.getDouble(11), (float)var1_1.getDouble(21)));
                var13_11 = var11_9;
                if (var3_3.startsWith("%%u")) ** GOTO lbl-1000
                if (var3_3.startsWith("%%U")) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = var14_12 = false;
                }
                if (var14_12 && (var15_13 = var3_3.length()) > 3 != 0) {
                    var3_3 = var3_3.substring(3, (int)var15_13);
                }
                var15_13 = this.getConfigurator().isTextAntialiasing();
                var16_14 = this.d.createText(var13_11, var3_3, var14_12, var15_13, IlvDXFReader.ae, var2_2);
                var17_15 = IlvDXFReader.a(var16_14, (float)var4_4);
                if (var6_5 != 1.0) {
                    var16_14.scale(var6_5, 1.0);
                }
                var18_16 = IlvDXFReader.a(var16_14);
                var19_17 = var18_16.width;
                var20_18 = var18_16.height;
                if (var8_6 != 1) break block12;
                var21_19 = var11_9.x - var18_16.x;
                var16_14.translate(var21_19, 0.0f);
                break block13;
            }
            if (var8_6 == 2) ** GOTO lbl37
            if (var8_6 == 4) {
lbl37:
                // 2 sources

                var21_19 = var12_10.x - (var18_16.x + var19_17 * 0.5f);
                var22_21 = var8_6 == 5 && var9_7 == 0 ? var12_10.y - (var18_16.y + var20_18 * 0.5f) : 0.0f;
                var16_14.translate(var21_19, var22_21);
            } else if (var8_6 == 5 && var12_10 != null) {
                var21_19 = Math.abs(var12_10.x - var11_9.x);
                var16_14.resize(var21_19, var17_15);
            }
        }
        if (var9_7 == 2) {
            var16_14.translate(0.0f, -var20_18 / 2.0f);
        } else if (var9_7 == 3) {
            var16_14.translate(0.0f, var20_18);
        }
        var21_20 = var1_1.getDouble(50);
        if (var21_20 != 0.0) {
            var23_22 = var13_11;
            var16_14.rotate(var23_22, -var21_20);
        }
        return var16_14;
    }

    private static IlvRect a(IlvGraphic ilvGraphic) {
        if (ilvGraphic instanceof IlvText) {
            return ((IlvText)ilvGraphic).getLabelBBox(null);
        }
        return ilvGraphic.boundingBox(null);
    }

    private static float a(IlvGraphic ilvGraphic, float f2) {
        float f3 = f2 * 2.0f;
        IlvText ilvText = ilvGraphic instanceof IlvText ? (IlvText)ilvGraphic : null;
        IlvRect ilvRect = null;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (ilvText != null) {
            IlvPoint ilvPoint = ilvText.getAnchorPoint();
            f4 = ilvPoint.x;
            f5 = ilvPoint.y;
            ilvRect = ilvText.getLabelBBox(null);
        } else {
            ilvRect = ilvGraphic.boundingBox(null);
            f4 = ilvRect.x;
            f5 = ilvRect.y + ilvRect.height;
        }
        float f6 = ilvRect.width;
        float f7 = ilvRect.height;
        float f8 = f3 / f7;
        ilvGraphic.resize(f6 * f8, f3);
        IlvRect ilvRect2 = ilvText != null ? ilvText.getLabelBBox(null) : ilvGraphic.boundingBox(null);
        float f9 = f4 - ilvRect2.x;
        float f10 = f5 - ilvRect2.y - ilvRect2.height * 0.75f;
        ilvGraphic.translate(f9, f10);
        return f3;
    }

    private IlvGraphic b(DXFElement dXFElement, Color color) {
        String string = dXFElement.getString(1);
        double d2 = this.a(dXFElement.getDouble(40));
        IlvPoint ilvPoint = new IlvPoint(this.a((float)dXFElement.getDouble(10), (float)dXFElement.getDouble(20)));
        string = this.e(string);
        boolean bl = this.getConfigurator().isTextAntialiasing();
        IlvGraphic ilvGraphic = this.d.createText(ilvPoint, string, false, bl, ae, color);
        IlvDXFReader.a(ilvGraphic, (float)d2);
        short s2 = dXFElement.getShort(71);
        IlvRect ilvRect = IlvDXFReader.a(ilvGraphic);
        float f2 = 0.0f;
        float f3 = 0.0f;
        switch (s2) {
            case 1: {
                f2 = ilvRect.x;
                f3 = ilvRect.y;
                break;
            }
            case 2: {
                f2 = ilvRect.x + ilvRect.width * 0.5f;
                f3 = ilvRect.y;
                break;
            }
            case 3: {
                f2 = ilvRect.x + ilvRect.width;
                f3 = ilvRect.y;
                break;
            }
            case 4: {
                f2 = ilvRect.x;
                f3 = ilvRect.y + ilvRect.height * 0.5f;
                break;
            }
            case 5: {
                f2 = ilvRect.x + ilvRect.width * 0.5f;
                f3 = ilvRect.y + ilvRect.height * 0.5f;
                break;
            }
            case 6: {
                f2 = ilvRect.x + ilvRect.width;
                f3 = ilvRect.y + ilvRect.height * 0.5f;
                break;
            }
            case 7: {
                f2 = ilvRect.x;
                f3 = ilvRect.y + ilvRect.height;
                break;
            }
            case 8: {
                f2 = ilvRect.x + ilvRect.width * 0.5f;
                f3 = ilvRect.y + ilvRect.height;
                break;
            }
            case 9: {
                f2 = ilvRect.x + ilvRect.width;
                f3 = ilvRect.y + ilvRect.height;
            }
        }
        float f4 = ilvPoint.x - f2;
        float f5 = ilvPoint.y - f3;
        ilvGraphic.translate(f4, f5);
        double d3 = dXFElement.getDouble(50);
        if (d3 != 0.0) {
            IlvPoint ilvPoint2 = ilvPoint;
            ilvGraphic.rotate(ilvPoint2, -d3);
        }
        return ilvGraphic;
    }

    private String e(String string) {
        int n2 = string.indexOf(";");
        if (n2 >= 0) {
            string = string.substring(n2 + 1, string.length() - 1);
        }
        return IlvDXFReader.a(string, "\\P", "\n");
    }

    private static String a(String string, String string2, String string3) {
        int n2 = string.indexOf(string2);
        if (n2 < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        do {
            stringBuffer.append(string.substring(n3, n2));
            stringBuffer.append(string3);
        } while ((n2 = string.indexOf(string, n3 = n2 + string2.length())) >= 0);
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    private IlvGraphic c(DXFElement dXFElement, Color color) {
        IlvPoint ilvPoint = new IlvPoint(this.a((float)dXFElement.getDouble(10), (float)dXFElement.getDouble(20)));
        IlvPoint ilvPoint2 = new IlvPoint(this.a((float)dXFElement.getDouble(11), (float)dXFElement.getDouble(21)));
        IlvPoint ilvPoint3 = new IlvPoint(this.a((float)dXFElement.getDouble(12), (float)dXFElement.getDouble(22)));
        IlvPoint ilvPoint4 = new IlvPoint(this.a((float)dXFElement.getDouble(13), (float)dXFElement.getDouble(23)));
        IlvPoint ilvPoint5 = new IlvPoint(this.a((float)dXFElement.getDouble(14), (float)dXFElement.getDouble(24)));
        IlvPoint ilvPoint6 = new IlvPoint(this.a((float)dXFElement.getDouble(15), (float)dXFElement.getDouble(25)));
        IlvPoint ilvPoint7 = new IlvPoint(this.a((float)dXFElement.getDouble(16), (float)dXFElement.getDouble(26)));
        String string = dXFElement.getString(1);
        short s2 = dXFElement.getShort(70);
        IlvGraphic ilvGraphic = this.d.createDimension(string, s2, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, ilvPoint5, ilvPoint6, ilvPoint7);
        return ilvGraphic;
    }
}

