/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvDefinitionRectInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.graphic.IlvArcUtil;
import ilog.views.graphic.IlvScale;
import ilog.views.internal.IlvUtility;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;

public class IlvCircularScale
extends IlvScale
implements IlvDefinitionRectInterface {
    private static final int a = 2;
    private boolean b;
    private float c;
    private float d;
    private int e = BOTH;
    public static int FIRST = 1;
    public static int LAST = 2;
    public static int BOTH = FIRST | LAST;

    public IlvCircularScale() {
        this(new IlvRect(0.0f, 0.0f, 100.0f, 100.0f), "0", 0.0f, 100.0f, 200.0f, -220.0f, true, 6, 5, 5.0f, 5.0f);
    }

    public IlvCircularScale(IlvRect ilvRect, String string, float f2, float f3, float f4, float f5, boolean bl, int n2, int n3, float f6, float f7) {
        super(ilvRect, n2, n3, f6, f7, f2, f3, string);
        this.b = bl;
        this.c = f4;
        this.d = f5;
    }

    public IlvCircularScale(IlvRect ilvRect, String[] stringArray, float f2, float f3, boolean bl, int n2, float f4, float f5) {
        super(ilvRect, stringArray, n2, f4, f5);
        this.b = bl;
        this.c = f2;
        this.d = f3;
    }

    public IlvCircularScale(IlvCircularScale ilvCircularScale) {
        super(ilvCircularScale);
        this.b = ilvCircularScale.b;
        this.c = ilvCircularScale.c;
        this.d = ilvCircularScale.d;
        this.e = ilvCircularScale.e;
    }

    public IlvCircularScale(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.b = ilvInputStream.readBoolean("inside");
        this.c = ilvInputStream.readFloat("start");
        this.d = ilvInputStream.readFloat("range");
        try {
            this.e = ilvInputStream.readInt("labelPolicy");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public IlvGraphic copy() {
        return new IlvCircularScale(this);
    }

    public final IlvRect getDefinitionRect() {
        return new IlvRect(((IlvScale)this).a);
    }

    public final void setDefinitionRect(IlvRect ilvRect) {
        ((IlvScale)this).a.setRect(ilvRect);
    }

    public IlvTransformer getDefinitionTransformer() {
        return null;
    }

    public final float getStart() {
        return this.c;
    }

    public final void setStart(float f2) {
        this.c = f2;
        while (this.c < 0.0f) {
            this.c += 360.0f;
        }
        while (this.c >= 360.0f) {
            this.c -= 360.0f;
        }
    }

    public final float getRange() {
        return this.d;
    }

    public final void setRange(float f2) {
        this.d = f2;
        while (this.d < -360.0f) {
            this.d += 360.0f;
        }
        while (this.d > 360.0f) {
            this.d -= 360.0f;
        }
    }

    public final boolean getLabelsInside() {
        return this.b;
    }

    public final void setLabelsInside(boolean bl) {
        this.b = bl;
    }

    public void setLabelPolicy(int n2) {
        if (n2 != 0 && n2 != FIRST && n2 != LAST && n2 != (FIRST | LAST)) {
            throw new IllegalArgumentException("Bad label visibility policy!");
        }
        this.e = n2;
    }

    public int getLabelPolicy() {
        return this.e;
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect(((IlvScale)this).a);
        IlvRect ilvRect2 = new IlvRect();
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvRect);
        }
        IlvArcUtil.ComputeArcBBox(ilvRect, this.c, this.d, ilvRect2);
        if (this.d >= 360.0f && this.b) {
            return ilvRect2;
        }
        int n2 = this.getNumberOfSteps() > 1 ? this.getNumberOfSteps() - 1 : this.getNumberOfSteps();
        int n3 = this.getNumberOfSubSteps();
        String[] stringArray = this.getLabels();
        float f2 = this.c;
        float f3 = n2 != 0 ? this.d / (float)n2 : this.d;
        float f4 = n2 != 0 && this.getNumberOfSubSteps() > 1 ? f3 / (float)this.getNumberOfSubSteps() : 0.0f;
        float f5 = ilvRect.width / 2.0f;
        float f6 = ilvRect.height / 2.0f;
        float f7 = this.getStepSize();
        float f8 = this.getSubStepSize();
        float f9 = this.b ? f5 - f7 : f5 + f7;
        float f10 = this.b ? f6 - f7 : f6 + f7;
        float f11 = this.b ? f5 - f8 : f5 + f8;
        float f12 = this.b ? f6 - f8 : f6 + f8;
        float f13 = this.b ? f9 - 2.0f : f9 + 2.0f;
        float f14 = this.b ? f10 - 2.0f : f10 + 2.0f;
        IlvRect ilvRect3 = new IlvRect();
        for (int i2 = 0; i2 <= n2; ++i2) {
            float f15;
            double d2 = Math.cos(IlvUtil.degreesToRadians(f2));
            double d3 = Math.sin(IlvUtil.degreesToRadians(f2));
            int n4 = (int)((double)ilvRect.x + (double)ilvRect.width / 2.0 + d2 * (double)f5);
            int n5 = (int)((double)ilvRect.y + (double)ilvRect.height / 2.0 - d3 * (double)f6);
            int n6 = (int)((double)ilvRect.x + (double)ilvRect.width / 2.0 + d2 * (double)f9);
            int n7 = (int)((double)ilvRect.y + (double)ilvRect.height / 2.0 - d3 * (double)f10);
            ilvRect2.add(n4, n5);
            ilvRect2.add(n6, n7);
            if (stringArray != null) {
                float f16 = this.a(i2);
                float f17 = this.b(i2);
                float f18 = this.c(i2);
                float f19 = (float)Math.min(d2 == 0.0 ? 100000.0 : Math.abs((double)(f16 / 2.0f) / d2), d3 == 0.0 ? 100000.0 : Math.abs((double)(f17 / 2.0f) / d3));
                if (!this.b) {
                    f19 = -f19;
                }
                f15 = ilvRect.x + ilvRect.width / 2.0f - f16 / 2.0f + (float)((double)(f13 - f19) * d2);
                float f20 = ilvRect.y + ilvRect.height / 2.0f + f17 / 2.0f + (float)((double)(-(f14 - f19)) * d3 - (double)f18);
                ilvRect3.move(f15, f20 - f17 + f18);
                ilvRect3.resize(f16, f17);
                if (this.d(i2)) {
                    ilvRect2.add(ilvRect3);
                }
            }
            if (i2 != n2) {
                f15 = f2 + f4;
                for (int i3 = 1; i3 < n3; ++i3) {
                    d2 = Math.cos(IlvUtil.degreesToRadians(f15));
                    d3 = Math.sin(IlvUtil.degreesToRadians(f15));
                    n4 = (int)((double)ilvRect.x + (double)ilvRect.width / 2.0 + d2 * (double)f5);
                    n5 = (int)((double)ilvRect.y + (double)ilvRect.height / 2.0 - d3 * (double)f6);
                    n6 = (int)((double)ilvRect.x + (double)ilvRect.width / 2.0 + d2 * (double)f11);
                    n7 = (int)((double)ilvRect.y + (double)ilvRect.height / 2.0 - d3 * (double)f12);
                    ilvRect2.add(n4, n5);
                    ilvRect2.add(n6, n7);
                    f15 += f4;
                }
            }
            f2 += f3;
        }
        ilvRect2.expand(1.0f);
        return ilvRect2;
    }

    public IlvPoint getCenter(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect(((IlvScale)this).a);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvRect);
        }
        return new IlvPoint(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height / 2.0f);
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        Rectangle rectangle;
        if (this.getNumberOfSteps() < 1) {
            return;
        }
        int n2 = this.getNumberOfSteps() - 1;
        int n3 = this.getNumberOfSubSteps();
        String[] stringArray = this.getLabels();
        IlvRect ilvRect = new IlvRect(((IlvScale)this).a);
        if (ilvTransformer != null) {
            ilvTransformer.applyFloor(ilvRect);
        }
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        Shape shape = null;
        IlvRect ilvRect2 = this.boundingBox(ilvTransformer);
        shape = graphics.getClip();
        Rectangle rectangle2 = shape != null ? shape.getBounds() : null;
        Rectangle rectangle3 = rectangle = rectangle2 != null ? rectangle2.intersection(new Rectangle((int)ilvRect2.x, (int)ilvRect2.y, (int)ilvRect2.width, (int)ilvRect2.height)) : new Rectangle((int)ilvRect2.x, (int)ilvRect2.y, (int)ilvRect2.width, (int)ilvRect2.height);
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
        graphics.drawArc(ilvRect.xFloor(), ilvRect.yFloor(), ilvRect.widthFloor(), ilvRect.heightFloor(), (int)Math.floor(this.c), (int)Math.ceil(this.d) + 1);
        if (this.b && ilvRect.width <= 2.0f || ilvRect.height <= 2.0f) {
            graphics.setClip(shape);
            return;
        }
        float f2 = this.c;
        float f3 = n2 != 0 ? this.d / (float)n2 : this.d;
        float f4 = n2 != 0 && n3 > 1 ? f3 / (float)n3 : 0.0f;
        float f5 = ilvRect.width / 2.0f;
        float f6 = ilvRect.height / 2.0f;
        float f7 = this.getStepSize();
        float f8 = this.getSubStepSize();
        float f9 = this.b ? f5 - f7 : f5 + f7;
        float f10 = this.b ? f6 - f7 : f6 + f7;
        float f11 = this.b ? f5 - f8 : f5 + f8;
        float f12 = this.b ? f6 - f8 : f6 + f8;
        float f13 = this.b ? f9 - 2.0f : f9 + 2.0f;
        float f14 = this.b ? f10 - 2.0f : f10 + 2.0f;
        boolean bl = this.isAntialiasing();
        ilvRect.width += 1.0f;
        ilvRect.height += 1.0f;
        for (int i2 = 0; i2 <= n2; ++i2) {
            float f15;
            double d2 = Math.cos(IlvUtil.degreesToRadians(f2));
            double d3 = Math.sin(IlvUtil.degreesToRadians(f2));
            int n4 = (int)((double)ilvRect.x + (double)ilvRect.width / 2.0 + d2 * (double)f5);
            int n5 = (int)((double)ilvRect.y + (double)ilvRect.height / 2.0 - d3 * (double)f6);
            int n6 = (int)((double)ilvRect.x + (double)ilvRect.width / 2.0 + d2 * (double)f9);
            int n7 = (int)((double)ilvRect.y + (double)ilvRect.height / 2.0 - d3 * (double)f10);
            graphics.drawLine(n4, n5, n6, n7);
            if (stringArray != null) {
                float f16 = this.a(i2);
                float f17 = this.b(i2);
                float f18 = (float)Math.min(d2 == 0.0 ? 100000.0 : Math.abs((double)(f16 / 2.0f) / d2), d3 == 0.0 ? 100000.0 : Math.abs((double)(f17 / 2.0f) / d3));
                if (!this.b) {
                    f18 = -f18;
                }
                f15 = ilvRect.x + ilvRect.width / 2.0f - f16 / 2.0f + (float)((double)(f13 - f18) * d2);
                float f19 = ilvRect.y + ilvRect.height / 2.0f + f17 / 2.0f + (float)((double)(-(f14 - f18)) * d3);
                if (this.d(i2)) {
                    IlvGraphicUtil.DrawString(graphics, stringArray[i2], (int)Math.floor(f15), (int)Math.floor(f19), bl);
                }
            }
            if (i2 != n2) {
                f15 = f2 + f4;
                for (int i3 = 1; i3 < n3; ++i3) {
                    d2 = Math.cos(IlvUtil.degreesToRadians(f15));
                    d3 = Math.sin(IlvUtil.degreesToRadians(f15));
                    n4 = (int)((double)ilvRect.x + (double)ilvRect.width / 2.0 + d2 * (double)f5);
                    n5 = (int)((double)ilvRect.y + (double)ilvRect.height / 2.0 - d3 * (double)f6);
                    n6 = (int)((double)ilvRect.x + (double)ilvRect.width / 2.0 + d2 * (double)f11);
                    n7 = (int)((double)ilvRect.y + (double)ilvRect.height / 2.0 - d3 * (double)f12);
                    graphics.drawLine(n4, n5, n6, n7);
                    f15 += f4;
                }
            }
            f2 += f3;
        }
        graphics.setClip(shape);
    }

    private boolean d(int n2) {
        if (this.e == BOTH) {
            return true;
        }
        if (n2 == 0 && (this.e & FIRST) == 0) {
            return false;
        }
        return n2 != this.getNumberOfSteps() - 1 || (this.e & LAST) != 0;
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        String[] stringArray;
        IlvRect ilvRect = new IlvRect(((IlvScale)this).a);
        IlvRect ilvRect2 = new IlvRect(((IlvScale)this).a);
        float f2 = Math.max(this.getStepSize(), this.getSubStepSize());
        if (this.b) {
            ilvRect2.x += f2;
            ilvRect2.y += f2;
            ilvRect2.width -= 2.0f * f2;
            ilvRect2.height -= 2.0f * f2;
        } else {
            ilvRect2.x -= f2;
            ilvRect2.y -= f2;
            ilvRect2.width += 2.0f * f2;
            ilvRect2.height += 2.0f * f2;
        }
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvRect);
            ilvTransformer.apply(ilvRect2);
        }
        if ((stringArray = this.getLabels()) != null) {
            float f3 = this.c;
            float f4 = this.getNumberOfSteps() > 1 ? this.d / (float)(this.getNumberOfSteps() - 1) : this.d;
            float f5 = this.getStepSize();
            float f6 = ilvRect.width / 2.0f;
            float f7 = ilvRect.height / 2.0f;
            float f8 = this.b ? f6 - f5 - 2.0f : f6 + f5 + 2.0f;
            float f9 = this.b ? f7 - f5 - 2.0f : f7 + f5 + 2.0f;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (this.d(i2) && stringArray[i2] != null) {
                    double d2 = Math.cos(IlvUtil.degreesToRadians(f3));
                    double d3 = Math.sin(IlvUtil.degreesToRadians(f3));
                    int n2 = this.a(i2);
                    int n3 = this.b(i2);
                    int n4 = this.c(i2);
                    float f10 = (float)Math.min(d2 == 0.0 ? 100000.0 : Math.abs((double)(n2 / 2) / d2), d3 == 0.0 ? 100000.0 : Math.abs((double)(n3 / 2) / d3));
                    if (!this.b) {
                        f10 = -f10;
                    }
                    float f11 = ilvRect.x + ilvRect.width / 2.0f - (float)(n2 / 2) + (float)((double)(f8 - f10) * d2);
                    float f12 = ilvRect.y + ilvRect.height / 2.0f - (float)(n3 / 2 + n4) + (float)((double)(-(f9 - f10)) * d3 - (double)n4);
                    if (ilvPoint2.x >= f11 && ilvPoint2.x <= f11 + (float)n2 && ilvPoint2.y >= f12 && ilvPoint2.y <= f12 + (float)n3) {
                        return true;
                    }
                }
                f3 += f4;
            }
        }
        if (this.b) {
            return IlvArcUtil.PointInFilledArc(ilvPoint2, ilvRect, this.c, this.d) && !IlvArcUtil.PointInFilledArc(ilvPoint2, ilvRect2, this.c, this.d);
        }
        return IlvArcUtil.PointInFilledArc(ilvPoint2, ilvRect2, this.c, this.d) && !IlvArcUtil.PointInFilledArc(ilvPoint2, ilvRect, this.c, this.d);
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        if (ilvTransformer != null) {
            ilvTransformer.apply(((IlvScale)this).a);
        }
        if (((IlvScale)this).a.width < 1.0E-20f) {
            ((IlvScale)this).a.width = 1.0E-20f;
        }
        if (((IlvScale)this).a.height < 1.0E-20f) {
            ((IlvScale)this).a.height = 1.0E-20f;
        }
    }

    public void moveResize(IlvRect ilvRect) {
        super.moveResize(ilvRect);
        IlvUtility.correctMoveResizeNonzoomableGraphic(this, ilvRect, true, true);
    }

    public boolean zoomable() {
        return false;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("inside", this.b);
        ilvOutputStream.write("start", this.c);
        ilvOutputStream.write("range", this.d);
        ilvOutputStream.write("labelPolicy", this.e);
    }
}

