/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvFontInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvToolkit;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvShadowRectangle;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;

public class IlvShadowLabel
extends IlvShadowRectangle
implements IlvFontInterface,
IlvLabelInterface {
    private Font a = IlvToolkit.defaultFont;
    private String b = null;
    private IlvRect c;

    public IlvShadowLabel() {
        this(new IlvRect(0.0f, 0.0f, 100.0f, 100.0f), "", 2.0f, 10);
    }

    public IlvShadowLabel(IlvRect ilvRect, String string, float f2, int n2) {
        super(ilvRect, f2, n2);
        this.setLabel(string);
    }

    public IlvShadowLabel(IlvPoint ilvPoint, String string, float f2, float f3, float f4, int n2) {
        super(new IlvRect(ilvPoint.x, ilvPoint.y, 10.0f, 10.0f), f2, n2);
        this.setLabel(string);
        this.fitToLabel(f3, f4);
    }

    public IlvShadowLabel(IlvShadowLabel ilvShadowLabel) {
        super(ilvShadowLabel);
        this.setLabel(ilvShadowLabel.getLabel());
        this.setFont(ilvShadowLabel.getFont());
        this.setAntialiasing(ilvShadowLabel.isAntialiasing());
    }

    public IlvShadowLabel(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setLabel(ilvInputStream.readString("label"));
        this.setFont(ilvInputStream.readFont("font"));
        try {
            this.setAntialiasing(ilvInputStream.readBoolean("antialiasing"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public IlvGraphic copy() {
        return new IlvShadowLabel(this);
    }

    public String getLabel() {
        return this.b;
    }

    public void setLabel(String string) {
        if (this.b == string && this.c != null) {
            return;
        }
        if (string == null || string == null || !string.equals(this.b)) {
            this.b = string;
            this.g();
        }
    }

    public void fitToLabel(float f2, float f3) {
        this.drawrect.resize(this.c.width + 2.0f * f2, this.c.height + 2.0f * f3);
    }

    public Font getFont() {
        return this.a;
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        if (font == this.a) {
            return;
        }
        this.a = font;
        this.g();
    }

    public final boolean isAntialiasing() {
        return this.getProperty("__ILVAntialiasing") != null;
    }

    public final void setAntialiasing(boolean bl) {
        if (bl == this.isAntialiasing()) {
            return;
        }
        this.setProperty("__ILVAntialiasing", bl ? new Boolean(true) : null);
        this.g();
    }

    public boolean supportMultiline() {
        return false;
    }

    public IlvRect getLabelBBox(IlvTransformer ilvTransformer) {
        return this.boundingBox(ilvTransformer);
    }

    private void g() {
        this.c = IlvGraphicUtil.GetStringBounds(this.getLabel(), this.getFont(), this.isAntialiasing());
    }

    public void drawLabel(Graphics graphics, IlvRect ilvRect, IlvTransformer ilvTransformer) {
        Rectangle rectangle;
        String string = this.getLabel();
        if (string == null) {
            return;
        }
        Shape shape = graphics.getClip();
        Rectangle rectangle2 = shape != null ? shape.getBounds() : null;
        Rectangle rectangle3 = rectangle = rectangle2 != null ? rectangle2.intersection(new Rectangle((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height)) : new Rectangle((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
        if (rectangle.width != 0 && rectangle.height != 0) {
            boolean bl = this.isAntialiasing();
            Font font = this.getFont();
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            IlvRect ilvRect2 = this.c;
            int n2 = (int)Math.floor(ilvRect.x) + (int)Math.floor(ilvRect.width) / 2 - (int)Math.floor(ilvRect2.width) / 2;
            int n3 = (int)Math.floor(ilvRect.y) + ((int)Math.floor(ilvRect.height) + (int)Math.floor(ilvRect2.height)) / 2;
            graphics.setColor(this.getForeground());
            graphics.setFont(font);
            IlvGraphicUtil.DrawString(graphics, string, n2, n3, bl);
            graphics.setClip(shape);
        }
    }

    protected void drawContent(Graphics graphics, IlvRect ilvRect, IlvTransformer ilvTransformer) {
        this.drawLabel(graphics, ilvRect, ilvTransformer);
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("label", this.getLabel());
        ilvOutputStream.write("font", this.getFont());
        if (this.isAntialiasing()) {
            ilvOutputStream.write("antialiasing", this.isAntialiasing());
        }
    }

    public String toString() {
        String string = this.getLabel();
        return super.toString() + (string != null ? " Label: " + string : " (no label)");
    }
}

