/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.internal.impl;

import ilog.views.internal.IlvBlinkingUtil;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.util.java2d.IlvBlinkingMultiPaint;
import ilog.views.util.java2d.IlvBlinkingPaint;
import ilog.views.util.java2d.IlvPattern;
import ilog.views.util.java2d.IlvTexture;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

public final class IlvUtility2D {
    private IlvUtility2D() {
    }

    public static void writePaint(IlvOutputStream ilvOutputStream, Paint paint, String string, String string2, Color color) throws IOException {
        IlvPersistentObject ilvPersistentObject = IlvBlinkingUtil.getProxyFromPaint(paint);
        if (ilvPersistentObject != null) {
            ilvOutputStream.write(string2 + "ppaint", ilvPersistentObject);
        } else if (paint instanceof Color) {
            ilvOutputStream.write(string, (Color)paint);
        } else if (paint instanceof IlvPersistentObject) {
            ilvOutputStream.write(string2 + "ppaint", (IlvPersistentObject)((Object)paint));
        } else if (paint instanceof GradientPaint) {
            ilvOutputStream.write(string2 + "gradient", (GradientPaint)paint);
        } else if (paint instanceof IlvPattern) {
            ilvOutputStream.write(string2 + "pattern", (IlvPattern)paint);
        } else if (paint instanceof IlvTexture) {
            ilvOutputStream.write(string2 + "texture", (IlvTexture)paint);
        } else {
            ilvOutputStream.write(string, color);
        }
    }

    public static void writeStrokePaint(IlvOutputStream ilvOutputStream, Paint paint) throws IOException {
        IlvUtility2D.writePaint(ilvOutputStream, paint, "strokeColor", "s", Color.black);
    }

    public static void writePaint(IlvOutputStream ilvOutputStream, Paint paint) throws IOException {
        IlvUtility2D.writePaint(ilvOutputStream, paint, "fillColor", "", Color.black);
    }

    public static Paint readPaint(IlvInputStream ilvInputStream, String string, String string2) throws IlvReadFileException {
        Paint paint = null;
        try {
            paint = ilvInputStream.readColor(string);
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            try {
                paint = ilvInputStream.readGradient(string2 + "gradient");
            }
            catch (IlvFieldNotFoundException ilvFieldNotFoundException2) {
                try {
                    paint = ilvInputStream.readPattern(string2 + "pattern");
                }
                catch (IlvFieldNotFoundException ilvFieldNotFoundException3) {
                    try {
                        paint = ilvInputStream.readTexture(string2 + "texture");
                    }
                    catch (IlvFieldNotFoundException ilvFieldNotFoundException4) {
                        IlvPersistentObject ilvPersistentObject = ilvInputStream.readPersistentObject(string2 + "ppaint");
                        paint = ilvPersistentObject instanceof Paint ? (Paint)((Object)ilvPersistentObject) : IlvBlinkingUtil.getPaintFromProxy(ilvPersistentObject);
                    }
                }
            }
        }
        return paint;
    }

    public static Paint readPaint(IlvInputStream ilvInputStream) throws IlvReadFileException {
        return IlvUtility2D.readPaint(ilvInputStream, "fillColor", "");
    }

    public static Paint readStrokePaint(IlvInputStream ilvInputStream) throws IlvReadFileException {
        return IlvUtility2D.readPaint(ilvInputStream, "strokeColor", "s");
    }

    public static Paint AdaptPaint(Shape shape, Paint paint) {
        if (paint instanceof Color) {
            return paint;
        }
        if (paint instanceof IlvBlinkingPaint) {
            IlvBlinkingPaint ilvBlinkingPaint = (IlvBlinkingPaint)paint;
            Paint paint2 = ilvBlinkingPaint.getOnPaint();
            Paint paint3 = ilvBlinkingPaint.getOffPaint();
            Paint paint4 = IlvUtility2D.AdaptPaint(shape, paint2);
            Paint paint5 = IlvUtility2D.AdaptPaint(shape, paint3);
            if (paint2 == paint4 && paint3 == paint5) {
                return paint;
            }
            return new IlvBlinkingPaint(paint4, paint5, ilvBlinkingPaint.getOnPeriod(), ilvBlinkingPaint.getOffPeriod());
        }
        if (paint instanceof IlvBlinkingMultiPaint) {
            IlvBlinkingMultiPaint ilvBlinkingMultiPaint = (IlvBlinkingMultiPaint)paint;
            Paint[] paintArray = ilvBlinkingMultiPaint.getPaints();
            Paint[] paintArray2 = new Paint[paintArray.length];
            boolean bl = false;
            for (int i2 = 0; i2 < paintArray.length; ++i2) {
                paintArray2[i2] = IlvUtility2D.AdaptPaint(shape, paintArray[i2]);
                if (paintArray2[i2] == paintArray[i2]) continue;
                bl = true;
            }
            if (!bl) {
                return paint;
            }
            return new IlvBlinkingMultiPaint(ilvBlinkingMultiPaint.getPeriod(), paintArray2);
        }
        if (paint instanceof GradientPaint) {
            double d2;
            double d3;
            double d4;
            double d5;
            Rectangle2D rectangle2D = shape.getBounds2D();
            GradientPaint gradientPaint = (GradientPaint)paint;
            Point2D point2D = gradientPaint.getPoint1();
            Point2D point2D2 = gradientPaint.getPoint2();
            boolean bl = gradientPaint.isCyclic();
            if (point2D.getX() == point2D2.getX()) {
                d4 = d5 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0;
                if (point2D.getY() > point2D2.getY()) {
                    d3 = rectangle2D.getY() + rectangle2D.getHeight();
                    d2 = bl ? rectangle2D.getY() + rectangle2D.getHeight() / 2.0 : rectangle2D.getY();
                } else {
                    d3 = rectangle2D.getY();
                    d2 = bl ? rectangle2D.getY() + rectangle2D.getHeight() / 2.0 : rectangle2D.getY() + rectangle2D.getHeight();
                }
            } else if (point2D.getY() == point2D2.getY()) {
                d2 = d3 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0;
                if (point2D.getX() > point2D2.getX()) {
                    d5 = rectangle2D.getX() + rectangle2D.getWidth();
                    d4 = bl ? rectangle2D.getX() + rectangle2D.getWidth() / 2.0 : rectangle2D.getX();
                } else {
                    d5 = rectangle2D.getX();
                    d4 = bl ? rectangle2D.getX() + rectangle2D.getWidth() / 2.0 : rectangle2D.getX() + rectangle2D.getWidth();
                }
            } else if (point2D.getX() > point2D2.getX()) {
                d5 = rectangle2D.getX() + rectangle2D.getWidth();
                d4 = bl ? rectangle2D.getX() + rectangle2D.getWidth() / 2.0 : rectangle2D.getX();
                if (point2D.getY() > point2D2.getY()) {
                    d3 = rectangle2D.getY() + rectangle2D.getHeight();
                    d2 = bl ? rectangle2D.getY() + rectangle2D.getHeight() / 2.0 : rectangle2D.getY();
                } else {
                    d3 = rectangle2D.getY();
                    d2 = bl ? rectangle2D.getY() + rectangle2D.getHeight() / 2.0 : rectangle2D.getY() + rectangle2D.getHeight();
                }
            } else {
                d5 = rectangle2D.getX();
                d4 = bl ? rectangle2D.getX() + rectangle2D.getWidth() / 2.0 : rectangle2D.getX() + rectangle2D.getWidth();
                if (point2D.getY() > point2D2.getY()) {
                    d3 = rectangle2D.getY() + rectangle2D.getHeight();
                    d2 = bl ? rectangle2D.getY() + rectangle2D.getHeight() / 2.0 : rectangle2D.getY();
                } else {
                    d3 = rectangle2D.getY();
                    d2 = bl ? rectangle2D.getY() + rectangle2D.getHeight() / 2.0 : rectangle2D.getY() + rectangle2D.getHeight();
                }
            }
            point2D.setLocation(d5, d3);
            point2D2.setLocation(d4, d2);
            return new GradientPaint(point2D, gradientPaint.getColor1(), point2D2, gradientPaint.getColor2(), gradientPaint.isCyclic());
        }
        if (paint instanceof TexturePaint) {
            Rectangle2D rectangle2D = shape.getBounds2D();
            TexturePaint texturePaint = (TexturePaint)paint;
            Rectangle2D rectangle2D2 = texturePaint.getAnchorRect();
            rectangle2D2.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
            return new TexturePaint(texturePaint.getImage(), rectangle2D2);
        }
        return paint;
    }

    public static void SetAlphaComposite(Graphics graphics, float f2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (f2 == 1.0f) {
            graphics2D.setComposite(AlphaComposite.SrcOver);
        } else {
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f2);
            graphics2D.setComposite(alphaComposite);
        }
    }

    public static float GetAlphaComposite(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        if (composite == null) {
            return 1.0f;
        }
        if (composite instanceof AlphaComposite) {
            return ((AlphaComposite)composite).getAlpha();
        }
        return 1.0f;
    }

    public static Composite SetComposedAlpha(Graphics2D graphics2D, float f2) {
        Composite composite = null;
        if (f2 != 1.0f) {
            composite = graphics2D.getComposite();
            IlvUtility2D.SetAlphaComposite(graphics2D, f2 *= IlvUtility2D.GetAlphaComposite(graphics2D));
            return composite;
        }
        return null;
    }
}

