/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.servlet;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvLayerVisibilityFilter;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.IlvRegion;
import ilog.views.IlvTransformer;
import ilog.views.servlet.IlvImageMapAreaGenerator;
import ilog.views.servlet.IlvManagerPopupServletSupport;
import ilog.views.servlet.ServerActionEvent;
import ilog.views.servlet.ServerActionListener;
import ilog.views.servlet.internal.IlvManagerServletUtil;
import ilog.views.util.servlet.IlvPopupMenuServletSupport;
import ilog.views.util.servlet.IlvSelectionSupport;
import ilog.views.util.servlet.internal.IlvServletUtil;
import ilog.views.util.servlet.tiling.IlvTileManager;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IlvManagerServletSupport {
    public static final String ImageMapAreaGeneratorProperty = "__ilvImageMapAreaGenerator";
    private static final int a = 10;
    private static final int b = 1;
    private boolean c = true;
    private float d = 0.75f;
    private boolean e = false;
    private EventListenerList f = new EventListenerList();
    ServletContext g = null;
    private IlvPopupMenuServletSupport h;
    private IlvSelectionSupport i;
    private boolean j = false;
    private boolean k = false;
    private boolean l = false;
    private double[] m;
    private static final String n = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final Pattern o = Pattern.compile("[,()]");
    private static final DateFormat p = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private static final IlvLayerVisibilityFilter q = new IlvLayerVisibilityFilter(){

        public boolean isPersistent() {
            return false;
        }

        public boolean isVisible(IlvManagerLayer ilvManagerLayer, IlvManagerView ilvManagerView) {
            return false;
        }
    };
    private static final Runnable r;

    public IlvManagerServletSupport(ServletContext servletContext) {
        this.g = servletContext;
    }

    public ServletContext getContext() {
        return this.g;
    }

    public final void setVerbose(boolean bl) {
        this.e = bl;
    }

    public final boolean isVerbose() {
        return this.e;
    }

    public void setPopupEnabled(boolean bl) {
        if (this.k != bl) {
            this.k = bl;
            if (bl) {
                this.getPopupMenuSupport().installListeners();
            } else if (this.h != null) {
                this.h.removeListeners();
                this.h = null;
            }
        }
    }

    public final boolean isPopupEnabled() {
        return this.k;
    }

    public final IlvPopupMenuServletSupport getPopupMenuSupport() {
        if (this.k) {
            if (this.h == null) {
                this.h = this.createPopupMenuSupport();
                this.h.setServletContext(this.g);
            }
            return this.h;
        }
        return null;
    }

    protected IlvPopupMenuServletSupport createPopupMenuSupport() {
        return new IlvManagerPopupServletSupport(this);
    }

    public final boolean isSelectionEnabled() {
        return this.j;
    }

    public void setSelectionEnabled(boolean bl) {
        if (this.j != bl) {
            this.j = bl;
            if (bl) {
                this.getSelectionSupport().installListeners();
            } else {
                if (this.i != null) {
                    this.i.removeListeners();
                }
                this.i = null;
            }
        }
    }

    public final IlvSelectionSupport getSelectionSupport() {
        if (this.j) {
            if (this.i == null) {
                this.i = this.createSelectionSupport();
            }
            return this.i;
        }
        return null;
    }

    protected IlvSelectionSupport createSelectionSupport() {
        return null;
    }

    public final void setAntialiasing(boolean bl) {
        this.c = bl;
    }

    public final boolean getAntialiasing() {
        return this.c;
    }

    public final void setContentLengthEnable(boolean bl) {
        this.l = bl;
    }

    public final boolean getContentLengthEnable() {
        return this.l;
    }

    public final void setJPEGQuality(float f2) {
        if (f2 < 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("quality must be in [0-1] range");
        }
        this.d = f2;
    }

    public final float getJPEGQuality() {
        return this.d;
    }

    public abstract IlvManagerView getManagerView(HttpServletRequest var1) throws ServletException;

    protected IlvRect getManagerBBox(HttpServletRequest httpServletRequest, IlvManagerView ilvManagerView) throws ServletException {
        return this.a(httpServletRequest, ilvManagerView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final IlvRect a(HttpServletRequest httpServletRequest, IlvManagerView ilvManagerView) throws ServletException {
        boolean bl = IlvServletUtil.getOptionalBooleanParameter(httpServletRequest, "tiled", false);
        IlvManager ilvManager = ilvManagerView.getManager();
        IlvRect ilvRect = null;
        if (bl) {
            Object object = this.getLock(httpServletRequest);
            synchronized (object) {
                IlvManagerLayer[] ilvManagerLayerArray = this.getDynamicLayers(httpServletRequest, ilvManagerView);
                IlvManagerLayer[] ilvManagerLayerArray2 = this.getLayers(httpServletRequest, ilvManagerView);
                for (int i2 = 0; i2 < ilvManagerLayerArray2.length; ++i2) {
                    boolean bl2;
                    boolean bl3 = false;
                    for (bl2 = false; !bl3 && bl2 < ilvManagerLayerArray.length; bl2 += 1) {
                        bl3 = ilvManagerLayerArray2[i2] == ilvManagerLayerArray[bl2];
                    }
                    if (bl3) continue;
                    bl2 = ilvManager.isVisible(ilvManagerLayerArray2[i2].getIndex());
                    ilvManager.setVisible(ilvManagerLayerArray2[i2].getIndex(), true, false);
                    IlvRect ilvRect2 = ilvManagerLayerArray2[i2].computeBBox(null);
                    if (ilvRect == null) {
                        ilvRect = ilvRect2;
                    } else {
                        ilvRect.add(ilvRect2);
                    }
                    ilvManager.setVisible(ilvManagerLayerArray2[i2].getIndex(), bl2, false);
                }
            }
        } else {
            ilvRect = ilvManager.computeBBox(null);
        }
        if (ilvRect == null) {
            ilvRect = new IlvRect(0.0f, 0.0f, 1.0f, 1.0f);
        }
        return ilvRect;
    }

    protected float getMaxZoomLevel(HttpServletRequest httpServletRequest, IlvManagerView ilvManagerView) {
        return this.b(httpServletRequest, ilvManagerView);
    }

    final float b(HttpServletRequest httpServletRequest, IlvManagerView ilvManagerView) {
        return 10.0f;
    }

    protected float getMinZoomLevel(HttpServletRequest httpServletRequest, IlvManagerView ilvManagerView) {
        return this.c(httpServletRequest, ilvManagerView);
    }

    final float c(HttpServletRequest httpServletRequest, IlvManagerView ilvManagerView) {
        return 1.0f;
    }

    public IlvManagerLayer[] getLayers(HttpServletRequest httpServletRequest, IlvManagerView ilvManagerView) throws ServletException {
        return this.d(httpServletRequest, ilvManagerView);
    }

    final IlvManagerLayer[] d(HttpServletRequest httpServletRequest, IlvManagerView ilvManagerView) throws ServletException {
        IlvManager ilvManager = ilvManagerView.getManager();
        IlvManagerLayer[] ilvManagerLayerArray = new IlvManagerLayer[ilvManager.getLayersCount()];
        for (int i2 = 0; i2 < ilvManagerLayerArray.length; ++i2) {
            ilvManagerLayerArray[i2] = ilvManager.getManagerLayer(i2);
        }
        return ilvManagerLayerArray;
    }

    protected boolean isOverviewLayer(HttpServletRequest httpServletRequest, IlvManagerLayer ilvManagerLayer) {
        return this.a(httpServletRequest, ilvManagerLayer);
    }

    final boolean a(HttpServletRequest httpServletRequest, IlvManagerLayer ilvManagerLayer) {
        return true;
    }

    protected Object getLock(HttpServletRequest httpServletRequest) {
        return this.a(httpServletRequest);
    }

    public Object getInternalLock(HttpServletRequest httpServletRequest) {
        return this.getLock(httpServletRequest);
    }

    final Object a(HttpServletRequest httpServletRequest) {
        IlvManagerView ilvManagerView = null;
        IlvRegion ilvRegion = null;
        try {
            ilvManagerView = this.getManagerView(httpServletRequest);
            ilvRegion = ilvManagerView.getRegion();
        }
        catch (ServletException servletException) {
            // empty catch block
        }
        return ilvRegion;
    }

    public final void addServerActionListener(ServerActionListener serverActionListener) {
        this.f.add(ServerActionListener.class, serverActionListener);
    }

    public final void removeServerActionListener(ServerActionListener serverActionListener) {
        this.f.remove(ServerActionListener.class, serverActionListener);
    }

    protected BufferedImage generateImage(HttpServletRequest httpServletRequest, IlvRect ilvRect, int n2, int n3, String[] stringArray, Color color, boolean bl) throws ServletException {
        return this.a(httpServletRequest, ilvRect, n2, n3, stringArray, color, bl);
    }

    BufferedImage a(HttpServletRequest httpServletRequest, IlvRect ilvRect, int n2, int n3, String[] stringArray, Color color, boolean bl) throws ServletException {
        IlvTileManager ilvTileManager;
        if (this.useTileManager(httpServletRequest) && (ilvTileManager = this.getTileManager(httpServletRequest)) != null) {
            Object object = this.getKey(httpServletRequest);
            BufferedImage bufferedImage = ilvTileManager.getImage(object);
            if (bufferedImage == null) {
                bufferedImage = this.b(httpServletRequest, ilvRect, n2, n3, stringArray, color, bl);
                ilvTileManager.putImage(object, bufferedImage);
            }
            return bufferedImage;
        }
        return this.b(httpServletRequest, ilvRect, n2, n3, stringArray, color, bl);
    }

    protected Object getKey(HttpServletRequest httpServletRequest) {
        try {
            IlvManagerView ilvManagerView = this.getManagerView(httpServletRequest);
            IlvRect ilvRect = this.getManagerBBox(httpServletRequest, ilvManagerView);
            IlvRect ilvRect2 = IlvManagerServletSupport.a(httpServletRequest, ilvManagerView, ilvRect);
            return ilvRect2;
        }
        catch (ServletException servletException) {
            if (this.isVerbose()) {
                this.b(servletException.toString());
            }
            return new IlvRect();
        }
    }

    private static IlvRect a(HttpServletRequest httpServletRequest, IlvManagerView ilvManagerView, IlvRect ilvRect) throws ServletException {
        IlvRect ilvRect2 = new IlvRect();
        String string = httpServletRequest.getParameter("tile");
        if (string == null) {
            throw new ServletException("No bbox or tile parameter");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new ServletException("bad tile " + string);
        }
        String string2 = stringTokenizer.nextToken();
        float f2 = Float.parseFloat(string2);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new ServletException("bad tile " + string);
        }
        string2 = stringTokenizer.nextToken();
        int n2 = Integer.parseInt(string2);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new ServletException("bad tile " + string);
        }
        string2 = stringTokenizer.nextToken();
        int n3 = Integer.parseInt(string2);
        ilvRect2 = new IlvRect(n2, n3, f2, -1.0f);
        return ilvRect2;
    }

    protected boolean useTileManager(HttpServletRequest httpServletRequest) {
        return this.b(httpServletRequest);
    }

    protected IlvTileManager getTileManager(HttpServletRequest httpServletRequest) throws ServletException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferedImage b(HttpServletRequest httpServletRequest, IlvRect ilvRect, int n2, int n3, String[] stringArray, Color color, boolean bl) throws ServletException {
        Object object;
        Object object2;
        Object object3;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, bl ? 2 : 1);
        Graphics graphics = bufferedImage.getGraphics();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.c) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (bl) {
            object3 = AlphaComposite.getInstance(3, 0.0f);
            graphics2D.setComposite((Composite)object3);
        }
        graphics.setColor(color);
        graphics.setClip(0, 0, n2, n3);
        graphics.fillRect(0, 0, n2, n3);
        if (bl) {
            graphics2D.setComposite(AlphaComposite.SrcOver);
        }
        object3 = IlvManagerServletUtil.getTransformer(ilvRect, n2, n3);
        if (this.isVerbose()) {
            this.b("Starts generating image");
            this.b("  width=" + n2);
            this.b("  height=" + n3);
            this.b("  format=" + IlvServletUtil.getStringParameter(httpServletRequest, "format"));
            this.b("  bbox=" + ilvRect);
            this.b("  zoomlevel=" + ((IlvTransformer)object3).zoomFactor());
            object2 = new StringBuffer("  layers=");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                ((StringBuffer)object2).append(stringArray[i2] + " ");
            }
            this.b(((StringBuffer)object2).toString());
            this.b("  bgColor=" + color);
            this.b("  transparent=" + bl);
            object = httpServletRequest.getParameter("dynamic");
            this.b("  dynamic=" + (object != null));
        }
        object2 = this.getLock(httpServletRequest);
        synchronized (object2) {
            int n4;
            object = this.getManagerView(httpServletRequest);
            this.prepareManagerView(httpServletRequest, (IlvManagerView)object);
            IlvManagerLayer[] ilvManagerLayerArray = this.getLayers(httpServletRequest, (IlvManagerView)object);
            Vector<IlvManagerLayer> vector = new Vector<IlvManagerLayer>(ilvManagerLayerArray.length);
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                int n5;
                String string = stringArray[i3];
                IlvManagerLayer ilvManagerLayer = null;
                for (n5 = 0; n5 < ilvManagerLayerArray.length; ++n5) {
                    if (ilvManagerLayerArray[n5].getName() == null || !ilvManagerLayerArray[n5].getName().equals(string)) continue;
                    ilvManagerLayer = ilvManagerLayerArray[n5];
                    break;
                }
                if (ilvManagerLayer == null) {
                    try {
                        n5 = Integer.parseInt(string);
                        if (n5 >= 0 && n5 < ilvManagerLayerArray.length) {
                            ilvManagerLayer = ilvManagerLayerArray[n5];
                        }
                    }
                    catch (Exception exception) {
                        throw new ServletException("bad layer : " + string, (Throwable)exception);
                    }
                }
                if (ilvManagerLayer == null) {
                    throw new ServletException("bad layer : " + string);
                }
                vector.addElement(ilvManagerLayer);
            }
            Object[] objectArray = new IlvManagerLayer[vector.size()];
            vector.copyInto(objectArray);
            ((IlvManagerView)object).setBounds(0, 0, n2, n3);
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(r);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            for (n4 = 0; n4 < ilvManagerLayerArray.length; ++n4) {
                ilvManagerLayerArray[n4].addVisibilityFilter(q);
            }
            for (n4 = 0; n4 < objectArray.length; ++n4) {
                ((IlvManagerView)object).getManager().setVisible((IlvManagerView)object, ((IlvManagerLayer)objectArray[n4]).getIndex(), true, false);
                ((IlvManagerLayer)objectArray[n4]).removeVisibilityFilter(q);
            }
            ((IlvManagerView)object).setTransformer((IlvTransformer)object3);
            this.beforeDraw(httpServletRequest, (IlvManagerView)object);
            ((IlvManagerView)object).getManager().draw(graphics, (IlvManagerView)object);
            for (n4 = 0; n4 < ilvManagerLayerArray.length; ++n4) {
                ilvManagerLayerArray[n4].removeVisibilityFilter(q);
            }
        }
        graphics.dispose();
        if (this.isVerbose()) {
            this.b("Ends generating Image");
        }
        return bufferedImage;
    }

    protected String getDefaultImageMapHREF(HttpServletRequest httpServletRequest, IlvManagerView ilvManagerView) {
        return null;
    }

    protected Comparator<IlvGraphic> getGraphicObjectComparator(IlvManagerLayer ilvManagerLayer, IlvManagerView ilvManagerView, HttpServletRequest httpServletRequest) {
        return null;
    }

    protected Comparator<IlvManagerLayer> getManagerLayerComparator(IlvManagerView ilvManagerView, HttpServletRequest httpServletRequest) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, IlvRect ilvRect, int n2, int n3, String[] stringArray, Color color, boolean bl) throws ServletException, IOException {
        Object object;
        Serializable serializable;
        int n4;
        block32: {
            block31: {
                n4 = 0;
                if (string == null) break block31;
                if (string.length() != 0) break block32;
            }
            string = "imagemap";
        }
        if (this.isVerbose()) {
            this.b("Starts generating image map");
            this.b("  width=" + n2);
            this.b("  height=" + n3);
            this.b("  bbox=" + ilvRect);
            serializable = new StringBuffer("  layers=");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                ((StringBuffer)serializable).append(stringArray[i2] + " ");
            }
            this.b(((StringBuffer)serializable).toString());
        }
        serializable = IlvManagerServletUtil.getTransformer(ilvRect, n2, n3);
        Object object2 = object = this.getLock(httpServletRequest);
        synchronized (object2) {
            Serializable serializable2;
            Object object3;
            IlvManagerView ilvManagerView = this.getManagerView(httpServletRequest);
            this.prepareManagerView(httpServletRequest, ilvManagerView);
            IlvManagerLayer[] ilvManagerLayerArray = this.getLayers(httpServletRequest, ilvManagerView);
            Vector<IlvManagerView> vector = new Vector<IlvManagerView>(ilvManagerLayerArray.length);
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                int n5;
                object3 = stringArray[i3];
                serializable2 = null;
                for (n5 = 0; n5 < ilvManagerLayerArray.length; ++n5) {
                    if (ilvManagerLayerArray[n5].getName() == null || !ilvManagerLayerArray[n5].getName().equals(object3)) continue;
                    serializable2 = ilvManagerLayerArray[n5];
                    break;
                }
                if (serializable2 == null) {
                    try {
                        n5 = Integer.parseInt((String)object3);
                        if (n5 >= 0 && n5 < ilvManagerLayerArray.length) {
                            serializable2 = ilvManagerLayerArray[n5];
                        }
                    }
                    catch (Exception exception) {
                        throw new ServletException("bad layer : " + (String)object3, (Throwable)exception);
                    }
                }
                if (serializable2 == null) {
                    throw new ServletException("bad layer : " + (String)object3);
                }
                vector.addElement((IlvManagerView)serializable2);
            }
            Object[] objectArray = new IlvManagerLayer[vector.size()];
            vector.copyInto(objectArray);
            object3 = ilvManagerView.getManager().getTreeLock();
            synchronized (object3) {
                serializable2 = ilvManagerView;
                synchronized (serializable2) {
                    int n6;
                    PrintWriter printWriter = httpServletResponse.getWriter();
                    printWriter.println("<map name=\"" + string + "\">");
                    IlvManager ilvManager = ilvManagerView.getManager();
                    IlvRect ilvRect2 = new IlvRect(0.0f, 0.0f, n2, n3);
                    for (n6 = 0; n6 < ilvManagerLayerArray.length; ++n6) {
                        ilvManagerLayerArray[n6].addVisibilityFilter(q);
                    }
                    for (n6 = 0; n6 < objectArray.length; ++n6) {
                        ilvManagerView.getManager().setVisible(ilvManagerView, ((IlvManagerLayer)objectArray[n6]).getIndex(), true, false);
                        ((IlvManagerLayer)objectArray[n6]).removeVisibilityFilter(q);
                    }
                    ilvManagerView.setTransformer((IlvTransformer)serializable);
                    serializable = ilvManagerView.getTransformer();
                    StringBuffer stringBuffer = this.a(ilvManager, httpServletRequest, (IlvTransformer)serializable, ilvRect2);
                    printWriter.println(stringBuffer.toString());
                    for (int i4 = 0; i4 < ilvManagerLayerArray.length; ++i4) {
                        ilvManagerLayerArray[i4].removeVisibilityFilter(q);
                    }
                    String string2 = this.getDefaultImageMapHREF(httpServletRequest, ilvManagerView);
                    if (string2 != null) {
                        printWriter.println("<area shape=\"rect\" coords=\"0,0," + n2 + "," + n3 + "\"href=\"" + IlvManagerServletSupport.c(string2) + "\">");
                    }
                    printWriter.println("</map>");
                    String string3 = httpServletRequest.getParameter("image");
                    if (string3 == null || string3.length() == 0) {
                        StringBuffer stringBuffer2 = new StringBuffer(httpServletRequest.getRequestURI());
                        stringBuffer2.append("?request=image");
                        Enumeration enumeration = httpServletRequest.getParameterNames();
                        while (enumeration.hasMoreElements()) {
                            String string4 = (String)enumeration.nextElement();
                            if (string4.equals("request")) continue;
                            if (string4.equals("tiled")) continue;
                            String[] stringArray2 = httpServletRequest.getParameterValues(string4);
                            for (int i5 = 0; i5 < stringArray2.length; ++i5) {
                                stringBuffer2.append("&");
                                stringBuffer2.append(string4);
                                stringBuffer2.append("=");
                                stringBuffer2.append(IlvManagerServletSupport.a(stringArray2[i5]));
                            }
                        }
                        printWriter.println("<img style=\"-webkit-user-drag:none\" usemap=\"#imagemap\" width=\"" + n2 + "\" height=\"" + n3 + "\" src=\"" + stringBuffer2.toString() + "\" border=0>");
                    } else {
                        printWriter.println("<img style=\"-webkit-user-drag:none\" usemap=\"#imagemap\" width=\"" + n2 + "\" height=\"" + n3 + "\" src=\"" + string3 + "\" border=0>");
                    }
                }
            }
        }
        if (this.isVerbose()) {
            this.b("Ends generating image map (" + n4 + " Areas)");
        }
    }

    private static IlvManagerLayer[] a(IlvManager ilvManager) {
        IlvManagerLayer[] ilvManagerLayerArray = new IlvManagerLayer[ilvManager.getLayersCount()];
        for (int i2 = 0; i2 < ilvManagerLayerArray.length; ++i2) {
            ilvManagerLayerArray[i2] = ilvManager.getManagerLayer(i2);
        }
        return ilvManagerLayerArray;
    }

    private StringBuffer a(IlvManager ilvManager, HttpServletRequest httpServletRequest, final IlvTransformer ilvTransformer, IlvRect ilvRect) throws ServletException {
        StringBuffer stringBuffer = new StringBuffer("");
        final IlvManagerView ilvManagerView = this.getManagerView(httpServletRequest);
        final IlvManager ilvManager2 = ilvManager;
        final boolean bl = ilvManager2.getGraphicBag() == null;
        IlvRect ilvRect2 = new IlvRect(ilvRect);
        if (ilvTransformer != null) {
            ilvTransformer.inverse(ilvRect2);
        }
        IlvManagerLayer[] ilvManagerLayerArray = IlvManagerServletSupport.a(ilvManager);
        ArrayList<IlvManagerLayer> arrayList = new ArrayList<IlvManagerLayer>(ilvManagerLayerArray.length);
        for (int i2 = 0; i2 < ilvManagerLayerArray.length; ++i2) {
            IlvManagerLayer ilvManagerLayer = ilvManagerLayerArray[i2];
            if (!this.shouldGenerateImageMap(httpServletRequest, ilvManagerLayer, ilvManagerView, ilvTransformer)) continue;
            arrayList.add(ilvManagerLayer);
        }
        Comparator<IlvManagerLayer> comparator = this.getManagerLayerComparator(ilvManagerView, httpServletRequest);
        if (comparator != null) {
            Collections.sort(arrayList, comparator);
        }
        for (int i3 = arrayList.size() - 1; i3 >= 0; --i3) {
            Comparator<IlvGraphic> comparator2;
            IlvManagerLayer ilvManagerLayer = (IlvManagerLayer)arrayList.get(i3);
            final ArrayList arrayList2 = new ArrayList(ilvManagerLayer.getCardinal());
            final HttpServletRequest httpServletRequest2 = httpServletRequest;
            if (bl && ilvManagerLayer.isVisible(ilvManagerView) || !bl && ilvManagerLayer.isVisible()) {
                ilvManagerLayer.mapIntersects(ilvRect2, ilvRect, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        if ((bl && ilvManager2.isVisible(ilvGraphic, ilvManagerView) || !bl && ilvManager2.isVisible(ilvGraphic)) && IlvManagerServletSupport.this.getImageMapAreaGenerator(httpServletRequest2, ilvGraphic, ilvManagerView, ilvTransformer) != null) {
                            arrayList2.add(ilvGraphic);
                        }
                    }
                }, null, ilvTransformer, false);
            }
            if ((comparator2 = this.getGraphicObjectComparator(ilvManagerLayer, ilvManagerView, httpServletRequest)) != null) {
                Collections.sort(arrayList2, comparator2);
            }
            for (int i4 = arrayList2.size() - 1; i4 >= 0; --i4) {
                Serializable serializable;
                IlvGraphic ilvGraphic = (IlvGraphic)arrayList2.get(i4);
                if (ilvGraphic instanceof IlvManager && !((IlvManager)ilvGraphic).isCollapsed()) {
                    serializable = (IlvManager)ilvGraphic;
                    IlvTransformer ilvTransformer2 = ((IlvManager)serializable).getTransformer();
                    ilvTransformer2.compose(ilvTransformer);
                    IlvRect ilvRect3 = (IlvRect)ilvRect2.clone();
                    ((IlvManager)serializable).getTransformer().inverse(ilvRect3);
                    ilvTransformer2.apply(ilvRect3);
                    StringBuffer stringBuffer2 = this.a((IlvManager)ilvGraphic, httpServletRequest, ilvTransformer2, ilvRect3);
                    if (stringBuffer2.length() > 0) {
                        stringBuffer.append(stringBuffer2.toString());
                    }
                }
                if (((StringBuffer)(serializable = this.a(httpServletRequest, ilvGraphic, ilvTransformer, ilvRect))).length() <= 0) continue;
                stringBuffer.append(((StringBuffer)serializable).toString());
            }
        }
        return stringBuffer;
    }

    private StringBuffer a(HttpServletRequest httpServletRequest, IlvGraphic ilvGraphic, IlvTransformer ilvTransformer, IlvRect ilvRect) throws ServletException {
        IlvManagerView ilvManagerView = this.getManagerView(httpServletRequest);
        IlvImageMapAreaGenerator ilvImageMapAreaGenerator = this.getImageMapAreaGenerator(httpServletRequest, ilvGraphic, ilvManagerView, ilvTransformer);
        StringBuffer stringBuffer = new StringBuffer("");
        if (ilvImageMapAreaGenerator != null && ilvImageMapAreaGenerator.shouldGenerate(ilvManagerView, ilvGraphic, ilvTransformer)) {
            String string;
            String string2;
            String string3;
            String string4;
            stringBuffer.append("<area");
            switch (ilvImageMapAreaGenerator.getShape(ilvManagerView, ilvGraphic, ilvTransformer)) {
                case 0: {
                    stringBuffer.append(" shape=\"circle\"");
                    break;
                }
                case 1: {
                    stringBuffer.append(" shape=\"rect\"");
                    break;
                }
                case 2: {
                    stringBuffer.append(" shape=\"polygon\"");
                }
            }
            stringBuffer.append(" coords=\"");
            stringBuffer.append(ilvImageMapAreaGenerator.generateCOORDS(ilvManagerView, ilvGraphic, ilvRect, ilvTransformer));
            stringBuffer.append("\"");
            String string5 = ilvImageMapAreaGenerator.generateHREF(ilvManagerView, ilvGraphic);
            if (string5 != null) {
                stringBuffer.append(" href=\"");
                stringBuffer.append(IlvManagerServletSupport.c(string5));
                stringBuffer.append("\"");
            }
            if ((string4 = ilvImageMapAreaGenerator.generateALT(ilvManagerView, ilvGraphic)) != null) {
                stringBuffer.append(" alt=\"");
                stringBuffer.append(IlvManagerServletSupport.c(string4));
                stringBuffer.append("\"");
                stringBuffer.append(" title=\"");
                stringBuffer.append(IlvManagerServletSupport.c(string4));
                stringBuffer.append("\"");
            }
            if ((string3 = ilvImageMapAreaGenerator.generateTARGET(ilvManagerView, ilvGraphic)) != null) {
                stringBuffer.append(" target=\"");
                stringBuffer.append(IlvManagerServletSupport.c(string3));
                stringBuffer.append("\"");
            }
            if ((string2 = ilvImageMapAreaGenerator.generateONMOUSEOVER(ilvManagerView, ilvGraphic)) != null) {
                stringBuffer.append(" onmouseover=\"");
                stringBuffer.append(IlvManagerServletSupport.c(string2));
                stringBuffer.append("\"");
            }
            if ((string = ilvImageMapAreaGenerator.generateONMOUSEOUT(ilvManagerView, ilvGraphic)) != null) {
                stringBuffer.append(" onmouseout=\"");
                stringBuffer.append(IlvManagerServletSupport.c(string));
                stringBuffer.append("\"");
            }
            stringBuffer.append(">");
        }
        return stringBuffer;
    }

    protected IlvImageMapAreaGenerator getImageMapAreaGenerator(HttpServletRequest httpServletRequest, IlvGraphic ilvGraphic, IlvManagerView ilvManagerView, IlvTransformer ilvTransformer) {
        return this.a(httpServletRequest, ilvGraphic, ilvManagerView, ilvTransformer);
    }

    final IlvImageMapAreaGenerator a(HttpServletRequest httpServletRequest, IlvGraphic ilvGraphic, IlvManagerView ilvManagerView, IlvTransformer ilvTransformer) {
        return (IlvImageMapAreaGenerator)ilvGraphic.getProperty(ImageMapAreaGeneratorProperty);
    }

    protected boolean shouldGenerateImageMap(HttpServletRequest httpServletRequest, IlvManagerLayer ilvManagerLayer, IlvManagerView ilvManagerView, IlvTransformer ilvTransformer) {
        return this.a(httpServletRequest, ilvManagerLayer, ilvManagerView, ilvTransformer);
    }

    final boolean a(HttpServletRequest httpServletRequest, IlvManagerLayer ilvManagerLayer, IlvManagerView ilvManagerView, IlvTransformer ilvTransformer) {
        return ilvManagerLayer.getProperty(ImageMapAreaGeneratorProperty) != null;
    }

    private void b(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        IlvPopupMenuServletSupport ilvPopupMenuServletSupport = this.getPopupMenuSupport();
        if (ilvPopupMenuServletSupport == null) {
            throw new ServletException("This servlet support is not configured to handle popup menu requests");
        }
        ilvPopupMenuServletSupport.handleRequest(httpServletRequest, httpServletResponse);
    }

    private void c(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        IlvSelectionSupport ilvSelectionSupport = this.getSelectionSupport();
        if (ilvSelectionSupport == null) {
            throw new ServletException("This servlet support is not configured to handle selection requests");
        }
        ilvSelectionSupport.handleRequest(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        int n2 = IlvServletUtil.getIntParameter(httpServletRequest, "width");
        int n3 = IlvServletUtil.getIntParameter(httpServletRequest, "height");
        IlvRect ilvRect = IlvManagerServletUtil.getBBoxParameter(httpServletRequest);
        String[] stringArray = IlvManagerServletUtil.getLayerParameter(httpServletRequest);
        IlvTransformer ilvTransformer = IlvManagerServletUtil.getTransformer(ilvRect, n2, n3);
        Object object = this.getLock(httpServletRequest);
        synchronized (object) {
            int n4;
            IlvManagerView ilvManagerView = this.getManagerView(httpServletRequest);
            this.prepareManagerView(httpServletRequest, ilvManagerView);
            IlvManagerLayer[] ilvManagerLayerArray = this.getLayers(httpServletRequest, ilvManagerView);
            Vector<IlvManagerLayer> vector = new Vector<IlvManagerLayer>(ilvManagerLayerArray.length);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                int n5;
                String string = stringArray[i2];
                IlvManagerLayer ilvManagerLayer = null;
                for (n5 = 0; n5 < ilvManagerLayerArray.length; ++n5) {
                    if (ilvManagerLayerArray[n5].getName() == null || !ilvManagerLayerArray[n5].getName().equals(string)) continue;
                    ilvManagerLayer = ilvManagerLayerArray[n5];
                    break;
                }
                if (ilvManagerLayer == null) {
                    try {
                        n5 = Integer.parseInt(string);
                        if (n5 >= 0 && n5 < ilvManagerLayerArray.length) {
                            ilvManagerLayer = ilvManagerLayerArray[n5];
                        }
                    }
                    catch (Exception exception) {
                        throw new ServletException("bad layer : " + string, (Throwable)exception);
                    }
                }
                if (ilvManagerLayer == null) {
                    throw new ServletException("bad layer : " + string);
                }
                vector.addElement(ilvManagerLayer);
            }
            Object[] objectArray = new IlvManagerLayer[vector.size()];
            vector.copyInto(objectArray);
            ilvManagerView.setBounds(0, 0, n2, n3);
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(r);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            for (n4 = 0; n4 < ilvManagerLayerArray.length; ++n4) {
                ilvManagerView.getManager().setVisible(ilvManagerView, ilvManagerLayerArray[n4].getIndex(), false, false);
            }
            for (n4 = 0; n4 < objectArray.length; ++n4) {
                ilvManagerView.getManager().setVisible(ilvManagerView, ((IlvManagerLayer)objectArray[n4]).getIndex(), true, false);
            }
            ilvManagerView.setTransformer(ilvTransformer);
            this.beforeDraw(httpServletRequest, ilvManagerView);
        }
    }

    private void e(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Object object;
        String[] stringArray;
        int n2 = IlvServletUtil.getIntParameter(httpServletRequest, "width");
        int n3 = IlvServletUtil.getIntParameter(httpServletRequest, "height");
        String string = IlvServletUtil.getStringParameter(httpServletRequest, "format");
        Color color = IlvManagerServletUtil.getOptionalColorParameter(httpServletRequest, "bgcolor", Color.white);
        boolean bl = IlvServletUtil.getOptionalBooleanParameter(httpServletRequest, "transparent", false);
        if (string == null) {
            throw new ServletException("An image encoding format compatible with javax.imageio must be specified");
        }
        String string2 = httpServletRequest.getParameter("tile");
        IlvRect ilvRect = null;
        if (string2 == null) {
            ilvRect = IlvManagerServletUtil.getBBoxParameter(httpServletRequest);
        } else {
            stringArray = this.getManagerView(httpServletRequest);
            object = this.getManagerBBox(httpServletRequest, (IlvManagerView)stringArray);
            ilvRect = IlvManagerServletUtil.getTileBBoxParameter(httpServletRequest, (IlvManagerView)stringArray, (IlvRect)object);
        }
        stringArray = IlvManagerServletUtil.getLayerParameter(httpServletRequest);
        object = this.generateImage(httpServletRequest, ilvRect, n2, n3, stringArray, color, bl);
        httpServletResponse.setContentType("image/" + string.toLowerCase());
        this.setImageResponseCachePolicy(httpServletRequest, httpServletResponse);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        this.a(httpServletResponse, (BufferedImage)object, servletOutputStream, string);
    }

    private void a(HttpServletResponse httpServletResponse, BufferedImage bufferedImage, ServletOutputStream servletOutputStream, String string) throws IOException {
        if (this.l) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.encodeImage(bufferedImage, byteArrayOutputStream, string);
            httpServletResponse.setContentLength(byteArrayOutputStream.size());
            byteArrayOutputStream.writeTo((OutputStream)servletOutputStream);
            servletOutputStream.close();
        } else {
            this.encodeImage(bufferedImage, (OutputStream)servletOutputStream, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodeImage(BufferedImage bufferedImage, OutputStream outputStream, String string) throws IOException {
        try {
            if ("JPEG".equalsIgnoreCase(string)) {
                this.a(bufferedImage, outputStream);
            } else {
                this.a(bufferedImage, outputStream, string);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger("ilog.views.servlet").log(Level.FINEST, "I/O error in encoding " + string, iOException);
        }
        finally {
            outputStream.close();
        }
    }

    private void a(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
        JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
        jPEGEncodeParam.setQuality(this.d, false);
        jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
    }

    private void a(BufferedImage bufferedImage, OutputStream outputStream, String string) throws IOException {
        ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
    }

    protected void setImageResponseCachePolicy(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this.b(httpServletRequest)) {
            long l2 = this.getExpirationDate(httpServletRequest);
            String string = p.format(new Date(l2));
            httpServletResponse.setHeader("Expires", string);
            httpServletResponse.setDateHeader("Expires", l2);
        } else {
            httpServletResponse.setHeader("pragma", "no-cache");
            httpServletResponse.setHeader("Cache-Control", "no-cache");
        }
    }

    protected long getExpirationDate(HttpServletRequest httpServletRequest) {
        return System.currentTimeMillis() + (long)(httpServletRequest.getSession().getMaxInactiveInterval() * 1000);
    }

    private boolean b(HttpServletRequest httpServletRequest) {
        try {
            return null != IlvServletUtil.getStringParameter(httpServletRequest, "tile");
        }
        catch (ServletException servletException) {
            return false;
        }
    }

    private void f(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        int n2 = IlvServletUtil.getIntParameter(httpServletRequest, "width");
        int n3 = IlvServletUtil.getIntParameter(httpServletRequest, "height");
        IlvRect ilvRect = IlvManagerServletUtil.getBBoxParameter(httpServletRequest);
        Color color = IlvManagerServletUtil.getOptionalColorParameter(httpServletRequest, "bgcolor", Color.white);
        boolean bl = IlvServletUtil.getOptionalBooleanParameter(httpServletRequest, "transparent", false);
        String string = httpServletRequest.getParameter("mapname");
        String[] stringArray = IlvManagerServletUtil.getLayerParameter(httpServletRequest);
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setHeader("pragma", "no-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
        this.a(httpServletRequest, httpServletResponse, string, ilvRect, n2, n3, stringArray, color, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void g(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = httpServletRequest.getParameter("format");
        if (string == null) {
            throw new ServletException("parameter format required");
        }
        if (this.isVerbose()) {
            this.b("Starts generating capabilities");
        }
        if (string.equals("json")) {
            httpServletResponse.setContentType("text/javascript;charset=utf-8");
            httpServletResponse.setHeader("pragma", "no-cache");
            httpServletResponse.setHeader("Cache-Control", "no-cache");
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            Object object = this.getLock(httpServletRequest);
            synchronized (object) {
                double[] dArray;
                Object object2;
                IlvManagerView ilvManagerView = this.getManagerView(httpServletRequest);
                this.prepareManagerView(httpServletRequest, ilvManagerView);
                IlvManagerLayer[] ilvManagerLayerArray = ilvManagerView.getManager().getTreeLock();
                synchronized (ilvManagerLayerArray) {
                    IlvManagerView ilvManagerView2 = ilvManagerView;
                    synchronized (ilvManagerView2) {
                        object2 = IlvManagerServletSupport.c(httpServletRequest);
                        if (object2 != null) {
                            this.a(httpServletRequest, ilvManagerView, ((ActionParameter)object2).a, ((ActionParameter)object2).b);
                        }
                        IlvRect ilvRect = this.getManagerBBox(httpServletRequest, ilvManagerView);
                        servletOutputStream.println("{ 'minx':" + ilvRect.x + ",");
                        servletOutputStream.println("'miny':" + ilvRect.y + ",");
                        servletOutputStream.println("'maxx':" + ((double)ilvRect.x + (double)ilvRect.width) + ",");
                        servletOutputStream.println("'maxy':" + ((double)ilvRect.y + (double)ilvRect.height) + ",");
                        servletOutputStream.println("'sessionMaxInactiveInterval':" + httpServletRequest.getSession().getMaxInactiveInterval() + ",");
                        IlvManagerLayer[] ilvManagerLayerArray2 = this.getLayers(httpServletRequest, ilvManagerView);
                        Object[] objectArray = new String[ilvManagerLayerArray2.length];
                        boolean[] blArray = new boolean[ilvManagerLayerArray2.length];
                        for (int i2 = 0; i2 < ilvManagerLayerArray2.length; ++i2) {
                            IlvManagerLayer ilvManagerLayer = ilvManagerLayerArray2[i2];
                            String string2 = ilvManagerLayer.getName();
                            if (string2 == null) {
                                string2 = Integer.toString(i2);
                            }
                            objectArray[i2] = "'" + string2 + "'";
                            blArray[i2] = this.isOverviewLayer(httpServletRequest, ilvManagerLayer);
                        }
                        servletOutputStream.println("'themes':" + Arrays.toString(objectArray) + ",");
                        servletOutputStream.println("'overviewthemes':" + Arrays.toString(blArray) + ",");
                    }
                }
                servletOutputStream.println("'maxZoom':" + this.getMaxZoomLevel(httpServletRequest, ilvManagerView));
                ilvManagerLayerArray = this.getDynamicLayers(httpServletRequest, this.getManagerView(httpServletRequest));
                if (ilvManagerLayerArray != null && ilvManagerLayerArray.length != 0) {
                    servletOutputStream.print(", 'dynLayers': [");
                    for (int i3 = 0; i3 < ilvManagerLayerArray.length; ++i3) {
                        object2 = ilvManagerLayerArray[i3].getName();
                        if (object2 == null) {
                            object2 = Integer.toString(ilvManagerLayerArray[i3].getIndex());
                        }
                        servletOutputStream.print(i3 != 0 ? ",'" + (String)object2 + "'" : "'" + (String)object2 + "'");
                    }
                    servletOutputStream.println("]");
                }
                if ((dArray = this.getZoomLevels(httpServletRequest, this.getManagerView(httpServletRequest))) != null && dArray.length != 0) {
                    servletOutputStream.print(", 'zoomLevels': [");
                    for (int i4 = 0; i4 < dArray.length; ++i4) {
                        if (i4 != 0) {
                            servletOutputStream.print(",");
                        }
                        servletOutputStream.print(dArray[i4]);
                    }
                    servletOutputStream.println("]");
                }
                this.additionalCapabilities(httpServletRequest, servletOutputStream, "json");
                object2 = this.getAdditionalCapabilities(httpServletRequest);
                if (object2 != null) {
                    servletOutputStream.print(",");
                    IlvServletUtil.writeJSONMap(servletOutputStream, (Map)object2, true);
                }
                servletOutputStream.println("}");
            }
            servletOutputStream.close();
        } else if (string.equals("octet-stream")) {
            httpServletResponse.setContentType("application/octet-stream");
            httpServletResponse.setHeader("pragma", "no-cache");
            httpServletResponse.setHeader("Cache-Control", "no-cache");
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)servletOutputStream);
            Object object = this.getLock(httpServletRequest);
            synchronized (object) {
                IlvManagerView ilvManagerView = this.getManagerView(httpServletRequest);
                this.prepareManagerView(httpServletRequest, ilvManagerView);
                Object object3 = ilvManagerView.getManager().getTreeLock();
                synchronized (object3) {
                    IlvManagerView ilvManagerView3 = ilvManagerView;
                    synchronized (ilvManagerView3) {
                        IlvRect ilvRect = this.getManagerBBox(httpServletRequest, ilvManagerView);
                        dataOutputStream.writeFloat(ilvRect.x);
                        dataOutputStream.writeFloat(ilvRect.y);
                        dataOutputStream.writeFloat(ilvRect.x + ilvRect.width);
                        dataOutputStream.writeFloat(ilvRect.y + ilvRect.height);
                        IlvManagerLayer[] ilvManagerLayerArray = this.getLayers(httpServletRequest, ilvManagerView);
                        dataOutputStream.writeInt(ilvManagerLayerArray.length);
                        for (int i5 = 0; i5 < ilvManagerLayerArray.length; ++i5) {
                            IlvManagerLayer ilvManagerLayer = ilvManagerLayerArray[i5];
                            String string3 = ilvManagerLayer.getName();
                            if (string3 == null) {
                                string3 = Integer.toString(i5);
                            }
                            dataOutputStream.writeUTF(string3);
                            dataOutputStream.writeBoolean(this.isOverviewLayer(httpServletRequest, ilvManagerLayer));
                        }
                    }
                }
                float f2 = this.getMaxZoomLevel(httpServletRequest, ilvManagerView);
                dataOutputStream.writeFloat(f2);
                this.additionalCapabilities(httpServletRequest, servletOutputStream, "application/octet-stream");
            }
            servletOutputStream.close();
        } else {
            if (string.equals("text")) {
                throw new ServletException("text format not supported anymore please use text/javascript");
            }
            throw new ServletException("parameter format required");
        }
        if (this.isVerbose()) {
            this.b("Ends generating capabilities");
        }
    }

    public double[] getZoomLevels(HttpServletRequest httpServletRequest, IlvManagerView ilvManagerView) {
        return this.m;
    }

    public IlvManagerLayer[] getDynamicLayers(HttpServletRequest httpServletRequest, IlvManagerView ilvManagerView) {
        int n2 = ilvManagerView.getTripleBufferedLayerCount();
        IlvManager ilvManager = ilvManagerView.getManager();
        ArrayList<IlvManagerLayer> arrayList = new ArrayList<IlvManagerLayer>();
        for (int i2 = n2; i2 < ilvManager.getLayersCount(); ++i2) {
            IlvManagerLayer ilvManagerLayer = ilvManager.getManagerLayer(i2);
            arrayList.add(ilvManagerLayer);
        }
        return arrayList.toArray(new IlvManagerLayer[arrayList.size()]);
    }

    protected void additionalCapabilities(HttpServletRequest httpServletRequest, ServletOutputStream servletOutputStream, String string) {
    }

    protected Map getAdditionalCapabilities(HttpServletRequest httpServletRequest) {
        return null;
    }

    private void a(HttpServletRequest httpServletRequest, IlvManagerView ilvManagerView, String string, String[] stringArray) throws ServletException {
        Serializable serializable;
        if (this.isVerbose()) {
            serializable = new StringBuffer("Action:" + string + "(");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (i2 != 0) {
                    ((StringBuffer)serializable).append(",");
                }
                ((StringBuffer)serializable).append(stringArray[i2]);
            }
            ((StringBuffer)serializable).append(")");
            this.b(((StringBuffer)serializable).toString());
        }
        serializable = new ServerActionEvent(httpServletRequest, ilvManagerView, string, this, stringArray);
        Object[] objectArray = this.f.getListenerList();
        for (int i3 = 1; i3 < objectArray.length; i3 += 2) {
            ServerActionListener serverActionListener = (ServerActionListener)objectArray[i3];
            serverActionListener.actionPerformed((ServerActionEvent)serializable);
        }
    }

    protected void beforeDraw(HttpServletRequest httpServletRequest, IlvManagerView ilvManagerView) throws ServletException {
        this.e(httpServletRequest, ilvManagerView);
    }

    final void e(HttpServletRequest httpServletRequest, IlvManagerView ilvManagerView) throws ServletException {
        ActionParameter actionParameter = IlvManagerServletSupport.c(httpServletRequest);
        if (actionParameter != null) {
            this.a(httpServletRequest, ilvManagerView, actionParameter.a, actionParameter.b);
        }
    }

    protected void prepareManagerView(HttpServletRequest httpServletRequest, IlvManagerView ilvManagerView) throws ServletException {
    }

    public boolean handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return this.a(httpServletRequest, httpServletResponse);
    }

    final boolean a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = httpServletRequest.getParameter("request");
        if ("popupmenurequested".equals(string)) {
            this.b(httpServletRequest, httpServletResponse);
            return true;
        }
        if ("image".equals(string)) {
            this.e(httpServletRequest, httpServletResponse);
            return true;
        }
        if ("imagemap".equals(string)) {
            this.f(httpServletRequest, httpServletResponse);
            return true;
        }
        if ("capabilities".equals(string)) {
            this.g(httpServletRequest, httpServletResponse);
            return true;
        }
        if ("lightselect".equals(string)) {
            this.c(httpServletRequest, httpServletResponse);
            return true;
        }
        if ("dynamicAction".equals(string)) {
            this.d(httpServletRequest, httpServletResponse);
            return true;
        }
        return false;
    }

    private static String a(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        block3: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case ' ': {
                    stringBuffer.append("%20");
                    continue block3;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    private void b(String string) {
        if (this.g == null) {
            System.out.println(string);
        } else {
            Logger.getLogger("ilog.views.servlet").log(Level.INFO, string);
        }
    }

    private static String c(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        block3: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block3;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static ActionParameter c(HttpServletRequest httpServletRequest) throws ServletException {
        String string = httpServletRequest.getParameter("action");
        if (string == null) {
            return null;
        }
        String[] stringArray = o.split(string);
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        return new ActionParameter(stringArray[0], stringArray2);
    }

    static {
        p.setTimeZone(TimeZone.getTimeZone("GMT"));
        r = new Runnable(){

            public void run() {
            }
        };
    }

    static final class ActionParameter {
        String a;
        String[] b;

        ActionParameter(String string, String[] stringArray) {
            this.a = string;
            this.b = stringArray;
        }
    }
}

