/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.palettes;

import ilog.views.symbology.palettes.IlvPalette;
import ilog.views.symbology.palettes.IlvPaletteCategory;
import ilog.views.symbology.palettes.IlvPaletteObject;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.ResourceBundleRegistry;
import ilog.views.symbology.palettes.event.PaletteManagerEvent;
import ilog.views.symbology.palettes.event.PaletteManagerListener;
import ilog.views.symbology.palettes.internal.IlvPaletteClassLoader;
import ilog.views.util.cssbeans.IlvCSSCompatible;
import ilog.views.util.cssbeans.IlvCSSCompatibleHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.swing.event.EventListenerList;

public class IlvPaletteManager {
    private Vector a = new Vector();
    private Vector b = new Vector();
    private EventListenerList c = null;
    private IlvPaletteClassLoader d = null;
    private File e = null;
    private ArrayList f = null;

    public IlvPaletteManager() {
        this(null);
    }

    public IlvPaletteManager(IlvCSSCompatible ilvCSSCompatible) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            this.d = new IlvPaletteClassLoader(classLoader, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ilvCSSCompatible != null) {
            this.attach(ilvCSSCompatible);
        }
    }

    public void attach(IlvCSSCompatible ilvCSSCompatible) {
        if (this.isAttached(ilvCSSCompatible)) {
            return;
        }
        IlvCSSCompatibleHandler ilvCSSCompatibleHandler = (IlvCSSCompatibleHandler)ilvCSSCompatible.getCSSInternal();
        if (ilvCSSCompatibleHandler == null) {
            throw new RuntimeException("Internal error: No internal CSS Compatible handler");
        }
        if (this.d != null) {
            ilvCSSCompatibleHandler.addExternalBeanClassLoader(this.d);
        }
        if (this.f == null) {
            this.f = new ArrayList();
        }
        this.f.add(ilvCSSCompatible);
    }

    public void detach(IlvCSSCompatible ilvCSSCompatible) {
        if (!this.isAttached(ilvCSSCompatible)) {
            return;
        }
        IlvCSSCompatibleHandler ilvCSSCompatibleHandler = (IlvCSSCompatibleHandler)ilvCSSCompatible.getCSSInternal();
        if (ilvCSSCompatibleHandler == null) {
            throw new RuntimeException("Internal error: No internal CSS Compatible handler");
        }
        if (this.d != null) {
            ilvCSSCompatibleHandler.removeExternalBeanClassLoader(this.d);
        }
        this.f.remove(ilvCSSCompatible);
        if (this.f.size() == 0) {
            this.f = null;
        }
    }

    public void detach() {
        IlvCSSCompatible[] ilvCSSCompatibleArray = this.getAttachComponents();
        for (int i2 = 0; i2 < ilvCSSCompatibleArray.length; ++i2) {
            this.detach(ilvCSSCompatibleArray[i2]);
        }
    }

    public IlvCSSCompatible[] getAttachComponents() {
        if (this.f == null) {
            return new IlvCSSCompatible[0];
        }
        IlvCSSCompatible[] ilvCSSCompatibleArray = new IlvCSSCompatible[this.f.size()];
        ilvCSSCompatibleArray = this.f.toArray(ilvCSSCompatibleArray);
        return ilvCSSCompatibleArray;
    }

    public boolean isAttached(IlvCSSCompatible ilvCSSCompatible) {
        if (this.f == null) {
            return false;
        }
        return this.f.contains(ilvCSSCompatible);
    }

    public ClassLoader getClassLoader() {
        return this.d;
    }

    public void add(IlvPalette ilvPalette) {
        if (this.contains(ilvPalette)) {
            return;
        }
        this.a.add(ilvPalette);
        if (this.d != null) {
            ilvPalette.a(this.d);
            this.d.addURL(ilvPalette.getJarURL());
            this.b(ilvPalette);
        }
        this.firePaletteAdded(ilvPalette);
    }

    public void remove(IlvPalette ilvPalette) {
        if (!this.contains(ilvPalette)) {
            return;
        }
        this.a.remove(ilvPalette);
        this.b.remove(ilvPalette);
        this.a(ilvPalette);
    }

    private void a(IlvPalette ilvPalette) {
        ilvPalette.a((ClassLoader)null);
        if (this.d != null) {
            this.d.removeURL(ilvPalette.getJarURL());
        }
        this.firePaletteRemoved(ilvPalette);
    }

    public void removeAll() {
        Vector vector = this.a;
        this.a = new Vector();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            this.a((IlvPalette)vector.elementAt(i2));
        }
    }

    public IlvPalette getPalette(String string) {
        if (string == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.getPaletteCount(); ++i2) {
            IlvPalette ilvPalette = this.getPalette(i2);
            if (!string.equals(ilvPalette.getPaletteResourceName())) continue;
            return ilvPalette;
        }
        return null;
    }

    public IlvPalette getPalette(int n2) {
        return (IlvPalette)this.a.get(n2);
    }

    public int getPaletteCount() {
        return this.a.size();
    }

    public boolean contains(IlvPalette ilvPalette) {
        return this.a.contains(ilvPalette);
    }

    public IlvPalette getPaletteWithSymbol(String string, String string2, String string3) {
        IlvPalette ilvPalette;
        int n2;
        for (n2 = 0; n2 < this.getPaletteCount(); ++n2) {
            ilvPalette = this.getPalette(n2);
            if (string == null || ilvPalette.getSymbol(string) == null) continue;
            return ilvPalette;
        }
        for (n2 = 0; n2 < this.getPaletteCount(); ++n2) {
            ilvPalette = this.getPalette(n2);
            if (ilvPalette.getSymbol(string2, string3) == null) continue;
            return ilvPalette;
        }
        return null;
    }

    public void addPaletteManagerListener(PaletteManagerListener paletteManagerListener) {
        if (this.c == null) {
            this.c = new EventListenerList();
        }
        this.c.add(PaletteManagerListener.class, paletteManagerListener);
    }

    public void removePaletteManagerListener(PaletteManagerListener paletteManagerListener) {
        if (this.c == null) {
            return;
        }
        this.c.remove(PaletteManagerListener.class, paletteManagerListener);
        if (this.c.getListenerCount() == 0) {
            this.c = null;
        }
    }

    protected void firePaletteAdded(IlvPalette ilvPalette) {
        if (this.c == null || ilvPalette == null) {
            return;
        }
        Object[] objectArray = this.c.getListenerList();
        PaletteManagerEvent paletteManagerEvent = new PaletteManagerEvent(this, ilvPalette);
        for (int i2 = 1; i2 < objectArray.length; i2 += 2) {
            PaletteManagerListener paletteManagerListener = (PaletteManagerListener)objectArray[i2];
            paletteManagerListener.paletteAdded(paletteManagerEvent);
        }
    }

    protected void firePaletteRemoved(IlvPalette ilvPalette) {
        if (this.c == null || ilvPalette == null) {
            return;
        }
        Object[] objectArray = this.c.getListenerList();
        PaletteManagerEvent paletteManagerEvent = new PaletteManagerEvent(this, ilvPalette);
        for (int i2 = 1; i2 < objectArray.length; i2 += 2) {
            PaletteManagerListener paletteManagerListener = (PaletteManagerListener)objectArray[i2];
            paletteManagerListener.paletteRemoved(paletteManagerEvent);
        }
    }

    public int getPaletteIndex(IlvPalette ilvPalette) {
        return this.a.indexOf(ilvPalette);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlvPalette[] load(URL uRL) throws IOException {
        IlvPalette ilvPalette;
        IlvPalette[] ilvPaletteArray;
        Object object;
        if (this.d == null) {
            throw new SecurityException("Cannot load a palette from Jar URL.\nTo load a palette from Jar URL, a palette class loader must be allocated but this applet or application does not have the necessary permissions.\nTo solve the problem, put the palette on the class path before starting the application and call IlvPaletteManager.load(String packageName) to load the palette from the class path instead.");
        }
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            object = (IlvPalette)this.a.get(i2);
            if (!uRL.equals(((IlvPalette)object).getJarURL())) continue;
            return new IlvPalette[]{object};
        }
        Vector<IlvPalette> vector = new Vector<IlvPalette>();
        object = new HashSet();
        this.d.addURL(uRL);
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        try {
            JarEntry jarEntry = jarInputStream.getNextJarEntry();
            while (jarEntry != null) {
                block14: {
                    block13: {
                        ilvPaletteArray = jarEntry.getName();
                        if (ilvPaletteArray.endsWith(".properties")) {
                            ((HashSet)object).add(ilvPaletteArray);
                        }
                        if (ilvPaletteArray.equals("palette.xml")) break block13;
                        if (!ilvPaletteArray.endsWith("/palette.xml")) break block14;
                    }
                    String string = ilvPaletteArray.substring(0, ilvPaletteArray.length() - "palette.xml".length());
                    ilvPalette = new IlvPalette();
                    ilvPalette.a(this.d);
                    if (ilvPalette != null) {
                        vector.add(ilvPalette);
                        ilvPalette.setPackageName(string);
                        ilvPalette.b(uRL);
                        ilvPalette.load(ilvPalette.getPaletteURL());
                    }
                }
                jarEntry = jarInputStream.getNextJarEntry();
            }
        }
        finally {
            jarInputStream.close();
        }
        this.d.removeURL(uRL);
        int n2 = vector.size();
        ilvPaletteArray = new IlvPalette[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            ilvPalette = (IlvPalette)vector.get(i3);
            this.add(ilvPalette);
            ilvPalette.b();
            this.a(ilvPalette, (HashSet)object);
            ilvPaletteArray[i3] = ilvPalette;
        }
        return ilvPaletteArray;
    }

    public IlvPalette load(String string) throws IOException {
        IlvPalette ilvPalette = new IlvPalette();
        ilvPalette.setPackageName(string);
        if (ilvPalette.getPaletteURL() == null) {
            return null;
        }
        ilvPalette.load(ilvPalette.getPaletteURL());
        try {
            String string2;
            int n2;
            URL uRL = null;
            if (ilvPalette.getPaletteURL().getProtocol().equals("jar") && (n2 = (string2 = ilvPalette.getPaletteURL().getFile()).lastIndexOf(33)) >= 0) {
                string2 = string2.substring(0, n2);
                uRL = new URL(string2);
            }
            if (ilvPalette.getPaletteURL().getProtocol().equals("wsjar") && (n2 = (string2 = ilvPalette.getPaletteURL().getFile()).lastIndexOf(33)) >= 0) {
                string2 = string2.substring(0, n2);
                uRL = new URL(string2);
            }
            if (uRL == null && (string2 = ilvPalette.getPaletteURL().toString()).endsWith(ilvPalette.getPaletteResourceName())) {
                string2 = string2.substring(0, string2.length() - ilvPalette.getPaletteResourceName().length());
                uRL = new URL(string2);
            }
            if (uRL != null) {
                ilvPalette.b(uRL);
            } else {
                System.err.println("** warning: " + string + " found but not in a jar file");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.add(ilvPalette);
        this.b.add(ilvPalette);
        ilvPalette.b();
        return ilvPalette;
    }

    private void a(IlvPalette ilvPalette, HashSet hashSet) {
        ResourceBundleRegistry resourceBundleRegistry = ilvPalette.a();
        String string = ilvPalette.getPackageName();
        int n2 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : hashSet) {
            if (!string2.startsWith(string)) continue;
            String string3 = string2.substring(n2);
            if (string3.indexOf("/") >= 0) continue;
            resourceBundleRegistry.b(string2);
            arrayList.add(string2);
        }
        for (String string2 : arrayList) {
            hashSet.remove(string2);
        }
    }

    public void save(IlvPalette ilvPalette, File file) throws IOException {
        this.save(ilvPalette, file, false, false);
    }

    public void save(IlvPalette ilvPalette, File file, boolean bl, boolean bl2) throws IOException {
        Serializable serializable;
        Object object;
        if (!this.contains(ilvPalette)) {
            throw new RuntimeException("Palette is not contained in this manager");
        }
        if (this.getWorkingDirectory() == null) {
            IOException iOException = new IOException("Working direcory for saving palettes is not specified");
            throw iOException;
        }
        File file2 = new File(this.getWorkingDirectory() + "/" + ilvPalette.getPackageName());
        try {
            if (bl) {
                object = new HashSet();
                ilvPalette.a((HashSet)object);
                this.a(file2, (HashSet)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ilvPalette.a(this.getWorkingDirectory());
        object = new FileOutputStream(file);
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)object);
        this.a(file2, jarOutputStream);
        jarOutputStream.close();
        try {
            if (this.d != null) {
                serializable = file.toURL();
                this.d.removeURL(ilvPalette.getJarURL());
                this.d.addURL((URL)serializable);
                ilvPalette.b((URL)serializable);
                ilvPalette.b();
                this.b(ilvPalette);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            if (bl2) {
                serializable = new HashSet();
                ((HashSet)serializable).add(this.a(file));
                this.a(file2, (HashSet)serializable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(IlvPalette ilvPalette) {
        URL uRL = ilvPalette.getPaletteURL();
        if (uRL == null) {
            return;
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            try {
                byte[] byArray = new byte[2];
                inputStream.read(byArray);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void a(File file, HashSet hashSet) {
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file2 = fileArray[i2];
            if (file2.isDirectory()) {
                this.a(file2, hashSet);
                continue;
            }
            if (hashSet.contains(this.a(file2))) continue;
            file2.delete();
        }
        if (file.listFiles().length == 0 && !hashSet.contains(this.a(file))) {
            file.delete();
        }
    }

    private String a(File file) {
        try {
            return file.toURL().toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private void a(File file, JarOutputStream jarOutputStream) {
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file2 = fileArray[i2];
            if (file2.isDirectory()) {
                this.a(file2, jarOutputStream);
                continue;
            }
            int n2 = this.getWorkingDirectory().getPath().length();
            String string = file2.getParent().substring(n2);
            try {
                int n3;
                String string2 = string + "/" + file2.getName();
                string2 = string2.substring(1).replace('\\', '/');
                jarOutputStream.putNextEntry(new ZipEntry(string2));
                byte[] byArray = new byte[4096];
                FileInputStream fileInputStream = new FileInputStream(file2);
                while ((n3 = ((InputStream)fileInputStream).read(byArray)) != -1) {
                    jarOutputStream.write(byArray, 0, n3);
                }
                ((InputStream)fileInputStream).close();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public File getWorkingDirectory() {
        return this.e;
    }

    public void setWorkingDirectory(File file) {
        if (file != null && !file.isDirectory()) {
            throw new RuntimeException("Working directory " + file + " is not a directory");
        }
        this.e = file;
    }

    public void setAndCreateWorkingDirectory(File file, String string) throws IOException {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        File file2 = new File(file, string);
        file2.mkdirs();
        if (!file2.isDirectory()) {
            throw new IOException("Could not create working directory " + file2);
        }
        this.setWorkingDirectory(file2);
    }

    public boolean isPaletteReadOnly(IlvPalette ilvPalette) {
        return this.b.contains(ilvPalette);
    }

    public void updateSymbolReferences(ArrayList arrayList, String string, String string2, String string3) {
        int n2 = string.lastIndexOf(string2);
        if (n2 >= 0) {
            String string4 = string.substring(0, n2);
            String string5 = string4 + string3 + ".css";
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                IlvPalette ilvPalette = (IlvPalette)arrayList.get(i2);
                if (this.isPaletteReadOnly(ilvPalette)) continue;
                ilvPalette.a(this.getWorkingDirectory(), string, string5, string2, string3, ilvPalette.getRoot());
                try {
                    this.save(ilvPalette, new File(ilvPalette.getJarURL().getFile()), true, true);
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public ArrayList getPalettesToUpdate(String string) {
        ArrayList<IlvPalette> arrayList = null;
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            IlvPalette ilvPalette = (IlvPalette)this.a.get(i2);
            if (this.isPaletteReadOnly(ilvPalette) || !this.a(ilvPalette.getRoot(), string)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<IlvPalette>();
            }
            arrayList.add(ilvPalette);
        }
        return arrayList;
    }

    private boolean a(IlvPaletteObject ilvPaletteObject, String string) {
        if (ilvPaletteObject == null) {
            return false;
        }
        if (ilvPaletteObject instanceof IlvPaletteCategory) {
            IlvPaletteCategory ilvPaletteCategory = (IlvPaletteCategory)ilvPaletteObject;
            Enumeration enumeration = ilvPaletteCategory.getChildren();
            while (enumeration.hasMoreElements()) {
                boolean bl = this.a((IlvPaletteObject)enumeration.nextElement(), string);
                if (!bl) continue;
                return true;
            }
        } else if (ilvPaletteObject instanceof IlvPaletteSymbol) {
            IlvPaletteSymbol ilvPaletteSymbol = (IlvPaletteSymbol)ilvPaletteObject;
            URL uRL = ilvPaletteSymbol.getCSSURL();
            StringBuffer stringBuffer = IlvPalette.a(uRL);
            if (uRL != null && stringBuffer != null && stringBuffer.indexOf(string) > -1) {
                return true;
            }
        }
        return false;
    }
}

