/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.java2d;

import ilog.views.util.java2d.IlvPolygon2D;
import ilog.views.util.java2d.IlvTranslatedShape;
import ilog.views.util.java2d.internal.IlvMath;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;

public class IlvShapeUtil {
    public static double distanceTo(Line2D line2D, double d2, double d3, Point2D point2D) {
        double d4;
        double d5 = line2D.getX1();
        double d6 = line2D.getY1();
        double d7 = line2D.getX2();
        double d8 = (d7 - d5) * (d7 - d5) + ((d4 = line2D.getY2()) - d6) * (d4 - d6);
        if (d8 == 0.0) {
            if (point2D != null) {
                point2D.setLocation(d5, d6);
            }
            return Math.sqrt((d2 - d5) * (d2 - d5) + (d3 - d6) * (d3 - d6));
        }
        double d9 = (d2 - d5) * (d7 - d5) + (d3 - d6) * (d4 - d6);
        double d10 = (d2 - d5) * (d4 - d6) - (d3 - d6) * (d7 - d5);
        if (d9 < 0.0) {
            if (point2D != null) {
                point2D.setLocation(d5, d6);
            }
            d9 = -d9;
        } else if (d9 > d8) {
            if (point2D != null) {
                point2D.setLocation(d7, d4);
            }
            d9 -= d8;
        } else {
            if (point2D != null) {
                point2D.setLocation(d5 + d9 / d8 * (d7 - d5), d6 + d9 / d8 * (d4 - d6));
            }
            d9 = 0.0;
        }
        return Math.sqrt((d9 * d9 + d10 * d10) / d8);
    }

    public static double distanceTo(Rectangle2D rectangle2D, double d2, double d3, Point2D point2D) {
        double d4;
        double d5;
        double d6;
        double d7;
        double d8 = rectangle2D.getMinX();
        double d9 = rectangle2D.getMaxX();
        double d10 = rectangle2D.getMinY();
        double d11 = rectangle2D.getMaxY();
        if (d2 >= d8) {
            if (d2 <= d9) {
                d7 = d2;
                d6 = 0.0;
            } else {
                d7 = d9;
                d6 = d2 - d9;
            }
        } else {
            d7 = d8;
            d6 = d8 - d2;
        }
        if (d3 >= d10) {
            if (d3 <= d11) {
                d5 = d3;
                d4 = 0.0;
            } else {
                d5 = d11;
                d4 = d3 - d11;
            }
        } else {
            d5 = d10;
            d4 = d10 - d3;
        }
        if (point2D != null) {
            point2D.setLocation(d7, d5);
        }
        if (d6 == 0.0) {
            return d4;
        }
        if (d4 == 0.0) {
            return d6;
        }
        return Math.sqrt(d6 * d6 + d4 * d4);
    }

    public static double distanceTo(Shape shape, double d2, double d3, Point2D point2D) {
        return IlvShapeUtil.a(shape, true, d2, d3, point2D);
    }

    public static double distanceToBorder(Shape shape, double d2, double d3, Point2D point2D) {
        return IlvShapeUtil.a(shape, false, d2, d3, point2D);
    }

    private static double a(Shape shape, boolean bl, double d2, double d3, Point2D point2D) {
        if (shape instanceof Line2D) {
            return IlvShapeUtil.distanceTo((Line2D)shape, d2, d3, point2D);
        }
        if (bl) {
            if (shape instanceof Rectangle2D) {
                return IlvShapeUtil.distanceTo((Rectangle2D)shape, d2, d3, point2D);
            }
            if (shape.contains(d2, d3)) {
                if (point2D != null) {
                    point2D.setLocation(d2, d3);
                }
                return 0.0;
            }
        }
        double d4 = Double.POSITIVE_INFINITY;
        if (point2D != null) {
            point2D.setLocation(Double.NaN, Double.NaN);
        }
        double[] dArray = new double[6];
        Point2D.Double double_ = point2D != null ? new Point2D.Double() : null;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        PathIterator pathIterator = shape.getPathIterator(null);
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(dArray);
            switch (n2) {
                case 0: {
                    d7 = dArray[0];
                    d8 = dArray[1];
                    double d9 = Math.sqrt((d2 - d7) * (d2 - d7) + (d3 - d8) * (d3 - d8));
                    if (d9 < d4) {
                        d4 = d9;
                        if (point2D != null) {
                            point2D.setLocation(d7, d8);
                        }
                    }
                    d5 = d7;
                    d6 = d8;
                    break;
                }
                case 1: {
                    double d9 = dArray[0];
                    double d10 = dArray[1];
                    double d11 = IlvShapeUtil.distanceTo(new Line2D.Double(d7, d8, d9, d10), d2, d3, (Point2D)double_);
                    if (d11 < d4) {
                        d4 = d11;
                        if (point2D != null) {
                            point2D.setLocation(double_.x, double_.y);
                        }
                    }
                    d7 = d9;
                    d8 = d10;
                    break;
                }
                case 2: {
                    double d12;
                    double d13;
                    double d14;
                    double d15;
                    double d9 = dArray[0];
                    double d10 = dArray[1];
                    double d11 = dArray[2];
                    double d16 = dArray[3];
                    double d17 = d7 - 2.0 * d9 + d11;
                    double d18 = 2.0 * (d9 - d7);
                    double d19 = d7 - d2;
                    double d20 = d8 - 2.0 * d10 + d16;
                    double d21 = 2.0 * (d10 - d8);
                    double d22 = d8 - d3;
                    double d23 = 2.0 * (d17 * d17 + d20 * d20);
                    double d24 = 3.0 * (d17 * d18 + d20 * d21);
                    double d25 = d18 * d18 + 2.0 * d17 * d19 + d21 * d21 + 2.0 * d20 * d22;
                    double d26 = d18 * d19 + d21 * d22;
                    int n3 = IlvMath.calcPolynomialSolution(3, new double[]{d26, d25, d24, d23}, 0.0, 1.0, dArray);
                    for (int i2 = 0; i2 < n3; ++i2) {
                        d15 = dArray[i2];
                        d14 = (d17 * d15 + d18) * d15 + d19;
                        d13 = (d20 * d15 + d21) * d15 + d22;
                        d12 = Math.sqrt(d14 * d14 + d13 * d13);
                        if (!(d12 < d4)) continue;
                        d4 = d12;
                        if (point2D == null) continue;
                        point2D.setLocation(d14 + d2, d13 + d3);
                    }
                    d17 = Math.sqrt((d2 - d11) * (d2 - d11) + (d3 - d16) * (d3 - d16));
                    if (d17 < d4) {
                        d4 = d17;
                        if (point2D != null) {
                            point2D.setLocation(d11, d16);
                        }
                    }
                    d7 = d11;
                    d8 = d16;
                    break;
                }
                case 3: {
                    double d9 = dArray[0];
                    double d10 = dArray[1];
                    double d11 = dArray[2];
                    double d16 = dArray[3];
                    double d17 = dArray[4];
                    double d18 = dArray[5];
                    double d19 = 3.0 * (d9 - d11) + d17 - d7;
                    double d20 = 3.0 * (d7 - 2.0 * d9 + d11);
                    double d21 = 3.0 * (d9 - d7);
                    double d22 = d7 - d2;
                    double d23 = 3.0 * (d10 - d16) + d18 - d8;
                    double d24 = 3.0 * (d8 - 2.0 * d10 + d16);
                    double d25 = 3.0 * (d10 - d8);
                    double d26 = d8 - d3;
                    double d27 = 3.0 * (d19 * d19 + d23 * d23);
                    double d15 = 5.0 * (d19 * d20 + d23 * d24);
                    double d14 = 4.0 * d19 * d21 + 2.0 * d20 * d20 + 4.0 * d23 * d25 + 2.0 * d24 * d24;
                    double d13 = 3.0 * (d19 * d22 + d20 * d21 + d23 * d26 + d24 * d25);
                    double d12 = 2.0 * d20 * d22 + d21 * d21 + 2.0 * d24 * d26 + d25 * d25;
                    double d28 = d21 * d22 + d25 * d26;
                    int n4 = IlvMath.calcPolynomialSolution(5, new double[]{d28, d12, d13, d14, d15, d27}, 0.0, 1.0, dArray);
                    for (int i3 = 0; i3 < n4; ++i3) {
                        double d29 = dArray[i3];
                        double d30 = ((d19 * d29 + d20) * d29 + d21) * d29 + d22;
                        double d31 = ((d23 * d29 + d24) * d29 + d25) * d29 + d26;
                        double d32 = Math.sqrt(d30 * d30 + d31 * d31);
                        if (!(d32 < d4)) continue;
                        d4 = d32;
                        if (point2D == null) continue;
                        point2D.setLocation(d30 + d2, d31 + d3);
                    }
                    d19 = Math.sqrt((d2 - d17) * (d2 - d17) + (d3 - d18) * (d3 - d18));
                    if (d19 < d4) {
                        d4 = d19;
                        if (point2D != null) {
                            point2D.setLocation(d17, d18);
                        }
                    }
                    d7 = d17;
                    d8 = d18;
                    break;
                }
                case 4: {
                    double d9 = IlvShapeUtil.distanceTo(new Line2D.Double(d7, d8, d5, d6), d2, d3, (Point2D)double_);
                    if (!(d9 < d4)) break;
                    d4 = d9;
                    if (point2D == null) break;
                    point2D.setLocation(double_.x, double_.y);
                    break;
                }
                default: {
                    throw new Error("Invalid seg type: " + n2);
                }
            }
            pathIterator.next();
        }
        return d4;
    }

    public static Shape getTranslatedShape(Shape shape, double d2, double d3) {
        Shape shape2;
        if (d2 == 0.0 && d3 == 0.0) {
            return shape;
        }
        if (shape instanceof IlvTranslatedShape) {
            shape2 = (IlvTranslatedShape)shape;
            shape = ((IlvTranslatedShape)shape2).getOriginalShape();
            if ((d2 += ((IlvTranslatedShape)shape2).getOffsetX()) == 0.0 && (d3 += ((IlvTranslatedShape)shape2).getOffsetY()) == 0.0) {
                return shape;
            }
        }
        if (shape instanceof Line2D) {
            shape2 = (Line2D)shape;
            return new Line2D.Double(((Line2D)shape2).getX1() + d2, ((Line2D)shape2).getY1() + d3, ((Line2D)shape2).getX2() + d2, ((Line2D)shape2).getY2() + d3);
        }
        if (shape instanceof Rectangle2D) {
            shape2 = (Rectangle2D)shape;
            return new Rectangle2D.Double(((RectangularShape)shape2).getX() + d2, ((RectangularShape)shape2).getY() + d3, ((RectangularShape)shape2).getWidth(), ((RectangularShape)shape2).getHeight());
        }
        if (shape instanceof RoundRectangle2D) {
            shape2 = (RoundRectangle2D)shape;
            return new RoundRectangle2D.Double(((RectangularShape)shape2).getX() + d2, ((RectangularShape)shape2).getY() + d3, ((RectangularShape)shape2).getWidth(), ((RectangularShape)shape2).getHeight(), ((RoundRectangle2D)shape2).getArcWidth(), ((RoundRectangle2D)shape2).getArcHeight());
        }
        if (shape instanceof Ellipse2D) {
            shape2 = (Ellipse2D)shape;
            return new Ellipse2D.Double(((RectangularShape)shape2).getX() + d2, ((RectangularShape)shape2).getY() + d3, ((RectangularShape)shape2).getWidth(), ((RectangularShape)shape2).getHeight());
        }
        if (shape instanceof Polygon) {
            shape2 = (Polygon)shape;
            int n2 = ((Polygon)shape2).npoints;
            if ((double)((int)d2) == d2 && (double)((int)d3) == d3) {
                int n3 = (int)d2;
                int n4 = (int)d3;
                int[] nArray = new int[n2];
                int[] nArray2 = new int[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    nArray[i2] = ((Polygon)shape2).xpoints[i2] + n3;
                    nArray2[i2] = ((Polygon)shape2).xpoints[i2] + n4;
                }
                return new Polygon(nArray, nArray2, n2);
            }
            Point2D[] point2DArray = new Point2D.Double[n2];
            for (int i3 = 0; i3 < n2; ++i3) {
                point2DArray[i3] = new Point2D.Double((double)((Polygon)shape2).xpoints[i3] + d2, (double)((Polygon)shape2).ypoints[i3] + d3);
            }
            return new IlvPolygon2D.Double(point2DArray);
        }
        if (shape instanceof IlvPolygon2D) {
            shape2 = ((IlvPolygon2D)shape).getPoints();
            int n5 = ((Shape)shape2).length;
            Point2D[] point2DArray = new Point2D.Double[n5];
            for (int i4 = 0; i4 < n5; ++i4) {
                point2DArray[i4] = new Point2D.Double(((Point2D)((Object)shape2[i4])).getX() + d2, ((Point2D)((Object)shape2[i4])).getY() + d3);
            }
            return new IlvPolygon2D.Double(point2DArray);
        }
        if (shape instanceof GeneralPath) {
            shape2 = (GeneralPath)shape;
            AffineTransform affineTransform = new AffineTransform(1.0, 0.0, 0.0, 1.0, d2, d3);
            return ((Path2D)shape2).createTransformedShape(affineTransform);
        }
        return new IlvTranslatedShape(shape, d2, d3);
    }

    private IlvShapeUtil() {
    }
}

