/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.java2d.internal;

public class IlvGradientUtil {
    public static final int[] SRGBtoLinearRGB = new int[256];
    public static final int[] LinearRGBtoSRGB = new int[256];

    private static int a(int n2) {
        float f2 = (float)n2 / 255.0f;
        float f3 = f2 <= 0.04045f ? f2 / 12.92f : (float)Math.pow(((double)f2 + 0.055) / 1.055, 2.4);
        int n3 = Math.round(f3 * 255.0f);
        return n3;
    }

    private static int b(int n2) {
        float f2 = (float)n2 / 255.0f;
        float f3 = (double)f2 <= 0.0031308 ? f2 * 12.92f : 1.055f * (float)Math.pow(f2, 0.4166666666666667) - 0.055f;
        int n3 = Math.round(f3 * 255.0f);
        return n3;
    }

    public static int convertEntireColorLinearRGBtoSRGB(int n2) {
        int n3 = n2 >> 24 & 0xFF;
        int n4 = n2 >> 16 & 0xFF;
        int n5 = n2 >> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        n4 = LinearRGBtoSRGB[n4];
        n5 = LinearRGBtoSRGB[n5];
        n6 = LinearRGBtoSRGB[n6];
        return n3 << 24 | n4 << 16 | n5 << 8 | n6;
    }

    public static int convertEntireColorSRGBtoLinearRGB(int n2) {
        int n3 = n2 >> 24 & 0xFF;
        int n4 = n2 >> 16 & 0xFF;
        int n5 = n2 >> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        n4 = SRGBtoLinearRGB[n4];
        n5 = SRGBtoLinearRGB[n5];
        n6 = SRGBtoLinearRGB[n6];
        return n3 << 24 | n4 << 16 | n5 << 8 | n6;
    }

    public static int interpolate(int n2, int n3, float f2) {
        int n4 = n2 >> 24 & 0xFF;
        int n5 = n2 >> 16 & 0xFF;
        int n6 = n2 >> 8 & 0xFF;
        int n7 = n2 & 0xFF;
        int n8 = (n3 >> 24 & 0xFF) - n4;
        int n9 = (n3 >> 16 & 0xFF) - n5;
        int n10 = (n3 >> 8 & 0xFF) - n6;
        int n11 = (n3 & 0xFF) - n7;
        return (int)((double)((float)n4 + f2 * (float)n8) + 0.5) << 24 | (int)((double)((float)n5 + f2 * (float)n9) + 0.5) << 16 | (int)((double)((float)n6 + f2 * (float)n10) + 0.5) << 8 | (int)((double)((float)n7 + f2 * (float)n11) + 0.5);
    }

    public static void interpolate(int n2, int n3, int[] nArray) {
        int n4 = n2 >> 24 & 0xFF;
        int n5 = n2 >> 16 & 0xFF;
        int n6 = n2 >> 8 & 0xFF;
        int n7 = n2 & 0xFF;
        int n8 = (n3 >> 24 & 0xFF) - n4;
        int n9 = (n3 >> 16 & 0xFF) - n5;
        int n10 = (n3 >> 8 & 0xFF) - n6;
        int n11 = (n3 & 0xFF) - n7;
        float f2 = 1.0f / (float)nArray.length;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = (int)((double)((float)n4 + (float)(i2 * n8) * f2) + 0.5) << 24 | (int)((double)((float)n5 + (float)(i2 * n9) * f2) + 0.5) << 16 | (int)((double)((float)n6 + (float)(i2 * n10) * f2) + 0.5) << 8 | (int)((double)((float)n7 + (float)(i2 * n11) * f2) + 0.5);
        }
    }

    private IlvGradientUtil() {
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            IlvGradientUtil.SRGBtoLinearRGB[i2] = IlvGradientUtil.a(i2);
            IlvGradientUtil.LinearRGBtoSRGB[i2] = IlvGradientUtil.b(i2);
        }
    }
}

