/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.print;

import ilog.views.util.print.IlvFlow;
import ilog.views.util.print.IlvFooter;
import ilog.views.util.print.IlvHeader;
import ilog.views.util.print.IlvPage;
import ilog.views.util.print.IlvUnit;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class IlvPrintableDocument
implements Printable,
Pageable {
    private Vector<IlvPage> a;
    private PageFormat b;
    private IlvPage c;
    private String d;
    private String e;
    private Date f = new Date();
    private IlvFooter g;
    private IlvHeader h;
    private PropertyChangeSupport i;
    private int j = 1;
    private int k = -1;
    private IlvFlow l;
    public static final int ORDERED_BY_COLUMNS = 0;
    public static final int ORDERED_BY_ROWS = 1;
    private boolean m = false;

    public IlvPrintableDocument(String string, PageFormat pageFormat) {
        this.a();
        this.b = pageFormat;
        this.d = string;
    }

    public IlvPrintableDocument(String string) {
        this.a();
        this.b = new PageFormat();
        this.b.setPaper(new Paper());
        this.d = string;
    }

    private void a() {
        this.a = new Vector();
        this.i = new PropertyChangeSupport(this);
    }

    public String getName() {
        return this.d;
    }

    public void setName(String string) {
        String string2 = this.d;
        this.d = string;
        this.firePropertyChange("name", string2, this.d);
    }

    public Date getDate() {
        return this.f;
    }

    public void setDate(Date date) {
        Date date2 = this.f;
        this.f = date;
        this.invalidateFlowLayout();
        this.firePropertyChange("date", date2, this.f);
    }

    public String getAuthor() {
        return this.e;
    }

    public void setAuthor(String string) {
        String string2 = this.e;
        this.e = string;
        this.invalidateFlowLayout();
        this.firePropertyChange("author", string2, this.e);
    }

    public PageFormat getPageFormat() {
        return this.b;
    }

    public PageFormat getPageFormat(int n2) {
        return this.getPage(n2).getPageFormat();
    }

    public void setPageFormat(PageFormat pageFormat) {
        if (pageFormat.getOrientation() != this.b.getOrientation() || pageFormat.getHeight() != this.b.getHeight() || pageFormat.getWidth() != this.b.getWidth() || pageFormat.getImageableX() != this.b.getImageableX() || pageFormat.getImageableY() != this.b.getImageableY() || pageFormat.getImageableHeight() != this.b.getImageableHeight() || pageFormat.getImageableWidth() != this.b.getImageableWidth()) {
            PageFormat pageFormat2 = this.b;
            this.b = pageFormat;
            this.invalidateFlowLayout();
            this.firePropertyChange("pageFormat", pageFormat2, this.b);
        }
    }

    public IlvUnit.Rectangle getImageableBounds() {
        double d2 = this.getPageFormat().getImageableX();
        double d3 = this.getPageFormat().getImageableY();
        double d4 = this.getPageFormat().getImageableWidth();
        double d5 = this.getPageFormat().getImageableHeight();
        if (this.getHeader() != null) {
            d3 += this.getHeader().getHeight();
            d5 -= this.getHeader().getHeight();
        }
        d3 = Math.min(this.getPageFormat().getImageableY() + this.getPageFormat().getImageableHeight(), d3);
        if (this.getFooter() != null) {
            d5 -= this.getFooter().getHeight();
        }
        if (d5 < 0.0) {
            d5 = 1.0;
        }
        return new IlvUnit.Rectangle(d2, d3, d4, d5, IlvUnit.POINTS);
    }

    public IlvFlow getFlow() {
        if (this.l == null) {
            this.l = new IlvFlow(this);
        }
        return this.l;
    }

    public boolean isFlowLayoutValid() {
        if (this.l == null) {
            return true;
        }
        return this.l.isValid();
    }

    public void invalidateFlowLayout() {
        if (this.l != null) {
            this.l.invalidate();
        }
    }

    private void b() {
        if (!this.m) {
            this.m = true;
            this.removeAll();
            IlvPage[] ilvPageArray = this.createPages();
            this.m = true;
            this.setPages(ilvPageArray);
        }
    }

    protected IlvPage[] createPages() {
        return null;
    }

    protected void invalidatePages() {
        this.m = false;
    }

    public synchronized void addPage(IlvPage ilvPage) {
        int n2 = this.getNumberOfPages();
        this.a.add(ilvPage);
        ilvPage.setDocument(this);
        this.firePropertyChange("pageCount", new Integer(n2), new Integer(this.getNumberOfPages()));
    }

    public synchronized void setPages(IlvPage[] ilvPageArray) {
        int n2 = this.getNumberOfPages();
        if (ilvPageArray == null) {
            this.removeAll();
            return;
        }
        this.a.clear();
        for (int i2 = 0; i2 < ilvPageArray.length; ++i2) {
            this.a.add(ilvPageArray[i2]);
            ilvPageArray[i2].setDocument(this);
        }
        this.firePropertyChange("pageCount", new Integer(n2), new Integer(this.getNumberOfPages()));
    }

    public synchronized void removePage(IlvPage ilvPage) {
        int n2 = this.getNumberOfPages();
        this.a.remove(ilvPage);
        ilvPage.setDocument(null);
        this.firePropertyChange("pageCount", new Integer(n2), new Integer(this.getNumberOfPages()));
    }

    public synchronized void removeAll() {
        int n2 = this.getNumberOfPages();
        Iterator<IlvPage> iterator = this.a.iterator();
        while (iterator.hasNext()) {
            iterator.next().setDocument(null);
        }
        this.a.clear();
        this.firePropertyChange("pageCount", new Integer(n2), new Integer(0));
    }

    public IlvPage getPage(int n2) {
        this.b();
        return this.a.elementAt(n2);
    }

    public int getPageIndex(IlvPage ilvPage) {
        this.b();
        return this.a.indexOf(ilvPage);
    }

    public synchronized int getNumberOfPages() {
        this.b();
        return this.a.size();
    }

    public Printable getPrintable(int n2) {
        return this.getPage(n2);
    }

    public int getColumnCount() {
        return this.k;
    }

    public void setColumnCount(int n2) {
        this.k = n2;
    }

    public int getPageOrder() {
        return this.j;
    }

    public void setPageOrder(int n2) {
        if (n2 != this.j) {
            int n3 = this.j;
            this.j = n2;
            this.invalidateFlowLayout();
            this.firePropertyChange("pageOrder", new Integer(n3), new Integer(this.j));
        }
    }

    public IlvPage getTemplatePage() {
        return this.c;
    }

    public void setTemplatePage(IlvPage ilvPage) {
        IlvPage ilvPage2 = this.c;
        this.c = ilvPage;
        if (ilvPage != null) {
            ilvPage.setDocument(this);
        }
        this.firePropertyChange("templatePage", ilvPage2, this.c);
    }

    public IlvFooter getFooter() {
        return this.g;
    }

    public void setFooter(IlvFooter ilvFooter) {
        if (ilvFooter == null && this.g == null) {
            return;
        }
        if (ilvFooter != null && ilvFooter.equals(this.g)) {
            return;
        }
        if (this.getTemplatePage() != null && this.g != null) {
            this.getTemplatePage().removePrintableObject(this.g);
        }
        if (ilvFooter != null) {
            if (this.getTemplatePage() == null) {
                this.setTemplatePage(new IlvPage());
            }
            this.getTemplatePage().addPrintableObject(ilvFooter);
        }
        IlvFooter ilvFooter2 = this.g;
        this.g = ilvFooter;
        this.invalidateFlowLayout();
        this.firePropertyChange("footer", ilvFooter2, this.g);
    }

    public IlvHeader getHeader() {
        return this.h;
    }

    public void setHeader(IlvHeader ilvHeader) {
        if (ilvHeader == null && this.h == null) {
            return;
        }
        if (ilvHeader != null && ilvHeader.equals(this.h)) {
            return;
        }
        if (this.getTemplatePage() != null && this.h != null) {
            this.getTemplatePage().removePrintableObject(this.h);
        }
        if (ilvHeader != null) {
            if (this.getTemplatePage() == null) {
                this.setTemplatePage(new IlvPage());
            }
            this.getTemplatePage().addPrintableObject(ilvHeader);
        }
        IlvHeader ilvHeader2 = this.h;
        this.h = ilvHeader;
        this.invalidateFlowLayout();
        this.firePropertyChange("header", ilvHeader2, this.h);
    }

    protected void prepareDocument() {
    }

    void c() {
        if (this.l != null) {
            this.l.layout();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n2) throws PrinterException {
        this.setDate(new Date());
        if (n2 >= this.a.size()) {
            return 1;
        }
        return this.getPrintable(n2).print(graphics, pageFormat, n2);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.i.firePropertyChange(string, object, object2);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.i.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.i.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.i.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.i.removePropertyChangeListener(propertyChangeListener);
    }
}

