/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing;

import ilog.views.util.IlvImageUtil;
import ilog.views.util.swing.IlvCursorRegistry;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.HashMap;

public class IlvCursorFactory {
    public static final int HAND_UP_CURSOR = 14;
    public static final int HAND_DOWN_CURSOR = 15;
    public static final int HAND_FINGER_CURSOR = 16;
    public static final int ZOOM_IN_CURSOR = 17;
    public static final int ZOOM_OUT_CURSOR = 18;
    public static final int XCROSSHAIR_CURSOR = 19;
    public static final int LARGE_PAN_CURSOR = 20;
    public static final int SMALL_PAN_CURSOR = 21;
    private static final Toolkit a = Toolkit.getDefaultToolkit();
    private static final Point b = new Point(16, 16);
    private static final HashMap c = new HashMap(4);

    private IlvCursorFactory() {
    }

    public static Cursor getCursor(int n2) {
        if (n2 < 14) {
            return Cursor.getPredefinedCursor(n2);
        }
        Integer n3 = new Integer(n2);
        Cursor cursor = (Cursor)c.get(n3);
        if (cursor != null) {
            return cursor;
        }
        switch (n2) {
            case 14: {
                cursor = IlvCursorFactory.a("HandUp", "handup32.gif", 12, b);
                break;
            }
            case 15: {
                cursor = IlvCursorFactory.a("HandDown", "handdown32.gif", 12, b);
                break;
            }
            case 16: {
                cursor = IlvCursorFactory.a("HandFinger", "handfinger32.gif", 12, b);
                break;
            }
            case 17: {
                cursor = IlvCursorFactory.a("ZoomIn", "zoomin32.gif", 1, new Point(7, 7));
                break;
            }
            case 18: {
                cursor = IlvCursorFactory.a("ZoomOut", "zoomout32.gif", 1, new Point(7, 7));
                break;
            }
            case 19: {
                cursor = IlvCursorFactory.a("XCrossHair", "xcross32.gif", 1, b);
                break;
            }
            case 20: {
                cursor = IlvCursorFactory.a("LargePan", "panup32.gif", 1, b);
                break;
            }
            case 21: {
                cursor = IlvCursorFactory.a("SmallPan", "pandown32.gif", 1, b);
            }
        }
        c.put(n3, cursor);
        return cursor;
    }

    private static Cursor a(String string, String string2, int n2, Point point) {
        Dimension dimension = a.getBestCursorSize(32, 32);
        if (dimension.width == 32 && dimension.height == 32) {
            try {
                Image image = IlvImageUtil.getImageFromFile(IlvCursorFactory.class, string2);
                MediaTracker mediaTracker = new MediaTracker(new Component(){});
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForID(0);
                mediaTracker.removeImage(image, 0);
                Cursor cursor = a.createCustomCursor(image, point, string);
                IlvCursorRegistry.registerCustomCursor(string, image, point);
                return cursor;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Cursor.getPredefinedCursor(n2);
    }
}

