/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;

public class IlvJTableHeaderWithToolTips
extends JTableHeader {
    public IlvJTableHeaderWithToolTips() {
    }

    public IlvJTableHeaderWithToolTips(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Object object;
        if (File.separatorChar == '\\' && (object = this.getTopLevelAncestor()) instanceof Window && !((Window)object).isActive()) {
            return null;
        }
        object = super.getToolTipText(mouseEvent);
        if (object != null) {
            return object;
        }
        Point point = mouseEvent.getPoint();
        int n2 = this.getColumnModel().getColumnIndexAtX(point.x);
        if (n2 != -1) {
            Component component;
            TableCellRenderer tableCellRenderer = this.getColumnModel().getColumn(n2).getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = this.getDefaultRenderer();
            }
            if ((component = tableCellRenderer.getTableCellRendererComponent(this.getTable(), this.getColumnModel().getColumn(n2).getHeaderValue(), false, false, -1, n2)) instanceof JLabel || component instanceof JTextComponent) {
                JComponent jComponent = (JComponent)component;
                Rectangle rectangle = this.getHeaderRect(n2);
                Dimension dimension = jComponent.getPreferredSize();
                if (rectangle.width < dimension.width) {
                    if (jComponent instanceof JLabel) {
                        return ((JLabel)jComponent).getText();
                    }
                    if (jComponent instanceof JTextComponent) {
                        return ((JTextComponent)jComponent).getText();
                    }
                }
            } else {
                Object object2 = this.getColumnModel().getColumn(n2).getHeaderValue();
                if (object2 != null && !(object2 instanceof JComponent)) {
                    return object2.toString();
                }
            }
        }
        return null;
    }
}

