/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.ide.Service;
import javax.ide.spi.ProviderNotFoundException;

public abstract class LookupProvider {
    private static LookupProvider PRIMORDIAL_PROVIDER;
    private static LookupProvider s_defaultProvider;

    public abstract Collection lookupAllImpl(ClassLoader var1, Class var2) throws ProviderNotFoundException;

    public static LookupProvider getDefault() {
        return s_defaultProvider;
    }

    public static final void setDefault(LookupProvider defaultProvider) {
        LookupProvider old = s_defaultProvider;
        s_defaultProvider = defaultProvider == null ? PRIMORDIAL_PROVIDER : defaultProvider;
        if (old != defaultProvider) {
            Service.resetAllServices();
        }
    }

    public static final Object lookup(ClassLoader loader, Class clazz) throws ProviderNotFoundException {
        Collection impls = LookupProvider.getDefault().lookupAllImpl(loader, clazz);
        if (impls.isEmpty()) {
            throw new ProviderNotFoundException("No provider for " + clazz);
        }
        Iterator i = impls.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (i.hasNext()) continue;
            return o;
        }
        throw new IllegalStateException();
    }

    public static Collection lookupAll(ClassLoader loader, Class clazz) throws ProviderNotFoundException {
        return LookupProvider.getDefault().lookupAllImpl(loader, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWith(Runnable r, LookupProvider lookupProvider) {
        LookupProvider lp = LookupProvider.getDefault();
        HashMap<Class<?>, Service> loadedServices = Service.cloneLoadedServices();
        LookupProvider.setDefault(lookupProvider);
        try {
            r.run();
        }
        finally {
            LookupProvider.setDefault(lp);
            Service.setLoadedServices(loadedServices);
        }
    }

    static {
        s_defaultProvider = PRIMORDIAL_PROVIDER = new DefaultImpl();
    }

    private static final class DefaultImpl
    extends LookupProvider {
        private DefaultImpl() {
        }

        @Override
        public Collection lookupAllImpl(ClassLoader loader, Class clazz) throws ProviderNotFoundException {
            try {
                Enumeration<URL> en = loader.getResources("META-INF/services/" + clazz.getName());
                Collection all = this.lookupAll(loader, clazz, en);
                all.addAll(this.lookupAll(loader, clazz, loader.getResources("meta-inf/services/" + clazz.getName())));
                return all;
            }
            catch (IOException ioe) {
                throw new ProviderNotFoundException(clazz.getName(), ioe);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection lookupAll(ClassLoader loader, Class clazz, Enumeration en) throws ProviderNotFoundException {
            ArrayList results = new ArrayList();
            while (en.hasMoreElements()) {
                URL url = (URL)en.nextElement();
                try {
                    InputStream is = url.openStream();
                    try {
                        String line;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                        while ((line = reader.readLine()) != null) {
                            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                            try {
                                Class<?> inst = Class.forName(line, false, loader);
                                if (!clazz.isAssignableFrom(inst)) {
                                    throw new ProviderNotFoundException(inst + " is not correct type for service " + clazz);
                                }
                                results.add(inst.newInstance());
                            }
                            catch (Exception e) {
                                throw new ProviderNotFoundException("Failed to create service class " + line, e);
                            }
                        }
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException ioe) {
                    throw new ProviderNotFoundException("Failed to load service class " + clazz, ioe);
                }
            }
            return results;
        }
    }
}

