/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import com.oracle.jdeveloper.nbwindowsystem.NbDockStation;
import com.oracle.jdeveloper.nbwindowsystem.NbDockableContainer;
import com.oracle.jdeveloper.nbwindowsystem.NbEditorContainer;
import com.oracle.jdeveloper.nbwindowsystem.NbWindowSystemFS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.ide.util.BitField;
import oracle.ideimpl.layout.RoleLayoutShapingProvider;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.windows.TopComponent;

class LayoutGroup {
    private final boolean isTaskLayout;
    private final Preferences prefs;
    private final String name;
    private Layout layout;
    private boolean opened = false;
    private boolean initialized = false;
    private final Set<String> visibleTopComponents = new CopyOnWriteArraySet<String>();
    private final Map<String, Flags> tcid2flags = new HashMap<String, Flags>(10);
    private final Set<String> unknownDockableIds = new HashSet<String>(20);
    private static final Logger LOG = Logger.getLogger(LayoutGroup.class.getName());
    private static final String SELECTION_PREF_STATE_NON_GLOBAL_PREFIX = "SELECTION_PREF_STATE_NON_GLOBAL_";
    private static final String SELECTION_PREF_STATE_GLOBAL_PREFIX = "SELECTION_PREF_STATE_GLOBAL_";
    private static final String TOP_COMPONENT_NAME_PREFIX = "NBDC_";
    private final Map<String, String> tcSelectionStateNonGlobal = new HashMap<String, String>();
    private static final Map<String, String> tcSelectionStateGlobal = new HashMap<String, String>();
    private Collection<String> newAddedSelectedTcs = new ArrayList<String>();

    LayoutGroup(String name, Preferences prefs, boolean taskLayout) {
        this.name = name;
        this.isTaskLayout = taskLayout;
        this.prefs = prefs.node(LayoutGroup.toPreferencesNodeName(name));
    }

    void load() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (null == this.prefs.get("layout-name", null)) {
            assert (null != this.layout);
            NbWindowSystemFS fs = NbWindowSystemFS.getDefault();
            this.unknownDockableIds.addAll(fs.getKnownDockableIds());
            return;
        }
        try {
            boolean loadGlobalSelection = tcSelectionStateGlobal.isEmpty();
            for (String key : this.prefs.keys()) {
                if ("layout-name".equals(key)) continue;
                if (key.startsWith(SELECTION_PREF_STATE_NON_GLOBAL_PREFIX)) {
                    String selectedTCInModeNonGlobal = this.prefs.get(key, null);
                    if (selectedTCInModeNonGlobal == null) continue;
                    key = key.replace(SELECTION_PREF_STATE_NON_GLOBAL_PREFIX, "");
                    this.tcSelectionStateNonGlobal.put(key, selectedTCInModeNonGlobal);
                    continue;
                }
                if (loadGlobalSelection && key.startsWith(SELECTION_PREF_STATE_GLOBAL_PREFIX)) {
                    String selectedTCInModeGlobal = this.prefs.get(key, null);
                    if (selectedTCInModeGlobal == null) continue;
                    key = key.replace(SELECTION_PREF_STATE_GLOBAL_PREFIX, "");
                    tcSelectionStateGlobal.put(selectedTCInModeGlobal, key);
                    continue;
                }
                String state = this.prefs.get(key, "");
                if (state.startsWith("v")) {
                    boolean clone;
                    this.visibleTopComponents.add(key);
                    if (!this.isTaskLayout) continue;
                    boolean minimized = state.indexOf("m-") >= 0;
                    boolean selected = state.indexOf("s-") >= 0;
                    boolean bl = clone = state.indexOf("c-") >= 0;
                    if (clone) {
                        NbWindowSystemFS.getDefault().addClonedDockable(key);
                    }
                    this.tcid2flags.put(key, new Flags(minimized, selected, clone));
                    continue;
                }
                this.unknownDockableIds.add(key);
            }
        }
        catch (BackingStoreException e) {
            LOG.log(Level.INFO, null, e);
        }
    }

    void open() {
        this.checkUnknownDockables();
        HashSet openedTcs = new HashSet(TopComponent.getRegistry().getOpened());
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        for (String tcId : this.visibleTopComponents) {
            TopComponent tc = wm.findTopComponent(tcId);
            if (null == tc || tc.isOpened()) continue;
            tc.open();
        }
        for (String tcId : this.tcid2flags.keySet()) {
            ModeImpl mode;
            TopComponent tc;
            Flags flags = this.tcid2flags.get(tcId);
            if (null == flags || null == (tc = wm.findTopComponent(tcId)) || null == (mode = (ModeImpl)wm.findMode(tc)) || mode.getState() != 0) continue;
            wm.setTopComponentMinimized(tc, flags.minimized);
            if (!flags.selected) continue;
            mode.setSelectedTopComponent(tc);
        }
        this.opened = true;
    }

    boolean isOpened() {
        return this.opened;
    }

    void close(Collection<String> keepOpened) {
        this.save();
        this.opened = false;
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        for (String tcId : this.visibleTopComponents) {
            TopComponent tc;
            if (keepOpened.contains(tcId) || null == (tc = wm.findTopComponent(tcId))) continue;
            if (tc instanceof NbDockableContainer) {
                ((NbDockableContainer)tc).markEventAsLayoutEvent();
            }
            tc.close();
        }
    }

    void save() {
        if (this.isOpened()) {
            this.visibleTopComponents.clear();
            this.tcid2flags.clear();
            NbWindowSystemFS fs = NbWindowSystemFS.getDefault();
            WindowManagerImpl wm = WindowManagerImpl.getInstance();
            for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
                NbDockableContainer dc;
                boolean isGlobal;
                if (!(tc instanceof NbDockableContainer) || (isGlobal = NbWindowSystemFS.isGlobal(dc = (NbDockableContainer)tc)) != this.isTaskLayout) continue;
                String tcId = wm.findTopComponentID(tc);
                this.visibleTopComponents.add(tcId);
                if (!this.isTaskLayout) continue;
                this.tcid2flags.put(tcId, Flags.create(tc, this.isClone(tcId)));
            }
        }
        this._save();
    }

    private void _save() {
        try {
            this.prefs.clear();
        }
        catch (BackingStoreException e) {
            LOG.log(Level.INFO, null, e);
        }
        this.prefs.put("layout-name", this.name);
        for (String tcId : this.visibleTopComponents) {
            String state = "v-";
            Flags flags = this.tcid2flags.get(tcId);
            if (null != flags) {
                if (flags.minimized) {
                    state = state + "m-";
                }
                if (flags.selected) {
                    state = state + "s-";
                }
                if (flags.clone) {
                    state = state + "c-";
                }
            }
            this.prefs.put(tcId, state);
        }
        for (String tcId : this.unknownDockableIds) {
            this.prefs.put(tcId, "u-");
        }
        for (String modeName : this.tcSelectionStateNonGlobal.keySet()) {
            if (this.tcSelectionStateNonGlobal.get(modeName) == null) continue;
            this.prefs.put(SELECTION_PREF_STATE_NON_GLOBAL_PREFIX + modeName, this.tcSelectionStateNonGlobal.get(modeName));
        }
        for (String globalTC : tcSelectionStateGlobal.keySet()) {
            String ideLayoutName = tcSelectionStateGlobal.get(globalTC);
            this.prefs.put(SELECTION_PREF_STATE_GLOBAL_PREFIX + ideLayoutName, globalTC);
        }
    }

    Collection<String> getOpeningSet() {
        this.checkUnknownDockables();
        return new HashSet<String>(this.visibleTopComponents);
    }

    private void checkUnknownDockables() {
        assert (null != this.layout);
        NbWindowSystemFS wsfs = NbWindowSystemFS.getDefault();
        ArrayList<String> unknownDockableIdsCopy = new ArrayList<String>(this.unknownDockableIds);
        for (String dockableId : unknownDockableIdsCopy) {
            DockStation dockStation = DockStation.getDockStation();
            Dockable dockable = dockStation.getDockable(new ViewId(dockableId));
            if (wsfs.isDockableKnownInLayout(dockableId, this.layout.getName()) && dockable == null) continue;
            if (dockable != null && dockStation.isDockableVisible(dockable) && BitField.isSet((int)dockable.getType(), (int)32)) {
                this.add(dockableId, true);
                continue;
            }
            this.add(dockableId);
        }
    }

    public String toString() {
        return this.isTaskLayout ? "task-" : "editor-" + this.name;
    }

    boolean add(Dockable dockable) {
        String dockableId = dockable.getUniqueName();
        String tcId = NbWindowSystemFS.toTopComponentId(dockableId);
        if (this.visibleTopComponents.contains(tcId)) {
            return false;
        }
        this.unknownDockableIds.add(dockableId);
        if (null == this.layout) {
            return true;
        }
        return this.add(dockableId);
    }

    private boolean add(String dockableId) {
        return this.add(dockableId, false);
    }

    private boolean add(String dockableId, boolean forceVisible) {
        RoleLayoutShapingProvider.DockableState roleOverride;
        NbDockStation dockStation = (NbDockStation)NbDockStation.getDockStation();
        RoleLayoutShapingProvider roleLayout = RoleLayoutShapingProvider.getInstance();
        ViewId viewId = new ViewId(dockableId);
        Dockable dockable = dockStation.findDockable(viewId);
        if (null == dockable) {
            if (null != dockStation.lookupFactory(viewId)) {
                LOG.log(Level.WARNING, "Cannot find Dockable with id: {0}", dockableId);
            }
            return false;
        }
        boolean isGlobal = NbWindowSystemFS.isGlobal(viewId);
        if (dockable instanceof DockableWindow && ((DockableWindow)dockable).isDrawer()) {
            return false;
        }
        if (this.isTaskLayout != isGlobal) {
            return false;
        }
        String tcId = NbWindowSystemFS.toTopComponentId(dockableId);
        int state = dockable.getDefaultVisibility(this.layout);
        boolean visible = BitField.isSet((int)state, (int)1);
        boolean minimized = BitField.isSet((int)state, (int)2);
        boolean selected = BitField.isSet((int)state, (int)4);
        if (this.isTaskLayout && null != (roleOverride = roleLayout.getState(this.layout.getName(), dockableId))) {
            switch (roleOverride) {
                case HIDDEN: {
                    visible = false;
                    break;
                }
                case VISIBLE: {
                    visible = true;
                    break;
                }
                case MINIMIZED: {
                    visible = true;
                    minimized = true;
                }
            }
        }
        if (forceVisible) {
            visible = true;
        }
        if (visible) {
            this.visibleTopComponents.add(tcId);
            if (this.isTaskLayout) {
                this.tcid2flags.put(tcId, new Flags(minimized, selected, this.isClone(tcId)));
            }
        }
        if (!isGlobal || visible) {
            this.unknownDockableIds.remove(dockable.getUniqueName());
        }
        NbWindowSystemFS wsfs = NbWindowSystemFS.getDefault();
        wsfs.addKnownDockableInLayout(dockableId, this.layout.getName());
        if (!this.isTaskLayout() && !isGlobal && visible && !minimized && selected) {
            this.newAddedSelectedTcs.add(dockableId);
        }
        return visible;
    }

    boolean isTaskLayout() {
        return this.isTaskLayout;
    }

    String getName() {
        return this.name;
    }

    void setLayout(Layout layout) {
        this.layout = layout;
    }

    private static String toPreferencesNodeName(String text) {
        text = text.replaceAll("\\\\", "_");
        text = text.replaceAll("/", "_");
        return text;
    }

    private boolean isClone(String tcId) {
        if (NbWindowSystemFS.getDefault().isClone(tcId)) {
            NbWindowSystemFS.getDefault().addClonedDockable(tcId);
            return true;
        }
        return false;
    }

    void saveModeSelectionState() {
        this.tcSelectionStateNonGlobal.clear();
        Set modes = WindowManagerImpl.getInstance().getModes();
        this.clearGlobalSelection(modes);
        String currentIdeLayoutName = this.getCurrentIdeLayoutName();
        for (ModeImpl mode : modes) {
            NbDockableContainer dc;
            if (mode == null || mode.getSelectedTopComponent() == null || mode.getSelectedTopComponent() instanceof NbEditorContainer || mode.getName().equals("editor")) continue;
            if (mode.getSelectedTopComponent() instanceof NbDockableContainer && NbWindowSystemFS.isGlobal(dc = (NbDockableContainer)mode.getSelectedTopComponent())) {
                tcSelectionStateGlobal.put(dc.getName(), currentIdeLayoutName);
                continue;
            }
            this.tcSelectionStateNonGlobal.put(mode.getName(), mode.getSelectedTopComponent().getName());
        }
    }

    void loadModeSelectionState() {
        if (Ide.isQuitting() || Ide.isStarting()) {
            return;
        }
        Set modes = WindowManagerImpl.getInstance().getModes();
        this.setGlobalSelection(modes);
        this.setNonGlobalSelection(modes);
    }

    private void clearGlobalSelection(Collection<? extends ModeImpl> modes) {
        String currentIdeLayoutName = this.getCurrentIdeLayoutName();
        HashSet<String> tcSelectionStateGlobalKeys = new HashSet<String>(tcSelectionStateGlobal.keySet());
        for (String globalDockableName : tcSelectionStateGlobalKeys) {
            String ideLayoutName = tcSelectionStateGlobal.get(globalDockableName);
            if (ideLayoutName == null && !ideLayoutName.equals(currentIdeLayoutName)) continue;
            for (ModeImpl modeImpl : modes) {
                boolean global;
                TopComponent selectedTC = modeImpl.getSelectedTopComponent();
                if (selectedTC == null || !(selectedTC instanceof NbDockableContainer) || !(global = NbWindowSystemFS.isGlobal((NbDockableContainer)selectedTC)) || !modeImpl.getOpenedTopComponentsIDs().contains(TOP_COMPONENT_NAME_PREFIX + globalDockableName) || modeImpl.getSelectedTopComponent().getName().equals(globalDockableName)) continue;
                tcSelectionStateGlobal.remove(globalDockableName);
            }
        }
    }

    private String getCurrentIdeLayoutName() {
        String currentIdeLayoutName = null;
        currentIdeLayoutName = this.layout instanceof IdeLayout ? this.layout.getName() : this.layout.getOwner().getName();
        return currentIdeLayoutName;
    }

    private void setGlobalSelection(Collection<? extends ModeImpl> modes) {
        for (ModeImpl modeImpl : modes) {
            TopComponent tc;
            if (modeImpl == null) continue;
            String selectedTcInMode = null;
            if (selectedTcInMode == null) {
                String currentIdeLayoutName = this.getCurrentIdeLayoutName();
                for (String globalTc : tcSelectionStateGlobal.keySet()) {
                    String ideLayoutName = tcSelectionStateGlobal.get(globalTc);
                    if (ideLayoutName == null || !currentIdeLayoutName.equals(ideLayoutName) || !modeImpl.getOpenedTopComponentsIDs().contains(TOP_COMPONENT_NAME_PREFIX + globalTc)) continue;
                    selectedTcInMode = globalTc;
                }
            }
            if (selectedTcInMode == null) continue;
            selectedTcInMode = TOP_COMPONENT_NAME_PREFIX + selectedTcInMode;
            if (!modeImpl.getOpenedTopComponentsIDs().contains(selectedTcInMode) || !(tc = WindowManagerImpl.getInstance().findTopComponent(selectedTcInMode)).isOpened() || !modeImpl.getOpenedTopComponents().contains(tc)) continue;
            modeImpl.setSelectedTopComponent(tc);
        }
    }

    private void setNonGlobalSelection(Collection<? extends ModeImpl> modes) {
        for (ModeImpl modeImpl : modes) {
            TopComponent tc;
            if (modeImpl == null) continue;
            String selectedTcInMode = null;
            for (String dockableId : this.newAddedSelectedTcs) {
                if (!modeImpl.getOpenedTopComponentsIDs().contains(TOP_COMPONENT_NAME_PREFIX + dockableId)) continue;
                selectedTcInMode = dockableId;
                break;
            }
            if (selectedTcInMode == null && this.tcSelectionStateNonGlobal.get(modeImpl.getName()) != null) {
                selectedTcInMode = this.tcSelectionStateNonGlobal.get(modeImpl.getName());
            } else if (selectedTcInMode == null) continue;
            selectedTcInMode = TOP_COMPONENT_NAME_PREFIX + selectedTcInMode;
            if (!modeImpl.getOpenedTopComponentsIDs().contains(selectedTcInMode) || !(tc = WindowManagerImpl.getInstance().findTopComponent(selectedTcInMode)).isOpened() || !modeImpl.getOpenedTopComponents().contains(tc)) continue;
            modeImpl.setSelectedTopComponent(tc);
        }
        this.newAddedSelectedTcs.clear();
    }

    private static class Flags {
        private final boolean minimized;
        private final boolean selected;
        private final boolean clone;

        public Flags(boolean minimized, boolean selected, boolean clone) {
            this.minimized = minimized;
            this.selected = selected;
            this.clone = clone;
        }

        static Flags create(TopComponent tc, boolean clone) {
            WindowManagerImpl wm = WindowManagerImpl.getInstance();
            ModeImpl mode = (ModeImpl)wm.findMode(tc);
            if (null == mode || mode.getState() != 0) {
                return null;
            }
            boolean minimized = mode.getKind() == 2;
            boolean selected = tc.equals(mode.getSelectedTopComponent());
            return new Flags(minimized, selected, clone);
        }
    }
}

