/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import com.oracle.jdeveloper.nbwindowsystem.JDevTopComponent;
import com.oracle.jdeveloper.nbwindowsystem.NbDockStation;
import com.oracle.jdeveloper.nbwindowsystem.NbEditorContainer;
import com.oracle.jdeveloper.nbwindowsystem.NbMainWindow;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorCreation;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorCriteriaImpl;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorPathImpl;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorState;
import com.oracle.jdeveloper.nbwindowsystem.editor.NbAcceleratorsActions;
import com.oracle.jdeveloper.nbwindowsystem.editor.SplitPane;
import com.oracle.jdeveloper.nbwindowsystem.editor.SplitPaneState;
import com.oracle.jdeveloper.nbwindowsystem.editor.TabGroup;
import com.oracle.jdeveloper.nbwindowsystem.editor.TabGroupState;
import com.oracle.jdeveloper.nbwindowsystem.plaf.ActionsUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.ide.util.MetaClass;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ProductInformation;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.ControllerProvider;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorPath;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.editor.RecentFile;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.file.Path;
import oracle.ide.file.ProjectCache;
import oracle.ide.layout.BaseLayoutListener;
import oracle.ide.layout.IdeProperties;
import oracle.ide.layout.Layout;
import oracle.ide.layout.LayoutListener;
import oracle.ide.layout.LayoutSelector;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.PreferredLayoutListener;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.NodeUtil;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.UnrecognizedTextNode;
import oracle.ide.model.Workspace;
import oracle.ide.util.BitField;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ideimpl.editor.DeclarativeDynamicEditorAddin;
import oracle.ideimpl.editor.DeclarativeEditorAddin;
import oracle.ideimpl.editor.DefaultEditorManager;
import oracle.ideimpl.editor.EditorAddinRegistry;
import oracle.ideimpl.editor.EditorBundle;
import oracle.ideimpl.editor.EditorCustomizationHook;
import oracle.ideimpl.editor.EditorCustomizationOptions;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.LastUsedFiles;
import oracle.ideimpl.editor.RecentFilesLRU;
import oracle.ideimpl.editor.RecentFilesLRUProvider;
import oracle.javatools.dialogs.BaseMessageDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.MaximizeWindowAction;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class NbEditorManager
extends DefaultEditorManager
implements ControllerProvider,
RecentFilesLRUProvider,
ActiveViewListener,
LayoutListener {
    private final List<EditorListener> listeners = new ArrayList<EditorListener>(3);
    private Component editorView;
    private NbAcceleratorsActions accelerators;
    protected final HashMap<ViewId, View> idsToViews;
    protected final HashMap<View, ViewId> viewsToIds;
    private final NodeListener closeListener = new NodeCloseListener();
    private Editor currentEditor;
    private RecentFilesLRU recentFilesLRU;
    private WeakSet<Editor> openedEditors = new WeakSet();
    private Set<View> activatedViews = new WeakSet();
    private final HashMap<String, BaseLayoutListener> layoutListeners = new HashMap();
    public static final int EMO_TOP_EDITOR_TABS = 1;
    public static final int EMO_HIDE_SINGLE_EDITOR_TABS = 2;
    public static final int EMO_GRADIENT_EDITOR_TABS = 4;
    public static final int EMO_HIDE_ALL_DYNAMIC_EDITOR_MENUS = 8;
    private static Integer editorManagerOptions;
    private final oracle.ide.util.MultiMap preferredLayouts = new oracle.ide.util.MultiMap();
    private static boolean DEBUG_TRACE_VIEW_CHANGES;

    public void setEditorFloating(Editor editor, boolean floating) {
        TopComponent nc = NbEditorManager.toTopComponent(editor);
        if (nc == null || !(nc instanceof NbEditorContainer)) {
            return;
        }
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        wm.setTopComponentFloating(nc, floating);
    }

    public NbEditorManager() {
        this.recentFilesLRU = new RecentFilesLRU();
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
        this.idsToViews = new HashMap();
        this.viewsToIds = new HashMap();
    }

    public static NbEditorManager getInstance() {
        return (NbEditorManager)EditorManager.getEditorManager();
    }

    public Editor findEditor(EditorPath path) {
        if (path instanceof EditorPathImpl) {
            EditorPathImpl epi = (EditorPathImpl)path;
            return epi.getTabGroupState().getCurrentEditor();
        }
        return null;
    }

    public void activateCurrentEditorFrame() {
        this.activateCurrentEditorFrame(false);
    }

    void activateCurrentEditorFrame(boolean focusOnly) {
        TopComponent editorTc;
        WindowManagerImpl wm;
        Mode editorMode;
        Editor e = this.getCurrentEditor();
        if (e == null && (editorMode = (wm = WindowManagerImpl.getInstance()).findMode("editor")) != null && (editorTc = editorMode.getSelectedTopComponent()) instanceof NbEditorContainer) {
            e = ((NbEditorContainer)editorTc).getEditor();
        }
        if (null != e) {
            TopComponent tc = NbEditorManager.toTopComponent(e);
            if (null == tc) {
                return;
            }
            if (focusOnly) {
                tc.requestFocusInWindow();
            } else {
                tc.requestActive();
                this.focusCurrentEditor();
            }
        }
    }

    public Controller getController() {
        return this;
    }

    public Editor openDefaultEditorInFrame(Context context) {
        if (Ide.getIdeArgs().hasArg("-noreopen") && Ide.isStarting()) {
            return null;
        }
        Editor editor = null;
        EditorPathImpl editorPath = new EditorPathImpl();
        if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
            if (editorPath.getEditorState() != null && editorPath.getEditorState().getEditor() != null) {
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, editorPath.getEditorState().getEditor().getClass());
                if (BitField.isSet((int)openEditorOptions.getFlags(), (int)5)) {
                    this.focusEditor(editorPath);
                }
            } else {
                this.focusEditor(editorPath);
            }
            TabGroupState tabGroupState = editorPath.getTabGroupState();
            editor = tabGroupState.getCurrentEditor();
            NbEditorManager.updateContext(editor, context);
        } else {
            Class editorClass;
            EditorAddin addin = this.bestEditorAddin(context);
            if (addin != null && (editor = this.openEditorInFrame(editorClass = addin.getEditorClass(), context)) != null) {
                editor.setEditorAddin(addin);
            }
        }
        return editor;
    }

    public Editor openEditorInFrame(Class editorClass, Context context) {
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, editorClass);
        return this.openEditor(openEditorOptions);
    }

    public Editor openEditor(OpenEditorOptions openEditorOptions) {
        EditorPathImpl editorPath;
        EditorAddin editorAddin;
        Class editorClass2;
        if (Ide.getIdeArgs().hasArg("-noreopen") && Ide.isStarting()) {
            return null;
        }
        if (NbEditorManager.openExternal(openEditorOptions)) {
            return null;
        }
        Context context = openEditorOptions.getContext();
        Editor editor = null;
        Class contextEditorClass = openEditorOptions.getEditorClass();
        TopComponent existingDocument = this.findOpenedDocument(openEditorOptions);
        ArrayList<Class> editorClasses = new ArrayList<Class>();
        EditorAddin bestEditorAddin = this.bestEditorAddin(context);
        for (EditorAddin editorAddin2 : this._getAddins(context)) {
            if (editorAddin2 == null || editorAddin2 instanceof DeclarativeDynamicEditorAddin || editorAddin2 instanceof DeclarativeEditorAddin && bestEditorAddin != editorAddin2) continue;
            editorClasses.add(editorAddin2.getEditorClass());
        }
        if (existingDocument == null && contextEditorClass != null && !editorClasses.contains(contextEditorClass)) {
            for (Class editorClass2 : editorClasses) {
                if (editorClass2 == null) continue;
                openEditorOptions.setEditorClass(editorClass2);
                existingDocument = this.findOpenedDocument(openEditorOptions);
                if (existingDocument != null) {
                    contextEditorClass = editorClass2;
                    break;
                }
                openEditorOptions.setEditorClass(contextEditorClass);
            }
        }
        if (null != existingDocument) {
            if (null != contextEditorClass && existingDocument instanceof NbEditorContainer) {
                ((NbEditorContainer)existingDocument).activateEditor(contextEditorClass);
            }
            editor = NbEditorManager.toEditor(existingDocument);
            boolean focus = BitField.isSet((int)openEditorOptions.getFlags(), (int)5);
            boolean raise = BitField.isSet((int)openEditorOptions.getFlags(), (int)1);
            if (focus) {
                this.focusEditor(context);
            } else if (raise) {
                if (existingDocument instanceof NbEditorContainer) {
                    ((NbEditorContainer)existingDocument).requestActiveWithoutFocus();
                }
                JDevTopComponent.activateTCWithoutFocusIfPossible(existingDocument);
                this.updateTCLookupForViewNoFocus(editor);
            }
            return editor;
        }
        openEditorOptions.setEditorClass(contextEditorClass);
        Node node = context.getNode();
        if (null == node) {
            return editor;
        }
        editorClass2 = openEditorOptions.getEditorClass();
        if (null == editorClass2 && (editorAddin = this.bestEditorAddin(context)) != null) {
            editorClass2 = editorAddin.getEditorClass();
            openEditorOptions.setEditorClass(editorClass2);
        }
        if (this.createEditor(openEditorOptions, editorPath = new EditorPathImpl())) {
            TabGroupState tabGroupState = editorPath.getTabGroupState();
            SplitPaneState splitState = tabGroupState.getCurrentSplitPaneState();
            editor = splitState.getCurrentEditor();
            NbEditorManager.setNames(editor, editorPath, node);
            NbEditorContainer ec = new NbEditorContainer(tabGroupState);
            this.dockNewEditor(ec, openEditorOptions);
            ec.open();
            boolean focus = BitField.isSet((int)openEditorOptions.getFlags(), (int)5);
            boolean raise = BitField.isSet((int)openEditorOptions.getFlags(), (int)1);
            if (focus && !Ide.isStarting() || focus && NbDockStation.INITIAL_STARTUP) {
                this.focusEditor(context);
                JDevTopComponent.activateTCWithoutFocusIfPossible((TopComponent)ec);
            } else if (raise && !Ide.isStarting() || raise && NbDockStation.INITIAL_STARTUP) {
                if (ec instanceof NbEditorContainer) {
                    ec.requestActiveWithoutFocus();
                }
                JDevTopComponent.activateTCWithoutFocusIfPossible((TopComponent)ec);
                this.updateTCLookupForViewNoFocus(editor);
            }
        }
        if (openEditorOptions.getPosition() == 10) {
            this.setEditorFloating(editor, true);
        }
        return editor;
    }

    private static void setNames(Editor editor, EditorPathImpl editorPath, Node node) {
        TabGroup tabGroup = editorPath.getTabGroup();
        if (tabGroup != null) {
            tabGroup.setName("TabGroup " + node.getShortLabel());
            SplitPane splitPane = tabGroup.getSplitPane(editor);
            if (splitPane != null) {
                splitPane.setName("SplitPane " + node.getShortLabel());
                CustomTab customTab = splitPane.getEditorTabs();
                if (customTab != null) {
                    customTab.setName("CustomTab " + node.getShortLabel());
                }
            }
        }
    }

    private void dockNewEditor(NbEditorContainer ec, OpenEditorOptions openEditorOptions) {
        EditorPath refPath = openEditorOptions.getPositionReference();
        if (null == refPath) {
            return;
        }
        Editor refEditor = this.findEditor(refPath);
        if (null == refEditor) {
            return;
        }
        TopComponent refTC = NbEditorManager.toTopComponent(refEditor);
        if (null == refTC) {
            return;
        }
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        ModeImpl refMode = (ModeImpl)wm.findMode(refTC);
        if (null == refMode) {
            return;
        }
        String side = null;
        switch (openEditorOptions.getPosition()) {
            case 0: {
                side = "left";
                break;
            }
            case 1: {
                side = "right";
                break;
            }
            case 2: {
                side = "top";
                break;
            }
            case 3: {
                side = "bottom";
            }
        }
        ModeImpl targetMode = refMode;
        if (null != side) {
            targetMode = wm.attachModeToSide(refMode, side, null, 1, false);
        }
        if (null != targetMode) {
            targetMode.dockInto((TopComponent)ec);
        }
    }

    NbEditorContainer cloneEditor(NbEditorContainer editorContainer) {
        EditorPathImpl editorPath;
        Class<?> editorClass;
        OpenEditorOptions openEditorOptions;
        Context context = editorContainer.getEditor().getContext();
        Node node = context.getNode();
        if (null != node && this.createEditor(openEditorOptions = new OpenEditorOptions(context, editorClass = editorContainer.getEditor().getClass()), editorPath = new EditorPathImpl())) {
            TabGroupState tabGroupState = editorPath.getTabGroupState();
            SplitPaneState splitState = tabGroupState.getCurrentSplitPaneState();
            Editor editorClone = splitState.getCurrentEditor();
            editorClone.open();
            return new NbEditorContainer(tabGroupState);
        }
        return null;
    }

    private boolean createEditor(OpenEditorOptions openEditorOptions, EditorPathImpl editorPath) {
        List<EditorAddin> editorAddins;
        boolean res = false;
        Context context = openEditorOptions.getContext();
        Node node = context.getNode();
        if (node != null && !(editorAddins = this._getAddins(context)).isEmpty()) {
            EditorCreation editorCreation = new EditorCreation();
            editorCreation.setOpenEditorOptions(openEditorOptions);
            editorCreation.setEditorAddins(editorAddins);
            editorCreation.setEditorPath(editorPath);
            try {
                res = this.createEditor(editorCreation);
            }
            catch (OpenAbortedException ex) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)new JLabel(NbBundle.getMessage(NbEditorManager.class, (String)"DIALOG_EDITOR_ERROR_MESSAGE") + ex.getMessage()), (String)NbBundle.getMessage(NbEditorManager.class, (String)"DIALOG_EDITOR_ERROR_TITLE"), null);
                res = false;
            }
        }
        return res;
    }

    private boolean createEditor(EditorCreation editorCreation) {
        int creationFlags;
        boolean ret = false;
        EditorPathImpl editorPath = editorCreation.getEditorPath();
        OpenEditorOptions openEditorOptions = editorCreation.getOpenEditorOptions();
        TabGroup tabGroup = new TabGroup();
        editorPath.setTabGroup(tabGroup);
        if (tabGroup.addTabGroupState(editorCreation) && (ret = BitField.isSet((int)(creationFlags = openEditorOptions.getFlags()), (int)1) ? tabGroup.activateEditor(editorPath) : true)) {
            if (BitField.isSet((int)creationFlags, (int)8)) {
                Context context = openEditorOptions.getContext();
                this.recentFilesLRU.setExplicit(context, true);
            }
            if (BitField.isSet((int)creationFlags, (int)2)) {
                tabGroup.validate();
            }
            if (BitField.isSet((int)creationFlags, (int)5)) {
                tabGroup.focusCurrentEditor();
            }
        }
        return ret;
    }

    public boolean activateEditorHasComponent(Component comp) {
        boolean activated = false;
        if (comp == null && this.currentEditor != null && NbEditorManager.toTopComponent(this.currentEditor) != null) {
            TopComponent tc = NbEditorManager.toTopComponent(this.currentEditor);
            if (tc != null) {
                tc.requestActive();
                activated = true;
            } else {
                activated = false;
            }
        } else if (comp != null) {
            activated = this.activateTC(comp, false);
        }
        return activated;
    }

    private boolean activateTC(Component comp, boolean activated) {
        if (comp instanceof TopComponent) {
            ((TopComponent)comp).requestActive();
            return true;
        }
        if (comp != null && comp.getParent() != null) {
            activated = this.activateTC(comp.getParent(), activated);
        }
        return activated;
    }

    public List<EditorAddin> _getAddins(Context ctx) {
        List<EditorAddin> editorAddins = this.getAddins(ctx);
        return editorAddins != null ? editorAddins : Collections.emptyList();
    }

    boolean isDocumentCloneable(Context context) {
        for (EditorAddin editorAddin : this._getAddins(context)) {
            if (editorAddin.isCloneable()) continue;
            return false;
        }
        return true;
    }

    public void replaceEditors(Context oldContext, Context newContext) {
        EditorPathImpl editorPath = new EditorPathImpl();
        EditorCriteriaImpl editorCriteria = new EditorCriteriaImpl(oldContext);
        if (this.searchEditor(editorPath, editorCriteria)) {
            TabGroupState tabGroupState = editorPath.getTabGroupState();
            tabGroupState.setContext(newContext);
        }
    }

    public List<Editor> findEditors(Context context) {
        ArrayList<Editor> list = new ArrayList<Editor>();
        for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
            NbEditorContainer nbec;
            TabGroup tabGroup;
            if (!(tc instanceof NbEditorContainer) || null == (tabGroup = (nbec = (NbEditorContainer)tc).getTabGroup())) continue;
            List subList = tabGroup.findEditors(context);
            list.addAll(subList);
        }
        return list;
    }

    public List<Editor> getAllEditors() {
        Set opened = TopComponent.getRegistry().getOpened();
        ArrayList<Editor> res = new ArrayList<Editor>(opened.size());
        for (TopComponent tc : opened) {
            NbEditorContainer ec;
            TabGroup tabGroup;
            if (!(tc instanceof NbEditorContainer) || (tabGroup = (ec = (NbEditorContainer)tc).getTabGroup()) == null) continue;
            List<Editor> subList = tabGroup.getAllEditors();
            res.addAll(subList);
        }
        return res;
    }

    public JComponent getDesktopComponent() {
        if (this.editorView == null) {
            this.editorView = this.registerController();
        }
        return (JComponent)this.editorView;
    }

    public synchronized Editor getCurrentEditor() {
        Set tcs = TopComponent.getRegistry().getOpened();
        boolean editorsOpen = false;
        for (TopComponent tc : tcs) {
            if (!(tc instanceof NbEditorContainer)) continue;
            editorsOpen = true;
            break;
        }
        if (!editorsOpen) {
            this.currentEditor = null;
        }
        return this.currentEditor;
    }

    public void initialize() {
        this.accelerators = new NbAcceleratorsActions();
        this.accelerators.createActions();
        new EditorManagerImpl().initialize();
        Project.addProjectChangeListener((String)"editor.project.listener", (ProjectChangeListener)new EditorProjectChangeListener());
        Workspace.addNodeListenerForType(Workspace.class, (NodeListener)new EditorWorkspaceChangeListener());
        NodeListener nl = new NodeListener(){

            public void nodeDeleted(NodeEvent e) {
                this.closeTopComponent(e.getNode());
                super.nodeDeleted(e);
            }

            public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
                Node newNode = NodeFactory.find((URL)newURL);
                if (newNode == null) {
                    return;
                }
                NbEditorContainer ec = this.getNonTriggeredEditor(oldURL);
                if (ec == null) {
                    ec = this.getNonTriggeredEditor(newURL);
                }
                if (ec != null && ec.getEditor() == null) {
                    Project project = NbEditorManager.findProject(newNode);
                    ec.updateProject(project, null);
                    ec.updateURL(newNode.getURL());
                    ec.updateEditorTitle(newNode);
                }
                super.nodeRenamed(e, oldURL, newURL);
            }

            private void closeTopComponent(Node node) {
                if (node == null) {
                    return;
                }
                NbEditorContainer tc = this.getNonTriggeredEditor(node.getURL());
                if (tc == null) {
                    return;
                }
                Runnable close = new Runnable((TopComponent)tc){
                    final /* synthetic */ TopComponent val$tc;
                    {
                        this.val$tc = topComponent;
                    }

                    @Override
                    public void run() {
                        if (this.val$tc.isOpened()) {
                            this.val$tc.close();
                        }
                    }
                };
                SwingUtilities.invokeLater(close);
            }

            private NbEditorContainer getNonTriggeredEditor(URL nodeURL) {
                for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
                    NbEditorContainer ec;
                    if (!(tc instanceof NbEditorContainer) || !(ec = (NbEditorContainer)tc).match(nodeURL)) continue;
                    return ec;
                }
                return null;
            }
        };
        Node.addNodeListenerForTypeHierarchy(Node.class, (NodeListener)nl);
    }

    public void addLayoutListener(String editorId, BaseLayoutListener listener) {
        this.layoutListeners.put(editorId, listener);
    }

    public void removeLayoutListener(String editorId) {
        this.layoutListeners.remove(editorId);
    }

    public void closeEditors(List list) {
        this.closeEditors(list, true);
    }

    public void closeEditors(List list, boolean doSaveCheck) {
        HashSet<TabGroupState> tabGroupStateSet = new HashSet<TabGroupState>(list.size());
        HashMap<TabGroupState, TopComponent> state2tc = new HashMap<TabGroupState, TopComponent>(list.size());
        for (Object o : list) {
            TabGroupState tgs;
            NbEditorContainer ec;
            TabGroup tg;
            TopComponent tc;
            Editor e = null;
            if (o instanceof Editor) {
                e = (Editor)o;
            } else if (o instanceof EditorInfo) {
                e = ((EditorInfo)o)._getEditor();
            }
            if (null == e || !((tc = NbEditorManager.toTopComponent(e)) instanceof NbEditorContainer) || null == (tg = (ec = (NbEditorContainer)tc).getTabGroup()) || null == (tgs = tg.getTabGroupState(0))) continue;
            tabGroupStateSet.add(tgs);
            state2tc.put(tgs, tc);
        }
        HashSet<TabGroupState> allTabGroupStates = new HashSet<TabGroupState>(TopComponent.getRegistry().getOpened().size());
        for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
            TabGroupState tgs;
            NbEditorContainer ec;
            TabGroup tg;
            if (!(tc instanceof NbEditorContainer) || null == (tg = (ec = (NbEditorContainer)tc).getTabGroup()) || null == (tgs = tg.getTabGroupState(0))) continue;
            allTabGroupStates.add(tgs);
        }
        HashSet<Node> documentsToClose = new HashSet<Node>();
        HashSet<Node> docsThatStayOpen = new HashSet<Node>();
        MultiMap contextsAndDocs = new MultiMap();
        for (TabGroupState tabGroupState : allTabGroupStates) {
            boolean isClosing = tabGroupStateSet.contains(tabGroupState);
            Editor currentEditor = tabGroupState.getCurrentEditor();
            if (currentEditor != null) {
                currentEditor.prepareForSaving(isClosing);
            }
            Context context = new Context(tabGroupState.getContext());
            Node node = context.getNode();
            if (isClosing) {
                documentsToClose.add(node);
                contextsAndDocs.add((Object)context, (Object)node);
            } else {
                docsThatStayOpen.add(node);
            }
            int splitPaneStateCount = tabGroupState.getSplitPaneStateCount();
            for (int k = 0; k < splitPaneStateCount; ++k) {
                SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(k);
                int nbrEditorStates = splitPaneState.getEditorStateCount();
                for (int l = 0; l < nbrEditorStates; ++l) {
                    Node[] dependentNodes;
                    EditorState editorState = splitPaneState.getEditorState(l);
                    Editor editor = editorState.getEditor();
                    if (editor == null || (dependentNodes = editor.getDependentNodes()) == null) continue;
                    for (int m = 0; m < dependentNodes.length; ++m) {
                        Node dependentNode = dependentNodes[m];
                        if (isClosing) {
                            documentsToClose.add(dependentNode);
                            contextsAndDocs.add((Object)context, (Object)dependentNode);
                            continue;
                        }
                        docsThatStayOpen.add(dependentNode);
                    }
                }
            }
        }
        for (Collection nodes : contextsAndDocs.values()) {
            nodes.removeAll(docsThatStayOpen);
        }
        documentsToClose.removeAll(docsThatStayOpen);
        IdeAction closeNodeAction = IdeActions.getFileCloseAction();
        Command closeNodeCommandObject = CommandProcessor.createCommandFromMeta((MetaClass)closeNodeAction.getCommandMetaClass(), (Context)new Context());
        CloseNodeCommand cmd = closeNodeCommandObject instanceof CloseNodeCommand ? (CloseNodeCommand)closeNodeCommandObject : new CloseNodeCommand();
        int status = doSaveCheck ? cmd.checkSave(documentsToClose.iterator()) : 0;
        if (status != 1) {
            TopComponent[] allTCsEditors;
            for (TabGroupState tgs : tabGroupStateSet) {
                TopComponent tc = (TopComponent)state2tc.get(tgs);
                if (null == tc) continue;
                tc.putClientProperty((Object)"NoCanCloseCheck", (Object)Boolean.TRUE);
                tc.close();
                tc.putClientProperty((Object)"NoCanCloseCheck", null);
            }
            for (Map.Entry entry : contextsAndDocs.entrySet()) {
                Context context = (Context)entry.getKey();
                Collection lstDocs = (Collection)entry.getValue();
                cmd.setContext(context);
                cmd.clearAffectedNodes();
                assert (lstDocs != null) : "Bug 6157300 occurred with context " + context;
                HashSet<Node> openedNodes = new HashSet<Node>();
                for (Node node : lstDocs) {
                    if (node == null || !node.isOpen()) continue;
                    openedNodes.add(node);
                }
                status = cmd.close(openedNodes.iterator(), context, false, true);
                if (status == 1) break;
                this.recentFilesLRU.setExplicit(context, false);
            }
            WindowManagerImpl wm = WindowManagerImpl.getInstance();
            for (TopComponent tc : allTCsEditors = wm.getEditorTopComponents()) {
                if (tc instanceof JDevTopComponent || !wm.isEditorTopComponent(tc)) continue;
                tc.close();
            }
        }
    }

    public List<EditorInfo> getEditorsInfo() {
        Set opened = TopComponent.getRegistry().getOpened();
        ArrayList<EditorInfo> res = new ArrayList<EditorInfo>(opened.size());
        for (TopComponent tc : opened) {
            TabGroup tabGroup;
            if (!(tc instanceof NbEditorContainer) || (tabGroup = ((NbEditorContainer)tc).getTabGroup()) == null) continue;
            int tabGroupStateCount = tabGroup.getTabGroupStateCount();
            ArrayList<TabGroupState> tabGroupStates = new ArrayList<TabGroupState>();
            for (int tgsc = 0; tgsc < tabGroupStateCount; ++tgsc) {
                tabGroupStates.add(tabGroup.getTabGroupState(tgsc));
            }
            ArrayList<SplitPaneState> splitPaneStates = new ArrayList<SplitPaneState>();
            for (TabGroupState tgs : tabGroupStates) {
                if (tgs == null) continue;
                splitPaneStates.addAll(tgs.getSplitPaneStates());
            }
            for (SplitPaneState editorSplitPane : splitPaneStates) {
                for (EditorInfo editorInfo : editorSplitPane.getEditorStates()) {
                    if (res.contains(editorInfo)) continue;
                    res.add(editorInfo);
                }
            }
        }
        return res;
    }

    public void activateEditor(EditorInfo ei) {
        Editor e = ei._getEditor();
        TopComponent tc = NbEditorManager.toTopComponent(e);
        if (tc instanceof NbEditorContainer) {
            NbEditorContainer ec = (NbEditorContainer)tc;
            ec.getTabGroup().getCurrentSplitPane().activateEditor(e);
        }
        if (null != tc) {
            tc.requestActive();
        }
    }

    public void setExplicit(Editor editor, boolean explicit) {
        Context context = editor.getContext();
        this.recentFilesLRU.setExplicit(context, explicit);
    }

    public void registerPreferredLayoutListener(Class docClass, Class editorClass, String preferredLayoutBaseName, PreferredLayoutListener listener) {
        this.preferredLayouts.add((Object)editorClass, (Object)new Object[]{docClass, preferredLayoutBaseName, listener});
    }

    public EditorPath searchEditor(Node node) {
        EditorPathImpl ret = null;
        EditorPathImpl editorPath = new EditorPathImpl();
        if (this.searchEditor(editorPath, new EditorCriteriaImpl(node))) {
            ret = editorPath;
        }
        return ret;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == 39) {
            List<EditorInfo> editorsInfo = this.getEditorsInfo();
            this.closeEditors(editorsInfo);
            this.closeNonTriggeredEditors();
        } else if (commandId == 48) {
            List<Editor> editors = this.findEditors(context);
            if (NbEditorManager.isSelectedTopComponentIsNonJdevEditor()) {
                TopComponent.getRegistry().getActivated().close();
            } else {
                if (editors == null || editors.isEmpty()) {
                    return false;
                }
                this.closeEditors(editors);
            }
        } else if (commandId == 51) {
            this.whenRefresh();
        } else if (commandId == SHOW_DROPDOWN_CMD_ID) {
            ActionsUtils.showDropDownList();
        } else if (commandId == 71 || commandId == 42) {
            TabGroup tabGroup = this.getTabGroup(this.currentEditor);
            if (tabGroup != null) {
                tabGroup.whenActivateRightNode();
            }
        } else if (commandId == 70 || commandId == 43) {
            TabGroup tabGroup = this.getTabGroup(this.currentEditor);
            if (tabGroup != null) {
                tabGroup.whenActivateLeftNode();
            }
        } else if (commandId == 40 || commandId == 41) {
            SplitPane currentSplitPane = this.getTabGroup(this.currentEditor).getSplitPane(this.currentEditor);
            currentSplitPane.handleEvent(commandId);
        } else if (!this.accelerators.handleGoto(action) && !this.accelerators.handleAssign(action)) {
            if (commandId == SYSTEM_MENU_CMD_ID) {
                TopComponent tc = TopComponent.getRegistry().getActivated();
                if (tc instanceof NbEditorContainer) {
                    ((NbEditorContainer)tc).showWindowMenu();
                }
            } else if (commandId == NAVIGATE_LRU_FILES_CMD_ID) {
                this.whenNavigateLRUFiles();
            } else if (commandId == NEXT_PANE_CMD_ID || commandId == PREV_PANE_CMD_ID) {
                TabGroupState currentTabGroupState;
                TabGroup currentTabGroup = this.getTabGroup(this.currentEditor);
                if (currentTabGroup != null && (currentTabGroupState = currentTabGroup.getCurrentTabGroupState()) != null) {
                    currentTabGroupState.handleEvent(commandId);
                }
            } else if (commandId == MAXIMIZE_TAB_GROUP_CMD_ID || commandId == RESTORE_TAB_GROUPS_CMD_ID || commandId == TOGGLE_MAXIMIZE_RESTORE_TAB_GROUP_CMD_ID) {
                ModeImpl mode;
                TopComponent tc = TopComponent.getRegistry().getActivated();
                if (tc == null && (mode = WindowManagerImpl.getInstance().getActiveMode()) != null) {
                    tc = WindowManagerImpl.getInstance().getSelectedTopComponent((Mode)mode);
                }
                if (tc != null) {
                    for (Action a : tc.getActions()) {
                        if (!(a instanceof MaximizeWindowAction) || !a.isEnabled()) continue;
                        a.actionPerformed(null);
                    }
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean update(IdeAction action, Context cntxt) {
        int commandId = action.getCommandId();
        if (commandId != NAVIGATE_LRU_FILES_CMD_ID) {
            if (commandId == 70 || commandId == 43) {
                this.canActivateFileAction(action, Direction.LEFT);
            } else if (commandId == 71 || commandId == 42) {
                this.canActivateFileAction(action, Direction.RIGHT);
            } else if (commandId == NEXT_PANE_CMD_ID || commandId == PREV_PANE_CMD_ID) {
                TabGroupState currentTabGroupState;
                boolean canDo = false;
                TabGroup currentTabGroup = this.getTabGroup(this.currentEditor);
                if (currentTabGroup != null && (currentTabGroupState = currentTabGroup.getCurrentTabGroupState()) != null) {
                    canDo = currentTabGroupState.canDo(action);
                }
                action.setEnabled(canDo);
            } else if (commandId == 40 || commandId == 41) {
                SplitPane currentSplitPane;
                boolean canDo = false;
                if (this.currentEditor != null && this.getTabGroup(this.currentEditor) != null && TopComponent.getRegistry().getActivated() instanceof NbEditorContainer && (currentSplitPane = this.getTabGroup(this.currentEditor).getSplitPane(this.currentEditor)) != null) {
                    canDo = currentSplitPane.canDo(action);
                }
                action.setEnabled(canDo);
            } else if (commandId == 51) {
                this.updateRefresh(action);
            } else if (!this.accelerators.updateAssign(action, commandId) && !this.accelerators.updateActivate(action, commandId)) {
                if (commandId == SHOW_DROPDOWN_CMD_ID) {
                    action.setEnabled(this.getEditorsInfo().size() > 0);
                } else if (commandId == 39) {
                    if (NbEditorManager.isSelectedTopComponentIsNonJdevEditor()) {
                        action.setEnabled(true);
                    } else if (this.getAllEditors() == null || this.getAllEditors().isEmpty()) {
                        action.setEnabled(false);
                    } else {
                        action.setEnabled(true);
                    }
                } else if (commandId == SYSTEM_MENU_CMD_ID) {
                    TopComponent tc = TopComponent.getRegistry().getActivated();
                    action.setEnabled(tc instanceof NbEditorContainer);
                } else if (commandId == 48 && NbEditorManager.isSelectedTopComponentIsNonJdevEditor()) {
                    action.setEnabled(true);
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    private void canActivateFileAction(IdeAction action, Direction direction) {
        int currentActiveWindow;
        boolean canDo = false;
        int currentDocumentPosition = this.getEditorPosition(this.currentEditor);
        if (currentDocumentPosition != (currentActiveWindow = this.getActiveDocumentPosition())) {
            canDo = false;
        } else if (currentDocumentPosition >= 0) {
            TabGroup tabGroup = this.getTabGroup(this.currentEditor);
            if (direction == Direction.LEFT) {
                canDo = tabGroup.canActivateLeftNode();
            } else if (direction == Direction.RIGHT) {
                canDo = tabGroup.canActivateRightNode();
            }
        }
        action.setEnabled(canDo);
    }

    private void updateRefresh(IdeAction action) {
        boolean isEnabled = false;
        Editor current = this.getCurrentEditor();
        if (current != null) {
            Context context = current.getContext();
            Node node = context.getNode();
            if (node != null) {
                isEnabled = true;
            }
            action.setEnabled(isEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addEditorListener(EditorListener el) {
        List<EditorListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(el);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeEditorListener(EditorListener el) {
        List<EditorListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(el);
        }
    }

    void handleEditorEvent(EditorEvent evt, Editor editor) {
        switch (evt) {
            case Activated: {
                this.deactivateCurrentNonEditorView();
                Editor oldCurrentEditor = null;
                if (editor != this.currentEditor) {
                    oldCurrentEditor = this.currentEditor;
                    this.currentEditor = editor;
                    this.loadEditorLayout(editor);
                }
                if (this.activatedViews.contains(editor) || !this.openedEditors.contains((Object)editor)) {
                    return;
                }
                if (oldCurrentEditor != null && this.activatedViews.contains(oldCurrentEditor)) {
                    this.handleEditorEvent(EditorEvent.Deactivated, oldCurrentEditor);
                }
                editor.activate();
                this.activatedViews.add((View)editor);
                if (!DEBUG_TRACE_VIEW_CHANGES) break;
                Logger.getAnonymousLogger().info("ACTIVATED - " + editor.getClass() + " editor name " + editor.getDisplayName() + " path: " + NbEditorManager.getEditorFileName(editor));
                break;
            }
            case Deactivated: {
                if (!this.activatedViews.contains(editor)) {
                    return;
                }
                editor.deactivate();
                if (DEBUG_TRACE_VIEW_CHANGES) {
                    Logger.getAnonymousLogger().info("DEACTIVATED - " + editor.getClass() + " editor name " + editor.getDisplayName() + " path: " + NbEditorManager.getEditorFileName(editor));
                }
                this.activatedViews.remove(editor);
                break;
            }
            case Opened: {
                this.deactivateCurrentNonEditorView();
                if (this.openedEditors.contains((Object)editor)) {
                    return;
                }
                this.openedEditors.putIfAbsent((Object)editor);
                if (!DEBUG_TRACE_VIEW_CHANGES) break;
                Logger.getAnonymousLogger().info("OPENED - " + editor.getClass() + " editor name " + editor.getDisplayName() + " path: " + NbEditorManager.getEditorFileName(editor));
                break;
            }
            case Closed: {
                if (!this.openedEditors.contains((Object)editor)) {
                    return;
                }
                this.openedEditors.remove((Object)editor);
                if (DEBUG_TRACE_VIEW_CHANGES) {
                    Logger.getAnonymousLogger().info("CLOSED - " + editor.getClass() + " editor name " + editor.getDisplayName() + " path: " + NbEditorManager.getEditorFileName(editor));
                }
                if (editor != this.currentEditor || editor == null || Ide.isQuitting()) break;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NbEditorManager.this.makeSomeEditorActive();
                    }
                });
                if (editor.getContext() == null || editor.getContext().getNode() == null || editor.getContext().getNode().getURL() == null) {
                    return;
                }
                this.currentEditor = null;
            }
        }
        this.fireEditorEvent(evt, editor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEditorEvent(EditorEvent evt, Editor editor) {
        ArrayList<EditorListener> toFire = null;
        List<EditorListener> list = this.listeners;
        synchronized (list) {
            toFire = new ArrayList<EditorListener>(this.listeners);
        }
        block9: for (EditorListener el : toFire) {
            switch (evt) {
                case Opened: {
                    el.editorOpened(editor);
                    continue block9;
                }
                case Closed: {
                    el.editorClosed(editor);
                    continue block9;
                }
                case Activated: {
                    el.editorActivated(editor);
                    continue block9;
                }
                case Deactivated: {
                    el.editorDeactivated(editor);
                    continue block9;
                }
            }
            assert (false) : "Unknown editor event type";
        }
    }

    private void makeSomeEditorActive() {
        Set opened = TopComponent.getRegistry().getOpened();
        for (TopComponent tc : opened) {
            Editor e;
            if (!tc.isShowing() || null == (e = NbEditorManager.toEditor(tc))) continue;
            this.currentEditor = e;
            break;
        }
        this.loadEditorLayout(this.currentEditor);
        if (this.currentEditor != null) {
            this.focusEditor(this.currentEditor.getContext());
        }
    }

    void loadEditorLayout(Editor editor) {
        Layouts layouts = Layouts.getLayouts();
        if (layouts != null) {
            if (null == editor) {
                layouts.activateDefaultDesignLayout();
            } else {
                layouts.activatePreferredLayout((LayoutSelector)editor);
            }
        }
    }

    static Editor toEditor(TopComponent tc) {
        if (tc instanceof NbEditorContainer) {
            return ((NbEditorContainer)tc).getEditor();
        }
        return null;
    }

    public static TopComponent toTopComponent(Editor e) {
        for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
            if (!(tc instanceof NbEditorContainer)) continue;
            NbEditorContainer ec = (NbEditorContainer)tc;
            for (Editor editor : ec.getTabGroup().getAllEditors()) {
                if (editor != e) continue;
                return ec;
            }
        }
        return null;
    }

    public String getActivateCmdTooltip(int nodeNumber) {
        return "<not implemented yet> " + nodeNumber;
    }

    public boolean searchEditor(EditorPathImpl editorPath, EditorCriteriaImpl editorCriteria) {
        NbEditorContainer tc = this.findOpenedDocument(editorPath, editorCriteria);
        return tc != null;
    }

    public NbEditorContainer findOpenedDocument(EditorPathImpl editorPath, EditorCriteriaImpl editorCriteria) {
        if (editorCriteria == null) {
            return null;
        }
        for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
            TabGroup tabGroup;
            if (!(tc instanceof NbEditorContainer)) continue;
            NbEditorContainer ec = (NbEditorContainer)tc;
            if (ec.getEditor() == null) {
                if (editorCriteria.getContext() == null || editorCriteria.getContext().getNode() == null) continue;
                if (ec.match(editorCriteria.getContext().getNode().getURL())) {
                    ec.loadTabGroup();
                }
            }
            if (null == (tabGroup = ec.getTabGroup()) || ec.getEditor() == null || !tabGroup.match(editorCriteria) && !tabGroup.searchEditor(editorPath, editorCriteria)) continue;
            editorPath.setTabGroup(tabGroup);
            return ec;
        }
        return null;
    }

    public boolean focusEditor(EditorPathImpl editorPath) {
        boolean ret = false;
        TabGroup tg = editorPath.getTabGroup();
        if (null != tg && tg.activateEditor(editorPath)) {
            TabGroup tabGroup = editorPath.getTabGroup();
            tabGroup.focusCurrentEditor();
            ret = true;
        }
        return ret;
    }

    boolean focusEditor(Context context) {
        EditorPathImpl editorPath = new EditorPathImpl();
        if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
            return this.focusEditor(editorPath);
        }
        return false;
    }

    void activateEditor(TabGroupState tabGroupState) {
        EditorPathImpl editorPath = new EditorPathImpl();
        this.searchEditor(editorPath, new EditorCriteriaImpl(tabGroupState));
        TabGroup tg = editorPath.getTabGroup();
        if (null != tg) {
            tg.activateEditor(editorPath);
        }
    }

    public void whenEditorClosed(Editor editor) {
        this.handleEditorEvent(EditorEvent.Closed, editor);
        String editorId = editor.getId();
        BaseLayoutListener listener = this.layoutListeners.get(editorId);
        if (listener != null) {
            IdeProperties layout = Ide.getIdeProperties();
            try {
                listener.close((Layout)layout);
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
    }

    public void whenEditorOpened(Editor editor) {
        if (this.editorView == null) {
            this.editorView = this.registerController();
        }
        this.handleEditorEvent(EditorEvent.Opened, editor);
    }

    void reset() {
        this.editorView = null;
    }

    private void whenRefresh() {
        Editor currentEditor = this.getCurrentEditor();
        Context context = currentEditor.getContext();
        Node node = context.getNode();
        if (node != null) {
            NodeUtil.reloadBuffers(Collections.singletonList(node), (boolean)true);
        }
    }

    public void initPreferredLayoutInfo(Editor editor, Context context) {
        Class<?> editorClass = editor.getClass();
        Object[] bestLayoutListener = null;
        List list = this.preferredLayouts.get(editorClass);
        if (list != null) {
            Node node = context.getNode();
            Class<?> nodeClass = node.getClass();
            boolean exactFound = false;
            for (Class<?> searchNodeClass = nodeClass; searchNodeClass != null; searchNodeClass = searchNodeClass.getSuperclass()) {
                for (int i = 0; i < list.size(); ++i) {
                    Object[] layoutListenerInfo = (Object[])list.get(i);
                    Class layoutListenerNodeClass = (Class)layoutListenerInfo[0];
                    if (searchNodeClass == layoutListenerNodeClass) {
                        bestLayoutListener = layoutListenerInfo;
                        exactFound = true;
                        break;
                    }
                    if (!layoutListenerNodeClass.isAssignableFrom(searchNodeClass)) continue;
                    bestLayoutListener = layoutListenerInfo;
                }
                if (exactFound) break;
            }
            if (bestLayoutListener != null) {
                PreferredLayoutListener listener = (PreferredLayoutListener)bestLayoutListener[2];
                editor.addPreferredLayoutListener(listener);
                String preferredLayoutBaseName = (String)bestLayoutListener[1];
                editor.setPreferredLayoutBaseName(preferredLayoutBaseName);
                String type = nodeClass.getName() + "-" + editorClass.getName();
                editor.setType(type);
            }
        }
    }

    public void releaseSplitPane(SplitPane splitPane) {
    }

    public SplitPane createSplitPane() {
        return new SplitPane();
    }

    public void whenEditorActivated(TabGroup tabGroup) {
        Editor e = tabGroup.getCurrentEditor();
        if (e != this.currentEditor) {
            this.currentEditor = e;
            this.loadEditorLayout(e);
            if (this.currentEditor != null) {
                this.handleEditorEvent(EditorEvent.Deactivated, this.currentEditor);
            }
        }
    }

    public void whenCurrentEditorChanges(TabGroup tabGroup) {
        if (!NbEditorManager.isWindowSystemStarted()) {
            return;
        }
        Editor e = tabGroup.getCurrentEditor();
        if (e != this.currentEditor) {
            if (this.currentEditor != null) {
                this.handleEditorEvent(EditorEvent.Deactivated, this.currentEditor);
            }
            this.currentEditor = e;
            tabGroup.getCurrentSplitPane().doLayout();
            this.loadEditorLayout(e);
            final IdeMainWindow mainWindow = Ide.getMainWindow();
            if (mainWindow instanceof NbMainWindow) {
                final Editor currentView = this.currentEditor;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (currentView == NbEditorManager.this.getCurrentEditor()) {
                            ((NbMainWindow)mainWindow).setActiveView((View)NbEditorManager.this.getCurrentEditor());
                        }
                        if (currentView != null && currentView.getContext() != null) {
                            NbEditorManager.this.setEditorForRecentFile(currentView);
                        }
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        }
    }

    private static boolean isWindowSystemStarted() {
        NbDockStation dockStation = (NbDockStation)NbDockStation.getDockStation();
        return dockStation.isWindowSystemStarted();
    }

    private static void updateContext(Editor editor, Context context) {
        Context editorContext = editor.getContext();
        if (ModelUtil.areDifferent((Object)editorContext.getProject(), (Object)context.getProject()) || ModelUtil.areDifferent((Object)editorContext.getWorkspace(), (Object)context.getWorkspace())) {
            editor.setContext(context);
        }
    }

    private Component registerController() {
        for (Frame frame : NbMainWindow.getFrames()) {
            if (!(frame instanceof NbMainWindow)) continue;
            Component editorView = this.searchForEditorView(frame);
            if (editorView == null) {
                return null;
            }
            NbMainWindow mainWindow = (NbMainWindow)((Object)frame);
            mainWindow.addControllerProvider(editorView, this);
            return editorView;
        }
        return null;
    }

    Component searchForEditorView(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            for (Component c : container.getComponents()) {
                if (c.getClass().getName().contains("EditorView")) {
                    return c;
                }
                Component editorView = this.searchForEditorView(c);
                if (editorView == null) continue;
                return editorView;
            }
        }
        return null;
    }

    public RecentFilesLRU getRecentFilesLRU() {
        return this.recentFilesLRU;
    }

    public void activeViewChanged(ActiveViewEvent e) {
        IdeAction.get((int)70).setEnabled(false);
        IdeAction.get((int)71).setEnabled(false);
    }

    public int getEditorPosition(Editor editor) {
        if (editor == null) {
            return -1;
        }
        for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
            NbEditorContainer ec;
            if (!(tc instanceof NbEditorContainer) || editor != (ec = (NbEditorContainer)tc).getEditor()) continue;
            Mode mode = WindowManager.getDefault().findMode(tc);
            if (mode == null) break;
            List<TopComponent> tcs = Arrays.asList(mode.getTopComponents());
            return tcs.indexOf(tc);
        }
        return -1;
    }

    public TabGroup getTabGroup(Editor editor) {
        for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
            NbEditorContainer ec;
            if (!(tc instanceof NbEditorContainer) || editor != (ec = (NbEditorContainer)tc).getEditor()) continue;
            return ec.getTabGroup();
        }
        return null;
    }

    private int getActiveDocumentPosition() {
        TopComponent tc = TopComponent.getRegistry().getActivated();
        Mode mode = WindowManager.getDefault().findMode(tc);
        if (mode == null) {
            return -1;
        }
        List<TopComponent> tcs = Arrays.asList(mode.getTopComponents());
        return tcs.indexOf(tc);
    }

    private TopComponent findOpenedDocument(OpenEditorOptions openEditorOptions) {
        EditorCriteriaImpl editorCriteria;
        EditorPathImpl editorPath = new EditorPathImpl();
        Context context = openEditorOptions.getContext();
        Class editorClass = openEditorOptions.getEditorClass();
        if (editorClass == null) {
            editorCriteria = new EditorCriteriaImpl(context);
            EditorAddin editorAddin = this.bestEditorAddin(context);
            if (editorAddin != null) {
                openEditorOptions.setEditorClass(editorAddin.getEditorClass());
            }
        } else {
            editorCriteria = new EditorCriteriaImpl(context, editorClass);
        }
        return this.findOpenedDocument(editorPath, editorCriteria);
    }

    void flushLastEditorCache() {
        this.recentFilesLRU = new RecentFilesLRU();
    }

    boolean isEditorActivated(Editor editor) {
        return this.activatedViews.contains(editor);
    }

    private static void traceEditorEvent(EditorEvent evt, Editor editor) {
        Logger.getAnonymousLogger().info("Editor: " + editor + " event: " + evt.name());
    }

    public void requestAttention(Editor editor, boolean brief) {
        if (editor == null) {
            return;
        }
        TopComponent tc = NbEditorManager.toTopComponent(editor);
        if (tc != null) {
            tc.requestAttention(brief);
        }
    }

    public void cancelRequestAttention(Editor editor) {
        if (editor == null) {
            return;
        }
        TopComponent tc = NbEditorManager.toTopComponent(editor);
        if (tc != null) {
            tc.cancelRequestAttention();
        }
    }

    public void makeBusy(Editor editor, boolean busy) {
        if (editor == null) {
            return;
        }
        TopComponent tc = NbEditorManager.toTopComponent(editor);
        if (tc != null) {
            tc.makeBusy(busy);
        }
    }

    void resolveActionsOnStart() {
        this.accelerators.createMenu();
    }

    public View getView(ViewId id) {
        return this.idsToViews.get(id);
    }

    public void addView(ViewId id, View view) {
        this.idsToViews.put(id, view);
        this.viewsToIds.put(view, id);
    }

    public void removeView(View view) {
        ViewId id = this.viewsToIds.get(view);
        if (id != null) {
            this.idsToViews.remove(id);
            this.viewsToIds.remove(view);
        }
    }

    public void addOpenedViews(Layout layout, List openedList) {
        for (View view : this.viewsToIds.keySet()) {
            openedList.add(view);
        }
    }

    public void save(Layout layout) {
        for (BaseLayoutListener listener : this.layoutListeners.values()) {
            try {
                listener.save(layout);
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
    }

    public void init(Layout layout) {
        for (BaseLayoutListener listener : this.layoutListeners.values()) {
            try {
                listener.init(layout);
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
    }

    public void close(Layout layout) {
    }

    private EditorAddin bestEditorAddin(Context context) {
        Node node;
        EditorAddin ret = this.getMostRecentEditorAddin(context);
        if (ret == null && (node = context.getNode()) != null) {
            ret = this.getBestEditorAddin(context);
        }
        return ret;
    }

    public EditorAddin getMostRecentEditorAddin(Context context) {
        EditorAddin ret = null;
        RecentFile recentFile = this.recentFilesLRU.getRecentFile(context);
        if (recentFile != null) {
            List editorAddins;
            String editorAddinClass = recentFile.getEditor();
            if (editorAddinClass != null) {
                ret = this._editorAddinRegistry.getRegisteredEditorAddin(editorAddinClass);
            }
            if (ret == null && editorAddinClass != null && (editorAddins = this.getAddins(context)) != null && (ret = this._editorAddinRegistry.getRegisteredEditorAddin(editorAddinClass)) == null) {
                for (EditorAddin addin : editorAddins) {
                    String createUniqueName = EditorAddinRegistry.createDeclarativeEditorAddinUniqueID((EditorAddin)addin);
                    if (!editorAddinClass.equals(createUniqueName)) continue;
                    ret = addin;
                }
            }
        }
        return ret;
    }

    private static boolean openExternal(OpenEditorOptions options) {
        Context context = options.getContext();
        if (context.getNode() != null && UnrecognizedTextNode.class.equals(context.getNode().getClass()) && (options.getFlags() & 0x10) != 0 && Desktop.isDesktopSupported()) {
            boolean[] dialogModel = new boolean[2];
            String openExternalKey = "openExternally" + NbEditorManager.getFileExt(context);
            String path = context.getNode().getURL().getPath();
            Boolean openExt = MessageDialog.getPersistence().getConfirmed(openExternalKey);
            if (null == openExt) {
                if (!NbEditorManager.openExternallyDialog(dialogModel).runDialog()) {
                    return true;
                }
                if (dialogModel[1]) {
                    MessageDialog.getPersistence().setConfirmed(openExternalKey, Boolean.valueOf(dialogModel[0]));
                }
            }
            if (Boolean.TRUE.equals(openExt) || dialogModel[0]) {
                File f = new File(path);
                if (!f.exists()) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)(EditorBundle.getString((int)2) + " " + f.getAbsolutePath()), (String)EditorBundle.getString((int)1), null);
                    return true;
                }
                try {
                    Desktop.getDesktop().open(f);
                }
                catch (Exception e) {
                    ResourceBundle bundle = NbBundle.getBundle(NbEditorManager.class);
                    String productName = ProductInformation.getProductInformation().getShortName();
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)(NbBundle.getMessage(NbEditorManager.class, (String)"OS_DEFAULT_FILE_ERROR_RB") + productName + " : " + e.getMessage()), (String)bundle.getString("NO_EDITOR_FOUND"), null);
                }
                return true;
            }
        }
        return false;
    }

    private static final JEWTDialog openExternallyDialog(final boolean[] external) {
        external[0] = true;
        external[1] = false;
        String productName = ProductInformation.getProductInformation().getShortName();
        ResourceBundle bundle = NbBundle.getBundle(NbEditorManager.class);
        JEWTDialog dialog = BaseMessageDialog.createDialog((Component)Ide.getMainWindow(), (String)bundle.getString("NO_EDITOR_FOUND"), (int)3);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)new MultiLineLabel(WordWrapper.getTextWrapper(), NbBundle.getMessage(NbEditorManager.class, (String)"NO_EDITOR_ASSOCIATED_MESSAGE", (Object)productName)), "North");
        final JRadioButton externalAppRadio = new JRadioButton(NbBundle.getMessage(NbEditorManager.class, (String)"OS_DEFAULT_APPLICATION_RB", (Object)productName));
        externalAppRadio.setMnemonic(bundle.getString("OS_DEFAULT_APPLICATION_RB_MNEMONIC").charAt(0));
        externalAppRadio.setSelected(true);
        JRadioButton plainEditorRadio = new JRadioButton(NbBundle.getMessage(NbEditorManager.class, (String)"AS_A_PLAIN_TEXT_RB", (Object)productName));
        plainEditorRadio.setMnemonic(bundle.getString("AS_A_PLAIN_TEXT_RB_MNEMONIC").charAt(0));
        ButtonGroup group = new ButtonGroup();
        group.add(externalAppRadio);
        group.add(plainEditorRadio);
        JPanel radioPanel = new JPanel();
        GroupLayout radioPanelLayout = new GroupLayout(radioPanel);
        radioPanel.setLayout(radioPanelLayout);
        radioPanelLayout.setHorizontalGroup(radioPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(radioPanelLayout.createSequentialGroup().addContainerGap().addGroup(radioPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(externalAppRadio).addComponent(plainEditorRadio)).addContainerGap(-1, Short.MAX_VALUE)));
        radioPanelLayout.setVerticalGroup(radioPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(radioPanelLayout.createSequentialGroup().addGap(16).addComponent(externalAppRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(plainEditorRadio)));
        panel.add((Component)radioPanel, "Center");
        final JCheckBox skipBox = new JCheckBox(bundle.getString("MD_SKIP"));
        skipBox.setMnemonic(bundle.getString("MD_SKIP_MNEMONIC").charAt(0));
        skipBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object eventObject = e.getSource();
                if (eventObject == null) {
                    return;
                }
                if (skipBox.equals(eventObject)) {
                    external[1] = skipBox.getModel().isSelected();
                }
            }
        });
        panel.add((Component)skipBox, "South");
        MessagePanel mp = new MessagePanel();
        mp.setMessage((Object)panel);
        mp.setMessageType(4);
        dialog.setContent((Component)mp);
        group.getSelection().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object eventObject = e.getSource();
                if (eventObject == null) {
                    return;
                }
                external[0] = externalAppRadio.getModel().isSelected();
            }
        });
        return dialog;
    }

    private static final String getFileExt(Context context) {
        Node node = context.getNode();
        String path = node.getURL().getPath();
        int lastDot = node.getURL().getFile().lastIndexOf(46);
        String ext = "noext";
        if (lastDot > -1) {
            ext = path.substring(lastDot);
        }
        return ext;
    }

    void setEditorForRecentFile(Editor editor) {
        if (editor == null || editor.getContext() == null) {
            return;
        }
        Context context = editor.getContext();
        List addins = this._editorAddinRegistry.getAddins(context);
        if (addins == null) {
            return;
        }
        for (EditorAddin addin : addins) {
            String createUniqueName = EditorAddinRegistry.createDeclarativeEditorAddinUniqueID((EditorAddin)addin);
            if (!editor.getClass().getName().equals(createUniqueName) && !createUniqueName.contains(editor.getClass().getName()) && !editor.getClass().equals(addin.getEditorClass())) continue;
            EditorManagerImpl.raiseContextInLRUList((Context)context, (EditorAddin)addin);
            break;
        }
    }

    void focusCurrentEditor() {
        if (this.currentEditor == null) {
            return;
        }
        TabGroup currentTabGroup = this.getTabGroup(this.currentEditor);
        if (currentTabGroup == null) {
            return;
        }
        currentTabGroup.focusCurrentEditor();
    }

    private void whenNavigateLRUFiles() {
        RecentFile[] recentFiles = this.recentFilesLRU.getRecentFiles();
        IdeMainWindow mainWindow = Ide.getMainWindow();
        LastUsedFiles.runDialog((Frame)mainWindow, (RecentFile[])recentFiles);
    }

    public void addNodeCloseListener(Node node) {
        node.addNodeListener(this.closeListener);
    }

    public static boolean getEditorManagerOption(int option) {
        int values = 0;
        EditorCustomizationHook customization = (EditorCustomizationHook)ExtensionRegistry.getExtensionRegistry().getHook(EditorCustomizationHook.ELEMENT);
        if (customization != null) {
            EditorCustomizationOptions options = customization.getCustomizationOptions();
            if (options.isTopTabMode()) {
                values |= 1;
            }
            if (options.isTabsUseGradient()) {
                values |= 4;
            }
            if (options.isHideTabsIfSingleEditor()) {
                values |= 2;
            }
            if (options.isHideAllDynamicEditorMenus()) {
                values |= 8;
            }
        }
        editorManagerOptions = values;
        return BitField.isSet((int)editorManagerOptions, (int)option);
    }

    private static boolean isSelectedTopComponentIsNonJdevEditor() {
        TopComponent tc;
        WindowManagerImpl wm;
        return TopComponent.getRegistry().getActivated() != null && !(TopComponent.getRegistry().getActivated() instanceof JDevTopComponent) && (wm = WindowManagerImpl.getInstance()).isEditorTopComponent(tc = TopComponent.getRegistry().getActivated());
    }

    private static String getEditorFileName(Editor editor) {
        if (editor == null || editor.getContext() == null || editor.getContext().getNode() == null || editor.getContext().getNode().getURL() == null || editor.getContext().getNode().getURL().getPath() == null) {
            return "";
        }
        return editor.getContext().getNode().getURL().getPath();
    }

    private void updateTCLookupForViewNoFocus(Editor editor) {
        JDevTopComponent viewTC;
        TopComponent tc;
        if (editor != null && editor == Ide.getMainWindow().getLastActiveView() && (tc = NbEditorManager.toTopComponent(editor)) instanceof JDevTopComponent && (viewTC = (JDevTopComponent)tc).isAncestorOf(editor.getGUI())) {
            viewTC.updateViewLookup((View)editor);
        }
    }

    private static Collection<Extension> getFullyLoadedExtensions() {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (Extension e : ExtensionRegistry.getExtensionRegistry().getExtensions()) {
            if (!ExtensionRegistry.getExtensionRegistry().isFullyLoaded(e)) continue;
            extensions.add(e);
        }
        return extensions;
    }

    private static final Project findProject(Node node) {
        Project project = NbEditorManager.findProject(Ide.getActiveWorkspace(), node);
        if (project != null) {
            return project;
        }
        Iterator iter = Ide.getWorkspaces().getChildren();
        while (iter.hasNext()) {
            Object workspace = iter.next();
            if (!(workspace instanceof Workspace) || workspace == Ide.getActiveWorkspace() || (project = NbEditorManager.findProject((Workspace)workspace, node)) == null) continue;
            return project;
        }
        return null;
    }

    private static final Project findProject(Workspace workspace, Node node) {
        if (node == null || workspace == null) {
            return null;
        }
        ProjectCache cache = ProjectCache.getInstance((Workspace)workspace);
        ArrayList<Project> allProjects = new ArrayList<Project>(workspace.projects());
        Project project = NbEditorManager.findProject(cache, node, allProjects);
        return project;
    }

    private static final Project findProject(ProjectCache cache, Node node, Collection<Project> projects) {
        for (Project p : projects) {
            Path path = cache.getContentPath(p);
            if (!path.contains(node.getURL())) continue;
            return p;
        }
        return null;
    }

    void addActiveView(View view) {
        this.activatedViews.add(view);
    }

    void removeActiveView(View view) {
        this.activatedViews.remove(view);
    }

    boolean isViewActive(View view) {
        return this.activatedViews.contains(view);
    }

    private void deactivateCurrentNonEditorView() {
        View currentView = Ide.getMainWindow().getLastActiveView();
        if (currentView != null && !(currentView instanceof Editor) && this.isViewActive(currentView)) {
            currentView.deactivate();
            this.activatedViews.remove(currentView);
            if (DEBUG_TRACE_VIEW_CHANGES) {
                Logger.getAnonymousLogger().info("View deactivated: info: " + currentView.getClass() + " ID: " + currentView.getId());
            }
        }
    }

    public void refreshEditorUI(Editor editor) {
        NbEditorContainer nbec = (NbEditorContainer)NbEditorManager.toTopComponent(editor);
        if (nbec == null || nbec.getTabGroup() == null) {
            return;
        }
        SplitPane sp = nbec.getTabGroup().getSplitPane(editor);
        if (sp == null) {
            return;
        }
        sp.refreshEditorUI(editor);
    }

    private void closeNonTriggeredEditors() {
        HashSet<NbEditorContainer> tcsToClose = new HashSet<NbEditorContainer>();
        for (TopComponent topComponent : TopComponent.getRegistry().getOpened()) {
            if (!(topComponent instanceof NbEditorContainer)) continue;
            NbEditorContainer nbec = (NbEditorContainer)topComponent;
            nbec.setClosing(true);
            tcsToClose.add(nbec);
        }
        for (TopComponent topComponent : tcsToClose) {
            topComponent.close();
        }
    }

    public static final void printAdditionalInformation(Editor editor) {
        System.out.println("--------------Editor Info---------------");
        System.out.println(">Editor Class: " + (editor != null ? editor : "Null Editor"));
        if (editor != null && editor.getContext() != null) {
            System.out.println(">Editor's Node Info - " + (editor.getContext().getNode() != null ? "\n     Class: " + editor.getContext().getNode().getClass() + "\n     URL: " + editor.getContext().getNode().getURL() + "\n     Node: " + editor.getContext().getNode() : "Null Node"));
        }
        System.out.println(">Editor UI Info and Tree: ");
        if (editor != null && editor.getGUI() != null && editor.getGUI() instanceof Container) {
            System.out.println("|-" + editor.getGUI());
            NbEditorManager.printComponentsTree((Container)editor.getGUI(), "");
        } else if (editor != null && editor.getGUI() != null) {
            System.out.println("|-" + editor);
        }
        System.out.println("-------------------------------------------------------------");
    }

    private static void printComponentsTree(Container rootCompo, String level) {
        level = level + "    ";
        for (Component child : rootCompo.getComponents()) {
            System.out.println(level + "|-" + child.getClass());
            if (!(child instanceof Container)) continue;
            NbEditorManager.printComponentsTree((Container)child, new String(level));
        }
    }

    private static void closeNonTriggeredEditors(Node node) {
        final Collection<TopComponent> nonTiggeredEditorsToClose = NbEditorManager.getNonTriggeredEditorsToClose(node);
        if (nonTiggeredEditorsToClose.isEmpty()) {
            return;
        }
        Runnable close = new Runnable(){

            @Override
            public void run() {
                for (TopComponent tc : nonTiggeredEditorsToClose) {
                    if (!tc.isOpened()) continue;
                    tc.close();
                }
            }
        };
        SwingUtilities.invokeLater(close);
    }

    private static Collection<TopComponent> getNonTriggeredEditorsToClose(Node node) {
        HashSet<TopComponent> toClose = new HashSet<TopComponent>();
        for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
            Project ecProject;
            NbEditorContainer ec;
            if (!(tc instanceof NbEditorContainer) || (ec = (NbEditorContainer)tc).getEditor() != null || (ecProject = ec.getProject()) == null || ecProject != node && (ecProject.getWorkspace() == null || ecProject.getWorkspace() != node)) continue;
            toClose.add((TopComponent)ec);
        }
        return toClose;
    }

    static {
        DEBUG_TRACE_VIEW_CHANGES = Boolean.valueOf(System.getProperty("DEBUG_TRACE_FOCUS_CHANGES"));
    }

    private class EditorWorkspaceChangeListener
    extends NodeListener {
        private EditorWorkspaceChangeListener() {
        }

        public void nodeClosed(NodeEvent e) {
            super.nodeClosed(e);
            if (e.getNode() instanceof Workspace) {
                Workspace workspace = (Workspace)e.getNode();
                NbEditorManager.closeNonTriggeredEditors((Node)workspace);
            }
        }
    }

    private class EditorProjectChangeListener
    extends ProjectChangeListener {
        private EditorProjectChangeListener() {
        }

        public void projectPropertiesChanged(ProjectChangeEvent e) {
            super.projectPropertiesChanged(e);
        }

        public void projectClosed(Project project) {
            NbEditorManager.closeNonTriggeredEditors((Node)project);
        }
    }

    private class NodeCloseListener
    extends NodeListener {
        private NodeCloseListener() {
        }

        public void nodeWillClose(NodeEvent e) {
            Node node = e.getNode();
            node.removeNodeListener((NodeListener)this);
        }

        public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
            if (!SwingUtilities.isEventDispatchThread()) {
                return;
            }
            Node newNode = NodeFactory.find((URL)newURL);
            Node oldNode = e.getNode();
            if (oldNode == null) {
                return;
            }
            oldNode.removeNodeListener((NodeListener)this);
            newNode.addNodeListener((NodeListener)this);
            boolean nodeTypeIsTheSame = oldNode.getClass() == newNode.getClass();
            EditorPath editorPath = NbEditorManager.this.searchEditor(oldNode);
            if (editorPath == null || !(editorPath instanceof EditorPathImpl)) {
                return;
            }
            EditorPathImpl editorPathImpl = (EditorPathImpl)editorPath;
            TabGroup tabGroup = editorPathImpl.getTabGroup();
            if (tabGroup == null) {
                return;
            }
            List<Editor> editors = tabGroup.getAllEditors();
            if (nodeTypeIsTheSame) {
                Editor editor2;
                TopComponent tc = null;
                Iterator<Editor> i$ = editors.iterator();
                while (i$.hasNext() && ((tc = NbEditorManager.toTopComponent(editor2 = i$.next())) == null || !(tc instanceof NbEditorContainer))) {
                }
                if (tc == null) {
                    return;
                }
                for (Editor editor2 : editors) {
                    Context context = editor2.getContext();
                    if (!context.getNode().equals(oldNode)) continue;
                    NbEditorContainer ec = (NbEditorContainer)tc;
                    Project project = NbEditorManager.findProject(newNode);
                    ec.updateProject(project, editor2);
                    ec.updateURL(newNode.getURL());
                }
            } else {
                ArrayList<Editor> editorsToClose = new ArrayList<Editor>();
                for (Editor editor : editors) {
                    if (!oldNode.equals(editor.getContext().getNode())) continue;
                    editorsToClose.add(editor);
                }
                this.replaceEditors(editorsToClose, oldNode, newNode);
            }
        }

        private void replaceEditors(final List<Editor> oldEditors, final Node oldNode, final Node newNode) {
            if (oldEditors.isEmpty()) {
                return;
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        oldNode.save();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    NbEditorManager.this.closeEditors(oldEditors);
                    for (Editor editor : oldEditors) {
                        Context newContext = new Context(editor.getContext());
                        newContext.setNode(newNode);
                        NbEditorManager.this.openEditorInFrame(editor.getClass(), newContext);
                    }
                    if (!oldNode.getURL().getPath().equals(newNode.getURL().getPath())) {
                        oldNode.delete();
                    }
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    private static enum Direction {
        RIGHT,
        LEFT;

    }

    public static enum EditorEvent {
        Opened,
        Closed,
        Activated,
        Deactivated;

    }
}

