/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import com.oracle.jdeveloper.nbwindowsystem.JDevTopComponent;
import com.oracle.jdeveloper.nbwindowsystem.MenuWarmUpTask;
import com.oracle.jdeveloper.nbwindowsystem.NbActions;
import com.oracle.jdeveloper.nbwindowsystem.NbDockStation;
import com.oracle.jdeveloper.nbwindowsystem.NbEditorContainer;
import com.oracle.jdeveloper.nbwindowsystem.NbEditorManager;
import com.oracle.jdeveloper.nbwindowsystem.NbMenuBarFS;
import com.oracle.jdeveloper.nbwindowsystem.NbMenubar;
import com.oracle.jdeveloper.nbwindowsystem.NbToolbar;
import com.oracle.jdeveloper.nbwindowsystem.NbToolbarsFS;
import com.oracle.jdeveloper.nbwindowsystem.NbView;
import com.oracle.jdeveloper.nbwindowsystem.NbWindowManagerStartingController;
import com.oracle.jdeveloper.nbwindowsystem.plaf.OracleLFCustoms;
import com.oracle.jdeveloper.nbwindowsystem.plaf.ToolbarDragger;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowListener;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.ide.menu.ActionRegistry;
import javax.ide.menu.spi.MenuHook;
import javax.ide.menu.spi.SectionContainer;
import javax.ide.menu.spi.Toolbar;
import javax.swing.DefaultFocusManager;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeActivationEvent;
import oracle.ide.IdeActivationListener;
import oracle.ide.IdeArgs;
import oracle.ide.IdeConstants;
import oracle.ide.IdeMainWindow;
import oracle.ide.ProductInformation;
import oracle.ide.TitleProvider;
import oracle.ide.Version;
import oracle.ide.controller.ControllerProvider;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuWeightComparator;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.StatusBarControl;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.ExceptionDialog;
import oracle.ide.docking.WindowManagerStartingController;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.extension.RoleManager;
import oracle.ide.layout.IdeProperties;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.DynamicStatusProvider;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.TitledContainer;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideimpl.DefaultTitleProvider;
import oracle.ideimpl.MemoryMonitor;
import oracle.ideimpl.controller.EditorMenuHook;
import oracle.ideimpl.docking.shutter.ShutterPanel;
import oracle.ideimpl.editor.LazyIconsCacheUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.PlatformUtils;
import oracle.javatools.util.SwingClosure;
import oracle.javatools.util.SwingUtils;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.DefaultSeparateContainer;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.openide.LifecycleManager;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.ToolbarPool;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import sun.swing.SwingUtilities2;

public class NbMainWindow
extends IdeMainWindow
implements PropertyChangeListener,
IdeMainWindow.ControllerContext {
    static final Logger LOG = Logger.getLogger(NbMainWindow.class.getName());
    private List<ActiveViewListener> avl = new CopyOnWriteArrayList<ActiveViewListener>();
    private List<IdeActivationListener> ial = new CopyOnWriteArrayList<IdeActivationListener>();
    private List<DynamicMenuListener> dml = new CopyOnWriteArrayList<DynamicMenuListener>();
    private View lastActiveView;
    private Map<Component, WeakReference<View>> componentToView = new WeakHashMap<Component, WeakReference<View>>();
    private Map<View, WeakReference<Component>> viewToComponent = new WeakHashMap<View, WeakReference<Component>>();
    private static NbMainWindow INSTANCE;
    private Map<Component, ControllerProvider> componentToControllerProvider = new WeakHashMap<Component, ControllerProvider>();
    private DynamicStatusProvider dynamicStatusProvider;
    private Collection<String> statusDetractors;
    private static final String STATUS_DETRACTORS = "MainWindow.nonStatusViews";
    private StatusListener statusListener = new StatusListener();
    private MemoryMonitor memoryMonitor;
    private TitleProvider titleProvider;
    private JMenu _dynamicMenu;
    private JMenuItem _dynamicPlaceholderItem;
    private static boolean DEBUG_TRACE_VIEW_CHANGES;
    private boolean winsysShowing = false;
    private boolean DEBUG = false;
    private JLabel currentViewLabel = null;
    private ViewSelectionListener viewSelectionListener = new ViewSelectionListener(){

        public void viewSelectionChanged(ViewSelectionEvent e) {
            NbMainWindow.this.updateTCLookupForView(e.getView());
        }
    };
    private boolean _deactivatingDynMenu;
    private boolean _activatingDynMenu;
    private Container statusBarHolder = null;

    public NbMainWindow() {
        LOG.log(Level.FINE, "IdeMainWindow created");
        assert (INSTANCE == null) : "Only one instance is allowed";
        INSTANCE = this;
        WindowManager.getDefault().getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                NbMainWindow.this.winsysShowing = true;
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this);
        this.setName("NbMainWindow");
        Toolkit tk = Toolkit.getDefaultToolkit();
        tk.addAWTEventListener(new ApplicationSwitchListener(), 68L);
    }

    static StatusBar getStatusBarStatic() {
        if (INSTANCE == null) {
            Lookup.getDefault().lookup(NbMainWindow.class);
        }
        return INSTANCE.getStatusBar();
    }

    public void registerView(View view) {
        Component c = view.getGUI();
        if (c != null) {
            this.registerView(view, c);
        }
    }

    public void registerView(View view, Component c) {
        this.componentToView.put(c, new WeakReference<View>(view));
        this.viewToComponent.put(view, new WeakReference<Component>(c));
    }

    private Component getRegisteredViewComponent(View view) {
        WeakReference<Component> ref = this.viewToComponent.get(view);
        return ref != null ? (Component)ref.get() : null;
    }

    public void unregisterView(View view) {
        WeakReference<Component> ref = this.viewToComponent.remove(view);
        if (ref != null) {
            this.componentToView.remove(ref.get());
            if (view == this.getLastActiveView()) {
                this.setActiveView(this.getIdeMainWindowView());
            }
        }
    }

    public void requestViewsUpdate() {
        View activeView = this.lastActiveView;
        if (activeView == null) {
            return;
        }
        activeView.updateSelection();
        this.repaintView(activeView);
        this.updateTCLookupForView(activeView);
        ActiveViewEvent ev = new ActiveViewEvent((Object)this, activeView, activeView);
        if (NbMainWindow.isViewTrackingEnabled()) {
            System.out.println("> Active View Listener: New View: " + ev.getNewView() + " Old View: " + ev.getOldView());
        }
        for (ActiveViewListener l : this.avl) {
            l.activeViewChanged(ev);
        }
        NbActions.updateAll();
        this.updateStatusBar(activeView);
        this.updateTitle(activeView);
    }

    public void setActiveView(View view) {
        assert (EventQueue.isDispatchThread());
        this.updateCurrentView(view);
        if (view == null || view == this.lastActiveView) {
            return;
        }
        NbEditorManager em = NbEditorManager.getInstance();
        if (this.lastActiveView != null) {
            this.lastActiveView.removeViewSelectionListener(this.viewSelectionListener);
            if (em.isViewActive(this.lastActiveView)) {
                this.lastActiveView.deactivate();
                em.removeActiveView(this.lastActiveView);
                NbMainWindow.printViewInfo("Deactivated View", this.lastActiveView, false);
            }
            this.repaintView(this.lastActiveView);
        }
        ActiveViewEvent ev = new ActiveViewEvent((Object)this, this.lastActiveView, view);
        this.lastActiveView = view;
        if (view instanceof Editor && !NbEditorManager.getInstance().isEditorActivated((Editor)view)) {
            NbEditorManager.getInstance().handleEditorEvent(NbEditorManager.EditorEvent.Activated, (Editor)view);
        } else if (!(view instanceof Editor) && !em.isViewActive(view)) {
            view.activate();
            em.addActiveView(view);
            NbMainWindow.printViewInfo("Activated View", view, false);
        }
        TopComponent currentTc = TopComponent.getRegistry().getActivated();
        Component viewComponent = this.lastActiveView.getGUI();
        TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, viewComponent);
        if (tc != null && currentTc != tc && tc instanceof NbEditorContainer) {
            NbEditorContainer ec = (NbEditorContainer)tc;
            ec.requestActiveWithoutFocus();
            ec.requestActive();
        }
        view.updateSelection();
        this.repaintView(view);
        this.updateTCLookupForView(view);
        view.addViewSelectionListener(this.viewSelectionListener);
        this.firePropertyChange("lastActiveView", ev.getOldView(), view);
        if (NbMainWindow.isViewTrackingEnabled()) {
            System.out.println("> Active View Listener:  New View: " + ev.getNewView() + " Old View: " + ev.getOldView());
        }
        for (ActiveViewListener l : this.avl.toArray(new ActiveViewListener[this.avl.size()])) {
            l.activeViewChanged(ev);
        }
        NbActions.updateAll();
        this.updateStatusBar(view);
        this.updateTitle(view);
        NbMainWindow.printViewInfo("current View", view, true);
    }

    private void updateTCLookupForView(View view) {
        JDevTopComponent viewTC;
        if (view != null && view == this.lastActiveView && !(view instanceof NbView) && (viewTC = (JDevTopComponent)((Object)SwingUtilities.getAncestorOfClass(JDevTopComponent.class, view.getGUI()))) != null) {
            viewTC.updateViewLookup(view);
        }
    }

    void setActiveViewForFocusOwner(Component newFocusOwner) {
        this.setActiveView(this.findView(newFocusOwner));
    }

    private View findView(Component comp) {
        if (comp == null) {
            return this.getIdeMainWindowView();
        }
        TopComponent tc = null;
        do {
            WeakReference<View> ref;
            if ((ref = this.componentToView.get(comp)) != null) {
                return (View)ref.get();
            }
            if (!(comp instanceof TopComponent)) continue;
            tc = (TopComponent)comp;
        } while ((comp = comp.getParent()) != null);
        if (tc != null) {
            return NbView.toView(tc);
        }
        return null;
    }

    private void repaintView(View view) {
        Component c;
        if (!(view instanceof NbView) && (c = this.getRegisteredViewComponent(view)) != null) {
            c.repaint();
        }
    }

    public void setJMenuBar(JMenuBar menubar) {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException();
        }
        JMenuBar old = super.getJMenuBar();
        super.setJMenuBar(menubar);
        ContainerListener cl = this.getNbBar().getContainerListener();
        menubar.addContainerListener(cl);
        for (Component component : menubar.getComponents()) {
            if (!(component instanceof JMenu)) continue;
            cl.componentAdded(new ContainerEvent(menubar, 0, component));
        }
        this.getNbBar().attachMenuAndPopupListeners(menubar);
        this.firePropertyChange("jMenuBar", old, menubar);
    }

    final NbMenubar getNbBar() {
        return (NbMenubar)this.getMenubar();
    }

    protected Menubar createMenubar() {
        return new NbMenubar(this, (NbMenuBarFS)((Object)Lookup.getDefault().lookup(NbMenuBarFS.class)));
    }

    public View getLastActiveView() {
        View v = this.lastActiveView;
        if (v == null) {
            v = this.getIdeMainWindowView();
        }
        return v;
    }

    private Component getLastActiveViewComponent() {
        return this.lastActiveView != null ? this.getRegisteredViewComponent(this.lastActiveView) : null;
    }

    public List<View> getVisibleViews() {
        ArrayList<View> views = new ArrayList<View>();
        HashSet<Map.Entry<Component, WeakReference<View>>> ctvCopy = new HashSet<Map.Entry<Component, WeakReference<View>>>(this.componentToView.entrySet());
        for (Map.Entry entry : ctvCopy) {
            View v;
            Component c = (Component)entry.getKey();
            if (c == null || !c.isShowing() || (v = (View)((WeakReference)entry.getValue()).get()) == null || v instanceof NbView) continue;
            views.add(v);
        }
        for (TopComponent topComponent : WindowManager.getDefault().getRegistry().getOpened()) {
            View v = NbView.toView(topComponent);
            if (!(v instanceof NbView)) continue;
            views.add(v);
        }
        views.add(this.getIdeMainWindowView());
        return views;
    }

    public IdeMainWindow.ControllerContext getControllerContext() {
        return this;
    }

    public synchronized void addActiveViewListener(ActiveViewListener al) {
        this.avl.add(al);
    }

    public synchronized void removeActiveViewListener(ActiveViewListener al) {
        this.avl.remove(al);
    }

    public void addIdeActivationListener(IdeActivationListener il) {
        this.ial.add(il);
    }

    public void removeIdeActivationListener(IdeActivationListener il) {
        this.ial.remove(il);
    }

    public void addDynamicMenuListener(DynamicMenuListener dl) {
        if (!this.dynamicMenusAreHidden()) {
            this.dml.add(dl);
        }
    }

    public void removeDynamicMenuListener(DynamicMenuListener dl) {
        this.dml.remove(dl);
    }

    public void preInitialize() {
        super.preInitialize();
        this.setLayeredPane(new JLayeredPane(){

            @Override
            public void remove(int index) {
                try {
                    super.remove(index);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        this.statusDetractors = new ArrayList<String>();
        String detractors = Ide.getProperty((String)STATUS_DETRACTORS);
        if (detractors != null) {
            StringTokenizer tokenizer = new StringTokenizer(detractors, ";");
            while (tokenizer.hasMoreTokens()) {
                String detractor = tokenizer.nextToken();
                this.statusDetractors.add(detractor);
            }
        }
        this.enableMacOsFullScreenIfNecessary();
    }

    private void createContextMenuAction() {
        IdeAction action = IdeAction.get((int)50, (String)"oracle.ide.cmd.NotImplementedCommand", (String)IdeArb.getString((int)322), null, null, null, null, (boolean)true);
        Ide.getMenubar().createMenuItem((ToggleAction)action);
    }

    public void initialize() {
        super.initialize();
        this.initDialogSize();
        this.createContextMenuAction();
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", new PropertyChangeListener(){
            private ArrayList<TitledContainer> _lastKnownFocusedContainers = new ArrayList(0);

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (Ide.isQuitting()) {
                    return;
                }
                ArrayList<TitledContainer> newlyFocused = new ArrayList<TitledContainer>(3);
                boolean activeModal = SwingUtilities.getAncestorOfClass(NbMainWindow.class, (Component)TopComponent.getRegistry().getActivated()) == null;
                TopComponent activeTc = TopComponent.getRegistry().getActivated();
                boolean changeLayout = false;
                for (Component component = (Component)evt.getNewValue(); component != null; component = component.getParent()) {
                    if (activeModal && activeTc != null && !activeTc.isAncestorOf(component) || !(component instanceof TitledContainer)) continue;
                    TitledContainer titledContainer = (TitledContainer)component;
                    if (!this._lastKnownFocusedContainers.remove(titledContainer)) {
                        titledContainer.containerActivated(true);
                        changeLayout = true;
                    }
                    newlyFocused.add(titledContainer);
                }
                if (!changeLayout) {
                    return;
                }
                for (int i = 0; i < this._lastKnownFocusedContainers.size(); ++i) {
                    TitledContainer titledContainer = this._lastKnownFocusedContainers.get(i);
                    if (titledContainer instanceof ShutterPanel) continue;
                    titledContainer.containerActivated(false);
                }
                this._lastKnownFocusedContainers = newlyFocused;
            }
        });
        if (OracleLFCustoms.isDefaultTheme()) {
            Toolkit.getDefaultToolkit().addAWTEventListener(ToolbarDragger.createMouseMotionListener(), 16L);
        }
        Ide.getSystem().attach(new Observer(){

            public void update(Object observed, UpdateMessage change) {
                if (change.getMessageID() == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                    View activeView = NbMainWindow.this.getLastActiveView();
                    NbMainWindow.this.updateTitle(activeView);
                }
            }
        });
        View active = this.getLastActiveView();
        this.addActiveViewListener(new ActiveViewListener(){

            public void activeViewChanged(ActiveViewEvent e) {
                final View view = e.getNewView();
                if (view == null || view instanceof MainWindowView) {
                    Timer timer = new Timer(500, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            View activeView = NbMainWindow.this.getLastActiveView();
                            NbMainWindow.this.updateTitle(activeView);
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                } else {
                    NbMainWindow.this.updateTitle(view);
                }
                NbMainWindow.this.deactivateDynamicMenu();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Editor activeEditor = EditorManager.getEditorManager().getCurrentEditor();
                        if (activeEditor != null) {
                            if (Ide.getMainWindow().getLastActiveView() != view) {
                                return;
                            }
                            Object editorAttribute = activeEditor.getEditorAttribute("old_editor");
                            if (!Boolean.TRUE.equals(editorAttribute)) {
                                NbMainWindow.this.activateDynamicMenu(view);
                            }
                        }
                    }
                });
            }
        });
    }

    private void initDialogSize() {
        IdeProperties properties = Ide.getIdeProperties();
        String dialogWidth = properties.getProperty("Ide.DefaultDialogWidth", "700");
        String dialogHeight = properties.getProperty("Ide.DefaultDialogHeight", "500");
        try {
            int width = Integer.parseInt(dialogWidth);
            width = Math.max(width, 600);
            width = Math.min(width, 1200);
            int height = Integer.parseInt(dialogHeight);
            height = Math.max(height, 400);
            height = Math.min(height, 800);
            TDialogLauncher.setPreferredDefaultInitialSize((Dimension)new Dimension(width, height));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    protected void postInitialize(IdeArgs ideArgs) {
        ActionRegistry.getActionRegistry().initAfterMainWindowOpened();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                View.loadManifestToolbar((String)"javax.ide.view.MAIN_WINDOW_TOOLBAR_ID", (oracle.ide.controls.Toolbar)NbMainWindow.this.getIdeMainWindowView().getToolbar());
            }
        });
        ((NbDockStation)NbDockStation.getDockStation()).initFactories();
    }

    void postWindowManagerInit() {
        this.updateStatusBarAction();
        MenuWarmUpTask.initialize(this);
        try {
            new SwingClosure(true){

                protected void runImpl() throws Exception {
                    try {
                        if (NbMainWindow.this.memoryMonitor != null) {
                            NbMainWindow.this.memoryMonitor.startMonitor();
                        }
                        if (NbMainWindow.isViewTrackingEnabled()) {
                            NbMainWindow.this.currentViewLabel = new JLabel();
                            NbMainWindow.this.getStatusBar().getGUI().add(NbMainWindow.this.currentViewLabel);
                        }
                    }
                    catch (Throwable e) {
                        NbMainWindow.this.processThrowable(e);
                    }
                }
            }.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.fireIdeActivated();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        block11: {
            Component newFocusOwner;
            block14: {
                boolean activeModal;
                TopComponent tc;
                block13: {
                    boolean newFocusOwnerModal;
                    boolean activeTcModal;
                    block12: {
                        block10: {
                            Component viewComp;
                            if (!"activated".equals(evt.getPropertyName())) break block10;
                            final TopComponent tc2 = TopComponent.getRegistry().getActivated();
                            if (tc2 != null && ((viewComp = this.getLastActiveViewComponent()) == null || tc2 != viewComp && !tc2.isAncestorOf(viewComp))) {
                                View view = NbView.toView(tc2);
                                if (view instanceof NbView) {
                                    this.setActiveView(view);
                                } else if (view != null) {
                                    final View outsideView = this.getLastActiveView();
                                    final Runnable r = new Runnable(){

                                        @Override
                                        public void run() {
                                            if (tc2 == TopComponent.getRegistry().getActivated() && outsideView == NbMainWindow.this.getLastActiveView()) {
                                                View view = NbView.toView(tc2);
                                                if (view == null) {
                                                    return;
                                                }
                                                Component gui = view.getGUI();
                                                Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
                                                boolean alreadyHasFocus = false;
                                                if (focused != null && gui != null) {
                                                    alreadyHasFocus = SwingUtilities.isDescendingFrom(focused, gui);
                                                }
                                                if (!alreadyHasFocus) {
                                                    GraphicsUtils.focusComponentOrChild((Component)NbView.toView(tc2).getGUI(), (boolean)true);
                                                }
                                            }
                                        }
                                    };
                                    java.util.Timer timer = new java.util.Timer();
                                    TimerTask tt = new TimerTask(){

                                        @Override
                                        public void run() {
                                            SwingUtilities.invokeLater(r);
                                        }
                                    };
                                    timer.schedule(tt, 100L);
                                }
                            }
                            break block11;
                        }
                        if (!"focusOwner".equals(evt.getPropertyName()) || !(evt.getNewValue() instanceof Component)) break block11;
                        newFocusOwner = (Component)evt.getNewValue();
                        TopComponent tcForRunnable = tc = TopComponent.getRegistry().getActivated();
                        activeTcModal = SwingUtilities.getAncestorOfClass(NbMainWindow.class, (Component)tc) == null || SwingUtilities.getAncestorOfClass(JDialog.class, (Component)tc) != null;
                        boolean bl = newFocusOwnerModal = SwingUtilities.getAncestorOfClass(NbMainWindow.class, newFocusOwner) == null || SwingUtilities.getAncestorOfClass(JDialog.class, newFocusOwner) != null;
                        if (tc == null || tc != newFocusOwner && !tc.isAncestorOf(newFocusOwner)) break block12;
                        JDevTopComponent.activateTCWithoutFocusIfPossible(tc);
                        this.setActiveViewForFocusOwner(newFocusOwner);
                        break block11;
                    }
                    if (tc == null || tc.isAncestorOf(newFocusOwner) || !activeTcModal || newFocusOwnerModal) break block13;
                    final Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            Component nfc = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
                            Component permamentNfc = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                            if (nfc == null || permamentNfc != nfc) {
                                return;
                            }
                            NbMainWindow.this.setActiveViewForFocusOwner(nfc);
                        }
                    };
                    java.util.Timer timer = new java.util.Timer();
                    TimerTask tt = new TimerTask(){

                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(r);
                        }
                    };
                    timer.schedule(tt, 200L);
                    break block11;
                }
                if (newFocusOwner instanceof TopComponent && newFocusOwner.isFocusable()) {
                    return;
                }
                tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, newFocusOwner);
                TopComponent activeTc = TopComponent.getRegistry().getActivated();
                boolean bl = activeModal = SwingUtilities.getAncestorOfClass(NbMainWindow.class, (Component)activeTc) == null || SwingUtilities.getAncestorOfClass(JDialog.class, (Component)activeTc) != null;
                if (activeModal && activeTc != null && !activeTc.isAncestorOf(newFocusOwner)) {
                    return;
                }
                if ((null == tc || !tc.isShowing()) && (tc != null || this.findView(newFocusOwner) == null)) break block11;
                if (newFocusOwner == DefaultFocusManager.getCurrentManager().getPermanentFocusOwner() || this.findView(newFocusOwner) == Ide.getMainWindow().getIdeMainWindowView() || tc == null && this.findView(newFocusOwner) != null && !Ide.getMainWindow().isAncestorOf(newFocusOwner)) break block14;
                if (tc == null || !tc.isAncestorOf(newFocusOwner) || !newFocusOwner.isShowing() || !(tc instanceof NbEditorContainer)) break block11;
                if (tc == tc.getRegistry().getActivated()) break block11;
            }
            this.setActiveViewForFocusOwner(newFocusOwner);
        }
    }

    public void updateTitle(View view) {
        this.setTitle(this.getTitleProvider().getTitle(view));
    }

    public void setTitle(String title) {
        if (title != null && title.startsWith("netbeans-platform")) {
            return;
        }
        super.setTitle(title);
    }

    public void addNotify() {
        super.addNotify();
        if (!this.winsysShowing) {
            Preferences prefs = this.getPreferences().node("mainwnd");
            int frameState = prefs.getInt("state", 0);
            super.setExtendedState(frameState);
        }
    }

    protected void initGeometry() {
        this.setMinimumSize(new Dimension(400, 300));
        Preferences prefs = this.getPreferences().node("mainwnd");
        int frameState = prefs.getInt("state", 0);
        int x = prefs.getInt("x", -1);
        int y = prefs.getInt("y", -1);
        int width = prefs.getInt("width", -1);
        int height = prefs.getInt("height", -1);
        boolean center = width < 0 || height < 0;
        Rectangle r = NbMainWindow.computeBounds(center, center, x, y, width, height, -1.0f, -1.0f, 0.9f, 0.9f);
        super.setBounds(r);
        super.setExtendedState(frameState);
    }

    public void setBounds(Rectangle r) {
        if (!this.winsysShowing) {
            return;
        }
        super.setBounds(r);
    }

    public void setExtendedState(int state) {
        if (!this.winsysShowing) {
            return;
        }
        super.setExtendedState(state);
    }

    public void close() {
        super.close();
    }

    public void terminate() {
    }

    public synchronized void addControllerProvider(Component component, ControllerProvider controllerProvider) {
        this.componentToControllerProvider.put(component, controllerProvider);
    }

    public synchronized void removeControllerProvider(Component component) {
        this.componentToControllerProvider.remove(component);
    }

    public List<ControllerProvider> getControllerProviders(View view) {
        ArrayList<ControllerProvider> retControllerStack;
        ArrayList<ControllerProvider> cachedControllerStack;
        if (this.DEBUG) {
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Controler providers - Current View: " + view.getId());
        }
        if ((cachedControllerStack = null) == null) {
            retControllerStack = null;
            WeakReference<Component> vRef = this.viewToComponent.get(view);
            if (this.DEBUG) {
                System.out.println(">>>>Registry<<<");
                System.out.println("Registered view to components: ");
                for (View view_ : this.viewToComponent.keySet()) {
                    Component c = (Component)this.viewToComponent.get(view_).get();
                    if (c == null) {
                        System.out.println(">View: " + view_ + " Component: is NULL");
                        continue;
                    }
                    System.out.println(">View: " + view_ + " Component: " + c.getClass() + " Hash: " + c.hashCode());
                }
                System.out.println("Registered components to view: ");
                for (Component c : this.componentToView.keySet()) {
                    View view_ = (View)this.componentToView.get(c).get();
                    if (view_ == null) {
                        System.out.println(">Component: " + c.getClass() + " View: is NULL");
                        continue;
                    }
                    System.out.println(">Component: " + c.getClass() + " Hash: " + c.hashCode() + " View: " + view_.getId());
                }
                System.out.println("Registered controllers: ");
                for (Component c : this.componentToControllerProvider.keySet()) {
                    ControllerProvider controller = this.componentToControllerProvider.get(c);
                    if (controller == null) {
                        System.out.println(">Component: " + c.getClass() + " Controller: is NULL");
                        continue;
                    }
                    System.out.println(">Component: " + c.getClass() + " Hash: " + c.hashCode() + " Controller: " + controller);
                }
                System.out.println(">>>>End of Registry<<<");
            }
            Component currentLevel = vRef != null && vRef.get() != null ? (Component)vRef.get() : this.getIdeMainWindowView().getGUI();
            for (currentLevel = currentLevel.getParent(); currentLevel != null; currentLevel = currentLevel.getParent()) {
                ControllerProvider controllerProvider;
                if (this.DEBUG) {
                    System.out.println("Current component level: " + currentLevel.getClass() + " Hash: " + currentLevel.hashCode());
                }
                if ((controllerProvider = this.componentToControllerProvider.get(currentLevel)) == null) {
                    WeakReference<View> cpRef = this.componentToView.get(currentLevel);
                    View view2 = controllerProvider = cpRef != null ? (View)cpRef.get() : null;
                }
                if (controllerProvider == null) continue;
                if (retControllerStack == null) {
                    retControllerStack = new ArrayList<ControllerProvider>(2);
                }
                retControllerStack.add(controllerProvider);
                if (!this.DEBUG) continue;
                System.out.println("SUMMARY: Controller found: " + controllerProvider + " Component: " + currentLevel.getClass() + " Hash: " + currentLevel.hashCode());
            }
            if (retControllerStack == null) {
                retControllerStack = Collections.EMPTY_LIST;
            }
        } else {
            retControllerStack = cachedControllerStack;
        }
        if (this.DEBUG) {
            if (retControllerStack == null || retControllerStack == null) {
                System.out.println("SUMMARY: No Controler found for view:" + view);
            } else {
                for (ControllerProvider controller : retControllerStack) {
                    System.out.println("SUMMARY: Controller found: " + controller);
                }
            }
        }
        return retControllerStack;
    }

    protected View createIdeMainWindowView() {
        return new MainWindowView("MainWindow");
    }

    protected WindowListener getWindowListener() {
        return null;
    }

    protected StatusBar createStatusBar() {
        StatusBarControl sb = new StatusBarControl(){
            StatusDisplayer.Message message = null;

            public void setText(String text) {
                this.message = StatusDisplayer.getDefault().setStatusText(text, 3);
            }

            public String getText() {
                String s = StatusDisplayer.getDefault().getStatusText();
                return null == s || s.equals(" ") ? "" : s;
            }
        };
        String property = Ide.getProperty((String)"MainWindow.MemoryMonitorOn");
        String systemProperty = System.getProperty("MainWindow.MemoryMonitorOn");
        if ("1".equals(systemProperty) || "on".toLowerCase().equals(systemProperty)) {
            systemProperty = "true";
        }
        if (Version.DEBUG_BUILD == 1 || Boolean.valueOf(property).booleanValue() || Boolean.valueOf(systemProperty).booleanValue()) {
            this.memoryMonitor = new MemoryMonitor((StatusBar)sb);
        }
        return sb;
    }

    public String getName() {
        WindowManagerStartingController controller = NbWindowManagerStartingController.getInstance();
        if (controller != null && !controller.isStarting() && !GraphicsEnvironment.isHeadless()) {
            return "main-window";
        }
        return "NbMainWindow";
    }

    public void beforeShutDown() {
        this.terminateIde();
        Beans.setDesignTime(false);
        LazyIconsCacheUtil.saveIconCache();
        LifecycleManager.getDefault().exit();
    }

    public void beforeShutDown(int status) {
        this.terminateIde();
        Beans.setDesignTime(false);
        LazyIconsCacheUtil.saveIconCache();
        LifecycleManager.getDefault().exit(status);
    }

    public void updateTitle() {
        this.updateTitle(this.getLastActiveView());
    }

    private static Rectangle computeBounds(boolean centeredHorizontaly, boolean centeredVerticaly, int x, int y, int width, int height, float relativeX, float relativeY, float relativeWidth, float relativeHeight) {
        Rectangle screen;
        Rectangle bounds;
        if (width > 0 && height > 0) {
            bounds = new Rectangle(x, y, width, height);
            screen = Utilities.getUsableScreenBounds();
            int xlimit = screen.x + screen.width - 20;
            int ylimit = screen.y + screen.height - 20;
            if (NbMainWindow.isOutOfScreen(bounds.x, bounds.y)) {
                while (bounds.x > xlimit) {
                    bounds.x = Math.max(bounds.x - screen.width, screen.x);
                }
                while (bounds.y > ylimit) {
                    bounds.y = Math.max(bounds.y - ylimit, screen.y);
                }
            }
        } else if (relativeWidth > 0.0f && relativeHeight > 0.0f) {
            screen = Utilities.getUsableScreenBounds();
            bounds = new Rectangle((int)((float)screen.width * relativeX), (int)((float)screen.height * relativeY), (int)((float)screen.width * relativeWidth), (int)((float)screen.height * relativeHeight));
        } else {
            return null;
        }
        if (centeredHorizontaly || centeredVerticaly) {
            Rectangle centered = Utilities.findCenterBounds((Dimension)new Dimension(bounds.width, bounds.height));
            if (centeredHorizontaly) {
                bounds.x = centered.x;
            }
            if (centeredVerticaly) {
                bounds.y = centered.y;
            }
        }
        return bounds;
    }

    private static boolean isOutOfScreen(int x, int y) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        for (int j = 0; j < gs.length; ++j) {
            Rectangle bounds;
            GraphicsDevice gd = gs[j];
            if (gd.getType() != 0 || !(bounds = gd.getDefaultConfiguration().getBounds()).contains(x, y)) continue;
            return false;
        }
        return true;
    }

    private void updateStatusBar(View view) {
        JComponent gui = Ide.getStatusBar().getGUI();
        if (gui == null || !gui.isVisible()) {
            return;
        }
        if (this.dynamicStatusProvider != null) {
            this.dynamicStatusProvider.removeChangeListener((ChangeListener)this.statusListener);
            this.dynamicStatusProvider = null;
        }
        StatusBarControl statusBar = (StatusBarControl)this.getStatusBar();
        if (view instanceof StatusProvider) {
            int i;
            boolean reset;
            StatusProvider provider = (StatusProvider)view;
            JComponent[] cells = provider.getCustomCells();
            int count = cells != null ? cells.length : 0;
            boolean bl = reset = count != statusBar.getStatusCount();
            if (!reset) {
                for (i = 0; i < count; ++i) {
                    if (statusBar.containsStatusItem(cells[i])) continue;
                    reset = true;
                    break;
                }
            }
            if (reset) {
                statusBar.resetStatus();
                for (i = 0; i < count; ++i) {
                    statusBar.add(cells[i]);
                    statusBar.setExpandable(cells[i], provider.isExpandable(cells[i]));
                }
                statusBar.getGUI().repaint();
            }
            if (view instanceof DynamicStatusProvider) {
                this.dynamicStatusProvider = (DynamicStatusProvider)view;
                this.dynamicStatusProvider.addChangeListener((ChangeListener)this.statusListener);
            }
        } else {
            if (view != null) {
                ViewId id = new ViewId(view.getId());
                String type = id.getType();
                if ("ComponentPalette".equals(type) || "InspectorWindow".equals(type)) {
                    return;
                }
                if (this.statusDetractors.contains(view.getClass().getName())) {
                    return;
                }
            }
            statusBar.resetStatus();
            statusBar.getGUI().repaint();
        }
    }

    private TitleProvider getTitleProvider() {
        LazyClassAdapter adapter;
        TitleProvider provider;
        HashStructure productHook;
        if (this.titleProvider != null) {
            return this.titleProvider;
        }
        ProductInformation pi = ProductInformation.getProductInformation();
        if (pi != null && (productHook = pi.getHashStructure()) != null && (provider = (TitleProvider)(adapter = LazyClassAdapter.getInstance((HashStructure)productHook)).createInstance(TitleProvider.class, "main-window/title-provider-class/#text")) != null) {
            this.titleProvider = provider;
            return provider;
        }
        this.titleProvider = new DefaultTitleProvider((IdeMainWindow)this);
        return this.titleProvider;
    }

    private void deactivateDynamicMenu() {
        if (this.dynamicMenusAreHidden()) {
            return;
        }
        if (this._deactivatingDynMenu || this._activatingDynMenu) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (NbMainWindow.this._dynamicMenu != null) {
                    NbMainWindow.this._deactivatingDynMenu = true;
                    if (!PlatformUtils.isMac()) {
                        NbMainWindow.this._dynamicMenu.setVisible(false);
                    }
                    if (NbMainWindow.this._dynamicPlaceholderItem == null) {
                        NbMainWindow.this._dynamicPlaceholderItem = new JMenuItem(IdeArb.getString((int)530));
                        NbMainWindow.this._dynamicPlaceholderItem.setEnabled(false);
                    }
                    NbMainWindow.this.getMenubar().getGUI(false).validate();
                    NbMainWindow.this._dynamicMenu.removeAll();
                    NbMainWindow.this.getMenubar().add((Component)NbMainWindow.this._dynamicPlaceholderItem, NbMainWindow.this._dynamicMenu);
                    NbMainWindow.this._deactivatingDynMenu = false;
                }
            }
        });
    }

    private boolean dynamicMenusAreHidden() {
        return NbEditorManager.getEditorManagerOption(8);
    }

    private void activateDynamicMenu(View view) {
        if (this.dynamicMenusAreHidden()) {
            return;
        }
        if (this._deactivatingDynMenu || this._activatingDynMenu) {
            return;
        }
        String viewName = this.getViewAttribute(view);
        if (viewName == null) {
            return;
        }
        ArrayList<JComponent> commandList = new ArrayList<JComponent>();
        this._activatingDynMenu = true;
        Context ctxt = view.getContext();
        for (DynamicMenuListener ml : this.dml) {
            try {
                JComponent[] menuItems = ml.gatherDynamicActions(ctxt);
                if (menuItems == null || menuItems.length <= 0) continue;
                ArrayList<JComponent> commands = new ArrayList<JComponent>();
                for (int x = 0; x < menuItems.length; ++x) {
                    commands.add(menuItems[x]);
                }
                this.ensureItemsAreWeighted(commands);
                commandList.addAll(commands);
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        String label = StringUtils.stripMnemonic((String)viewName);
        int mnemonic = StringUtils.getMnemonicKeyCode((String)viewName);
        if (this._dynamicMenu == null) {
            this._dynamicMenu = this.getMenubar().createMenu(label, Integer.valueOf(mnemonic), MenuConstants.WEIGHT_DYNAMIC_MENU);
        }
        if (this._dynamicPlaceholderItem != null) {
            this.getMenubar().remove((Component)this._dynamicPlaceholderItem, this._dynamicMenu);
        }
        this._dynamicMenu.setText(label);
        this._dynamicMenu.setMnemonic(mnemonic);
        if (commandList.size() > 0) {
            Collections.sort(commandList, new MenuWeightComparator());
            float section = 1.0f;
            Iterator menuItems = commandList.iterator();
            while (menuItems.hasNext()) {
                JComponent comp = (JComponent)menuItems.next();
                if (comp instanceof JSeparator) {
                    menuItems.remove();
                    section = MenuConstants.increment((float)section);
                    continue;
                }
                this.getMenubar().add((Component)comp, this._dynamicMenu, section);
            }
        }
        this.addEditorMenuHookItems(this._dynamicMenu, view);
        if (this._dynamicMenu.getItemCount() > 0) {
            if (this.getMenubar().contains((Component)this._dynamicMenu)) {
                if (!PlatformUtils.isMac()) {
                    this._dynamicMenu.setVisible(true);
                }
            } else {
                this.getMenubar().add((Component)this._dynamicMenu);
            }
        }
        this._dynamicMenu.revalidate();
        this._activatingDynMenu = false;
    }

    private String getViewAttribute(View view) {
        Editor editor;
        String menuId;
        View editorView;
        for (editorView = view; !(editorView instanceof Editor) && editorView != null && editorView.owner() != null; editorView = editorView.owner()) {
        }
        if (editorView instanceof Editor && (menuId = (String)(editor = (Editor)editorView).getEditorAttribute("menu_id")) != null) {
            return menuId;
        }
        return null;
    }

    private void ensureItemsAreWeighted(ArrayList<JComponent> commands) {
        int size = commands.size();
        if (size == 0) {
            return;
        }
        HashMap<Integer, Float> weightsMap = this.getMarkers(commands);
        if (weightsMap.size() == 0) {
            return;
        }
        ArrayList<Integer> markers = new ArrayList<Integer>(weightsMap.keySet());
        Collections.sort(markers);
        int start = 0;
        for (Integer index : markers) {
            int end = index;
            for (int i = start; i < end; ++i) {
                commands.get(i).putClientProperty("menu-weight", weightsMap.get(index));
            }
            start = end + 1;
        }
        int lastIndex = size - 1;
        int finalMarker = markers.get(markers.size() - 1);
        if (finalMarker < lastIndex) {
            for (int i = finalMarker + 1; i <= lastIndex; ++i) {
                commands.get(i).putClientProperty("menu-weight", weightsMap.get(finalMarker));
            }
        }
    }

    private HashMap<Integer, Float> getMarkers(ArrayList<JComponent> list) {
        HashMap<Integer, Float> markers = new HashMap<Integer, Float>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Float weight = (Float)list.get(i).getClientProperty("menu-weight");
            if (weight == null) continue;
            markers.put(i, weight);
        }
        return markers;
    }

    private void addEditorMenuHookItems(JMenu menu, View view) {
        Context context = view.getContext();
        EditorMenuHook hook = (EditorMenuHook)ExtensionRegistry.getExtensionRegistry().getHook(EditorMenuHook.ELEMENT);
        hook.addMenuItems(menu, context);
    }

    private Preferences getPreferences() {
        RoleManager rm = ExtensionRegistry.getExtensionRegistry().getRoleManager();
        String role = rm.getActiveRole().getId();
        return NbPreferences.forModule(NbMainWindow.class).node(role);
    }

    void saveBounds() {
        Preferences prefs = this.getPreferences().node("mainwnd");
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        int frameState = wm.getMainWindowFrameStateJoined();
        Rectangle bounds = wm.getMainWindowBoundsJoined();
        prefs.putInt("state", frameState);
        prefs.putInt("x", bounds.x);
        prefs.putInt("y", bounds.y);
        prefs.putInt("width", bounds.width);
        prefs.putInt("height", bounds.height);
    }

    void processCommandLine() {
        try {
            this.processCommandLine(Ide.getIdeArgs());
        }
        catch (Exception exception) {
            this.processThrowable(exception);
        }
    }

    private void processThrowable(Throwable e) {
        if (e instanceof ThreadDeath) {
            e.printStackTrace();
            throw (ThreadDeath)e;
        }
        oracle.javatools.dialogs.ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)e);
    }

    private void fireIdeActivated() {
        if (this.DEBUG) {
            System.out.println("IDE ACTIVATE");
        }
        IdeActivationEvent event = new IdeActivationEvent();
        for (IdeActivationListener l : this.ial) {
            try {
                l.activated(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void fireIdeDeactivated() {
        IdeActivationEvent event = new IdeActivationEvent();
        if (this.DEBUG) {
            System.out.println("IDE DEACTIVATE");
        }
        for (IdeActivationListener l : this.ial) {
            try {
                l.deactivated(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setStatusBarVisible(boolean visible) {
        super.setStatusBarVisible(visible);
        this.updateStatusBarVisible(visible);
    }

    private void updateStatusBarVisible(boolean visible) {
        if (this.statusBarHolder == null) {
            for (Component c : this.getContentPane().getComponents()) {
                if (!(c instanceof Container) || !this.searchForStatusLine((Container)c)) continue;
                this.statusBarHolder = (Container)c;
                break;
            }
        }
        if (visible && this.statusBarHolder != null) {
            this.getContentPane().add((Component)this.statusBarHolder, "South");
        } else if (!visible && this.statusBarHolder != null) {
            this.getContentPane().remove(this.statusBarHolder);
        }
        Ide.getMainWindow().getContentPane().invalidate();
        Ide.getMainWindow().getContentPane().validate();
        Ide.getMainWindow().repaint();
    }

    private boolean searchForStatusLine(Container comp) {
        if (comp == null) {
            return false;
        }
        boolean isStatusLine = false;
        for (Component c : comp.getComponents()) {
            if (c != null && c.getClass().getName().endsWith("StatusLine")) {
                return true;
            }
            if (!(c instanceof Container)) continue;
            return this.searchForStatusLine((Container)c);
        }
        return isStatusLine;
    }

    private void enableMacOsFullScreenIfNecessary() {
        String os = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        if (!os.contains("OS X")) {
            return;
        }
        Integer ver = Integer.getInteger(osVersion);
        if (ver != null && (double)ver.intValue() < 10.7) {
            return;
        }
        try {
            Class<?> c = Class.forName("com.apple.eawt.FullScreenUtilities");
            Class[] p = new Class[]{Window.class, Boolean.TYPE};
            Method method = c.getMethod("setWindowCanFullScreen", p);
            method.invoke(c, Ide.getMainWindow(), true);
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.INFO, "OS X Fullscreen not supported", e);
        }
    }

    private void updateCurrentView(View view) {
        if (this.currentViewLabel == null) {
            return;
        }
        String viewID = view == null ? "no view" : view.getId();
        String trimmedText = NbMainWindow.trimmText(viewID, 120, this.currentViewLabel);
        this.currentViewLabel.setText(trimmedText);
        this.currentViewLabel.setToolTipText("Current view: " + viewID);
    }

    private static String trimmText(String text, int maxSize, JComponent comp) {
        int charSize;
        int aboveWidth;
        int toRemove;
        Font font;
        int stringWidth;
        if (text == null) {
            text = "";
        }
        if ((stringWidth = SwingUtilities2.getFontMetrics(comp, font = comp.getFont()).stringWidth(text)) > maxSize && (toRemove = (aboveWidth = stringWidth - maxSize) / (charSize = stringWidth / text.length())) > 4 && stringWidth > 10) {
            text = text.substring(0, text.length() - toRemove + 3) + "...";
        }
        return " |" + text + "| ";
    }

    public boolean isFullScreenMode() {
        MainWindow mainWindow = MainWindow.getInstance();
        return mainWindow.isFullScreenMode();
    }

    private static boolean isViewTrackingEnabled() {
        DEBUG_TRACE_VIEW_CHANGES = Boolean.valueOf(System.getProperty("DEBUG_TRACE_FOCUS_CHANGES"));
        return DEBUG_TRACE_VIEW_CHANGES;
    }

    private static void printViewInfo(String message, View view, boolean requestSpaceAfter) {
        if (NbMainWindow.isViewTrackingEnabled()) {
            String id = null;
            String viewClass = null;
            if (view == null) {
                id = "null";
                viewClass = "null";
            } else {
                id = view.getId();
                viewClass = view.getClass().getName();
            }
            System.out.println("> " + message + ": class: " + viewClass + " ID: " + id);
            if (requestSpaceAfter) {
                System.out.println("\n");
            }
        }
    }

    static {
        DEBUG_TRACE_VIEW_CHANGES = Boolean.valueOf(System.getProperty("DEBUG_TRACE_FOCUS_CHANGES"));
    }

    private class ApplicationSwitchListener
    implements AWTEventListener {
        private Object active;
        private Object inactive;
        private boolean deactivated;

        private ApplicationSwitchListener() {
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            try {
                int id = e.getID();
                Object source = e.getSource();
                switch (id) {
                    case 205: {
                        this.active = source;
                        if (NbMainWindow.this.DEBUG) {
                            System.out.println("On activation: active - " + this.active.getClass());
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!ApplicationSwitchListener.this.deactivated) {
                                    return;
                                }
                                ApplicationSwitchListener.this.deactivated = false;
                                NbMainWindow.this.fireIdeActivated();
                            }
                        });
                        return;
                    }
                    case 206: {
                        this.inactive = source;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (NbMainWindow.this.DEBUG) {
                                    System.out.println("On deactivation: inactive - " + ApplicationSwitchListener.this.inactive.getClass() + " hash " + ApplicationSwitchListener.this.inactive.hashCode());
                                    if (ApplicationSwitchListener.this.active != null) {
                                        System.out.println("On deactivation: active - " + ApplicationSwitchListener.this.active.getClass() + " hash " + ApplicationSwitchListener.this.active.hashCode());
                                    } else {
                                        System.out.println("On deactivation: active - NULL");
                                    }
                                    System.out.println("On deactivation: ! = inactive  - " + (ApplicationSwitchListener.this.active != ApplicationSwitchListener.this.inactive));
                                    System.out.println("On deactivation: ! = NbMainWindow.this  - " + (ApplicationSwitchListener.this.inactive != NbMainWindow.this));
                                    System.out.println("On deactivation: Main Window  - " + SwingUtils.getMainWindow().getClass());
                                }
                                if (ApplicationSwitchListener.this.active != ApplicationSwitchListener.this.inactive || ApplicationSwitchListener.this.inactive != NbMainWindow.this && !(ApplicationSwitchListener.this.inactive instanceof DefaultSeparateContainer.ModeUIBase)) {
                                    return;
                                }
                                ApplicationSwitchListener.this.deactivated = true;
                                NbMainWindow.this.fireIdeDeactivated();
                            }
                        });
                        return;
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class UpdateVisibleActions
    implements ActionListener {
        private static final int UPDATE_INTERVAL = 250;
        private static Timer _timer;
        private static UpdateMessage _updateMessage;
        private static int updateCount;

        private UpdateVisibleActions() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void scheduleUpdate(UpdateMessage updateMessage) {
            Class<UpdateVisibleActions> clazz = UpdateVisibleActions.class;
            synchronized (UpdateVisibleActions.class) {
                if (_timer == null) {
                    _timer = new Timer(250, new UpdateVisibleActions());
                    _timer.setRepeats(false);
                }
                _timer.restart();
                _updateMessage = updateMessage;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Class<UpdateVisibleActions> clazz = UpdateVisibleActions.class;
            synchronized (UpdateVisibleActions.class) {
                _timer = null;
                UpdateMessage updateMessage = _updateMessage;
                _updateMessage = null;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                this.fireUpdate(updateMessage);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireUpdate(UpdateMessage updateMessage) {
            ++updateCount;
            String ALL_ID = "IdeMainWindow.updateVisibleActions";
            String VIEW_ID = "IdeMainWindow.updateVisibleActions/view";
            IdeMainWindow mainWindow = Ide.getMainWindow();
            if (mainWindow != null) {
                for (View view : mainWindow.getVisibleViews()) {
                    if (view != mainWindow.getIdeMainWindowView()) {
                        view.updateVisibleActions(updateMessage);
                        continue;
                    }
                    if (Ide.isQuitting()) continue;
                    View.updateToolbarActions((oracle.ide.controls.Toolbar)view.getToolbar());
                }
            }
        }

        static {
            updateCount = 0;
        }
    }

    private final class StatusListener
    implements ChangeListener {
        private StatusListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() instanceof View) {
                return;
            }
            View view = (View)e.getSource();
            NbMainWindow.this.updateStatusBar(view);
            NbMainWindow.this.updateTitle(view);
        }
    }

    class MainWindowView
    extends View {
        private oracle.ide.controls.Toolbar toolbar;

        MainWindowView(String id) {
            super(id);
        }

        public void close() {
            NbMainWindow.this.terminate();
        }

        public void show() {
            NbMainWindow.this.setVisible(true);
        }

        public void updateTitle(Object ctx) {
            if (ctx instanceof View) {
                NbMainWindow.this.updateTitle((View)ctx);
            }
        }

        public boolean isVisible() {
            return NbMainWindow.this.isVisible();
        }

        public Component getGUI() {
            return NbMainWindow.this;
        }

        public void updateVisibleActions(UpdateMessage updateMessage) {
            try {
                UpdateVisibleActions.scheduleUpdate(updateMessage);
            }
            catch (Exception e) {
                ExceptionDialog.showExceptionDialog((Window)((Object)NbMainWindow.this), (Exception)e);
            }
        }

        public oracle.ide.controls.Toolbar getToolbar() {
            if (this.toolbar == null) {
                final NbToolbarsFS fs = (NbToolbarsFS)Lookup.getDefault().lookup(NbToolbarsFS.class);
                NbToolbar nb = null;
                final NbToolbar[] nbWrapper = new NbToolbar[1];
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        nbWrapper[0] = new NbToolbar(fs);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    r.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(r);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                nb = nbWrapper[0];
                if (nb == null) {
                    nb = new NbToolbar(fs);
                }
                ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
                MenuHook mh = (MenuHook)er.getHook(MenuHook.ELEMENT);
                Toolbar modelToolbar = (Toolbar)mh.getModel().getToolbars().get("javax.ide.view.MAIN_WINDOW_TOOLBAR_ID");
                fs.assignModel((SectionContainer)modelToolbar);
                this.toolbar = nb;
            }
            return this.toolbar;
        }

        public void setToolbarVisible(boolean visible) {
            ToolbarPool toolbar = ToolbarPool.getDefault();
            if (toolbar != null) {
                toolbar.setVisible(visible);
                this.getToolbar().setVisible(visible);
                Ide.setProperty((String)"MainWindow.Toolbar.visible", (String)(visible ? "TRUE" : "FALSE"));
            }
        }
    }
}

