/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import com.oracle.jdeveloper.nbwindowsystem.NbMainWindow;
import com.oracle.jdeveloper.nbwindowsystem.NbMenuBarFS;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ideimpl.IdeMenus;
import oracle.ideimpl.extension.OldStyleMenuUtil;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;

final class NbMenubar
extends Menubar
implements PopupMenuListener,
MenuListener {
    private static final Logger LOG = Logger.getLogger(NbMenubar.class.getName());
    private static final ThreadLocal<List<Component>> SORT = new ThreadLocal();
    private static final float MENU_VIEW_OLD_STYLE_SECTION = 0.5f;
    private final NbMainWindow mw;
    private final NbMenuBarFS fs;
    private List<NbMenu> menus;

    public NbMenubar(NbMainWindow mw, NbMenuBarFS fs) {
        this.mw = mw;
        this.fs = fs;
        this.menus = new ArrayList<NbMenu>();
        this.fs.assignMenuBar(this);
    }

    final List<NbMenu> menus() {
        return Collections.unmodifiableList(this.menus);
    }

    public boolean contains(Component component) {
        return this.menus.contains(component);
    }

    public Container getGUI(boolean bln) {
        return this.mw.getJMenuBar();
    }

    public void add(Component child) {
        LOG.log(Level.FINE, "add: {0}", child);
        if (child instanceof NbMenu) {
            NbMenu nbm = (NbMenu)child;
            nbm.init();
            this.menus.add(nbm);
            this.fs.refresh(true);
            return;
        }
        super.add(child);
    }

    public void add(Component child, float sectionId) {
        LOG.log(Level.FINE, "add: {0} sectionId: {1}", new Object[]{child, Float.valueOf(sectionId)});
        if (child instanceof NbMenu) {
            NbMenu nbm = (NbMenu)child;
            nbm.init();
            this.menus.add(nbm);
            this.fs.refresh(true);
            return;
        }
        super.add(child, sectionId);
    }

    public void add(Component child, JMenu parent) {
        LOG.log(Level.FINE, "add: {0} parent: {1}", new Object[]{child, parent});
        if (NbMenubar.isSpecial(parent)) {
            NbMenu m = (NbMenu)parent;
            m.addChild(child);
            this.fs.refresh(true);
            return;
        }
        super.add(child, parent);
    }

    public void add(Component child, JMenu parent, float sectionId) {
        LOG.log(Level.FINE, "add: {0} parent: {1} sectionId: {2}", new Object[]{child, parent, Float.valueOf(sectionId)});
        JMenu newParent = this.oldStyleMenuShaping(parent, sectionId);
        if (newParent != parent) {
            parent = newParent;
            sectionId = 0.5f;
        }
        if (NbMenubar.isSpecial(parent)) {
            NbMenu m = (NbMenu)parent;
            ((JComponent)child).putClientProperty("menu-section-id", Float.valueOf(sectionId));
            m.addChild(child);
            this.fs.refresh(true);
            return;
        }
        if (null == parent) {
            LOG.log(Level.INFO, "null parent when adding child: {0} sectionId: {1}", new Object[]{child, Float.valueOf(sectionId)});
            return;
        }
        super.add(child, parent, sectionId);
    }

    final boolean isMenuCmpAccepted(Component c) {
        return super.isMenuComponentAccepted(c);
    }

    protected void applyGlobalFilterImpl(MenuFilter filter) {
        super.applyGlobalFilterImpl(filter);
        this.fs.refresh(true);
    }

    protected void clearGlobalFilterImpl() {
        super.clearGlobalFilterImpl();
        this.fs.refresh(true);
    }

    public JMenu createMenu(String caption, Integer mnemonic) {
        LOG.log(Level.FINE, "createMenu {0} mnemonic: {1}", new Object[]{caption, mnemonic});
        return new NbMenu(caption, mnemonic, null, null, false);
    }

    public JMenu createMenu(String caption, float weight, float addinSectionId) {
        LOG.log(Level.FINE, "createMenu: {0} weight: {1} addinSectionId: {2}", new Object[]{caption, Float.valueOf(weight), Float.valueOf(addinSectionId)});
        return new NbMenu(caption, null, Float.valueOf(weight), Float.valueOf(addinSectionId), false);
    }

    public JMenu createMenu(String caption, Integer mnemonic, float weight) {
        LOG.log(Level.FINE, "createMenu: {0} weight: {1} mnemonic: {2}", new Object[]{caption, Float.valueOf(weight), mnemonic});
        return new NbMenu(caption, mnemonic, Float.valueOf(weight), null, false);
    }

    public JMenu createMenu(String caption, float weight) {
        LOG.log(Level.FINE, "createMenu: {0} weight: {1}", new Object[]{caption, Float.valueOf(weight)});
        return new NbMenu(caption, null, Float.valueOf(weight), null, false);
    }

    public JMenu createMenu(String caption, Integer mnemonic, float weight, float addinSectionId) {
        LOG.log(Level.FINE, "createMenu: {0} weight: {1} mnemonic {2} addinSectionId: {3}", new Object[]{caption, Float.valueOf(weight), mnemonic, Float.valueOf(addinSectionId)});
        return new NbMenu(caption, mnemonic, Float.valueOf(weight), Float.valueOf(addinSectionId), false);
    }

    public JMenuItem createMenuItem(ToggleAction action) {
        LOG.log(Level.FINE, "createMenuItem: {0}", action);
        return super.createMenuItem(action);
    }

    public JMenuItem createMenuItem(ToggleAction action, float menuWeight) {
        LOG.log(Level.FINE, "createMenuItem: {0} menuWeight: {1}", new Object[]{action, Float.valueOf(menuWeight)});
        return super.createMenuItem(action, menuWeight);
    }

    public JMenu createSubMenu(String caption, Integer mnemonic) {
        LOG.log(Level.FINE, "createSubMenu: {0} mnemonic: {1}", new Object[]{caption, mnemonic});
        return new NbMenu(caption, mnemonic, null, null, true);
    }

    public JMenu createSubMenu(String caption, Integer mnemonic, float weight) {
        LOG.log(Level.FINE, "createSubMenu: {0} mnemonic:{1} weight: {2}", new Object[]{caption, mnemonic, Float.valueOf(weight)});
        return new NbMenu(caption, mnemonic, Float.valueOf(weight), null, true);
    }

    public JMenu createSubMenu(String caption, Integer mnemonic, float weight, float sectionId) {
        LOG.log(Level.FINE, "createSubMenu: {0} mnemonic:{1} weight: {2} sectionId: {3}", new Object[]{caption, mnemonic, Float.valueOf(weight), Float.valueOf(sectionId)});
        return new NbMenu(caption, mnemonic, Float.valueOf(weight), Float.valueOf(sectionId), true);
    }

    public Component getChildById(Container parent, int commandId) {
        return super.getChildById(parent, commandId);
    }

    public final ContainerListener getContainerListener() {
        return super.getContainerListener();
    }

    public int getIndexOfChild(Container parent, Component child) {
        return super.getIndexOfChild(parent, child);
    }

    public int getIndexOfCommandId(Container parent, int commandId) {
        return super.getIndexOfCommandId(parent, commandId);
    }

    public int getKeyboardMnemonic(String menuLabel, Integer mnemonic) {
        return super.getKeyboardMnemonic(menuLabel, mnemonic);
    }

    public Float lookupMenuSection(String menuId, String sectionId) {
        return super.lookupMenuSection(menuId, sectionId);
    }

    protected void registerFilterContainerListener(JMenu menu) {
        super.registerFilterContainerListener(menu);
    }

    public void remove(Component child) {
        super.remove(child);
    }

    public void removeAll(JMenu parent) {
        super.removeAll(parent);
    }

    public void remove(Component child, JMenu parent) {
        LOG.log(Level.FINE, "remove: {0} parent: {1}", new Object[]{child, parent});
        if (NbMenubar.isSpecial(parent)) {
            NbMenu m = (NbMenu)parent;
            m.removeChild(child);
            this.fs.refresh(true);
            return;
        }
        super.remove(child, parent);
    }

    public void removeMenuFilter(MenuFilter menuFilter) {
        super.removeMenuFilter(menuFilter);
    }

    public void removeMenuManagerMenuListener(JMenu menu) {
        super.removeMenuManagerMenuListener(menu);
    }

    protected void setWeight(Component component, float weight, String weightId) {
        super.setWeight(component, weight, weightId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortContainer(Container container) {
        if (container.getClass().getName().equals("org.openide.awt.MenuBar$LazyMenu")) {
            return;
        }
        List<Component> prev = SORT.get();
        try {
            SORT.set(null);
            if (NbMenubar.isSpecial(container)) {
                ((NbMenu)container).children();
                return;
            }
            this.sortContainerOld(container);
        }
        finally {
            SORT.set(prev);
        }
    }

    final void sortContainerOld(Container container) {
        super.sortContainer(container);
    }

    static boolean isSpecial(Component jm) {
        if (jm instanceof NbMenu) {
            if (NbMenubar.isDirect((JMenu)jm)) {
                return false;
            }
            return ((NbMenu)jm).children != null;
        }
        return false;
    }

    static boolean isDirect(JMenu m) {
        if (m instanceof NbMenu) {
            NbMenu nb = (NbMenu)m;
            return nb.submenu;
        }
        return true;
    }

    void attachMenuAndPopupListeners(JMenuBar bar) {
        int cnt = bar.getMenuCount();
        for (int i = 0; i < cnt; ++i) {
            JMenu m = bar.getMenu(i);
            if (m == null) continue;
            m.addMenuListener(this);
            m.getPopupMenu().addPopupMenuListener(this);
        }
    }

    private NbMenu findMenu(Object source) {
        JMenu menu;
        if (source instanceof JPopupMenu) {
            JPopupMenu pm = (JPopupMenu)source;
            menu = (JMenu)pm.getInvoker();
        } else {
            menu = (JMenu)source;
        }
        for (NbMenu nbMenu : this.menus) {
            if (nbMenu.getText().equals(menu.getText())) {
                return nbMenu;
            }
            if (!menu.getText().equals(nbMenu.getClientProperty("oide.menu.id"))) continue;
            return nbMenu;
        }
        throw new IllegalStateException("Cannot find menu for " + source);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        for (PopupMenuListener l : this.findMenu(e.getSource()).getPopupMenu().getPopupMenuListeners()) {
            l.popupMenuWillBecomeVisible(e);
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        for (MenuListener l : this.findMenu(e.getSource()).getMenuListeners()) {
            l.menuSelected(e);
        }
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    private JMenu oldStyleMenuShaping(JMenu parent, float sectionId) {
        OldStyleMenuUtil oldStyleMenuUtil = OldStyleMenuUtil.getInstance();
        if (oldStyleMenuUtil == null || !oldStyleMenuUtil.isOldStyleMenu() || parent != IdeMenus.findOrCreateJMenu((String)"Window") || sectionId != 2.0f) {
            return parent;
        }
        JMenu viewMenu = IdeMenus.findOrCreateJMenu((String)"View");
        this.sortSectionByName(viewMenu, 0.5f);
        return viewMenu;
    }

    final class NbMenu
    extends JMenu {
        final boolean submenu;
        private List<Component> children;
        private List<Component> sorted;

        private NbMenu(String caption, Integer mnemonic, Float weight, Float addinSectionId, boolean submenu) {
            this.submenu = submenu;
            if (mnemonic != null && mnemonic > 32) {
                this.setText(Actions.cutAmpersand((String)caption));
                this.setMnemonic(mnemonic);
            } else {
                Mnemonics.setLocalizedText((AbstractButton)this, (String)caption);
            }
            MenuManager.CustomMenu.updateMnemonic((JMenu)this, (Integer)mnemonic);
            this.putClientProperty("menu-section-id", addinSectionId);
            this.putClientProperty("menu-weight", weight);
            NbMenubar.this.addMenuManagerAsListener(this);
        }

        final void init() {
            if (this.children != null) {
                return;
            }
            List<Component> arr = Arrays.asList(super.getMenuComponents());
            this.children = new ArrayList<Component>();
            this.children.addAll(arr);
            if (!arr.isEmpty()) {
                this.clearSorted();
            }
        }

        final void addChild(Component mi) {
            this.children.add(mi);
            this.clearSorted();
            if (mi instanceof NbMenu) {
                ((NbMenu)mi).init();
            }
        }

        private void removeChild(Component child) {
            this.children.remove(child);
            this.clearSorted();
        }

        @Override
        public Component[] getMenuComponents() {
            if (NbMenubar.isSpecial(this)) {
                return this.children.toArray(new Component[0]);
            }
            return super.getMenuComponents();
        }

        @Override
        public int getMenuComponentCount() {
            return this.getMenuComponents().length;
        }

        @Override
        public Component getMenuComponent(int n) {
            if (n < 0) {
                return null;
            }
            Component[] arr = this.getMenuComponents();
            if (n >= arr.length) {
                return null;
            }
            return arr[n];
        }

        @Override
        public Component add(Component c) {
            List arr = (List)SORT.get();
            if (arr != null) {
                arr.add(c);
                if (c instanceof JComponent) {
                    ((JComponent)c).putClientProperty("position", 100 * arr.size() + 37);
                }
                return c;
            }
            if (NbMenubar.isSpecial(this)) {
                this.children.add(c);
                this.clearSorted();
                return c;
            }
            return super.add(c);
        }

        @Override
        public void remove(Component c) {
            if (NbMenubar.isSpecial(this)) {
                this.children.remove(c);
                this.clearSorted();
            } else {
                super.remove(c);
            }
        }

        @Override
        public void remove(int index) {
            if (NbMenubar.isSpecial(this)) {
                this.children.remove(index);
                this.clearSorted();
            } else {
                super.remove(index);
            }
        }

        @Override
        public void removeAll() {
            if (SORT.get() != null) {
                return;
            }
            if (NbMenubar.isSpecial(this)) {
                this.children.clear();
                this.clearSorted();
                NbMenubar.this.fs.refresh(true);
            } else {
                super.removeAll();
            }
        }

        @Override
        public void setVisible(boolean aFlag) {
            super.setVisible(aFlag);
            if (NbMenubar.isSpecial(this)) {
                NbMenubar.this.fs.refresh(true);
            }
        }

        @Override
        public void validate() {
            if (SORT.get() != null) {
                return;
            }
            super.validate();
        }

        Float weight(Component c) {
            if (c instanceof JComponent) {
                JComponent jc = (JComponent)c;
                return (Float)jc.getClientProperty("menu-weight");
            }
            return null;
        }

        private synchronized void clearSorted() {
            this.sorted = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized Collection<? extends Component> children() {
            if (this.sorted != null) {
                return this.sorted;
            }
            List prev = (List)SORT.get();
            try {
                ArrayList arr = new ArrayList();
                SORT.set(arr);
                NbMenubar.this.sortContainerOld(this);
                assert (this.sorted == null);
                assert (arr == SORT.get());
                this.sorted = Collections.unmodifiableList(arr);
            }
            finally {
                SORT.set(prev);
            }
            return this.sorted;
        }
    }
}

