/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import com.oracle.jdeveloper.nbwindowsystem.NbDockStation;
import com.oracle.jdeveloper.nbwindowsystem.NbEditorContainer;
import com.oracle.jdeveloper.nbwindowsystem.NbEditorManager;
import com.oracle.jdeveloper.nbwindowsystem.NbWindowSystemFS;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.ide.layout.Layout;
import oracle.ide.layout.LayoutResetEvent;
import oracle.ide.layout.LayoutResetListener;
import oracle.ide.layout.Layouts;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceHandler;
import org.netbeans.core.windows.RegistryImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WindowSystemImpl;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public final class ResetWindowsAction
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        final LayoutResetEvent event = new LayoutResetEvent((Layout)Layouts.getLayouts().getActiveLayout());
        final WindowSystemImpl ws = (WindowSystemImpl)Lookup.getDefault().lookup(WindowSystemImpl.class);
        if (null == ws) {
            Logger.getLogger(ResetWindowsAction.class.getName()).log(Level.INFO, "Reset Windows action does not support custom WindowSystem implementations.");
            return;
        }
        final WindowManagerImpl wm = WindowManagerImpl.getInstance();
        MainWindow.getInstance().setFullScreenMode(false);
        wm.getMainWindow().setExtendedState(0);
        final HashSet openedBefore = new HashSet(wm.getRegistry().getOpened());
        final ArrayList<NbEditorContainer> editors = new ArrayList<NbEditorContainer>();
        for (ModeImpl mode : wm.getModes()) {
            for (TopComponent tc : mode.getTopComponents()) {
                if (!(tc instanceof NbEditorContainer)) continue;
                editors.add((NbEditorContainer)tc);
            }
        }
        wm.closeNonEditorViews();
        wm.getMainWindow().setVisible(false);
        final TopComponent activeEditor = wm.getArbitrarySelectedEditorTopComponent();
        wm.deselectEditorTopComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    FileObject rootFolder = PersistenceManager.getDefault().getRootLocalFolder();
                    if (null != rootFolder) {
                        for (FileObject fo : rootFolder.getChildren()) {
                            if ("Components".equals(fo.getName())) continue;
                            fo.delete();
                        }
                    }
                }
                catch (IOException ioE) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioE);
                }
                ws.hide();
                NbDockStation dockStation = (NbDockStation)NbDockStation.getDockStation();
                Layout taskLayout = dockStation.getCurrentTaskLayout();
                Layout editorLayout = dockStation.getCurrentEditorLayout();
                dockStation.closeLayouts();
                WindowManagerImpl.getInstance().resetModel();
                PersistenceManager.getDefault().reset();
                PersistenceHandler.getDefault().clear();
                ws.load();
                dockStation.reset();
                for (LayoutResetListener l : Layouts.getLayouts().layoutResetListeners()) {
                    l.beforeLayoutActivation(event);
                }
                if (null != taskLayout) {
                    dockStation.loadLayout(taskLayout);
                }
                if (null != editorLayout) {
                    dockStation.loadLayout(editorLayout);
                }
                ws.show();
                ModeImpl editorMode = (ModeImpl)wm.findMode("editor");
                for (NbEditorContainer editor : editors) {
                    ModeImpl mode = (ModeImpl)wm.findMode((TopComponent)editor);
                    if (null == mode) {
                        mode = editorMode;
                    }
                    if (null == mode) continue;
                    if (editor.getTabGroup() != null) {
                        mode.addOpenedTopComponentNoNotify((TopComponent)editor);
                    }
                    openedBefore.remove((Object)editor);
                }
                Set openedAfter = wm.getRegistry().getOpened();
                openedBefore.removeAll(openedAfter);
                for (TopComponent tc : openedBefore) {
                    wm.notifyTopComponentClosed(tc);
                }
                RegistryImpl reg = (RegistryImpl)TopComponent.getRegistry();
                for (TopComponent tc : openedAfter) {
                    reg.topComponentOpened(tc);
                }
                for (TopComponent tc : editors) {
                    reg.topComponentOpened(tc);
                }
                NbEditorManager.getInstance().reset();
                NbWindowSystemFS.getDefault().removeAllClonedDockables();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Frame mainWindow = wm.getMainWindow();
                        mainWindow.invalidate();
                        mainWindow.repaint();
                    }
                });
                if (null != activeEditor && activeEditor.isOpened()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            activeEditor.requestActive();
                        }
                    });
                }
            }
        });
    }
}

