/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem.editor;

import com.oracle.jdeveloper.nbwindowsystem.NbEditorContainer;
import com.oracle.jdeveloper.nbwindowsystem.NbEditorManager;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorCriteriaImpl;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorPathImpl;
import com.oracle.jdeveloper.nbwindowsystem.editor.TabGroup;
import com.oracle.jdeveloper.nbwindowsystem.editor.TabGroupState;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.resource.IdeArb;
import oracle.ideimpl.editor.AcceleratorIcon;
import oracle.ideimpl.resource.IdeImplArb;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;

public final class NbAcceleratorsActions {
    private int[] assignCmdId = null;
    private static final int MAX_ACCELERATOR = 9;
    private static final int MAX_MENUS = 9;
    private final String sWindow = IdeArb.getString((int)193) + " ";
    private final int[] windowListCmdID = new int[9];
    private int[] activateCmdId = null;
    private MenuListener windowMenuListener;
    private JMenu windowMenu;

    public void createActions() {
        EditorManager controller = EditorManager.getEditorManager();
        String sWindow = IdeArb.getString((int)193) + " ";
        for (int i = 0; i < 9; ++i) {
            this.windowListCmdID[i] = Ide.findOrCreateCmdID((String)("WINDOW_" + i + "_CMD_ID"));
            IdeAction action = IdeAction.get((int)this.windowListCmdID[i], (String)null, (String)(sWindow + i), (String)IdeArb.getString((int)191), (Integer)(49 + i), null, (Object)i, (boolean)true);
            action.addController((Controller)controller);
        }
        this.activateCmdId = new int[9];
        this.assignCmdId = new int[9];
        String sActivate = IdeImplArb.getString((int)40);
        String sAssign = IdeImplArb.getString((int)41);
        for (int i = 0; i < 9; ++i) {
            this.activateCmdId[i] = Ide.findOrCreateCmdID((String)("DOCUMENT_" + (i + 1) + "_CMD_ID"));
            Object[] formatStack = new Object[]{i + 1};
            IdeAction action = IdeAction.get((int)this.activateCmdId[i], (String)null, (String)MessageFormat.format(sActivate, formatStack), (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)(49 + i), null, (Object)i, (boolean)true);
            action.addController((Controller)controller);
            this.assignCmdId[i] = Ide.findOrCreateCmdID((String)("DOCUMENT_ASSIGN_" + (i + 1) + "_CMD_ID"));
            action = IdeAction.get((int)this.assignCmdId[i], (String)null, (String)MessageFormat.format(sAssign, formatStack), (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)(49 + i), null, (Object)i, (boolean)true);
            action.addController((Controller)controller);
        }
    }

    private static int getExplicitNumber() {
        TabGroupState tabGroupState;
        int assignedNumber;
        int found;
        TabGroupState tabGroupState2;
        int i;
        ArrayList<TabGroupState> tabGroupStates = new ArrayList<TabGroupState>();
        Set topComponents = TopComponent.getRegistry().getOpened();
        for (TopComponent topComponent : topComponents) {
            NbEditorContainer nbc;
            if (!(topComponent instanceof NbEditorContainer) || (nbc = (NbEditorContainer)topComponent).getTabGroup() == null) continue;
            TabGroup tabGroup = nbc.getTabGroup();
            for (int i2 = 0; i2 < tabGroup.getTabGroupStateCount(); ++i2) {
                TabGroupState tabGroupState3 = tabGroup.getTabGroupState(i2);
                if (tabGroupState3 == null) continue;
                tabGroupStates.add(tabGroupState3);
            }
        }
        Collections.sort(tabGroupStates, new Comparator<TabGroupState>(){

            @Override
            public int compare(TabGroupState o1, TabGroupState o2) {
                TabGroupState ts1 = o1;
                TabGroupState ts2 = o2;
                return ts1.getNodeNumber() - ts2.getNodeNumber();
            }
        });
        for (i = 0; i < tabGroupStates.size() && !(tabGroupState2 = (TabGroupState)tabGroupStates.get(i)).isExplicit(); ++i) {
        }
        for (found = 0; i < tabGroupStates.size() && found >= (assignedNumber = (tabGroupState = (TabGroupState)tabGroupStates.get(i)).getNodeNumber()); ++i, ++found) {
        }
        if (found >= 9) {
            found = -1;
        }
        return found;
    }

    public boolean updateAssign(IdeAction action, int commandId) {
        boolean ret = false;
        for (int i = 0; i < this.assignCmdId.length; ++i) {
            int cmdId = this.assignCmdId[i];
            if (cmdId != commandId) continue;
            boolean hasOneEditor = EditorManager.getEditorManager().getAllEditors().size() != 0;
            action.setEnabled(hasOneEditor);
            ret = true;
            break;
        }
        return ret;
    }

    private JMenu fillAssignMenu(Menubar menuMgr) {
        float section = 1.0f;
        String assignString = IdeImplArb.getString((int)2);
        String assignLabel = StringUtils.stripMnemonic((String)assignString);
        Integer mnemonic = StringUtils.getMnemonicKeyCode((String)assignString);
        JMenu menuAssign = menuMgr.createSubMenu(assignLabel, mnemonic);
        for (int i = 0; i < 9; ++i) {
            int assignCmdId_ = this.assignCmdId[i];
            IdeAction action = IdeAction.find((int)assignCmdId_);
            JMenuItem assignMenuItem = menuMgr.createMenuItem((ToggleAction)action);
            menuMgr.add((Component)assignMenuItem, menuAssign, section);
        }
        return menuAssign;
    }

    public boolean handleAssign(IdeAction action) {
        int commandId = action.getCommandId();
        for (int i = 0; i < this.assignCmdId.length; ++i) {
            int assignCmdId_ = this.assignCmdId[i];
            if (assignCmdId_ != commandId) continue;
            EditorPathImpl currentEditorPath = new EditorPathImpl();
            NbEditorManager editorManager = NbEditorManager.getInstance();
            Editor currentEditor = editorManager.getCurrentEditor();
            if (currentEditor == null) {
                return true;
            }
            TabGroupState currentTabGroupState = editorManager.getTabGroup(currentEditor).getTabGroupState(0);
            TabGroupState reassignTabGroupState = null;
            EditorPathImpl reassignEditorPath = new EditorPathImpl();
            if (editorManager.searchEditor(reassignEditorPath, new EditorCriteriaImpl(i))) {
                reassignTabGroupState = reassignEditorPath.getTabGroupState();
            }
            if (reassignTabGroupState == null) {
                currentTabGroupState.setNodeNumber(i);
            } else if (reassignTabGroupState != currentTabGroupState) {
                reassignTabGroupState.setNodeNumber(-1);
                currentTabGroupState.setNodeNumber(i);
                int newNumber = NbAcceleratorsActions.getExplicitNumber();
                reassignTabGroupState.setNodeNumber(newNumber);
            }
            TopComponent tc = NbEditorManager.toTopComponent(currentEditor);
            NbAcceleratorsActions.setAcceleratorIcon(tc, currentTabGroupState.getNodeNumber());
            if (reassignTabGroupState != null) {
                TopComponent reassignTc = NbEditorManager.toTopComponent(reassignTabGroupState.getCurrentEditor());
                if (reassignTc != null) {
                    NbAcceleratorsActions.setAcceleratorIcon(reassignTc, reassignTabGroupState.getNodeNumber());
                }
            }
            return true;
        }
        return false;
    }

    private static void setAcceleratorIcon(TopComponent tc, int nodeNumber) {
        if (tc != null) {
            Icon tcIcon = ImageUtilities.image2Icon((Image)tc.getIcon());
            AcceleratorIcon aIcon = new AcceleratorIcon(tcIcon, nodeNumber + 1);
            Image tcImage = ImageUtilities.icon2Image((Icon)aIcon);
            tc.setIcon(tcImage);
        }
    }

    public boolean handleGoto(IdeAction action) {
        int commandId = action.getCommandId();
        for (int i = 0; i < this.activateCmdId.length; ++i) {
            EditorPathImpl editorPath;
            int assignCmdId = this.activateCmdId[i];
            if (assignCmdId != commandId) continue;
            NbEditorManager editorManager = NbEditorManager.getInstance();
            if (editorManager.searchEditor(editorPath = new EditorPathImpl(), new EditorCriteriaImpl(i))) {
                Editor currentEditor = editorPath.getTabGroup().getCurrentEditor();
                TopComponent tc = NbEditorManager.toTopComponent(currentEditor);
                tc.requestActive();
            }
            return true;
        }
        return false;
    }

    public boolean updateActivate(IdeAction action, int commandId) {
        boolean ret = false;
        for (int i = 0; i < this.activateCmdId.length; ++i) {
            int cmdId = this.activateCmdId[i];
            if (cmdId != commandId) continue;
            boolean found = NbEditorManager.getInstance().searchEditor(new EditorPathImpl(), new EditorCriteriaImpl(i));
            action.setEnabled(found);
            ret = true;
            break;
        }
        return ret;
    }

    public void createMenu() {
        Ide.getMenubar();
        this.windowMenu = Menubar.getJMenu((String)"Window");
        if (this.windowMenuListener == null && this.windowMenu != null) {
            this.windowMenuListener = new WindowMenuListener();
            this.windowMenu.addMenuListener(this.windowMenuListener);
        } else if (!GraphicsEnvironment.isHeadless()) {
            Logger.getAnonymousLogger().warning("Menu listener for the editor acceleratrs not registered for the Accelerators.");
        }
    }

    public static void updateAllAcceleratorIcons() {
        Set openedTCs = TopComponent.getRegistry().getOpened();
        for (TopComponent tc : openedTCs) {
            if (!(tc instanceof NbEditorContainer)) continue;
            NbEditorContainer ec = (NbEditorContainer)tc;
            NbAcceleratorsActions.updateAcceleratorIcon(ec);
        }
    }

    public static void updateAcceleratorIcon(NbEditorContainer ec) {
        int acceleratorNumber = NbAcceleratorsActions.getEditorHasAccelerator(ec);
        if (NbAcceleratorsActions.getEditorHasAccelerator(ec) > -1) {
            NbAcceleratorsActions.setAcceleratorIcon((TopComponent)ec, acceleratorNumber);
        }
    }

    public static int getEditorHasAccelerator(NbEditorContainer ec) {
        NbEditorManager editorManager = NbEditorManager.getInstance();
        if (ec.getEditor() == null || editorManager.getTabGroup(ec.getEditor()) == null) {
            return -1;
        }
        TabGroupState currentTabGroupState = editorManager.getTabGroup(ec.getEditor()).getTabGroupState(0);
        if (currentTabGroupState != null && currentTabGroupState.getNodeNumber() > -1) {
            return currentTabGroupState.getNodeNumber();
        }
        return -1;
    }

    private class WindowMenuListener
    implements MenuListener {
        private static final String ASSIGN_ACCELERATOR_MENU_ID = "Window.AssignFileAcceleratorMenu";
        public static final float SECTION_WINDOW_BOTTOM = 1000.0f;

        private WindowMenuListener() {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            JMenu menuAssign = NbAcceleratorsActions.this.fillAssignMenu(Ide.getMenubar());
            menuAssign.putClientProperty("menu-weight", Float.valueOf(1.0f));
            MenuManager.putJMenu((String)ASSIGN_ACCELERATOR_MENU_ID, (JMenu)menuAssign);
            Ide.getMenubar();
            JMenu windowMenu = Menubar.getJMenu((String)"Window");
            Ide.getMenubar().add((Component)menuAssign, windowMenu, 1000.0f);
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }
}

