/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem.editor;

import com.oracle.jdeveloper.nbwindowsystem.NbEditorContainer;
import com.oracle.jdeveloper.nbwindowsystem.NbEditorManager;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorCreation;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorCriteriaImpl;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorPathImpl;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorState;
import com.oracle.jdeveloper.nbwindowsystem.editor.SplitPane;
import com.oracle.jdeveloper.nbwindowsystem.editor.SplitPaneState;
import com.oracle.jdeveloper.nbwindowsystem.editor.SplitPaneStructPersistence;
import com.oracle.jdeveloper.nbwindowsystem.editor.TabGroupPanel;
import com.oracle.jdeveloper.nbwindowsystem.editor.TabGroupState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.controls.dockLayout.DockLayout;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;
import oracle.ideimpl.controls.dockLayout.XMLDockLayoutPersistence;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class TabGroup
extends JPanel {
    private final TabGroupPanel _centerPanel;
    private TabGroupState _currentTabGroupState;
    private boolean focused = false;

    public TabGroup() {
        super(new BorderLayout());
        this.setOpaque(false);
        this._centerPanel = new TabGroupPanel();
        this.add((Component)((Object)this._centerPanel), "Center");
    }

    private static NbEditorManager getEditorManager() {
        return NbEditorManager.getInstance();
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public int getTabGroupStateCount() {
        return 1;
    }

    public TabGroupState getTabGroupState(int pos) {
        return this._currentTabGroupState;
    }

    public boolean addTabGroupState(EditorCreation editorCreation) {
        boolean ret = false;
        TabGroupState tabGroupState = new TabGroupState(this, editorCreation);
        SplitPaneState splitPaneState = tabGroupState.createSplitPaneState(editorCreation);
        if (splitPaneState != null) {
            tabGroupState.addSplitPaneState(splitPaneState);
            TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
            EditorPathImpl editorPath = editorCreation.getEditorPath();
            this.addTabGroupState(tabGroupState, 0);
            editorPath._panePos = 0;
            this.setCurrentTabGroupState(tabGroupState);
            ret = true;
        }
        return ret;
    }

    int addTabGroupState(TabGroupState tabGroupState, int pos) {
        tabGroupState.setParentTabGroup(this);
        this.whenTabGroupStateChanged(pos);
        return pos;
    }

    void whenTabGroupStateChanged(TabGroupState tabGroupState) {
        boolean tabGroupStatePos = false;
        this.whenTabGroupStateChanged(0);
    }

    private void whenTabGroupStateChanged(int tabGroupStatePos) {
    }

    private void detachCurrentNode() {
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        if (currentTabGroupState != null) {
            this.updateCurrentLayoutState();
            int splitPaneStateCount = currentTabGroupState.getSplitPaneStateCount();
            for (int i = 0; i < splitPaneStateCount; ++i) {
                SplitPaneState splitPaneState = currentTabGroupState.getSplitPaneState(i);
                SplitPane splitPane = splitPaneState.getSplitPane();
                if (splitPane == null) continue;
                this._centerPanel.remove(splitPane);
                splitPane.setSplitPaneState(null);
                splitPaneState.setSplitPane(null);
                TabGroup.getEditorManager().releaseSplitPane(splitPane);
            }
        }
    }

    private void updateCurrentLayoutState() {
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        DockLayout layout = (DockLayout)this._centerPanel.getLayout();
        SplitPaneStructPersistence structPersistence = new SplitPaneStructPersistence(currentTabGroupState);
        DefaultStructuredPropertyAccess paneNode = new DefaultStructuredPropertyAccess("pane");
        layout.saveLayout((XMLDockLayoutPersistence)structPersistence, (StructuredPropertyAccess)paneNode);
        currentTabGroupState.setStructPersistence((StructuredPropertyAccess)paneNode);
    }

    private void attachCurrentNode() {
        DockLayout layout = (DockLayout)this._centerPanel.getLayout();
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        StructuredPropertyAccess structPersistence = currentTabGroupState.getStructPersistence();
        if (structPersistence != null) {
            SplitPaneStructPersistence layoutPersistence = new SplitPaneStructPersistence(currentTabGroupState);
            layout.loadLayout((Container)((Object)this._centerPanel), (XMLDockLayoutPersistence)layoutPersistence, structPersistence);
        } else {
            SplitPaneState splitPaneState = currentTabGroupState.getSplitPaneState(0);
            SplitPane splitPane = TabGroup.getEditorManager().createSplitPane();
            splitPaneState.setSplitPane(splitPane);
            splitPane.setSplitPaneState(splitPaneState);
            this._centerPanel.add(splitPane, new DockLayoutConstraint((Component)null, 2, 1, new Dimension(1000, 1000)));
        }
    }

    public void focusCurrentEditor() {
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        if (currentTabGroupState != null) {
            currentTabGroupState.focusCurrentEditor();
        }
    }

    void getDropArea(Rectangle dropArea) {
        this._centerPanel.getBounds(dropArea);
    }

    private static void printTree(Component top, String level) {
        System.out.println((top.isValid() ? " " : "I") + "  " + level + top.getClass().getName());
        if (top instanceof Container) {
            Container container = (Container)top;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component = container.getComponent(i);
                TabGroup.printTree(component, level + "  ");
            }
        }
    }

    public boolean searchEditor(EditorPathImpl editorPath, EditorCriteriaImpl editorCriteria) {
        boolean ret = false;
        int pageCount = this.getTabGroupStateCount();
        for (int i = 0; !ret && i < pageCount; ++i) {
            TabGroupState tabGroupState = this.getTabGroupState(i);
            if (tabGroupState == null || !tabGroupState.match(editorCriteria) && !tabGroupState.searchEditor(editorPath, editorCriteria)) continue;
            ret = true;
        }
        return ret;
    }

    public boolean match(EditorCriteriaImpl editorCriteria) {
        return editorCriteria.getCriteria1() == this && editorCriteria.getType() == 13;
    }

    public boolean activateEditor(EditorPathImpl editorPath) {
        TabGroupState tabGroupState;
        boolean ret = true;
        int tabGroupStatePos = editorPath._tabGroupStatePos;
        if (tabGroupStatePos != -1 && this.setCurrentTabGroupState(tabGroupState = this.getTabGroupState(tabGroupStatePos)) && (ret = tabGroupState.activateEditor(editorPath))) {
            this.restoreIfMaximized();
        }
        return ret;
    }

    private void restoreIfMaximized() {
    }

    public List findEditors(Context context) {
        ArrayList<Editor> ret = null;
        Node node = context.getNode();
        Project project = context.getProject();
        Workspace workspace = context.getWorkspace();
        int nodeCount = this.getTabGroupStateCount();
        for (int i = 0; i < nodeCount; ++i) {
            boolean equal;
            TabGroupState tabGroupState = this.getTabGroupState(i);
            if (tabGroupState == null) continue;
            Context tabGroupStateContext = tabGroupState.getContext();
            boolean bl = equal = ModelUtil.areEqual((Object)node, (Object)tabGroupStateContext.getNode()) && ModelUtil.areEqual((Object)project, (Object)tabGroupStateContext.getProject()) && ModelUtil.areEqual((Object)workspace, (Object)tabGroupStateContext.getWorkspace());
            if (!equal) continue;
            int splitPaneStateCount = tabGroupState.getSplitPaneStateCount();
            for (int j = 0; j < splitPaneStateCount; ++j) {
                SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(j);
                int nbrEditorStates = splitPaneState.getEditorStateCount();
                for (int k = 0; k < nbrEditorStates; ++k) {
                    EditorState editorState = splitPaneState.getEditorState(k);
                    Editor editor = editorState.getEditor();
                    if (editor == null) continue;
                    if (ret == null) {
                        ret = new ArrayList<Editor>(1);
                    }
                    ret.add(editor);
                }
            }
        }
        return ret != null ? ret : Collections.EMPTY_LIST;
    }

    public List<Editor> getAllEditors() {
        ArrayList<Editor> ret = new ArrayList<Editor>();
        int nodeCount = this.getTabGroupStateCount();
        for (int i = 0; i < nodeCount; ++i) {
            TabGroupState tabGroupState = this.getTabGroupState(i);
            if (tabGroupState == null) continue;
            int splitPaneCount = tabGroupState.getSplitPaneStateCount();
            for (int j = 0; j < splitPaneCount; ++j) {
                SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(j);
                if (splitPaneState == null) continue;
                int nbrEditorStates = splitPaneState.getEditorStateCount();
                for (int k = 0; k < nbrEditorStates; ++k) {
                    Editor editor;
                    EditorState editorState = splitPaneState.getEditorState(k);
                    if (editorState == null || (editor = editorState.getEditor()) == null) continue;
                    ret.add(editor);
                }
            }
        }
        return ret;
    }

    boolean getCurrentEditorPath(EditorPathImpl editorPath) {
        boolean ret = false;
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        if (currentTabGroupState != null) {
            ret = currentTabGroupState.getCurrentEditorPath(editorPath);
        }
        return ret;
    }

    public TabGroupState getCurrentTabGroupState() {
        return this._currentTabGroupState;
    }

    public SplitPane getCurrentSplitPane() {
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        return currentTabGroupState == null ? null : currentTabGroupState.getCurrentSplitPane();
    }

    public Editor getCurrentEditor() {
        Editor ret = null;
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        if (currentTabGroupState != null) {
            ret = currentTabGroupState.getCurrentEditor();
        }
        return ret;
    }

    public SplitPane getSplitPane(Editor editor) {
        SplitPane ret = null;
        int nodeCount = this.getTabGroupStateCount();
        for (int i = 0; i < nodeCount; ++i) {
            TabGroupState tabGroupState = this.getTabGroupState(i);
            int splitPaneCount = tabGroupState.getSplitPaneStateCount();
            for (int j = 0; j < splitPaneCount; ++j) {
                SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(j);
                int nbrEditorStates = splitPaneState.getEditorStateCount();
                for (int k = 0; k < nbrEditorStates; ++k) {
                    EditorState editorState = splitPaneState.getEditorState(k);
                    if (editor != editorState.getEditor()) continue;
                    ret = splitPaneState.getSplitPane();
                }
            }
        }
        return ret;
    }

    public void closeEditors() {
        for (int i = this.getTabGroupStateCount() - 1; i >= 0; --i) {
            TabGroupState tabGroupState = this.getTabGroupState(i);
            for (int j = tabGroupState.getSplitPaneStateCount() - 1; j >= 0; --j) {
                tabGroupState.closeSplitPaneState(j);
            }
            tabGroupState.dispose();
        }
    }

    void splitPane(EditorPathImpl editorPath) {
        SplitPaneState splitPaneState = editorPath.getSplitPaneState();
        SplitPane splitPane = splitPaneState.getSplitPane();
        int splitAt = splitPane.getHeight() / 2;
        this.split(splitPane, splitAt, 1);
    }

    void unsplitPane(EditorPathImpl editorPath) {
        int keepPane = editorPath._panePos;
        TabGroupState tabGroupState = editorPath.getTabGroupState();
        editorPath._panePos = 0;
        for (int splitPaneStatePos = 0; splitPaneStatePos < keepPane; ++splitPaneStatePos) {
            this._centerPanel.closePanel(editorPath);
        }
        int splitPaneStateCount = tabGroupState.getSplitPaneStateCount();
        editorPath._panePos = 1;
        for (int splitPaneStatePos = 1; splitPaneStatePos < splitPaneStateCount; ++splitPaneStatePos) {
            this._centerPanel.closePanel(editorPath);
        }
    }

    void split(SplitPane sourceSplitPane, int splitPos, int splitOrientation) {
        int editorStatePos;
        SplitPaneState sourceSplitPaneState;
        EditorState sourceEditorState;
        EditorAddin sourceEditorAddin;
        EditorAddin bestDuplicatedEditor;
        int newEditorStatePos;
        TabGroupState tabGroupState = this.getCurrentTabGroupState();
        SplitPaneState newSplitPaneState = new SplitPaneState(tabGroupState);
        boolean canCreateEditor = newSplitPaneState.setCurrentEditorStatePos(newEditorStatePos = newSplitPaneState.searchEditorPos(bestDuplicatedEditor = tabGroupState.findBestDuplicatedEditor(sourceEditorAddin = (sourceEditorState = (sourceSplitPaneState = sourceSplitPane.getSplitPaneState()).getEditorState(editorStatePos = sourceSplitPaneState.getCurrentEditorStatePos())).getEditorAddin())));
        if (canCreateEditor) {
            int orient;
            tabGroupState.addSplitPaneState(newSplitPaneState);
            SplitPane splitPane = NbEditorManager.getInstance().createSplitPane();
            newSplitPaneState.setSplitPane(splitPane);
            splitPane.setSplitPaneState(newSplitPaneState);
            DockLayoutInfoLeaf layoutInfo = this._centerPanel.getLayoutInfo(sourceSplitPane);
            Dimension sizePref = layoutInfo.getSize(2);
            Dimension sizeReal = sourceSplitPane.getSize();
            Dimension sizeNew = new Dimension(sizePref);
            if (splitOrientation == 1) {
                int heightToSplit = sizePref.height;
                sizePref.height = heightToSplit * splitPos / sizeReal.height;
                sizeNew.height = heightToSplit - sizePref.height;
                orient = 3;
            } else {
                int widthToSplit = sizePref.width;
                sizePref.width = widthToSplit * splitPos / sizeReal.width;
                sizeNew.width = widthToSplit - sizePref.width;
                orient = 1;
            }
            if (sourceEditorAddin == bestDuplicatedEditor) {
                DefaultStructuredPropertyAccess editorStateInfo = new DefaultStructuredPropertyAccess("DUPLICATON");
                sourceSplitPane.savePaneState();
                sourceEditorState.saveStateInfo((StructuredPropertyAccess)editorStateInfo);
                EditorState newEditorState = newSplitPaneState.getCurrentEditorState();
                newEditorState.loadStateInfo((StructuredPropertyAccess)editorStateInfo);
                splitPane.loadPaneState();
            }
            this._centerPanel.add(splitPane, new DockLayoutConstraint((Component)sourceSplitPane, orient, 1, sizeNew));
            this.revalidate();
        }
    }

    private boolean setCurrentTabGroupState(TabGroupState tabGroupState) {
        boolean ret = false;
        if (this._currentTabGroupState != tabGroupState) {
            boolean shouldRestoreFocus;
            boolean bl = shouldRestoreFocus = GraphicsUtils.getFocusedChildComponent((Component)this) != null;
            if (this._currentTabGroupState != null) {
                this.detachCurrentNode();
            }
            this._currentTabGroupState = tabGroupState;
            if (this._currentTabGroupState != null) {
                this.attachCurrentNode();
                if (shouldRestoreFocus) {
                    this.focusCurrentEditor();
                }
            }
            this.whenCurrentEditorChanges();
            if (tabGroupState != null) {
                Context context = tabGroupState.getContext();
                SplitPaneState currentSplitPaneState = tabGroupState.getCurrentSplitPaneState();
                EditorState currentEditorState = currentSplitPaneState.getCurrentEditorState();
                EditorAddin editorAddin = currentEditorState.getEditorAddin();
                NbEditorManager editorManager = TabGroup.getEditorManager();
            }
            this.revalidate();
            this.repaint();
            ret = true;
        } else {
            ret = true;
        }
        return ret;
    }

    void whenCurrentEditorChanges(TabGroupState tabGroupState) {
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        if (currentTabGroupState == tabGroupState) {
            this.whenCurrentEditorChanges();
        }
    }

    private void whenCurrentEditorChanges() {
        NbEditorManager.getInstance().whenCurrentEditorChanges(this);
    }

    public void whenEditorActivated(TabGroupState tabGroupState) {
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        if (currentTabGroupState != tabGroupState) {
            this.setCurrentTabGroupState(tabGroupState);
        }
        NbEditorManager.getInstance().whenEditorActivated(this);
    }

    void dump(String indent, boolean isActive) {
        System.out.println(indent + "TabGroupState" + (isActive ? "*" : ""));
        int tabGroupStateCount = this.getTabGroupStateCount();
        for (int i = 0; i < tabGroupStateCount; ++i) {
            TabGroupState tabGroupState = this.getTabGroupState(i);
            boolean active = tabGroupState == this._currentTabGroupState;
            tabGroupState.dump(indent + "  ", active);
        }
    }

    public boolean saveLayout(StructuredPropertyAccess leafBox) {
        return this.saveLayout(leafBox, false);
    }

    public boolean saveLayout(StructuredPropertyAccess leafBox, boolean forceSave) {
        this.updateCurrentLayoutState();
        boolean leavesSaved = false;
        int nbrTabGroupState = this.getTabGroupStateCount();
        for (int i = 0; i < nbrTabGroupState; ++i) {
            TabGroupState tabGroupState = this.getTabGroupState(i);
            boolean restorableAtStartup = tabGroupState.isRestorableAtStartup();
            if (!restorableAtStartup && !forceSave) continue;
            DefaultStructuredPropertyAccess stateNode = new DefaultStructuredPropertyAccess("state");
            tabGroupState.saveStateInfo((StructuredPropertyAccess)stateNode);
            leafBox.appendChild((StructuredPropertyAccess)stateNode);
            leavesSaved = true;
        }
        return leavesSaved;
    }

    public static TabGroup loadLayout(StructuredPropertyAccess leafBox) {
        StructuredPropertyAccess element;
        TabGroupState tabGroupState;
        TabGroup tabGroup = new TabGroup();
        boolean ret = false;
        Iterator childNodes = leafBox.getChildNodes("state");
        if (childNodes.hasNext() && (tabGroupState = new TabGroupState(tabGroup)).loadStateInfo(element = (StructuredPropertyAccess)childNodes.next())) {
            tabGroup.addTabGroupState(tabGroupState, -1);
            ret = tabGroup.setCurrentTabGroupState(tabGroupState);
        }
        tabGroup.validate();
        return ret ? tabGroup : null;
    }

    void highlight(boolean highlight) {
    }

    public boolean canActivateLeftNode() {
        return this.canActivateEditor(Direction.LEFT);
    }

    public void whenActivateLeftNode() {
        this.activateNextEditor(Direction.LEFT);
    }

    public boolean canActivateRightNode() {
        return this.canActivateEditor(Direction.RIGHT);
    }

    public void whenActivateRightNode() {
        this.activateNextEditor(Direction.RIGHT);
    }

    private Editor getEditor(TabGroup tabGroup) {
        for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
            NbEditorContainer ec;
            if (!(tc instanceof NbEditorContainer) || tabGroup != (ec = (NbEditorContainer)tc).getTabGroup()) continue;
            return ec.getEditor();
        }
        return null;
    }

    private void activateEditor(int position) {
        for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
            TopComponent tcForActivation;
            Mode mode;
            TopComponent[] tcs;
            NbEditorContainer ec;
            if (!(tc instanceof NbEditorContainer) || (ec = (NbEditorContainer)tc).getTabGroup() != this || (tcs = (mode = WindowManager.getDefault().findMode(tc)).getTopComponents()) == null && position >= tcs.length || (tcForActivation = tcs[position]) == null) continue;
            tcForActivation.requestActive();
        }
    }

    private int getNextEditor(int position, Direction direction) {
        for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
            int i;
            NbEditorContainer ec;
            if (!(tc instanceof NbEditorContainer) || (ec = (NbEditorContainer)tc).getTabGroup() != this) continue;
            Mode mode = WindowManager.getDefault().findMode(tc);
            TopComponent[] tcs = mode.getTopComponents();
            if (tcs == null || tcs.length == 0) {
                return -1;
            }
            if (direction == Direction.LEFT) {
                for (i = position - 1; i >= 0; --i) {
                    if (!(tcs[i] instanceof NbEditorContainer)) continue;
                    return i;
                }
                continue;
            }
            if (direction != Direction.RIGHT) continue;
            for (i = position + 1; tcs.length > i; ++i) {
                if (!(tcs[i] instanceof NbEditorContainer)) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean canActivateEditor(Direction direction) {
        Editor editor = this.getEditor(this);
        if (editor == null) {
            return false;
        }
        int selectedPage = TabGroup.getEditorManager().getEditorPosition(editor);
        return this.getNextEditor(selectedPage, direction) >= 0;
    }

    private void activateNextEditor(Direction direction) {
        Editor editor = this.getEditor(this);
        if (editor == null) {
            return;
        }
        int selectedPage = TabGroup.getEditorManager().getEditorPosition(editor);
        int newSelectedPage = this.getNextEditor(selectedPage, direction);
        if (newSelectedPage >= 0) {
            this.activateEditor(newSelectedPage);
        }
    }

    private static enum Direction {
        RIGHT,
        LEFT;

    }
}

