/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem.plaf;

import com.oracle.jdeveloper.nbwindowsystem.NbToolbarsFS;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.ide.Ide;
import oracle.ide.controller.Menubar;
import org.netbeans.swing.tabcontrol.plaf.TabControlButton;
import org.openide.util.Lookup;

public final class ActionsUtils {
    private static WeakReference<TabControlButton> buttonFileListDropDown;

    private ActionsUtils() {
    }

    public static void addListenerToNbFileListButton() {
        Collection buttons = ActionsUtils.findAllComponentsByType((Container)Ide.getMainWindow(), TabControlButton.class);
        TabControlButton button = (TabControlButton)ActionsUtils.findObjectByClassName(buttons, "TabControlButtonFactory$DropDownButton");
        if (button != null) {
            buttonFileListDropDown = new WeakReference<TabControlButton>(button);
        }
    }

    public static void installViewMenuListener() {
        Menubar menuMgr = Ide.getMenubar();
        JMenu viewMenu = Menubar.getJMenu((String)"View");
        if (viewMenu == null) {
            Logger.getAnonymousLogger().severe("The view menu not ready yet!");
            return;
        }
        viewMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                NbToolbarsFS fs = (NbToolbarsFS)Lookup.getDefault().lookup(NbToolbarsFS.class);
                fs.refresh(true);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    public static void showDropDownList() {
        if (buttonFileListDropDown == null) {
            return;
        }
        TabControlButton buttonFileList = (TabControlButton)buttonFileListDropDown.get();
        if (buttonFileList != null) {
            buttonFileList.getAction().actionPerformed(new ActionEvent(buttonFileList, 1001, "pressed"));
        }
    }

    private static <T> T findObjectByClassName(Collection<T> objects, String className) {
        for (T o : objects) {
            if (o == null || !o.getClass().getName().endsWith(className)) continue;
            return o;
        }
        return null;
    }

    private static <T> Collection<T> findAllComponentsByType(Container root, Class searchType) {
        HashSet components = new HashSet();
        ActionsUtils.searchForAllComponentsByType(root, components, searchType);
        return components;
    }

    private static <T> void searchForAllComponentsByType(Container root, Collection<T> allComponents, Class searchType) {
        if (searchType.isInstance(root)) {
            allComponents.add(root);
        }
        for (Component c : root.getComponents()) {
            if (!(c instanceof Container)) continue;
            ActionsUtils.searchForAllComponentsByType((Container)c, allComponents, searchType);
        }
    }
}

