/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem.plaf;

import java.awt.Color;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.netbeans.swing.plaf.util.GuaranteedValue;

public final class AdditionalDefaultsForNbLAF {
    private static final String GTK_LAF = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    private static final String NIMBUS_LAF = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";
    private static final String WINDOWS_LAF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";

    private AdditionalDefaultsForNbLAF() {
    }

    public static void resolveLAFDefaults() {
        if (UIManager.getLookAndFeel() == null) {
            return;
        }
        if (UIManager.getLookAndFeel().getClass().getName().equals(GTK_LAF)) {
            AdditionalDefaultsForNbLAF.setLAFUIDefaults(AdditionalDefaultsForNbLAF.createKeysAndValuesGTK());
        } else if (UIManager.getLookAndFeel().getClass().getName().equals(NIMBUS_LAF)) {
            AdditionalDefaultsForNbLAF.setLAFUIDefaults(AdditionalDefaultsForNbLAF.createKeysAndValuesNIMBUS());
        } else if (UIManager.getLookAndFeel().getClass().getName().equals(WINDOWS_LAF)) {
            AdditionalDefaultsForNbLAF.setLAFUIDefaults(AdditionalDefaultsForNbLAF.createKeysAndValuesWindows());
        }
    }

    public static void setLAFUIDefaults(Object[] values) {
        UIDefaults defaults = UIManager.getDefaults();
        if (defaults != null) {
            defaults.putDefaults(values);
        }
    }

    private static Object[] createKeysAndValuesGTK() {
        return new Object[]{"InternalFrame.activeTitleBackground", new GuaranteedValue("InternalFrame.activeTitleBackground", (Object)Color.LIGHT_GRAY), "InternalFrame.borderShadow", new GuaranteedValue("InternalFrame.borderShadow", (Object)Color.LIGHT_GRAY), "InternalFrame.borderHighlight", new GuaranteedValue("InternalFrame.borderHighlight", (Object)Color.white), "InternalFrame.borderDarkShadow", new GuaranteedValue("InternalFrame.borderDarkShadow", (Object)Color.darkGray), "InternalFrame.borderLight", new GuaranteedValue("InternalFrame.borderLight", (Object)Color.lightGray), "TabbedPane.background", new GuaranteedValue("TabbedPane.background", (Object)Color.LIGHT_GRAY), "TabbedPane.focus", new GuaranteedValue("TabbedPane.focus", (Object)Color.GRAY), "TabbedPane.highlight", new GuaranteedValue("TabbedPane.highlight", (Object)Color.WHITE), "Button.dashedRectGapX", new GuaranteedValue("Button.dashedRectGapX", (Object)5), "Button.dashedRectGapY", new GuaranteedValue("Button.dashedRectGapY", (Object)4), "Button.dashedRectGapWidth", new GuaranteedValue("Button.dashedRectGapWidth", (Object)10), "Button.dashedRectGapHeight", new GuaranteedValue("Button.dashedRectGapHeight", (Object)8), "InternalFrame.activeTitleForeground", Color.LIGHT_GRAY};
    }

    private static Object[] createKeysAndValuesNIMBUS() {
        return new Object[]{"InternalFrame.activeTitleBackground", new GuaranteedValue("InternalFrame.activeTitleBackground", (Object)Color.LIGHT_GRAY), "InternalFrame.borderShadow", new GuaranteedValue("InternalFrame.borderShadow", (Object)Color.LIGHT_GRAY), "InternalFrame.borderHighlight", new GuaranteedValue("InternalFrame.borderHighlight", (Object)Color.white), "InternalFrame.borderDarkShadow", new GuaranteedValue("InternalFrame.borderDarkShadow", (Object)Color.darkGray), "InternalFrame.borderLight", new GuaranteedValue("InternalFrame.borderLight", (Object)Color.lightGray), "TabbedPane.background", new GuaranteedValue("TabbedPane.background", (Object)Color.LIGHT_GRAY), "TabbedPane.focus", new GuaranteedValue("TabbedPane.focus", (Object)Color.GRAY), "TabbedPane.highlight", new GuaranteedValue("TabbedPane.highlight", (Object)Color.WHITE), "Button.dashedRectGapX", new GuaranteedValue("Button.dashedRectGapX", (Object)5), "Button.dashedRectGapY", new GuaranteedValue("Button.dashedRectGapY", (Object)4), "Button.dashedRectGapWidth", new GuaranteedValue("Button.dashedRectGapWidth", (Object)10), "Button.dashedRectGapHeight", new GuaranteedValue("Button.dashedRectGapHeight", (Object)8), "InternalFrame.activeTitleForeground", Color.LIGHT_GRAY, "TextArea.selectionBackground", Color.LIGHT_GRAY, "TextArea.selectionForeground", Color.GRAY, "TextField.inactiveForeground", Color.LIGHT_GRAY, "Table.selectionBackground", Color.WHITE, "List.selectionForeground", Color.GRAY, "List.selectionBackground", Color.LIGHT_GRAY};
    }

    private static Object[] createKeysAndValuesWindows() {
        return new Object[]{"Button.showMnemonics", Boolean.FALSE};
    }
}

