/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem.plaf;

import com.oracle.jdeveloper.nbwindowsystem.plaf.AttentionSupport;
import com.oracle.jdeveloper.nbwindowsystem.plaf.OracleViewTabLayoutModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.Themes;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.BusyTabsSupport;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.openide.awt.HtmlRenderer;
import org.openide.util.ImageUtilities;

public final class OracleViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int TXT_X_PAD = 8;
    private static final int ICON_X_LEFT_PAD = 8;
    private static final int ICON_X_RIGHT_PAD = 4;
    private static final String IMAGE_PREFIX = "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/viewtabs/";
    private static final Image[] normal = new Image[6];
    private static final Image[] normalRollover = new Image[6];
    private static final Image[] selected = new Image[6];
    private static final Image[] selectedRollover = new Image[6];
    private static final Image[] focused = new Image[6];
    static final int IMG_TOP = 0;
    static final int IMG_TOP_LEFT = 1;
    static final int IMG_TOP_RIGHT = 2;
    static final int IMG_LEFT = 3;
    static final int IMG_RIGHT = 4;
    static final int IMG_MIDDLE = 5;
    private static final Image separator = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/viewtabs/default_tab_seperator.png");
    private static final Image selectedSeparator = ImageUtilities.loadImage((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/viewtabs/selected_tab_separator.png");
    private static final Icon iconMinimizeDefault = ImageUtilities.loadImageIcon((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/minimize_selected_default.png", (boolean)true);
    private static final Icon iconMinimizeRollover = ImageUtilities.loadImageIcon((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/minimize_selected_rollover.png", (boolean)true);
    private static final Icon iconMinimizePressed = ImageUtilities.loadImageIcon((String)"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/minimize_selected_pressed.png", (boolean)true);
    private static final int BORDER_SIZE = 3;
    private static Color inactBgColor;
    private static Color actBgColor;
    private static Map<Integer, String[]> buttonIconPaths;
    private Dimension prefSize = new Dimension(100, 19);
    private Font txtFont;

    private OracleViewTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
    }

    public static ComponentUI createUI(JComponent c) {
        return new OracleViewTabDisplayerUI((TabDisplayer)c);
    }

    protected TabLayoutModel createLayoutModel() {
        WinsysInfoForTabbedContainer winsysInfo = this.displayer.getContainerWinsysInfo();
        if (null != winsysInfo && winsysInfo.isSlidedOutContainer()) {
            return super.createLayoutModel();
        }
        return new OracleViewTabLayoutModel(this.getDataModel(), this.displayer);
    }

    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    public Dimension getPreferredSize(JComponent c) {
        FontMetrics fm = this.getTxtFontMetrics();
        int height = fm == null ? 21 : fm.getAscent() + 2 * fm.getDescent() + 4;
        Insets insets = c.getInsets();
        this.prefSize.height = height + insets.bottom + insets.top;
        return this.prefSize;
    }

    static void drawTabBackground(Graphics g, Image[] images, int x, int y, int width, int height, int borderSize) {
        g.translate(x, y);
        g.drawImage(images[1], 0, 0, null);
        g.drawImage(images[2], width - borderSize, 0, null);
        g.drawImage(images[0], borderSize, 0, width - 2 * borderSize, borderSize, null);
        g.drawImage(images[3], 0, borderSize, borderSize, height - borderSize, null);
        g.drawImage(images[4], width - borderSize, borderSize, borderSize, height - borderSize, null);
        g.drawImage(images[5], borderSize, borderSize, width - 2 * borderSize, height - borderSize, null);
        g.translate(-x, -y);
    }

    protected void paintDisplayerBackground(Graphics g, JComponent c) {
        Painter painter = Themes.getActiveTheme().getStateProperties("mainwindow", "normal").getPainter("bg");
        if (null != painter) {
            painter.paint(g, 0, 0, this.displayer.getWidth(), this.displayer.getHeight());
        }
        int width = c.getWidth();
        int height = c.getHeight();
        Image[] images = normal;
        if (this.getDataModel().size() == 1) {
            boolean isFocused = this.isFocused(0);
            boolean isMouseOver = this.isMouseOver(0);
            images = isFocused ? focused : (isMouseOver ? selectedRollover : selected);
        }
        OracleViewTabDisplayerUI.drawTabBackground(g, images, 0, 0, width, height, 3);
    }

    protected void paintTabContent(Graphics g, int index, String text, int x, int y, int width, int height) {
        int neededWidth;
        Icon busyIcon;
        Graphics2D g2d = (Graphics2D)g;
        Shape clip = g2d.getClip();
        g2d.clip(new Rectangle(x, y, width - 2, height));
        FontMetrics fm = this.getTxtFontMetrics();
        g.setFont(this.getTxtFont());
        if (this.isTabBusy(index) && null != (busyIcon = BusyTabsSupport.getDefault().getBusyIcon(this.isSelected(index)))) {
            x += 4;
            int iconY = y + 3;
            if (height > busyIcon.getIconHeight() + 3 + 3) {
                iconY = (height - busyIcon.getIconHeight()) / 2;
            }
            busyIcon.paintIcon((Component)this.displayer, g, x, iconY);
            x += busyIcon.getIconWidth();
            width = Math.max(0, width - (4 + busyIcon.getIconWidth()));
        }
        int txtWidth = width;
        if (this.isSelected(index)) {
            Component buttons = this.getControlButtons();
            int buttonsWidth = 0;
            if (null != buttons) {
                Dimension buttonsSize = buttons.getPreferredSize();
                if (width < buttonsSize.width + 8 + 4) {
                    buttons.setVisible(false);
                    txtWidth = 0;
                } else {
                    buttons.setVisible(true);
                    buttonsWidth = buttonsSize.width + 8 + 4;
                    buttons.setLocation(x + (txtWidth -= buttonsWidth + 8) + 8 + 8, y + (height - buttonsSize.height) / 2);
                }
            }
        } else {
            txtWidth = width - 16;
        }
        int fullTxtWidth = (int)HtmlRenderer.renderString((String)text, (Graphics)g, (int)0, (int)(height - fm.getDescent() - 4), (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (Font)this.getTxtFont(), (Color)UIManager.getColor("textText"), (int)1, (boolean)false);
        if (fullTxtWidth > txtWidth && this.isSelected(index)) {
            txtWidth += 5;
        }
        if ((neededWidth = (int)HtmlRenderer.renderString((String)text, (Graphics)g, (int)0, (int)(height - fm.getDescent() - 4), (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (Font)this.getTxtFont(), (Color)UIManager.getColor("textText"), (int)1, (boolean)false)) > txtWidth) {
            text = this.getShortText(text, txtWidth, neededWidth);
        }
        HtmlRenderer.renderString((String)text, (Graphics)g, (int)(x + 8), (int)(height - fm.getDescent() - 4), (int)txtWidth, (int)height, (Font)this.getTxtFont(), (Color)UIManager.getColor("textText"), (int)1, (boolean)true);
        g2d.setClip(clip);
    }

    protected String getShortText(String text, int txtWidth, int neededWidth) {
        int shortText;
        if (text == null) {
            return null;
        }
        if (neededWidth <= 0) {
            neededWidth = 1;
        }
        if ((shortText = text.length() * txtWidth / neededWidth) > text.length()) {
            return text;
        }
        if (shortText < 4) {
            text = text.substring(0, 1) + ".";
        } else if (shortText < 6) {
            text = text.substring(0, 2);
            text = text + "..";
        } else {
            text = text.substring(0, shortText);
            text = text + "...";
        }
        return text;
    }

    protected void paintTabBorder(Graphics g, int index, int x, int y, int width, int height) {
    }

    protected void paintTabBackground(Graphics g, int index, int x, int y, int width, int height) {
        boolean isLast;
        boolean isSelected = this.isSelected(index);
        boolean isFocused = this.isFocused(index);
        boolean isMouseOver = this.isMouseOver(index);
        boolean bl = isLast = index == this.getDataModel().size() - 1;
        if (this.getDataModel().size() == 1) {
            WinsysInfoForTabbedContainer winsysInfo = this.displayer.getContainerWinsysInfo();
            if (null != winsysInfo && winsysInfo.isSlidedOutContainer()) {
                return;
            }
            g.drawImage(selectedSeparator, x + width - 2, y + 3, 2, height - 6, (ImageObserver)this.displayer);
            return;
        }
        if (!isFocused) {
            if (isSelected) {
                if (isMouseOver) {
                    OracleViewTabDisplayerUI.drawTabBackground(g, selectedRollover, x, y, width, height, 3);
                } else {
                    OracleViewTabDisplayerUI.drawTabBackground(g, selected, x, y, width, height, 3);
                }
            } else if (isMouseOver) {
                OracleViewTabDisplayerUI.drawTabBackground(g, normalRollover, x, y, width, height, 3);
            } else if (isLast || !isLast && !this.isSelected(index + 1) && !this.isFocused(index + 1) && !this.isMouseOver(index + 1)) {
                g.drawImage(separator, x + width - 1, y + 3, 1, height - 6, (ImageObserver)this.displayer);
            }
        } else {
            OracleViewTabDisplayerUI.drawTabBackground(g, focused, x, y, width, height, 3);
        }
        if (this.isAttention(index)) {
            AttentionSupport.paintAttention(g, x, y, width, height);
        }
    }

    private boolean isMouseOver(int index) {
        if (index < 0) {
            return false;
        }
        return ((OwnController)this.getController()).getMouseIndex() == index;
    }

    static Color getInactBgColor() {
        if (inactBgColor == null && (inactBgColor = (Color)UIManager.get("inactiveCaption")) == null) {
            inactBgColor = new Color(204, 204, 204);
        }
        return inactBgColor;
    }

    static Color getActBgColor() {
        if (actBgColor == null && (actBgColor = (Color)UIManager.get("activeCaption")) == null) {
            actBgColor = new Color(204, 204, 255);
        }
        return actBgColor;
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            String[] iconPaths;
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            iconPaths = new String[]{"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/bigclose_enabled.png", "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/bigclose_pressed.png", iconPaths[0], "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/bigclose_rollover.png"};
            buttonIconPaths.put(1, iconPaths);
            iconPaths = new String[]{"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/minimize_enabled.png", "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/minimize_pressed.png", iconPaths[0], "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/minimize_rollover.png"};
            buttonIconPaths.put(12, iconPaths);
            buttonIconPaths.put(6, iconPaths);
            buttonIconPaths.put(5, iconPaths);
            buttonIconPaths.put(7, iconPaths);
            iconPaths = new String[]{"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/restore_enabled.png", "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/restore_pressed.png", iconPaths[0], "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/restore_rollover.png"};
            buttonIconPaths.put(2, iconPaths);
            iconPaths = new String[]{"com/oracle/jdeveloper/nbwindowsystem/plaf/resources/restore_group_enabled.png", "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/restore_group_pressed.png", iconPaths[0], "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/restore_group_rollover.png"};
            buttonIconPaths.put(11, iconPaths);
        }
    }

    public Icon getButtonIcon(int buttonId, int buttonState) {
        if (buttonId == 12 && this.getDataModel().size() == 1) {
            switch (buttonState) {
                case 1: {
                    return iconMinimizePressed;
                }
                case 3: {
                    return iconMinimizeRollover;
                }
            }
            return iconMinimizeDefault;
        }
        Icon res = null;
        OracleViewTabDisplayerUI.initIcons();
        String[] paths = buttonIconPaths.get(buttonId);
        if (null != paths && buttonState >= 0 && buttonState < paths.length) {
            res = TabControlButtonFactory.getIcon((String)paths[buttonState]);
        }
        return res;
    }

    public void postTabAction(TabActionEvent e) {
        super.postTabAction(e);
        if ("maximize".equals(e.getActionCommand())) {
            ((OwnController)this.getController()).updateHighlight(-1);
        }
    }

    protected Font getTxtFont() {
        if (this.txtFont == null) {
            this.txtFont = (Font)UIManager.get("windowTitleFont");
            if (this.txtFont == null) {
                Integer size = (Integer)UIManager.get("windowTitleFontSize");
                if (size == null) {
                    size = 11;
                }
                this.txtFont = new Font("Dialog", 0, size);
            } else if (this.txtFont.isBold()) {
                this.txtFont = new Font(this.txtFont.getName(), 0, this.txtFont.getSize());
            }
        }
        return this.txtFont;
    }

    private static void initImages() {
        OracleViewTabDisplayerUI.initImages(normal, "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/viewtabs/normal/");
        OracleViewTabDisplayerUI.initImages(selected, "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/viewtabs/selected/");
        OracleViewTabDisplayerUI.initImages(normalRollover, "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/viewtabs/normal-rollover/");
        OracleViewTabDisplayerUI.initImages(selectedRollover, "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/viewtabs/selected-rollover/");
        OracleViewTabDisplayerUI.initImages(focused, "com/oracle/jdeveloper/nbwindowsystem/plaf/resources/viewtabs/focused/");
    }

    static void initImages(Image[] images, String prefix) {
        images[0] = ImageUtilities.loadImage((String)(prefix + "top.png"));
        images[1] = ImageUtilities.loadImage((String)(prefix + "top-left.png"));
        images[2] = ImageUtilities.loadImage((String)(prefix + "top-right.png"));
        images[3] = ImageUtilities.loadImage((String)(prefix + "left.png"));
        images[4] = ImageUtilities.loadImage((String)(prefix + "right.png"));
        images[5] = ImageUtilities.loadImage((String)(prefix + "middle.png"));
    }

    static {
        OracleViewTabDisplayerUI.initImages();
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private int lastIndex;

        private OwnController() {
            super((AbstractViewTabDisplayerUI)OracleViewTabDisplayerUI.this);
            this.lastIndex = -1;
        }

        public int getMouseIndex() {
            return this.lastIndex;
        }

        public void mouseMoved(MouseEvent e) {
            super.mouseMoved(e);
            Point pos = e.getPoint();
            this.updateHighlight(OracleViewTabDisplayerUI.this.getDataModel().size() == 1 ? 0 : OracleViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(pos.x, pos.y));
        }

        public void mouseExited(MouseEvent e) {
            super.mouseExited(e);
            if (!this.inControlButtonsRect(e.getPoint())) {
                this.updateHighlight(-1);
            }
        }

        private void updateHighlight(int curIndex) {
            int h;
            int w;
            int y;
            int x;
            if (curIndex == this.lastIndex) {
                return;
            }
            TabLayoutModel tlm = OracleViewTabDisplayerUI.this.getLayoutModel();
            Rectangle repaintRect = null;
            if (curIndex != -1) {
                x = tlm.getX(curIndex) - 1;
                y = tlm.getY(curIndex);
                w = tlm.getW(curIndex) + 2;
                h = tlm.getH(curIndex);
                repaintRect = new Rectangle(x, y, w, h);
            }
            if (this.lastIndex != -1 && this.lastIndex < OracleViewTabDisplayerUI.this.getDataModel().size()) {
                x = tlm.getX(this.lastIndex) - 1;
                y = tlm.getY(this.lastIndex);
                w = tlm.getW(this.lastIndex) + 2;
                h = tlm.getH(this.lastIndex);
                repaintRect = repaintRect != null ? repaintRect.union(new Rectangle(x, y, w, h)) : new Rectangle(x, y, w, h);
            }
            if (OracleViewTabDisplayerUI.this.getDataModel().size() == 1) {
                OracleViewTabDisplayerUI.this.getDisplayer().repaint();
            } else if (repaintRect != null) {
                OracleViewTabDisplayerUI.this.getDisplayer().repaint(repaintRect);
            }
            this.lastIndex = curIndex;
        }
    }
}

