/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.transform.Templates;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.xpath.XPathFunctionResolver;
import oracle.xml.jaxp.JXEntityResolver;
import oracle.xml.jdwp.LineTable;
import oracle.xml.jdwp.VariableTable;
import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNamespaceContext;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.util.FastVector;
import oracle.xml.util.XMLCompatible;
import oracle.xml.util.XMLError;
import oracle.xml.util.XMLUtil;
import oracle.xml.xpath.XMLPathTable;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLApplyImport;
import oracle.xml.xslt.XSLApplyTemplates;
import oracle.xml.xslt.XSLAttribute;
import oracle.xml.xslt.XSLAttributeSet;
import oracle.xml.xslt.XSLCallTemplate;
import oracle.xml.xslt.XSLCharacterMap;
import oracle.xml.xslt.XSLCondition;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLCopy;
import oracle.xml.xslt.XSLCopyOf;
import oracle.xml.xslt.XSLDocument;
import oracle.xml.xslt.XSLElement;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLFallback;
import oracle.xml.xslt.XSLForEach;
import oracle.xml.xslt.XSLForEachGroup;
import oracle.xml.xslt.XSLFunction;
import oracle.xml.xslt.XSLImportSchema;
import oracle.xml.xslt.XSLKey;
import oracle.xml.xslt.XSLMiscElements;
import oracle.xml.xslt.XSLNamespace2;
import oracle.xml.xslt.XSLNextMatch;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLNumber;
import oracle.xml.xslt.XSLOtherElements;
import oracle.xml.xslt.XSLOutput;
import oracle.xml.xslt.XSLOutputCharacter;
import oracle.xml.xslt.XSLPerfSort;
import oracle.xml.xslt.XSLResultDocument;
import oracle.xml.xslt.XSLResultElement;
import oracle.xml.xslt.XSLSequence;
import oracle.xml.xslt.XSLSort;
import oracle.xml.xslt.XSLSortKey;
import oracle.xml.xslt.XSLSpaceElem;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTemplate;
import oracle.xml.xslt.XSLText;
import oracle.xml.xslt.XSLValueOf;
import oracle.xml.xslt.XSLVariable;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSLBuilder
extends DefaultHandler
implements XSLConstants,
TemplatesHandler {
    private int classID = 0;
    private int methodID = 1;
    private int dmethodID = -1;
    private boolean fixedXss;
    private boolean compat2029 = false;
    private XSLStylesheet xss;
    private XSLNode xssRoot;
    private boolean ignorexmlid = false;
    private XMLPathTable pathtable;
    private URL baseURL;
    private String baseStr;
    private Stack xbases = new Stack();
    private URL xssURL;
    private Stack<String> impNinc;
    private XMLError err;
    private Locator locator;
    private EntityResolver entityResolver;
    private FastVector nodeStack;
    private ArrayList importSchemaNodes;
    private XSLNode currentNode;
    private int contentMode;
    private int importLevel;
    private int importPriority;
    private int skipTopLevel;
    private int includeProcessing;
    private int xsltversion;
    private int version;
    private boolean bkwdCompFlag;
    private boolean fwdCompFlag;
    private boolean isSecure;
    private XMLSchema schema;
    private DocumentBuilder esdombuilder = null;
    private boolean isesm = false;
    private boolean isimpsch = false;
    private XPathFunctionResolver funcResolver;
    XMLDocument schemadom;
    XSLImportSchema ximpschnode = null;
    XSDBuilder xsdbuilder = null;
    boolean namespacecontextset = false;
    int codeIndex = 0;
    static HashMap<String, Integer> elemIds;
    static HashSet<String> transformAttrs;
    static HashSet<String> stylesheetAttrs;
    static HashSet<String> resultDocAttrs;
    static HashSet<String> outputAttrs;
    static HashSet<String> numberAttrs;
    static HashSet<String> decFormatAttrs;
    static HashSet<String> stdAttrs;

    public XSLBuilder() {
        this.nodeStack = new FastVector(16);
        this.contentMode = 0;
    }

    XSLBuilder(XSLStylesheet xSLStylesheet) {
        this.xss = xSLStylesheet;
        this.fixedXss = true;
        this.nodeStack = new FastVector(16);
        this.contentMode = 0;
    }

    public XSLStylesheet getStylesheet() throws XSLException {
        this.xss.setSecure(this.isSecure ? Boolean.TRUE : Boolean.FALSE);
        return this.xss;
    }

    void setXMLSchema(XMLSchema xMLSchema) {
        this.schema = xMLSchema;
    }

    XMLSchema getSyntheticXMLSchema() {
        return this.schema;
    }

    void setXMLPathTable(XMLPathTable xMLPathTable) {
        this.pathtable = xMLPathTable;
    }

    public void reset() {
        if (!this.fixedXss) {
            this.xss = null;
        }
        this.locator = null;
        this.nodeStack.setSize(0);
        this.currentNode = null;
        this.contentMode = 0;
        this.importLevel = 0;
        this.importPriority = 0;
        this.skipTopLevel = 0;
        this.includeProcessing = 0;
        this.bkwdCompFlag = false;
        this.fwdCompFlag = false;
        this.impNinc = null;
        this.xbases.clear();
    }

    public void setBaseURL(URL uRL) {
        this.xssURL = this.baseURL = uRL;
    }

    public void setError(XMLError xMLError) {
        this.err = xMLError;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        this.funcResolver = xPathFunctionResolver;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setSecure(boolean bl) {
        this.isSecure = bl;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            if (this.includeProcessing == 0) {
                if (this.err == null) {
                    this.err = new XMLError();
                }
                if (this.xss == null) {
                    this.xss = new XSLStylesheet();
                    this.xss.setXMLPathTable(this.pathtable);
                    this.xss.setFunctionResolver(this.funcResolver);
                }
                this.xss.set2029Compatibility(this.compat2029);
                this.xss.setXMLSchema(this.schema);
            }
            this.xssRoot = new XSLNode(this.xss);
            this.xssRoot.elementType = 1;
            this.xssRoot.xssImportPriority = this.importPriority;
            this.xssRoot.setLocalName("stylesheet");
            if (this.xss.getXSLDebugProp().debug()) {
                this.methodID = 1;
            }
            if (this.includeProcessing > 0) {
                return;
            }
            this.xss.err = this.err;
            this.nodeStack.addElement(this.xss);
            if (this.locator != null) {
                this.err.setLocator(this.locator);
                this.xss.setDebugInfo(this.locator.getLineNumber(), this.locator.getColumnNumber(), this.locator.getSystemId());
            }
            this.currentNode = this.xss;
            this.contentMode = 0;
        }
        catch (XSLException xSLException) {
            throw new SAXException(xSLException);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.xss.appendChild(this.xssRoot);
            if (this.xss.getXSLDebugProp().debug()) {
                this.methodID = 1;
            }
            if (this.includeProcessing > 0) {
                this.importPriority = this.xssRoot.xssImportPriority;
                return;
            }
            this.xss.endContent();
            ArrayList[] arrayListArray = this.groupingImportSchemaNodes(this.importSchemaNodes);
            if (arrayListArray != null && arrayListArray.length > 0) {
                this.schema = this.syntheticGroupedImportSchemaNodes(arrayListArray);
            }
        }
        catch (XSLException xSLException) {
            throw new SAXException(xSLException);
        }
        catch (XQException xQException) {
            throw new SAXException(xQException);
        }
    }

    private XMLSchema syntheticGroupedImportSchemaNodes(ArrayList[] arrayListArray) throws XSLException {
        if (arrayListArray == null) {
            return null;
        }
        int n = arrayListArray.length;
        XMLSchema xMLSchema = null;
        try {
            XSLImportSchema xSLImportSchema;
            ArrayList arrayList;
            if (this.xsdbuilder == null) {
                this.xsdbuilder = new XSDBuilder();
            }
            XMLDocument xMLDocument = new XMLDocument();
            XMLElement xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", "xs:schema");
            xMLDocument.appendChild(xMLElement);
            boolean bl = false;
            if (n > 0 && (arrayList = arrayListArray[0]) != null && arrayList.size() > 0) {
                xSLImportSchema = (XSLImportSchema)arrayList.get(0);
                if (!this.namespacecontextset && xSLImportSchema != null) {
                    this.xsdbuilder.setXMLProperty("XDK_Namespace_Context", new XSDNamespaceContext(xSLImportSchema.getPrefixHash()));
                    this.namespacecontextset = true;
                }
            }
            for (int i = 0; i < n; ++i) {
                arrayList = arrayListArray[i];
                for (int j = 0; j < arrayList.size(); ++j) {
                    xSLImportSchema = (XSLImportSchema)arrayList.get(j);
                    XMLDocument xMLDocument2 = xSLImportSchema.getEmbededSchemaDOM();
                    if (xMLDocument2 == null) {
                        XMLElement xMLElement2 = xSLImportSchema.convert2XMLElement(xMLDocument);
                        xMLElement.appendChild(xMLElement2);
                        bl = true;
                        continue;
                    }
                    int n2 = xSLImportSchema.validateImportSchemaNode();
                    if (n2 == -1) {
                        throw new XSLException(this.err, 0);
                    }
                    xMLSchema = this.xsdbuilder.build(xMLDocument2, this.baseURL);
                }
            }
            if (bl) {
                xMLSchema = this.xsdbuilder.build(xMLDocument, this.baseURL);
            }
        }
        catch (XSDException xSDException) {
            // empty catch block
        }
        return xMLSchema;
    }

    private ArrayList[] groupingImportSchemaNodes(ArrayList arrayList) {
        Object[] objectArray;
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        int n = arrayList.size();
        if (n == 1) {
            ArrayList[] arrayListArray = new ArrayList[n];
            arrayListArray[0] = new ArrayList();
            arrayListArray[0].add(arrayList.get(0));
            return arrayListArray;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < n; ++i) {
            ArrayList<Object[]> arrayList2;
            int n2;
            objectArray = (Object[])arrayList.get(i);
            String string = objectArray.nsvalue;
            Object v = hashMap.get(string);
            if (v == null) {
                hashMap.put(string, objectArray);
                continue;
            }
            int n3 = objectArray.importprecedence;
            if (v instanceof XSLImportSchema) {
                n2 = ((XSLImportSchema)v).importprecedence;
            } else {
                arrayList2 = (ArrayList<Object[]>)v;
                XSLImportSchema xSLImportSchema = (XSLImportSchema)arrayList2.get(0);
                n2 = xSLImportSchema.importprecedence;
            }
            if (n3 < n2) {
                hashMap.put(string, objectArray);
                continue;
            }
            if (n3 != n2) continue;
            if (v instanceof XSLImportSchema) {
                arrayList2 = new ArrayList<Object[]>(2);
                arrayList2.add(objectArray);
                arrayList2.add((Object[])((XSLImportSchema)v));
                hashMap.put(string, arrayList2);
                continue;
            }
            arrayList2 = (ArrayList)v;
            arrayList2.add(objectArray);
            hashMap.put(string, arrayList2);
        }
        Collection collection = hashMap.values();
        objectArray = collection.toArray();
        n = hashMap.size();
        ArrayList[] arrayListArray = new ArrayList[n];
        for (int i = 0; i < n; ++i) {
            arrayListArray[i] = new ArrayList();
            arrayListArray[i].add(objectArray[i]);
        }
        return arrayListArray;
    }

    private ArrayList[] groupingImportSchemaNodesOld(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        int n = arrayList.size();
        if (n == 1) {
            ArrayList[] arrayListArray = new ArrayList[n];
            arrayListArray[0] = new ArrayList();
            arrayListArray[0].add(arrayList.get(0));
            return arrayListArray;
        }
        int n2 = 0;
        ArrayList[] arrayListArray = new ArrayList[n];
        for (int i = 0; i < n; ++i) {
            XSLImportSchema xSLImportSchema = (XSLImportSchema)arrayList.get(i);
            if (xSLImportSchema == null) continue;
            int n3 = xSLImportSchema.importprecedence;
            String string = xSLImportSchema.nsvalue;
            arrayList.set(i, null);
            arrayListArray[n2] = new ArrayList();
            arrayListArray[n2].add(xSLImportSchema);
            for (int j = i + 1; j < n; ++j) {
                String string2;
                XSLImportSchema xSLImportSchema2 = (XSLImportSchema)arrayList.get(j);
                if (xSLImportSchema2 == null || !string.equals(string2 = xSLImportSchema2.nsvalue)) continue;
                int n4 = xSLImportSchema2.importprecedence;
                if (n4 < n3) {
                    arrayListArray[n2].set(i, xSLImportSchema2);
                    arrayList.set(j, null);
                    n3 = n4;
                    continue;
                }
                if (n4 != n3) continue;
                arrayListArray[n2].add(xSLImportSchema2);
                arrayList.set(j, null);
            }
            ++n2;
        }
        if (n2 < n) {
            ArrayList[] arrayListArray2 = new ArrayList[n2];
            System.arraycopy(arrayListArray, 0, arrayListArray2, 0, n2);
            return arrayListArray2;
        }
        return arrayListArray;
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.isesm && this.isimpsch) {
            this.esdombuilder.endPrefixMapping(string);
        }
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        if (this.isesm && this.isimpsch) {
            this.esdombuilder.endPrefixMapping(string);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string.equals("http://www.w3.org/1999/XSL/Transform") && string2.equals("import-schema")) {
            this.isimpsch = true;
        } else if (this.isimpsch && string.equals("http://www.w3.org/2001/XMLSchema") && string2.equals("schema")) {
            this.isesm = true;
            this.esdombuilder = new DocumentBuilder();
            this.esdombuilder.startDocument();
            this.esdombuilder.startElement(string, string2, string3, attributes);
        } else if (this.isimpsch && this.isesm) {
            this.esdombuilder.startElement(string, string2, string3, attributes);
            return;
        }
        Integer n = null;
        if ("http://www.w3.org/1999/XSL/Transform".equals(string) && (n = elemIds.get(string2)) == null && !this.fwdCompFlag) {
            if (XMLCompatible.useBuggyBehavior(11703832)) {
                this.err.error1(22134, 2, string3);
            } else {
                this.err.error1(22134, 1, string3);
            }
        }
        try {
            XSLNode xSLNode = null;
            if (this.skipTopLevel > 0) {
                ++this.skipTopLevel;
                return;
            }
            switch (this.contentMode) {
                case 3: 
                case 8: {
                    break;
                }
                case 0: {
                    xSLNode = this.processStylesheetRoot(string, string2, string3, attributes);
                    break;
                }
                case 1: {
                    xSLNode = this.processImport(string, string2, attributes);
                    if (xSLNode != null) break;
                }
                case 2: {
                    xSLNode = this.createTopLevelInstruction(string, string2, attributes);
                    if (xSLNode != null) break;
                    if (this.version == 10) {
                        return;
                    }
                    this.xbases.push(this.baseURL);
                    return;
                }
                case 6: {
                    xSLNode = this.createMiscTemplateInstruction(string, string2);
                    if (xSLNode != null) break;
                }
                case 7: {
                    xSLNode = this.createTemplateInstruction(string, string2);
                    if (xSLNode != null) break;
                }
                case 5: {
                    xSLNode = this.createCharTemplateInstruction(string, string2);
                    if (xSLNode != null) break;
                }
                case 4: {
                    xSLNode = this.createMiscTemplateElement(string, string2);
                }
            }
            if (xSLNode == null) {
                xSLNode = new XSLNode(this.xss);
                xSLNode.elementType = 7;
                String string4 = this.currentNode.getQualifiedName();
                String string5 = this.currentNode.getLocalName();
                if (string5.equals("template") && string2.equals("param") || string5.equals("for-each") && string2.equals("sort") || string5.equals("for-each-group") && string2.equals("sort") || string5.equals("perform-sort") && string2.equals("sort")) {
                    this.err.error2(1048, 2, string3, string4);
                } else {
                    this.err.error2(1029, 2, string3, string4);
                    xSLNode.setErrorId(1047, 1, 2);
                    xSLNode.addErrorParam(0, string3);
                    xSLNode.addErrorParam(1, string4);
                }
            }
            xSLNode.setURI(string);
            xSLNode.setPrefix(XMLUtil.getPrefix(string3));
            xSLNode.setLocalName(string2);
            this.pushXSLNode(xSLNode);
            this.processAttributes(n, xSLNode, attributes);
            xSLNode.startContent();
            this.contentMode = xSLNode.getElementType();
            this.pushBaseURL(xSLNode, string, string2);
            if (xSLNode instanceof XSLImportSchema) {
                this.ximpschnode = (XSLImportSchema)xSLNode;
                if (this.importSchemaNodes == null) {
                    this.importSchemaNodes = new ArrayList();
                }
                this.importSchemaNodes.add(this.ximpschnode);
            }
            if (this.xss.getXSLDebugProp().debug()) {
                ++this.codeIndex;
                XSLJDWPUtil.printTrace(this.xss.dbgProp, "XSLBuilder.startElement: " + string2 + " is: " + xSLNode.getLineNumber() + ":" + this.codeIndex);
                xSLNode.setCodeIndexBegin(this.codeIndex);
                this.addMethodID(xSLNode);
                this.addGlobalLineVarTableData(xSLNode.getLineNumber(), string, string2, xSLNode, true);
                this.addLineTableData(xSLNode.getLineNumber(), string, string2, xSLNode, true);
                this.addVariableTableData(xSLNode, string, string2);
            }
        }
        catch (XSLException xSLException) {
            throw new SAXException(xSLException);
        }
        catch (XQException xQException) {
            throw new SAXException(xQException);
        }
    }

    private void pushBaseURL(XSLNode xSLNode, String string, String string2) {
        if (this.version == 10) {
            return;
        }
        URL uRL = xSLNode.getXBaseURL();
        this.baseURL = uRL != null ? uRL : (this.xbases.size() > 0 ? (URL)this.xbases.peek() : this.xssURL);
        this.xbases.push(this.baseURL);
        xSLNode.setBaseURL(this.baseURL);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string.equals("http://www.w3.org/1999/XSL/Transform") && string2.equals("import-schema")) {
            this.isimpsch = false;
        }
        if (this.isesm && string.equals("http://www.w3.org/2001/XMLSchema") && string2.equals("schema")) {
            this.isimpsch = false;
        }
        if (this.isesm && string.equals("http://www.w3.org/2001/XMLSchema") && string2.equals("schema")) {
            this.isesm = false;
            this.esdombuilder.endElement(string, string2, string3);
            this.esdombuilder.endDocument();
            this.schemadom = this.esdombuilder.getDocument();
            this.ximpschnode.setEmbededSchemaDOM(this.schemadom);
            try {
                if (this.xsdbuilder == null) {
                    this.xsdbuilder = new XSDBuilder();
                }
                if (!this.namespacecontextset) {
                    this.xsdbuilder.setXMLProperty("XDK_Namespace_Context", new XSDNamespaceContext(this.ximpschnode.getPrefixHash()));
                    this.namespacecontextset = true;
                }
            }
            catch (XSDException xSDException) {
                this.err.error0(24000, 1);
            }
            return;
        }
        if (this.isesm && this.isimpsch) {
            this.esdombuilder.endElement(string, string2, string3);
            return;
        }
        if (this.skipTopLevel > 0) {
            --this.skipTopLevel;
            return;
        }
        try {
            this.currentNode.endContent();
            if (this.xss.getXSLDebugProp().debug()) {
                if (this.locator != null) {
                    this.currentNode.setEndingLineNumber(this.locator.getLineNumber());
                }
                ++this.codeIndex;
                XSLJDWPUtil.printTrace(this.xss.dbgProp, "XSLBuilder.endElement: " + string2 + " is: " + this.currentNode.getEndingLineNumber() + ":" + this.codeIndex);
                this.currentNode.setCodeIndexEnd(this.codeIndex);
                this.addGlobalLineVarTableData(this.currentNode.getEndingLineNumber(), string, string2, this.currentNode, false);
                this.addLineTableData(this.currentNode.getEndingLineNumber(), string, string2, this.currentNode, false);
                this.processMethodEnd(this.currentNode);
            }
        }
        catch (XSLException xSLException) {
            throw new SAXException(xSLException);
        }
        catch (XQException xQException) {
            throw new SAXException(xQException);
        }
        int n = this.nodeStack.size();
        this.currentNode = (XSLNode)this.nodeStack.elementAt(n - 2);
        this.contentMode = this.currentNode.elementType;
        this.nodeStack.setSize(n - 1);
        if (this.version != 10) {
            this.xbases.pop();
        }
        this.version = this.currentNode.getXSLTVersion();
        this.bkwdCompFlag = this.currentNode.isBackwardCompatibilityMode();
        this.fwdCompFlag = this.currentNode.isForwardCompatibilityMode();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.isesm && this.isimpsch) {
            this.esdombuilder.characters(cArray, n, n2);
            return;
        }
        try {
            if (this.skipTopLevel > 0) {
                return;
            }
            if (this.contentMode == 1 || this.contentMode == 2 || this.contentMode == 4 || this.contentMode == 3) {
                if (!XMLUtil.isWhiteSpace(cArray, n, n2)) {
                    this.err.error2(1029, 2, "text", this.currentNode.getQualifiedName());
                }
            } else {
                this.currentNode.appendText(cArray, n, n2);
            }
        }
        catch (XSLException xSLException) {
            throw new SAXException(xSLException);
        }
    }

    void setXSLTVersion(int n) {
        this.xsltversion = n;
    }

    void set2029Compatibility(boolean bl) {
        this.compat2029 = bl;
    }

    private XSLNode processStylesheetRoot(String string, String string2, String string3, Attributes attributes) throws XSLException, SAXException, XQException {
        String string4;
        String string5;
        XSLNode xSLNode = this.xssRoot;
        String string6 = "";
        if ("http://www.w3.org/1999/XSL/Transform".equals(string)) {
            if (!string2.equals("stylesheet") && !string2.equals("transform")) {
                this.err.error1(1001, 1, string3);
                return null;
            }
        } else {
            string6 = "http://www.w3.org/1999/XSL/Transform";
        }
        if ((string5 = attributes.getValue(string6, "version")) != null) {
            double d = new Double(string5);
            this.setCompatibilityFlags(d);
            if (this.includeProcessing == 0) {
                this.xss.setCompatibilityFlags(this.version, this.bkwdCompFlag, this.fwdCompFlag);
            }
        } else {
            String string7 = "version";
            if (string6.equals("http://www.w3.org/1999/XSL/Transform")) {
                string7 = "{http://www.w3.org/1999/XSL/Transform}:version";
            }
            this.err.error2(1009, 1, string7, string3);
        }
        if (!string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (string2.equalsIgnoreCase("html") && string.equals("")) {
                this.xss.output.setMethod("html");
            }
            this.xssRoot.setCompatibilityFlags(this.version, this.bkwdCompFlag, this.fwdCompFlag);
            XSLTemplate xSLTemplate = new XSLTemplate(this.xss);
            xSLTemplate.setAttribute("", "", "match", "/");
            xSLTemplate.setURI("http://www.w3.org/1999/XSL/Transform");
            xSLTemplate.setLocalName("template");
            xSLTemplate.startContent();
            xSLTemplate.endContent();
            this.xssRoot.appendChild(xSLTemplate);
            this.currentNode = xSLTemplate;
            this.contentMode = 7;
            xSLTemplate.elementType = 7;
            xSLNode = this.createTemplateInstruction(string, string2);
        }
        if ((string4 = attributes.getValue("http://www.oracle.com/XSL/Transform/java", "ignorexmlids")) != null && string4.equalsIgnoreCase("true")) {
            this.ignorexmlid = true;
        }
        return xSLNode;
    }

    private void setCompatibilityFlags(double d) {
        if (this.xsltversion == 10) {
            this.version = 10;
            if (d > 1.0) {
                this.fwdCompFlag = true;
            }
        } else if (this.xsltversion == 20) {
            this.version = 20;
            if (d < 2.0) {
                this.bkwdCompFlag = true;
            } else if (d > 2.0) {
                this.fwdCompFlag = true;
            }
        } else if (d >= 2.0) {
            this.version = 20;
            if (d > 2.0) {
                this.fwdCompFlag = true;
            }
        } else {
            this.version = 10;
            if (d > 1.0) {
                this.fwdCompFlag = true;
            }
        }
    }

    private XSLNode createMiscTemplateInstruction(String string, String string2) throws XSLException {
        XSLNode xSLNode = null;
        String string3 = this.currentNode.getLocalName();
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (string3.equals("template") && string2.equals("param")) {
                xSLNode = new XSLVariable(this.xss, string2);
                if (this.xss.getXSLDebugProp().debug()) {
                    Long l;
                    String string4 = this.currentNode.baseURL.toString();
                    this.classID = this.xss.getJDWPVirtualMachine().getClassID(string4);
                    long l2 = ((long)this.classID << 32) + (long)this.methodID;
                    Hashtable hashtable = this.xss.getClassMethodParams();
                    Integer n = (Integer)hashtable.get(l = new Long(l2));
                    if (n == null) {
                        int n2 = 1;
                        hashtable.put(l, new Integer(n2));
                    } else {
                        int n3 = n;
                        hashtable.put(l, new Integer(++n3));
                    }
                }
            } else if (string3.equals("for-each") && string2.equals("sort")) {
                xSLNode = new XSLSort(this.xss);
            } else if (this.version >= 20 && string3.equals("for-each-group") && string2.equals("sort")) {
                xSLNode = new XSLSort(this.xss);
            } else if (this.version >= 20 && string3.equals("function") && string2.equals("param")) {
                xSLNode = new XSLVariable(this.xss, string2);
            } else if (this.version >= 20 && string3.equals("perform-sort") && string2.equals("sort")) {
                xSLNode = new XSLSort(this.xss);
            }
        }
        if (xSLNode == null) {
            this.contentMode = 7;
            this.currentNode.elementType = 7;
        }
        return xSLNode;
    }

    private XSLNode createTemplateInstruction(String string, String string2) throws XSLException {
        XSLNode xSLNode = null;
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (string2.equals("attribute")) {
                xSLNode = new XSLAttribute(this.xss);
            } else if (string2.equals("element")) {
                xSLNode = new XSLElement(this.xss);
            } else if (string2.equals("sequence") && this.version >= 20) {
                xSLNode = new XSLSequence(this.xss);
            } else if (string2.equals("document") && this.version >= 20) {
                xSLNode = new XSLDocument(this.xss);
            } else if (string2.equals("result-document") && this.version >= 20) {
                xSLNode = new XSLResultDocument(this.xss);
            } else if (string2.equals("namespace") && this.version >= 20) {
                xSLNode = new XSLNamespace2(this.xss);
            } else if (string2.equals("processing-instruction") || string2.equals("comment")) {
                xSLNode = new XSLMiscElements(string2, this.xss);
            }
        } else {
            xSLNode = new XSLResultElement(this.xss);
        }
        return xSLNode;
    }

    private XSLNode createCharTemplateInstruction(String string, String string2) throws XSLException {
        XSLNode xSLNode = null;
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (string2.equals("text")) {
                xSLNode = new XSLText(this.xss);
            } else if (string2.equals("message")) {
                xSLNode = new XSLMiscElements(string2, this.xss);
            } else if (string2.equals("apply-imports")) {
                xSLNode = new XSLApplyImport(this.xss);
            } else if (string2.equals("next-match") && this.version >= 20) {
                xSLNode = new XSLNextMatch(this.xss);
            } else if (string2.equals("apply-templates")) {
                xSLNode = new XSLApplyTemplates(this.xss);
            } else if (string2.equals("for-each")) {
                xSLNode = new XSLForEach(this.xss);
            } else if (string2.equals("for-each-group") && this.version >= 20) {
                xSLNode = new XSLForEachGroup(this.xss);
            } else if (string2.equals("perform-sort") && this.version >= 20) {
                xSLNode = new XSLPerfSort(this.xss);
            } else if (string2.equals("call-template")) {
                xSLNode = new XSLCallTemplate(this.xss);
            } else if (string2.equals("copy")) {
                xSLNode = new XSLCopy(this.xss);
            } else if (string2.equals("copy-of")) {
                xSLNode = new XSLCopyOf(this.xss);
            } else if (string2.equals("value-of")) {
                xSLNode = new XSLValueOf(this.xss);
            } else if (string2.equals("number")) {
                xSLNode = new XSLNumber(this.xss);
            } else if (string2.equals("choose") || string2.equals("if")) {
                xSLNode = new XSLCondition(this.xss);
            } else if (string2.equals("variable")) {
                xSLNode = new XSLVariable(this.xss, string2);
            } else if (string2.equals("fallback")) {
                xSLNode = new XSLFallback(this.xss);
            } else if (this.fwdCompFlag) {
                xSLNode = new XSLOtherElements(this.xss);
            }
        }
        return xSLNode;
    }

    private XSLNode createMiscTemplateElement(String string, String string2) throws XSLException {
        XSLNode xSLNode = null;
        String string3 = this.currentNode.getLocalName();
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (string3.equals("apply-templates")) {
                if (string2.equals("with-param")) {
                    xSLNode = new XSLVariable(this.xss, string2);
                } else if (string2.equals("sort")) {
                    xSLNode = new XSLSort(this.xss);
                }
            } else if (this.version >= 20 && string3.equals("apply-imports") && string2.equals("with-param")) {
                xSLNode = new XSLVariable(this.xss, string2);
            } else if (this.version >= 20 && string3.equals("next-match") && string2.equals("with-param")) {
                xSLNode = new XSLVariable(this.xss, string2);
            } else if (string3.equals("call-template") && string2.equals("with-param")) {
                xSLNode = new XSLVariable(this.xss, string2);
            } else if (string3.equals("choose")) {
                if (string2.equals("when") || string2.equals("otherwise")) {
                    xSLNode = new XSLCondition(this.xss);
                }
            } else if (string3.equals("attribute-set") && string2.equals("attribute")) {
                xSLNode = new XSLAttribute(this.xss);
            } else if (string3.equals("sort-key") && this.version >= 20) {
                if (string2.equals("sort")) {
                    xSLNode = new XSLSort(this.xss);
                }
            } else if (string3.equals("character-map")) {
                if (string2.equals("output-character")) {
                    xSLNode = new XSLOutputCharacter(this.xss);
                }
            } else if (this.currentNode instanceof XSLOtherElements && string2.equals("fallback")) {
                xSLNode = new XSLFallback(this.xss);
            }
        } else if (string.equals("http://www.oracle.com/XSL/Transform/java") && string3.equals("extlib") && string2.equals("element")) {
            xSLNode = new XSLNode(this.xss);
        }
        return xSLNode;
    }

    private XSLNode createTopLevelInstruction(String string, String string2, Attributes attributes) throws XSLException, SAXException {
        XSLNode xSLNode = null;
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (string2.equals("import")) {
                xSLNode = this.processImport(string, string2, attributes);
                this.err.error2(1048, 1, string2, "stylesheet");
            } else if (string2.equals("include")) {
                xSLNode = this.processInclude(string, string2, attributes);
            } else if (string2.equals("template")) {
                xSLNode = new XSLTemplate(this.xss);
                xSLNode.setBaseURL(this.baseURL);
                ((XSLTemplate)xSLNode).importLevel = this.importLevel;
                ((XSLTemplate)xSLNode).importPriority = this.xssRoot.xssImportPriority;
            } else if (string2.equals("variable") || string2.equals("param")) {
                xSLNode = new XSLVariable(this.xss, string2);
                xSLNode.setBaseURL(this.baseURL);
            } else if (string2.equals("attribute-set")) {
                xSLNode = new XSLAttributeSet(this.xss);
            } else if (string2.equals("key")) {
                xSLNode = new XSLKey(this.xss);
            } else if (string2.equals("strip-space") || string2.equals("preserve-space")) {
                xSLNode = new XSLSpaceElem(this.xss, string2);
                ((XSLSpaceElem)xSLNode).importPriority = this.xssRoot.xssImportPriority;
            } else if (string2.equals("output")) {
                xSLNode = new XSLOutput(this.xss);
            } else if (string2.equals("namespace-alias")) {
                xSLNode = new XSLNode(this.xss);
            } else if (string2.equals("decimal-format")) {
                xSLNode = new XSLNode(this.xss);
            } else if (string2.equals("function") && this.version >= 20) {
                xSLNode = new XSLFunction(this.xss);
                ((XSLFunction)xSLNode).funcstruc.importprecedence = this.importLevel;
            } else if (string2.equals("import-schema") && this.version >= 20) {
                xSLNode = new XSLImportSchema(this.xss);
                ((XSLImportSchema)xSLNode).importprecedence = this.importLevel;
            } else if (string2.equals("sort-key") && this.version >= 20) {
                xSLNode = new XSLSortKey(this.xss);
            } else if (string2.equals("character-map") && this.version >= 20) {
                xSLNode = new XSLCharacterMap(this.xss);
                ((XSLCharacterMap)xSLNode).importLevel = this.importLevel;
            }
        } else if (string.equals("http://www.oracle.com/XSL/Transform/java")) {
            if (string2.equals("output")) {
                xSLNode = new XSLOutput(this.xss);
            } else if (string2.equals("extlib")) {
                xSLNode = new XSLNode(this.xss);
                xSLNode.elementType = 4;
            }
        }
        if (xSLNode == null) {
            ++this.skipTopLevel;
        }
        return xSLNode;
    }

    private void processAttributes(Integer n, XSLNode xSLNode, Attributes attributes) throws XSLException, SAXException, XQException {
        String string;
        String string2;
        String string3;
        String string4;
        int n2;
        int n3 = attributes.getLength();
        for (n2 = 0; n2 < n3; ++n2) {
            string4 = ((SAXAttrList)attributes).getPrefix(n2);
            string3 = attributes.getLocalName(n2);
            string2 = attributes.getURI(n2);
            string = attributes.getValue(n2);
            if (string4.equals("xmlns")) {
                xSLNode.addNamespace(string3, string.intern());
                continue;
            }
            if (string3.equals("xmlns")) {
                xSLNode.addNamespace("#default", string.intern());
                continue;
            }
            if (this.version < 20 || !string3.equals("xpath-default-namespace")) continue;
            xSLNode.addNamespace("#xpath-default-namespace", string.intern());
        }
        for (n2 = 0; n2 < n3; ++n2) {
            string4 = ((SAXAttrList)attributes).getPrefix(n2);
            string3 = attributes.getLocalName(n2);
            string2 = attributes.getURI(n2);
            string = attributes.getValue(n2);
            if (!(string4.equals("xmlns") || string3.equals("xmlns") || string3.equals("xpath-default-namespace"))) {
                if (this.ignorexmlid && string4.equals("xml") && string3.equals("id") && string2.equals("http://www.w3.org/XML/1998/namespace")) continue;
                xSLNode.setAttribute(string2.intern(), string4.intern(), string3.intern(), string.intern());
            }
            if (string3.equals("version") && !xSLNode.getLocalName().equals("output")) {
                String string5 = xSLNode.getURI();
                if (string2.equals("") && string5.equals("http://www.w3.org/1999/XSL/Transform") || !string2.equals("http://www.w3.org/1999/XSL/Transform") && !string5.equals("http://www.w3.org/1999/XSL/Transform")) {
                    double d = new Double(string);
                    this.setCompatibilityFlags(d);
                    xSLNode.setCompatibilityFlags(this.version, this.bkwdCompFlag, this.fwdCompFlag);
                }
            }
            if (n == null || !string2.equals("") && !string2.equals("http://www.w3.org/1999/XSL/Transform") || this.verifyAttribute(n, string2, string3) || this.fwdCompFlag) continue;
            this.err.error2(22133, 1, attributes.getQName(n2), xSLNode.localName);
        }
        if (this.version == 10 && xSLNode.prefixHash != null) {
            xSLNode.prefixHash.put("#xpath-default-namespace", "");
        }
    }

    private XSLNode processImport(String string, String string2, Attributes attributes) throws XSLException, SAXException {
        XSLNode xSLNode = null;
        if (string.equals("http://www.w3.org/1999/XSL/Transform") && string2.equals("import")) {
            String string3;
            xSLNode = new XSLNode(this.xss);
            String string4 = string3 = attributes.getValue("href");
            if (string3 != null) {
                URL uRL = this.getAbsoluteURL(attributes, this.xssURL, string3);
                if (uRL != null) {
                    string4 = uRL.toString();
                } else if (this.entityResolver == null) {
                    this.err.error1(1006, 1, string3);
                }
                if (this.impNinc == null) {
                    this.impNinc = new Stack();
                }
                if (this.xssURL != null && string4.equals(this.xssURL.toString()) || this.impNinc.contains(string4)) {
                    this.err.error2(1123, 0, uRL.toString(), "xsl:import or xsl:include");
                    throw new XSLException(this.err, 0);
                }
                this.impNinc.push(string4);
                this.processImportHref(string3, attributes);
                this.impNinc.pop();
            } else {
                this.err.error2(1009, 1, "href", "xsl:import");
            }
        } else {
            this.xssRoot.elementType = 2;
            this.contentMode = 2;
        }
        return xSLNode;
    }

    private XSLNode processInclude(String string, String string2, Attributes attributes) throws XSLException, SAXException {
        XSLNode xSLNode = null;
        if (string.equals("http://www.w3.org/1999/XSL/Transform") && string2.equals("include")) {
            String string3;
            xSLNode = new XSLNode(this.xss);
            String string4 = string3 = attributes.getValue("href");
            if (string3 != null) {
                URL uRL = this.getAbsoluteURL(attributes, this.xssURL, string3);
                if (uRL != null) {
                    string4 = uRL.toString();
                } else if (this.entityResolver == null) {
                    this.err.error1(1006, 1, string3);
                }
                if (this.impNinc == null) {
                    this.impNinc = new Stack();
                }
                if (this.xssURL != null && string4.equals(this.xssURL.toString()) || this.impNinc.contains(string4)) {
                    this.err.error2(1123, 0, uRL.toString(), "xsl:import or xsl:include");
                    throw new XSLException(this.err, 0);
                }
                this.impNinc.push(string4);
                this.processIncludeHref(string3, attributes);
                this.impNinc.pop();
            } else {
                this.err.error2(1009, 1, "href", "xsl:include");
            }
        }
        return xSLNode;
    }

    private void processImportHref(String string, Attributes attributes) throws SAXException {
        int n = this.importPriority++;
        ++this.importLevel;
        this.processIncludeHref(string, attributes);
        --this.importLevel;
    }

    private URL getAbsoluteURL(Attributes attributes, URL uRL, String string) throws SAXException {
        URL uRL2 = null;
        try {
            Object object;
            if (this.version >= 20 && (object = attributes.getValue("xml:base")) != null) {
                uRL = new URL(uRL, (String)object);
            }
            if (this.entityResolver != null && this.entityResolver instanceof JXEntityResolver) {
                object = this.entityResolver.resolveEntity("", string);
                uRL2 = new URL(uRL, ((InputSource)object).getSystemId());
            }
            uRL2 = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            this.err.setException(iOException);
            this.err.error1(1002, 0, string);
        }
        return uRL2;
    }

    private void processIncludeHref(String string, Attributes attributes) throws SAXException {
        boolean bl;
        int n;
        URL uRL;
        Locator locator;
        XSLNode xSLNode;
        block15: {
            xSLNode = this.xssRoot;
            locator = this.locator;
            uRL = this.baseURL;
            n = this.contentMode;
            bl = false;
            ++this.includeProcessing;
            try {
                Object object;
                if (this.version >= 20 && (object = attributes.getValue("xml:base")) != null) {
                    this.baseURL = new URL(this.baseURL, (String)object);
                }
                object = new SAXParser();
                ((XMLParser)object).setPreserveWhitespace(true);
                ((SAXParser)object).setContentHandler(this);
                this.contentMode = 0;
                if (this.entityResolver != null) {
                    InputSource inputSource;
                    if (this.entityResolver instanceof JXEntityResolver) {
                        if (this.version >= 20) {
                            this.xbases.push(this.baseURL);
                            bl = true;
                        }
                        inputSource = this.entityResolver.resolveEntity("", string);
                    } else {
                        URL uRL2 = null;
                        try {
                            uRL2 = new URL(this.baseURL, string);
                            String string2 = uRL2.toString();
                            inputSource = this.entityResolver.resolveEntity("", string2);
                        }
                        catch (MalformedURLException malformedURLException) {
                            inputSource = this.entityResolver.resolveEntity("", string);
                            uRL2 = this.xbases.size() > 0 ? (URL)this.xbases.peek() : this.xssURL;
                        }
                        this.baseURL = uRL2;
                        ((XMLParser)object).setBaseURL(uRL2);
                        if (this.version >= 20) {
                            this.xbases.push(this.baseURL);
                            bl = true;
                        }
                    }
                    ((XMLParser)object).setEntityResolver(this.entityResolver);
                    ((XMLParser)object).parse(inputSource);
                    break block15;
                }
                if (!this.isSecure) {
                    URL uRL3;
                    this.baseURL = uRL3 = new URL(this.baseURL, string);
                    if (this.version >= 20) {
                        this.xbases.push(this.baseURL);
                        bl = true;
                    }
                    ((XMLParser)object).setBaseURL(uRL3);
                    ((XMLParser)object).parse(uRL3);
                } else {
                    this.err.error1(21028, 0, string);
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.err.setException(malformedURLException);
                this.err.error1(1002, 0, string);
            }
            catch (IOException iOException) {
                this.err.setException(iOException);
                this.err.error1(1002, 0, string);
            }
        }
        this.locator = locator;
        this.baseURL = uRL;
        this.xssRoot = xSLNode;
        this.contentMode = n;
        if (this.version >= 20 && bl) {
            this.xbases.pop();
        }
        --this.includeProcessing;
    }

    private void pushXSLNode(XSLNode xSLNode) throws XSLException {
        this.nodeStack.addElement(xSLNode);
        if (xSLNode != this.xssRoot) {
            this.currentNode.appendChild(xSLNode);
        }
        this.currentNode = xSLNode;
        if (this.locator != null) {
            xSLNode.setDebugInfo(this.locator.getLineNumber(), this.locator.getColumnNumber(), this.locator.getSystemId());
        }
    }

    private void addMethodID(XSLNode xSLNode) {
        String string;
        NSName nSName;
        if (!(xSLNode instanceof XSLTemplate) && !(xSLNode instanceof XSLFunction)) {
            return;
        }
        String string2 = xSLNode.baseURL.toString();
        if (xSLNode instanceof XSLTemplate) {
            nSName = ((XSLTemplate)xSLNode).templateNSName;
        } else {
            nSName = ((XSLFunction)xSLNode).funcstruc.funcqname;
            if (this.xss.usrdefuncs == null) {
                this.xss.usrdefuncs = new ArrayList(10);
            }
            this.xss.usrdefuncs.add(nSName);
        }
        ++this.methodID;
        this.classID = this.xss.getJDWPVirtualMachine().getClassID(string2);
        if (nSName != null) {
            string = nSName.getExpandedName();
        } else {
            this.dmethodID = this.dmethodID == -1 ? 2 : ++this.dmethodID;
            string = "$$" + new Integer(this.dmethodID).toString();
        }
        XSLJDWPUtil.printTrace(this.xss.dbgProp, "methodID: " + this.classID + ":" + this.methodID + " -> " + string + " " + string2);
        Hashtable[] hashtableArray = this.xss.getClassID2methodID();
        Hashtable[] hashtableArray2 = this.xss.getClassID2methodName();
        hashtableArray = XSLJDWPUtil.ensureHashtableSize(hashtableArray, this.classID);
        hashtableArray2 = XSLJDWPUtil.ensureHashtableSize(hashtableArray2, this.classID);
        Hashtable hashtable = hashtableArray[this.classID - 1];
        Hashtable hashtable2 = hashtableArray2[this.classID - 1];
        if (hashtable == null) {
            hashtable = new Hashtable();
            hashtable.put(new Integer(this.methodID), string);
            hashtableArray[this.classID - 1] = hashtable;
        } else {
            hashtable = hashtableArray[this.classID - 1];
            hashtable.put(new Integer(this.methodID), string);
        }
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
            hashtable2.put(string, new Integer(this.methodID));
            hashtableArray2[this.classID - 1] = hashtable2;
        } else {
            hashtable2 = hashtableArray2[this.classID - 1];
            hashtable2.put(string, new Integer(this.methodID));
        }
        this.xss.setClassID2methodID(hashtableArray);
        this.xss.setClassID2methodName(hashtableArray2);
        LineTable lineTable = new LineTable(this.classID, this.methodID, this.xss);
        lineTable.setStart(this.codeIndex);
        lineTable.setStartLine(xSLNode.getLineNumber());
        this.xss.lineTables.push(lineTable);
        VariableTable variableTable = new VariableTable(this.classID, this.methodID, this.xss, this.codeIndex);
        this.xss.variableTables.push(variableTable);
    }

    private void addGlobalMethodID() {
        Hashtable[] hashtableArray = this.xss.getClassID2methodID();
        Hashtable[] hashtableArray2 = this.xss.getClassID2methodName();
        hashtableArray = XSLJDWPUtil.ensureHashtableSize(hashtableArray, this.classID);
        hashtableArray2 = XSLJDWPUtil.ensureHashtableSize(hashtableArray2, this.classID);
        Hashtable hashtable = hashtableArray[this.classID - 1];
        Hashtable hashtable2 = hashtableArray2[this.classID - 1];
        if (hashtable == null) {
            hashtable = new Hashtable();
            hashtable.put(new Integer(1), "$$1");
            hashtableArray[this.classID - 1] = hashtable;
        } else {
            hashtable = hashtableArray[this.classID - 1];
            hashtable.put(new Integer(1), "$$1");
        }
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
            hashtable2.put("$$1", new Integer(1));
            hashtableArray2[this.classID - 1] = hashtable2;
        } else {
            hashtable2 = hashtableArray2[this.classID - 1];
            hashtable2.put("$$1", new Integer(1));
        }
        this.xss.setClassID2methodID(hashtableArray);
        this.xss.setClassID2methodName(hashtableArray2);
    }

    private void addGlobalLineVarTableData(int n, String string, String string2, XSLNode xSLNode, boolean bl) {
        VariableTable variableTable;
        LineTable lineTable;
        if (!string.equals("http://www.w3.org/1999/XSL/Transform")) {
            return;
        }
        if (string2.equals("transform") || string2.equals("stylesheet")) {
            if (bl) {
                String string3 = xSLNode.getSystemId();
                this.classID = this.xss.getJDWPVirtualMachine().getClassID(string3);
                this.addGlobalMethodID();
                lineTable = new LineTable(this.classID, 1, this.xss);
                lineTable.setStart(this.codeIndex);
                lineTable.setStartLine(xSLNode.getLineNumber());
                lineTable.setCodeIndexLineNumber(this.codeIndex, xSLNode.getLineNumber());
                this.xss.glbLineTable.push(lineTable);
                variableTable = new VariableTable(this.classID, 1, this.xss, this.codeIndex);
                this.xss.glbVarTable.push(variableTable);
            } else {
                lineTable = (LineTable)this.xss.glbLineTable.pop();
                lineTable.setEnd(this.codeIndex);
                lineTable.setEndLine(xSLNode.getEndingLineNumber());
                lineTable.setCodeIndexLineNumber(this.codeIndex, xSLNode.getEndingLineNumber());
                lineTable.notifyEnd();
                variableTable = (VariableTable)this.xss.glbVarTable.pop();
                variableTable.setEndCodeIndex(this.codeIndex);
                variableTable.notifyEnd();
            }
        }
        if (string2.equals("variable") && bl && string.equals("http://www.w3.org/1999/XSL/Transform") && (xSLNode.parent.localName.equals("transform") || xSLNode.parent.localName.equals("stylesheet"))) {
            lineTable = (LineTable)this.xss.glbLineTable.peek();
            lineTable.setCodeIndexLineNumber(this.codeIndex, n);
            variableTable = (VariableTable)this.xss.glbVarTable.peek();
            variableTable.set(this.codeIndex, (XSLVariable)xSLNode);
        }
    }

    private void addLineTableData(int n, String string, String string2, XSLNode xSLNode, boolean bl) {
        if (this.xss.lineTables.empty()) {
            return;
        }
        if (string.equals("http://www.w3.org/1999/XSL/Transform") && (string2.equals("with-param") || string2.equals("param"))) {
            return;
        }
        LineTable lineTable = (LineTable)this.xss.lineTables.peek();
        if (n == lineTable.getLastVisitedLine()) {
            return;
        }
        lineTable.setCodeIndexLineNumber(this.codeIndex, n);
    }

    private void addVariableTableData(XSLNode xSLNode, String string, String string2) {
        if (!(xSLNode instanceof XSLVariable)) {
            return;
        }
        if (string.equals("http://www.w3.org/1999/XSL/Transform") && string2.equals("with-param")) {
            return;
        }
        if (xSLNode.parent.localName.equals("transform") || xSLNode.parent.localName.equals("stylesheet")) {
            return;
        }
        VariableTable variableTable = (VariableTable)this.xss.variableTables.peek();
        variableTable.set(this.codeIndex, (XSLVariable)xSLNode);
    }

    private void processMethodEnd(XSLNode xSLNode) {
        if (!(xSLNode instanceof XSLTemplate) && !(xSLNode instanceof XSLFunction)) {
            return;
        }
        LineTable lineTable = (LineTable)this.xss.lineTables.pop();
        lineTable.setEnd(this.codeIndex);
        lineTable.setEndLine(xSLNode.getEndingLineNumber());
        lineTable.notifyEnd();
        VariableTable variableTable = (VariableTable)this.xss.variableTables.pop();
        variableTable.setEndCodeIndex(this.codeIndex);
        variableTable.notifyEnd();
    }

    private boolean verifyAttribute(int n, String string, String string2) {
        if (stdAttrs.contains(string2)) {
            return true;
        }
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                if (string2 != "select" && string2 != "mode") break;
                return true;
            }
            case 3: {
                if (string2 != "select" && string2 != "name" && string2 != "namespace" && string2 != "type" && string2 != "validation") break;
                return true;
            }
            case 4: {
                if (string2 != "name" && string2 != "use-attribute-sets") break;
                return true;
            }
            case 5: {
                if (string2 != "name") break;
                return true;
            }
            case 6: {
                break;
            }
            case 7: {
                if (string2 != "select") break;
                return true;
            }
            case 8: {
                if (string2 != "copy-namespaces" && string2 != "inherit-namespaces" && string2 != "use-attribute-sets" && string2 != "type" && string2 != "validation") break;
                return true;
            }
            case 9: {
                if (string2 != "copy-namespaces" && string2 != "select" && string2 != "type" && string2 != "validation") break;
                return true;
            }
            case 10: {
                return decFormatAttrs.contains(string2);
            }
            case 11: {
                if (string2 != "name" && string2 != "namespace" && string2 != "use-attribute-sets" && string2 != "type" && string2 != "validation" && string2 != "inherit-namespaces") break;
                return true;
            }
            case 12: {
                break;
            }
            case 13: {
                if (string2 != "select") break;
                return true;
            }
            case 14: {
                if (string2 != "test") break;
                return true;
            }
            case 15: {
                if (string2 != "href") break;
                return true;
            }
            case 16: {
                if (string2 != "href") break;
                return true;
            }
            case 17: {
                if (string2 != "name" && string2 != "match" && string2 != "use" && string2 != "collation") break;
                return true;
            }
            case 18: {
                if (string2 != "select" && string2 != "terminate") break;
                return true;
            }
            case 19: {
                if (string2 != "stylesheet-prefix" && string2 != "result-prefix") break;
                return true;
            }
            case 20: {
                return numberAttrs.contains(string2);
            }
            case 21: {
                break;
            }
            case 22: {
                return outputAttrs.contains(string2);
            }
            case 23: {
                if (string2 != "name" && string2 != "select" && string2 != "as" && string2 != "required" && string2 != "tunnel") break;
                return true;
            }
            case 24: {
                if (string2 != "elements") break;
                return true;
            }
            case 25: {
                if (string2 != "name" && string2 != "select") break;
                return true;
            }
            case 26: {
                if (string2 != "select" && string2 != "lang" && string2 != "order" && string2 != "collation" && string2 != "stable" && string2 != "case-order" && string2 != "data-type") break;
                return true;
            }
            case 27: {
                if (string2 != "elements") break;
                return true;
            }
            case 28: {
                return stylesheetAttrs.contains(string2);
            }
            case 29: {
                if (string2 != "match" && string2 != "name" && string2 != "priority" && string2 != "mode" && string2 != "as") break;
                return true;
            }
            case 30: {
                if (string2 != "disable-output-escaping") break;
                return true;
            }
            case 31: {
                return transformAttrs.contains(string2);
            }
            case 32: {
                if (string2 != "select" && string2 != "separator" && string2 != "disable-output-escaping") break;
                return true;
            }
            case 33: {
                if (string2 != "select" && string2 != "name" && string2 != "as") break;
                return true;
            }
            case 34: {
                if (string2 != "test") break;
                return true;
            }
            case 35: {
                if (string2 != "select" && string2 != "name" && string2 != "as" && string2 != "tunnel") break;
                return true;
            }
            case 36: {
                if (string2 != "select" && string2 != "regex" && string2 != "flags") break;
                return true;
            }
            case 37: {
                if (string2 != "name" && string2 != "use-character-maps") break;
                return true;
            }
            case 38: {
                if (string2 != "type" && string2 != "validation") break;
                return true;
            }
            case 39: {
                if (string2 != "select" && string2 != "group-by" && string2 != "group-adjacent" && string2 != "group-starting-with" && string2 != "group-ending-with" && string2 != "collation") break;
                return true;
            }
            case 40: {
                if (string2 != "override" && string2 != "name" && string2 != "as") break;
                return true;
            }
            case 41: {
                if (string2 != "namespace" && string2 != "schema-location") break;
                return true;
            }
            case 42: {
                break;
            }
            case 43: {
                if (string2 != "name" && string2 != "select") break;
                return true;
            }
            case 44: {
                break;
            }
            case 45: {
                break;
            }
            case 46: {
                if (string2 != "character" && string2 != "string") break;
                return true;
            }
            case 47: {
                if (string2 != "select") break;
                return true;
            }
            case 48: {
                return resultDocAttrs.contains(string2);
            }
            case 49: {
                if (string2 != "select") break;
                return true;
            }
        }
        return false;
    }

    @Override
    public Templates getTemplates() {
        try {
            return this.getStylesheet();
        }
        catch (XSLException xSLException) {
            return null;
        }
    }

    @Override
    public void setSystemId(String string) {
        try {
            this.baseStr = string;
            if (string != null) {
                this.xssURL = this.baseURL = new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            if (this.err == null) {
                this.err = new XMLError();
            }
            this.err.setException(malformedURLException);
            this.err.error1(1002, 1, string);
        }
    }

    @Override
    public String getSystemId() {
        if (this.baseURL != null) {
            return this.baseURL.toString();
        }
        return this.baseStr;
    }

    static {
        stdAttrs = new HashSet(10);
        stdAttrs.add("version");
        stdAttrs.add("exclude-result-prefixes");
        stdAttrs.add("extension-element-prefixes");
        stdAttrs.add("xpath-default-namespace");
        stdAttrs.add("default-collation");
        stdAttrs.add("use-when");
        transformAttrs = new HashSet(15);
        transformAttrs.add("id");
        transformAttrs.add("extension-element-prefixes");
        transformAttrs.add("exclude-result-prefixes");
        transformAttrs.add("version");
        transformAttrs.add("xpath-default-namespace");
        transformAttrs.add("default-validation");
        transformAttrs.add("default-collation");
        transformAttrs.add("input-type-annotations");
        stylesheetAttrs = new HashSet(15);
        stylesheetAttrs.add("id");
        stylesheetAttrs.add("extension-element-prefixes");
        stylesheetAttrs.add("exclude-result-prefixes");
        stylesheetAttrs.add("version");
        stylesheetAttrs.add("xpath-default-namespace");
        stylesheetAttrs.add("default-validation");
        stylesheetAttrs.add("default-collation");
        stylesheetAttrs.add("input-type-annotations");
        resultDocAttrs = new HashSet(25);
        resultDocAttrs.add("format");
        resultDocAttrs.add("href");
        resultDocAttrs.add("validation");
        resultDocAttrs.add("type");
        resultDocAttrs.add("method");
        resultDocAttrs.add("byte-order-mark");
        resultDocAttrs.add("cdata-section-elements");
        resultDocAttrs.add("doctype-public");
        resultDocAttrs.add("doctype-system");
        resultDocAttrs.add("encoding");
        resultDocAttrs.add("escape-uri-attributes");
        resultDocAttrs.add("include-content-type");
        resultDocAttrs.add("indent");
        resultDocAttrs.add("media-type");
        resultDocAttrs.add("normalization-form");
        resultDocAttrs.add("omit-xml-declaration");
        resultDocAttrs.add("standalone");
        resultDocAttrs.add("undeclare-prefixes");
        resultDocAttrs.add("use-character-maps");
        resultDocAttrs.add("output-version");
        outputAttrs = new HashSet(25);
        outputAttrs.add("name");
        outputAttrs.add("method");
        outputAttrs.add("byte-order-mark");
        outputAttrs.add("cdata-section-elements");
        outputAttrs.add("doctype-system");
        outputAttrs.add("doctype-public");
        outputAttrs.add("encoding");
        outputAttrs.add("escape-uri-attributes");
        outputAttrs.add("include-content-type");
        outputAttrs.add("indent");
        outputAttrs.add("media-type");
        outputAttrs.add("normalization-form");
        outputAttrs.add("omit-xml-declaration");
        outputAttrs.add("standalone");
        outputAttrs.add("undeclare-prefixes");
        outputAttrs.add("use-character-maps");
        outputAttrs.add("version");
        numberAttrs = new HashSet(20);
        numberAttrs.add("value");
        numberAttrs.add("select");
        numberAttrs.add("level");
        numberAttrs.add("count");
        numberAttrs.add("from");
        numberAttrs.add("format");
        numberAttrs.add("lang");
        numberAttrs.add("letter-value");
        numberAttrs.add("ordinal");
        numberAttrs.add("grouping-separator");
        numberAttrs.add("grouping-size");
        decFormatAttrs = new HashSet(20);
        decFormatAttrs.add("name");
        decFormatAttrs.add("decimal-separator");
        decFormatAttrs.add("grouping-separator");
        decFormatAttrs.add("infinity");
        decFormatAttrs.add("NaN");
        decFormatAttrs.add("percent");
        decFormatAttrs.add("per-mille");
        decFormatAttrs.add("zero-digit");
        decFormatAttrs.add("digit");
        decFormatAttrs.add("pattern-separator");
        decFormatAttrs.add("minus-sign");
        elemIds = new HashMap(120);
        elemIds.put("apply-imports", new Integer(1));
        elemIds.put("apply-templates", new Integer(2));
        elemIds.put("attribute", new Integer(3));
        elemIds.put("attribute-set", new Integer(4));
        elemIds.put("call-template", new Integer(5));
        elemIds.put("choose", new Integer(6));
        elemIds.put("comment", new Integer(7));
        elemIds.put("copy", new Integer(8));
        elemIds.put("copy-of", new Integer(9));
        elemIds.put("decimal-format", new Integer(10));
        elemIds.put("element", new Integer(11));
        elemIds.put("fallback", new Integer(12));
        elemIds.put("for-each", new Integer(13));
        elemIds.put("if", new Integer(14));
        elemIds.put("import", new Integer(15));
        elemIds.put("include", new Integer(16));
        elemIds.put("key", new Integer(17));
        elemIds.put("message", new Integer(18));
        elemIds.put("namespace-alias", new Integer(19));
        elemIds.put("number", new Integer(20));
        elemIds.put("otherwise", new Integer(21));
        elemIds.put("output", new Integer(22));
        elemIds.put("param", new Integer(23));
        elemIds.put("preserve-space", new Integer(24));
        elemIds.put("processing-instruction", new Integer(25));
        elemIds.put("sort", new Integer(26));
        elemIds.put("strip-space", new Integer(27));
        elemIds.put("stylesheet", new Integer(28));
        elemIds.put("template", new Integer(29));
        elemIds.put("text", new Integer(30));
        elemIds.put("transform", new Integer(31));
        elemIds.put("value-of", new Integer(32));
        elemIds.put("variable", new Integer(33));
        elemIds.put("when", new Integer(34));
        elemIds.put("with-param", new Integer(35));
        elemIds.put("analyze-string", new Integer(36));
        elemIds.put("character-map", new Integer(37));
        elemIds.put("document", new Integer(38));
        elemIds.put("for-each-group", new Integer(39));
        elemIds.put("function", new Integer(40));
        elemIds.put("import-schema", new Integer(41));
        elemIds.put("matching-substring", new Integer(42));
        elemIds.put("namespace", new Integer(43));
        elemIds.put("next-match", new Integer(44));
        elemIds.put("non-matching-substring", new Integer(45));
        elemIds.put("output-character", new Integer(46));
        elemIds.put("perform-sort", new Integer(47));
        elemIds.put("result-document", new Integer(48));
        elemIds.put("sequence", new Integer(49));
    }
}

