/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;
import oracle.jdeveloper.merge.BaseMergeNode;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNConflictsFinder;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.merge.SVNDirectoryCompareContributor;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tmatesoft.svn.core.SVNException;

public class SVNMergeDirectoryNode
extends BaseMergeNode<CompareModel> {
    public SVNMergeDirectoryNode(URL url) {
        super(url);
    }

    protected void saveResultToURL(CompareModel compareModel, URL url) {
        boolean found;
        SVNDirectoryCompareContributor first = (SVNDirectoryCompareContributor)compareModel.getContributor(ContributorKind.FIRST);
        SVNDirectoryCompareContributor second = (SVNDirectoryCompareContributor)compareModel.getContributor(ContributorKind.SECOND);
        DirectoryFile[] prestinDirList = first.getPrestinDirectoryList().getFiles();
        DirectoryFile[] dirList1 = first.getDirectoryList().getFiles();
        DirectoryFile[] dirList2 = second.getDirectoryList().getFiles();
        URL wcRootUrl = SVNUtil.resolveWorkingCopy(url);
        HashSet<DirectoryFile> dirSet1 = new HashSet<DirectoryFile>(Arrays.asList(dirList1));
        HashSet<DirectoryFile> dirSet2 = new HashSet<DirectoryFile>(Arrays.asList(dirList2));
        ArrayList<DirectoryFile> toDeleteList = new ArrayList<DirectoryFile>();
        for (DirectoryFile dirFile : prestinDirList) {
            found = false;
            for (DirectoryFile dirFile1 : dirList1) {
                if (!dirFile.equals((Object)dirFile1)) continue;
                found = true;
            }
            if (found) continue;
            toDeleteList.add(dirFile);
        }
        for (DirectoryFile dirFile2 : dirList2) {
            found = false;
            for (DirectoryFile dirFile1 : dirList1) {
                if (!dirFile2.equals((Object)dirFile1)) continue;
                found = true;
            }
            if (found) continue;
            toDeleteList.add(dirFile2);
        }
        try {
            ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNProfile.IDE_CLIENT_CONTEXT_ID, SVNProfile.CACHE_ADAPTER_CONTEXT_ID);
            SVNClientInteraction.getInstance().beginInteraction(client, SVNUtil.getFirstAssociatedRepository(url));
            SVNConflictsFinder conflictFinder = new SVNConflictsFinder();
            for (DirectoryFile dirFile : toDeleteList) {
                URL delUrl = URLFactory.newURL((String)(wcRootUrl.toString() + dirFile.getName()));
                if (!URLFileSystem.exists((URL)delUrl)) continue;
                if (conflictFinder.containsConflicts(delUrl)) {
                    client.resolved(SVNUtil.toFile(delUrl));
                }
                client.remove(new File[]{SVNUtil.toFile(delUrl)}, true);
            }
            SVNClientInteraction.getInstance().endInteraction();
            SVNOperationLogger.getInstance().beginOperation(client, SVNUtil.getFirstAssociatedRepository(url));
            try {
                client.resolved(SVNUtil.toFile(url));
            }
            catch (SVNClientException e) {
                // empty catch block
            }
            SVNOperationLogger.getInstance().endOperation();
            VCSFileEventSender.fireFileStructureChanged((URL[])new URL[]{url, URLFileSystem.getParent((URL)url)});
            VCSFileEventSender.fireFilesModified((URL[])new URL[]{url, URLFileSystem.getParent((URL)url)});
            return;
        }
        catch (SVNClientException e) {
        }
        catch (SVNException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        VCSFileEventSender.fireFileStructureChanged((URL[])new URL[]{url, URLFileSystem.getParent((URL)url)});
        VCSFileEventSender.fireFilesModified((URL[])new URL[]{url, URLFileSystem.getParent((URL)url)});
    }
}

