/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.awt.Color;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.ide.editor.EditorManager;
import oracle.ide.log.Href;
import oracle.ide.log.StyledMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.util.Pair;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNMessagePage;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNHrefInfo;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNEvent;

public final class SVNOperationLogger {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNOperationLogger.class.getName());
    private static final SVNOperationLogger sInstance = new SVNOperationLogger();
    private final NotifyListener _notifier = new NotifyListener();
    private final EventHandlerImpl _eventHandler;
    private Collection<File> _changeSet = new HashSet<File>();
    private long _opStartTime;
    private ISVNClientAdapter _client;
    private SVNBasicClient _svnClient;
    private IndeterminateProgressMonitor _indeterminateProgress;
    private DeterminateProgressMonitor _determinateProgress;
    private static Color COMMAND_COLOR = Color.BLACK;
    private static Color MESSAGE_COLOR = new Color(0, 0, 128);
    private static Color ERROR_COLOR = Color.RED;
    private static String MESSAGE_INDENT = "    ";
    private boolean _newSession = true;
    private SVNHrefInfo _hInfo;
    static String _pre_error_msg = null;
    static String _pre_complete_msg = null;

    public static final SVNOperationLogger getInstance() {
        return sInstance;
    }

    public synchronized void beginOperation(ISVNClientAdapter client, SVNRepositoryInfo reposInfo) {
        if (this._client != null) {
            sLogger.warning("Subversion client is already in use by another thread");
            return;
        }
        SVNClientInteraction.getInstance().beginInteraction(client, reposInfo);
        this._client = client;
        this._indeterminateProgress = null;
        this._determinateProgress = null;
        this._client.addNotifyListener((ISVNNotifyListener)this._notifier);
        this._opStartTime = System.currentTimeMillis();
        this._notifier.logBeginOperation();
        this._changeSet.clear();
    }

    public synchronized void beginOperation(SVNBasicClient client, SVNRepositoryInfo reposInfo) {
        if (this._svnClient != null) {
            sLogger.warning("Subversion client is already in use by another thread");
            return;
        }
        this._svnClient = client;
        this._indeterminateProgress = null;
        this._determinateProgress = null;
        this._svnClient.setEventHandler((ISVNEventHandler)this._eventHandler);
        this._opStartTime = System.currentTimeMillis();
        this._notifier.logBeginOperation();
        this._changeSet.clear();
    }

    public synchronized void beginOperation(ISVNClientAdapter client, SVNRepositoryInfo reposInfo, SVNHrefInfo hInfo) {
        this.beginOperation(client, reposInfo);
        this._hInfo = hInfo;
    }

    public synchronized void beginOperation(ISVNClientAdapter client, SVNRepositoryInfo reposInfo, IndeterminateProgressMonitor progressMonitor) {
        this.beginOperation(client, reposInfo);
        this._indeterminateProgress = progressMonitor;
    }

    public synchronized void beginOperation(ISVNClientAdapter client, SVNRepositoryInfo reposInfo, IndeterminateProgressMonitor progressMonitor, SVNHrefInfo hInfo) {
        this.beginOperation(client, reposInfo);
        this._indeterminateProgress = progressMonitor;
        this._hInfo = hInfo;
    }

    public synchronized void beginOperation(ISVNClientAdapter client, SVNRepositoryInfo reposInfo, DeterminateProgressMonitor progressMonitor) {
        this.beginOperation(client, reposInfo);
        this._determinateProgress = progressMonitor;
    }

    public synchronized void beginOperation(SVNBasicClient client, SVNRepositoryInfo reposInfo, DeterminateProgressMonitor progressMonitor) {
        this.beginOperation(client, reposInfo);
        this._determinateProgress = progressMonitor;
    }

    public Collection<File> getChangeSet() {
        return this._changeSet;
    }

    public void addToChangeSet(File path) {
        this._changeSet.add(path);
    }

    public synchronized void successFinish(String operation) {
        if (operation != null) {
            if (this._notifier != null) {
                this._notifier.logCommandLine(Resource.format("OPERATION_SUCCESS", operation));
            } else if (this._eventHandler != null) {
                this._eventHandler.logCommandLine(Resource.format("OPERATION_SUCCESS", operation));
            }
        }
    }

    public synchronized void endOperation() {
        this._newSession = true;
        if (this._client == null && this._svnClient == null) {
            sLogger.warning("Subversion client is already in use by another thread");
            return;
        }
        long duration = System.currentTimeMillis() - this._opStartTime;
        if (this._client != null) {
            this._notifier.logEndOperation(duration);
            this._client.removeNotifyListener((ISVNNotifyListener)this._notifier);
            SVNClientInteraction.getInstance().endInteraction();
            this._client = null;
        }
        if (this._svnClient != null) {
            this._svnClient.setEventHandler(null);
            this._svnClient = null;
        }
        this._indeterminateProgress = null;
        this._determinateProgress = null;
    }

    private SVNOperationLogger() {
        this._eventHandler = new EventHandlerImpl();
    }

    private class LinkHref
    extends Href {
        public LinkHref(String text, URL url) {
            super(text, url);
        }

        public void go() {
            BrowserRunner runner = BrowserRunner.getBrowserRunner();
            runner.runBrowserOnURL(this.getURL(), null, null);
        }
    }

    private class ConsoleHref
    extends Href {
        public ConsoleHref(String text, URL url) {
            super(text, url);
        }

        public void go() {
            EditorManager.getEditorManager().openDefaultEditorInFrame(this.getURL());
        }
    }

    private final class NotifyListener
    extends BaseHandler
    implements ISVNNotifyListener {
        private NotifyListener() {
        }

        public void logBeginOperation() {
            sLogger.info("begin svn operation");
        }

        public void logEndOperation(long duration) {
            sLogger.info("end svn operation, duration: " + duration + "ms");
        }

        public void setCommand(int commandId) {
        }

        public void logError(String error) {
            if (error.equals(_pre_error_msg)) {
                _pre_error_msg = null;
                return;
            }
            SVNOperationLogger.this._newSession = false;
            _pre_error_msg = error;
            this.toMessagePage(MESSAGE_INDENT);
            this.processHrefAware(error, ERROR_COLOR);
            this.toMessagePage("\n");
            sLogger.warning(error);
        }

        public void logRevision(long revision, String path) {
        }

        public void logCompleted(String message) {
            if (!SVNOperationLogger.this._newSession && message.equals(_pre_complete_msg)) {
                _pre_complete_msg = null;
                return;
            }
            SVNOperationLogger.this._newSession = false;
            _pre_complete_msg = message;
            this.toMessagePage(MESSAGE_INDENT);
            this.processHrefAware(message, MESSAGE_COLOR);
            this.toMessagePage("\n");
            sLogger.fine(message);
        }

        public void onNotify(File path, SVNNodeKind nodeKind) {
            SVNOperationLogger.this.addToChangeSet(path);
        }
    }

    private final class EventHandlerImpl
    extends BaseHandler
    implements ISVNEventHandler {
        private EventHandlerImpl() {
        }

        public void handleEvent(SVNEvent event, double progress) throws SVNException {
            this.logCommandLine(event.getAction().toString() + " " + event.getFile().getPath());
            this.toProgressMonitor(event.getFile().getPath());
            if (event.getErrorMessage() != null) {
                this.logError(event.getErrorMessage().getMessage());
            }
        }

        public void checkCancelled() throws SVNCancelException {
            if (this.isCancel()) {
                throw new SVNCancelException();
            }
        }

        private void logError(String error) {
            this.toMessagePage(MESSAGE_INDENT);
            this.processHrefAware(error, ERROR_COLOR);
            this.toMessagePage("\n");
            sLogger.warning(error);
        }

        private boolean isCancel() {
            if (SVNOperationLogger.this._indeterminateProgress != null) {
                return SVNOperationLogger.this._indeterminateProgress.isCanceled();
            }
            if (SVNOperationLogger.this._determinateProgress != null) {
                return SVNOperationLogger.this._determinateProgress.isCanceled();
            }
            return false;
        }
    }

    private class BaseHandler {
        private BaseHandler() {
        }

        public void logCommandLine(String commandLine) {
            this.processHrefAware(commandLine, COMMAND_COLOR);
            this.toMessagePage("\n");
            sLogger.info(commandLine);
        }

        protected void processHrefAware(String message, Color color) {
            if (!this.processHrefInfoimpl(message, color)) {
                this.processHrefAwareImpl(message, color);
            }
        }

        protected boolean processHrefInfoimpl(String message, Color color) {
            int pos;
            if (SVNOperationLogger.this._hInfo == null) {
                return false;
            }
            String[] msgSegs = message.split("\n");
            if (msgSegs.length == 2 && (pos = this.getFilenameStartPosition(msgSegs[1])) > -1) {
                boolean isWindows = msgSegs[1].contains(":/");
                String hLink = msgSegs[1].substring(0, isWindows ? pos - 2 : pos).replaceAll("\"", "");
                if (SVNOperationLogger.this._hInfo.isHlink(hLink)) {
                    this.toMessagePage(msgSegs[0]);
                    this.toMessagePage(" ");
                    Pair<URL, String>[] urlAndText = SVNOperationLogger.this._hInfo.getUrl(hLink);
                    if (urlAndText != null) {
                        this.toMessagePage(msgSegs[1].substring(0, msgSegs[1].indexOf((String)urlAndText[0].getSecond())));
                        for (Pair<URL, String> hUrlTxt : urlAndText) {
                            LinkHref href = new LinkHref((String)hUrlTxt.getSecond(), (URL)hUrlTxt.getFirst());
                            this.toMessagePage((Object)href);
                            this.toMessagePage(" ");
                        }
                    }
                    String lastId = (String)urlAndText[urlAndText.length - 1].getSecond();
                    this.processHrefAwareImpl(msgSegs[1].substring(msgSegs[1].indexOf(lastId) + lastId.length()), color);
                    return true;
                }
            }
            return false;
        }

        protected void processHrefAwareImpl(String message, Color color) {
            String[] msgSegs = message.split("\\s+");
            for (int i = 0; i < msgSegs.length; ++i) {
                if (this.hasHref(msgSegs[i])) {
                    try {
                        Href href = this.createHref(this.getHrefText(msgSegs[i]));
                        this.toMessagePage(href);
                        this.toMessagePage(" ");
                    }
                    catch (MalformedURLException e) {
                        sLogger.info(e.getMessage());
                    }
                    continue;
                }
                this.toMessagePage(this.formatMessage(msgSegs[i], color));
                this.toMessagePage(" ");
            }
        }

        protected void toMessagePage(Object message) {
            if (IdeUtil.isHeadless() || message == null) {
                return;
            }
            SVNMessagePage page = null;
            try {
                page = SVNMessagePage.getInstance();
                page.log(message);
            }
            catch (Exception ex) {
                sLogger.warning(ex.getMessage());
            }
        }

        protected boolean hasHref(String msgSeg) {
            if (msgSeg.indexOf(92) < 0 && msgSeg.indexOf(47) < 0) {
                return false;
            }
            String hrefText = this.getHrefText(msgSeg);
            try {
                URL url = new URL("file:" + hrefText);
                if (URLFileSystem.isDirectory((URL)url) || !URLFileSystem.exists((URL)url)) {
                    return false;
                }
            }
            catch (MalformedURLException e) {
                return false;
            }
            return true;
        }

        protected String getHrefText(String msgSeg) {
            String hrefText = msgSeg;
            if (msgSeg.startsWith("'") || msgSeg.startsWith("\"") || msgSeg.startsWith("(")) {
                hrefText = msgSeg.substring(1, msgSeg.length() - 1);
            }
            return hrefText;
        }

        protected int getFilenameStartPosition(String msg) {
            int pos = msg.indexOf(":/");
            if (pos == -1) {
                return msg.indexOf(47);
            }
            return ++pos;
        }

        protected Href createHref(String hrefText) throws MalformedURLException {
            URL url = new URL("file:" + hrefText);
            return new ConsoleHref(hrefText, url);
        }

        protected StyledMessage formatMessage(String message, Color color) {
            SimpleAttributeSet attributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(attributeSet, color);
            return new StyledMessage((AttributeSet)attributeSet, message);
        }

        public void logMessage(String message) {
            this.toMessagePage(MESSAGE_INDENT);
            this.processHrefAware(message, MESSAGE_COLOR);
            this.toMessagePage("\n");
            this.toProgressMonitor(message);
            sLogger.fine(message);
        }

        protected void toProgressMonitor(String message) {
            if (SVNOperationLogger.this._indeterminateProgress != null) {
                SVNOperationLogger.this._indeterminateProgress.getPanel().setNote(message);
            }
            if (SVNOperationLogger.this._determinateProgress != null) {
                SVNOperationLogger.this._determinateProgress.getPanel().setNote(message);
            }
        }
    }
}

