/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.cache.StatusCacheUtil;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdevimpl.vcs.svn.model.SVNURLInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;

abstract class SVNURLInfoCacheStrategy {
    private ISVNClientAdapter _client = null;
    private SVNStatusClient _statusClient = null;

    SVNURLInfoCacheStrategy() {
    }

    protected Map<VCSHashURL, SVNURLInfo> getDirectoryURLInfo(URL url, boolean descend) throws SVNException {
        throw new UnsupportedOperationException();
    }

    protected abstract SVNURLInfo getURLInfo(URL var1) throws SVNException, IOException;

    protected abstract void clear();

    protected abstract void clear(URL[] var1);

    protected abstract void clear(URLFilter var1);

    protected final void clear(URL[] urls, Depth depth) {
        this.clear(StatusCacheUtil.createDepthFilter((URL[])urls, (Depth)depth));
    }

    protected final SVNURLInfo toURLInfo(SVNStatus status) {
        SVNRevision workingRevision = status.getRevision();
        SVNRevision changedRevision = status.getCommittedRevision();
        return new SVNURLInfo(status.getNodeStatus(), status.getContentsStatus(), status.getPropertiesStatus(), status.getTreeConflict() != null, workingRevision != null ? workingRevision.getNumber() : -1L, changedRevision != null ? changedRevision.getNumber() : -1L, status.getAuthor(), SVNUtil.canonicalizeSVNURL(status.getURL()));
    }

    protected Collection<URL> getUrls(URLFilter filter) {
        return null;
    }

    protected SVNStatusClient getClient() {
        if (this._statusClient == null) {
            this._statusClient = SVNUtil.getStatusClient();
        }
        return this._statusClient;
    }
}

