/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.changelist;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TimerTask;
import oracle.ide.docking.DockStation;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.cache.LocalStatusCache;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEvent;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSThreadPool;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.generic.changelist.ChangeListViewId;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.changelist.SVNIncomingChangeList;
import oracle.jdevimpl.vcs.svn.changelist.SVNIncomingEventQueue;
import oracle.jdevimpl.vcs.svn.changelist.SVNRemoteStatus;
import oracle.jdevimpl.vcs.svn.changelist.SVNRemoteStatusCache;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public final class SVNIncomingChangesTask
extends TimerTask {
    private final SVNIncomingChangeList _changeList;
    private final SVNIncomingEventQueue _eventQueue;
    private final SVNRemoteStatusCache _statusCache;
    private final VCSThreadPool _threadPool;
    private final URLFilter _scopeFilter;
    private ISVNInfo _wcInfo;

    public SVNIncomingChangesTask(SVNIncomingChangeList changeList, VCSThreadPool threadPool, URLFilter scopeFilter) {
        this._changeList = changeList;
        this._eventQueue = (SVNIncomingEventQueue)this._changeList.getEventQueue();
        this._statusCache = (SVNRemoteStatusCache)((LocalStatusCache)this._changeList.getPolicyStatusCache()).getMasterCache();
        this._threadPool = threadPool;
        this._scopeFilter = scopeFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this._eventQueue == null || this._changeList == null || this._eventQueue.isTaskInProgress() || this._changeList.isBusy() || !this.isChangeListVisible() || SVNClientInteraction.getInstance().isClientInUse()) {
            return;
        }
        this.setChangeListBusy(true);
        try {
            Workspace[] wss;
            HashSet<VCSHashURL> workingCopies = new HashSet<VCSHashURL>(10);
            for (Workspace ws : wss = VCSModelUtils.findCachedWorkspaces()) {
                URL root = SVNUtil.resolveWorkingCopy(ws.getURL());
                if (root != null) {
                    workingCopies.add(new VCSHashURL(root));
                    continue;
                }
                Collection prjs = ws.projects();
                for (Project prj : prjs) {
                    URL pRoot = SVNUtil.resolveWorkingCopy(prj.getURL());
                    if (pRoot == null) continue;
                    workingCopies.add(new VCSHashURL(pRoot));
                }
            }
            final HashMap<VCSHashURL, Object> cache = new HashMap<VCSHashURL, Object>(100);
            Iterator it = workingCopies.iterator();
            while (it.hasNext()) {
                try {
                    final URL workingCopyRoot = URLFileSystem.canonicalize((URL)((VCSHashURL)it.next()).getURL());
                    SVNStatusClient stClient = this.getStatusClient(workingCopyRoot);
                    ISVNStatusHandler handler = new ISVNStatusHandler(){

                        public void handleStatus(SVNStatus status) {
                            try {
                                SVNIncomingChangesTask.this.cacheRelevantStatuses(workingCopyRoot, status, cache);
                            }
                            catch (Exception e) {
                                SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(e.getMessage());
                            }
                        }
                    };
                    ArrayList changelist = new ArrayList();
                    stClient.doStatus(SVNUtil.toFile(workingCopyRoot), SVNRevision.HEAD, SVNDepth.INFINITY, true, false, false, false, handler, changelist);
                }
                catch (Exception ce) {
                    String header;
                    String msg;
                    SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(ce.getMessage());
                    Exception e = SVNExceptionWrapper.wrapException(ce);
                    if (!(e instanceof VCSException)) continue;
                    VCSException ex = (VCSException)e;
                    String title = ex.getTitle();
                    if (title == null) {
                        title = IdeUtil.getProgramName();
                    }
                    if ((msg = (header = this._wcInfo != null ? Resource.format("INCOMING_EXCEPTION_HEADER", this._wcInfo.getRepository().toString()) : "") + ex.getMessage()) == null || msg.equals("")) continue;
                    MessageDialog.optionalInformation((String)title, null, (Object)msg, (String)title, null);
                }
            }
            this._statusCache.setInternalCache(cache);
            ChangeListEvent event = new ChangeListEvent(0);
            event.setReplace(true);
            event.setURLs(this.getUrlsFromCache(cache));
            this._eventQueue.enqueue(event);
        }
        finally {
            this.setChangeListBusy(false);
        }
    }

    private SVNStatusClient getStatusClient(URL url) throws SVNException, IOException {
        SVNUrl svnurl = SVNURLInfoCache.getInstance().getURL(url);
        return SVNUtil.getStatusClient(SVNUtil.resolveRepository(svnurl));
    }

    private void cacheRelevantStatuses(URL localRoot, SVNStatus status, Map<VCSHashURL, Object> cache) throws SVNException, IOException {
        SVNUrl wcReposUrl = SVNURLInfoCache.getInstance().getURL(localRoot);
        if (wcReposUrl == null) {
            return;
        }
        if (status != null && status.getRemoteURL() != null) {
            SVNStatusType nodeStatus = status.getRemoteNodeStatus();
            SVNStatusType textStatus = status.getRemoteContentsStatus();
            SVNStatusType propStatus = status.getRemotePropertiesStatus();
            URL virtualUrl = this.getVirtualUrl(localRoot, wcReposUrl, status.getRemoteURL());
            if (virtualUrl == null) {
                return;
            }
            VCSHashURL cacheUrl = new VCSHashURL(virtualUrl);
            if (SVNStatusType.STATUS_MODIFIED == textStatus && SVNStatusType.STATUS_MODIFIED == propStatus) {
                cache.put(cacheUrl, SVNRemoteStatus.TEXT_PROP_MODIFIED);
            } else if (SVNStatusType.STATUS_MODIFIED == textStatus) {
                cache.put(cacheUrl, SVNRemoteStatus.TEXT_MODIFIED);
            } else if (SVNStatusType.STATUS_MODIFIED == propStatus) {
                cache.put(cacheUrl, SVNRemoteStatus.PROP_MODIFIED);
            } else if (SVNStatusType.STATUS_ADDED == textStatus) {
                cache.put(cacheUrl, SVNRemoteStatus.ADDED);
            } else if (SVNStatusType.STATUS_DELETED == nodeStatus) {
                cache.put(cacheUrl, SVNRemoteStatus.DELETED);
            }
        }
    }

    private URL getVirtualUrl(URL localBase, SVNUrl reposBase, SVNURL item) {
        String base = reposBase.toString();
        String itemStr = item.toDecodedString();
        String rel = itemStr.substring(base.length());
        return rel == null ? null : URLFileSystem.canonicalize((URL)URLFactory.newURL((URL)localBase, (String)rel.replace('/', File.separatorChar)));
    }

    private void setChangeListBusy(final boolean busy) {
        ChangeListEvent cle = new ChangeListEvent(2);
        cle.setRunnable(new Runnable(){

            @Override
            public void run() {
                SVNIncomingChangesTask.this._eventQueue.setChangeListBusyImpl(busy);
            }
        });
        this._eventQueue.enqueue(cle);
        this._eventQueue.setTaskInProgress(busy);
    }

    protected void populateStatusCacheMap(Map<VCSHashURL, Object> statusCacheMap, Collection<VCSHashURL> directoriesToQuery) {
    }

    protected boolean isControlled(URL directoryUrl) {
        return false;
    }

    protected String getViewId() {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
        return profile == null ? null : ChangeListViewId.getViewId((VCSProfile)profile);
    }

    protected boolean isChangeListVisible() {
        ChangeListWindow clw = this.getChangeListWindow();
        if (clw == null) {
            return false;
        }
        return clw == null ? false : clw.isChangeListVisible((ChangeList)this._changeList);
    }

    public final ChangeListWindow getChangeListWindow() {
        String viewID = this.getViewId();
        if (viewID == null) {
            return null;
        }
        return (ChangeListWindow)DockStation.getDockStation().getDockable(new ViewId(viewID));
    }

    private URL[] getUrlsFromCache(Map<VCSHashURL, Object> cache) {
        ArrayList<URL> urls = new ArrayList<URL>();
        Iterator<VCSHashURL> it = cache.keySet().iterator();
        while (it.hasNext()) {
            urls.add(it.next().getURL());
        }
        return urls.toArray(new URL[0]);
    }
}

