/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.changelist;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListCommentsCustomizer;
import oracle.jdeveloper.vcs.generic.PendingChangesAdapter;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.StatusMapping;
import oracle.jdevimpl.vcs.svn.op.SVNOperationCommit;
import oracle.jdevimpl.vcs.svn.prefs.SVNVersionToolsPreferences;
import oracle.jdevimpl.vcs.svn.res.Resource;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public final class SVNPendingChangesAdapter
extends PendingChangesAdapter {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNPendingChangesAdapter.class.getName());
    private static final String CL_ID_OUTGOING = "oracle.jdevimpl.vcs.svn.changelist.OUTGOING";
    private static final String CL_ID_INCOMING = "oracle.jdevimpl.vcs.svn.changelist.INCOMING";
    private static final String CL_ID_CANDIDATES = "oracle.jdevimpl.vcs.svn.changelist.CANDIDATES";
    private static final String PROP_ID_TEXT_STATUS = "textStatus";
    private static final String PROP_ID_PROP_STATUS = "propStatus";
    private static final String PROP_ID_STATUS = "status";

    public VCSProfile getProfile() {
        return VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
    }

    public Object resolvePropertyValue(String changeListId, String propertyId, URL url) {
        if (CL_ID_OUTGOING.equals(changeListId)) {
            if (PROP_ID_TEXT_STATUS.equals(propertyId)) {
                return this.resolveOutgoingTextStatus(url);
            }
            if (PROP_ID_PROP_STATUS.equals(propertyId)) {
                return this.resolveOutgoingPropStatus(url);
            }
            throw new IllegalArgumentException("Unknown outgoing change list display property: " + propertyId);
        }
        if (CL_ID_INCOMING.equals(changeListId)) {
            return "";
        }
        if (CL_ID_CANDIDATES.equals(changeListId)) {
            if (PROP_ID_STATUS.equals(propertyId)) {
                return super.resolvePropertyValue(changeListId, propertyId, url);
            }
            throw new IllegalArgumentException("Unknown candidate change list display property: " + propertyId);
        }
        throw new IllegalArgumentException("Unknown change list id: " + changeListId);
    }

    public boolean isActionSilent(ChangeList changeList, String actionId) {
        if (actionId.equals("oracle.jdeveloper.subversion.commit") || actionId.equals("oracle.jdeveloper.subversion.commit-workingcopy")) {
            VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
            if (profile != null) {
                SVNVersionToolsPreferences prefs = SVNVersionToolsPreferences.getInstance((PropertyStorage)Preferences.getPreferences());
                Integer policy = prefs.getOutgoingCommitDialog();
                if (0 == policy) {
                    return false;
                }
                if (1 == policy) {
                    return changeList.isOptionsVisible();
                }
                if (2 == policy) {
                    return true;
                }
                throw new IllegalStateException();
            }
            return false;
        }
        return true;
    }

    private Object resolveOutgoingPropStatus(URL url) {
        try {
            SVNStatusType status = SVNURLInfoCache.getInstance().getPropStatus(url);
            return StatusMapping.getVCSStatus(status);
        }
        catch (SVNException ce) {
            sLogger.log(Level.SEVERE, "unable to resolve property status for " + URLFileSystem.getPlatformPathName((URL)url), ce);
            return "<<error>>";
        }
        catch (IOException ce) {
            sLogger.log(Level.SEVERE, "unable to resolve property status for " + URLFileSystem.getPlatformPathName((URL)url), ce);
            return "<<error>>";
        }
    }

    private Object resolveOutgoingTextStatus(URL url) {
        try {
            SVNStatusType nodeStatus = SVNURLInfoCache.getInstance().getNodeStatus(url);
            if (SVNURLInfoCache.getInstance().getTreeStatus(url) && (SVNStatusType.STATUS_CONFLICTED == nodeStatus || SVNStatusType.STATUS_ADDED == nodeStatus || SVNStatusType.STATUS_DELETED == nodeStatus)) {
                return this.getProfile().getStatusInstance("MISSING-CONFLICT");
            }
            return StatusMapping.getVCSStatus(nodeStatus);
        }
        catch (SVNException ce) {
            sLogger.log(Level.SEVERE, "unable to resolve text status for " + URLFileSystem.getPlatformPathName((URL)url), ce);
            return "<<error>>";
        }
        catch (IOException ce) {
            sLogger.log(Level.SEVERE, "unable to resolve text status for " + URLFileSystem.getPlatformPathName((URL)url), ce);
            return "<<error>>";
        }
    }

    public HashStructureAdapter getPreferences() {
        return SVNVersionToolsPreferences.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    public String[] getPreferencesPath() {
        return VCSNavigableUtils.getSystemNavigablePath((String)VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion").getInformation().getShortLabel(), (String[])new String[]{Resource.getBundle().getString("PREFERENCES_VTOOLS")});
    }

    public void initializeCommentsCustomizer(ChangeListCommentsCustomizer commentsCustomizer, Object id) {
        commentsCustomizer.setRecentCommentsModel(SVNOperationCommit.getRecentCommentsModel());
        commentsCustomizer.setShowTemplatesAndCommentsCombo(true);
    }
}

