/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.merge;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import oracle.ide.Context;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Element;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareDifference;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.view.CompareToolTipProvider;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.merge.BaseMergeEditor;
import oracle.jdeveloper.merge.MergeContext;
import oracle.jdeveloper.merge.MergeEngine;
import oracle.jdevimpl.vcs.svn.merge.ListMergeView;

public abstract class ListMergeEditor
extends BaseMergeEditor
implements CompareToolTipProvider {
    protected void initializeMergeView(CompareView mergeView) {
        if (mergeView != null && mergeView instanceof ListMergeView) {
            return;
        }
    }

    protected void initializeToolbarImpl(Toolbar toolbar) {
        toolbar.addSeparator();
        JButton acceptleftButton = new JButton();
        JButton acceptRightButton = new JButton();
        JButton resetButton = new JButton();
        Icon acceptleftIcon = OracleIcons.getIcon((String)"shuttle_rightall.png");
        Icon acceptrightIcon = OracleIcons.getIcon((String)"shuttle_leftall.png");
        Icon resetIcon = OracleIcons.getIcon((String)"restore_save_point.png");
        acceptleftButton.setIcon(acceptleftIcon);
        acceptRightButton.setIcon(acceptrightIcon);
        resetButton.setIcon(resetIcon);
        acceptleftButton.setToolTipText("Accept Local Changes");
        acceptRightButton.setToolTipText("Accept Incoming Chagnes");
        resetButton.setToolTipText("Reset");
        acceptleftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ListMergeEditor.this.getCompareView() instanceof ListMergeView) {
                    ((ListMergeView)ListMergeEditor.this.getCompareView()).acceptLeft();
                }
            }
        });
        acceptRightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ListMergeEditor.this.getCompareView() instanceof ListMergeView) {
                    ((ListMergeView)ListMergeEditor.this.getCompareView()).acceptRight();
                }
            }
        });
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ListMergeEditor.this.getCompareView() instanceof ListMergeView) {
                    ListMergeEditor.this.reopen();
                }
            }
        });
        toolbar.add((Component)resetButton, -1);
    }

    protected boolean restartMergeImpl(Context context) throws IOException {
        this.reopen();
        return true;
    }

    protected boolean getClientSideMergeSetting() {
        return true;
    }

    protected CompareModel createMergeModelImpl(Context context) {
        CompareModel compareModel = MergeContext.getModel((Context)context);
        if (compareModel == null) {
            CompareContributor contributor1 = MergeContext.getFirstContributor((Context)context);
            CompareContributor contributor2 = MergeContext.getSecondContributor((Context)context);
            CompareContributor contributorA = MergeContext.getAncestorContributor((Context)context);
            if (contributor1 == null || contributor2 == null || contributorA == null) {
                return null;
            }
            MergeEngine mergeEngine = MergeContext.getMergeEngine((Context)context);
            if (mergeEngine == null) {
                mergeEngine = MergeEngine.getInstance();
            }
            mergeEngine.prepareMerge(contributor1, contributor2, contributorA, (Element)context.getNode());
            this.setProgressCancelable(mergeEngine.isCancelable());
            try {
                compareModel = mergeEngine.executeMerge();
            }
            catch (CompareFailedException cfe) {
                // empty catch block
            }
        }
        return compareModel;
    }

    protected boolean validateContent(CompareModel compareModel) throws IOException {
        return true;
    }

    public String getToolTipText(ContributorKind contributorKind, CompareDifference difference) {
        return "";
    }
}

