/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.mergewiz;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizardModel;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class MergeOperation
extends Thread {
    private int _mergeType = 0;
    private SVNMergeWizardModel _model;
    private boolean _dryrun;

    public MergeOperation(SVNMergeWizardModel model, boolean dryrun) {
        this._model = model;
        this._dryrun = dryrun;
    }

    @Override
    public void run() {
        this._mergeType = this._model.getMergeType();
        switch (this._mergeType) {
            case 0: {
                this.doRangeMerge();
                break;
            }
            case 1: {
                this.doIntegrateMerge();
                break;
            }
            case 2: {
                this.doTreeMerge();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRangeMerge() {
        ISVNClientAdapter client = null;
        try {
            client = SVNUtil.getIDEClientAdapter();
            SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(this._model.getFromSVNUrl());
            SVNOperationLogger.getInstance().beginOperation(client, repoInfo);
            client.merge(this._model.getFromSVNUrl(), SVNRevision.HEAD, this._model.getFromRevisionRanges(), this._model.getLocalPath(), this._model.isForce(), this._model.getDepth(), this._model.isIgnoreAncestry(), this._dryrun, this._model.isRecordOnly());
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(MergeOperation.class.getName()).warning(e.getMessage());
        }
        finally {
            this.updateCache(SVNOperationLogger.getInstance().getChangeSet());
            SVNOperationLogger.getInstance().endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIntegrateMerge() {
        ISVNClientAdapter client = null;
        try {
            client = SVNUtil.getIDEClientAdapter();
            SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(this._model.getFromSVNUrl());
            SVNOperationLogger.getInstance().beginOperation(client, repoInfo);
            client.mergeReintegrate(this._model.getFromSVNUrl(), SVNRevision.HEAD, this._model.getLocalPath(), this._model.isForce(), this._dryrun);
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(MergeOperation.class.getName()).warning(e.getMessage());
        }
        finally {
            this.updateCache(SVNOperationLogger.getInstance().getChangeSet());
            SVNOperationLogger.getInstance().endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTreeMerge() {
        ISVNClientAdapter client = null;
        try {
            client = SVNUtil.getIDEClientAdapter();
            SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(this._model.getFromSVNUrl());
            SVNOperationLogger.getInstance().beginOperation(client, repoInfo);
            client.merge(this._model.getFromSVNUrl(), this._model.getFromRevision(), this._model.getToSVNUrl(), this._model.getToRevision(), this._model.getLocalPath(), this._model.isForce(), this._model.getDepth(), this._dryrun, this._model.isIgnoreAncestry(), this._model.isRecordOnly());
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(MergeOperation.class.getName()).warning(e.getMessage());
        }
        finally {
            this.updateCache(SVNOperationLogger.getInstance().getChangeSet());
            SVNOperationLogger.getInstance().endOperation();
        }
    }

    private void updateCache(Collection<File> changeSet) {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
        URL[] processed = SVNUtil.toURLs(changeSet.toArray(new File[changeSet.size()]));
        StatusCache statusCache = profile.getPolicyStatusCache();
        if (statusCache != null) {
            statusCache.clear(processed);
        }
        SVNURLInfoCache svnurlInfoCache = SVNURLInfoCache.getInstance();
        svnurlInfoCache.clear(processed);
        VCSBufferUtils.reloadBuffer((URL[])processed);
    }
}

