/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.mergewiz;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.util.ImageIconCache;
import oracle.javatools.util.SwingUtils;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdevimpl.vcs.svn.mergewiz.MergeOperation;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizardModel;
import oracle.jdevimpl.vcs.svn.mergewiz.ui.MergeOptionsPanel;
import oracle.jdevimpl.vcs.svn.mergewiz.ui.MergeTypePanel;
import oracle.jdevimpl.vcs.svn.mergewiz.ui.ReintegratePanel;
import oracle.jdevimpl.vcs.svn.mergewiz.ui.RevisionRangePanel;
import oracle.jdevimpl.vcs.svn.mergewiz.ui.TreeMergePanel;
import oracle.jdevimpl.vcs.svn.res.Resource;

public class SVNMergeWizard {
    public static final String DATA_KEY = SVNMergeWizard.class.getName() + ".mergeWizard";
    public static final Object FSM_STATE_REVISION_RANGE = new Object();
    public static final Object FSM_STATE_REINTEGRATE = new Object();
    public static final Object FSM_STATE_TREE_MERGE = new Object();
    public static final Object FSM_STATE_MERGE_OPTIONS = new Object();
    public static final Object FSM_TRANS_TO_REVISION_RANGE = new Object();
    public static final Object FSM_TRANS_TO_REINTEGRATE = new Object();
    public static final Object FSM_TRANS_TO_TREE_MERGE = new Object();
    public static final Object FSM_TRANS_TO_MERGE_OPTIONS = new Object();
    private IndeterminateProgressMonitor _progress;
    private final VCSProfile _profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");

    public boolean runWizard(Component parent, final Context context) {
        SVNMergeWizardModel model = this.createModel(context);
        if (model == null) {
            return false;
        }
        final Namespace ns = new Namespace();
        ns.put(DATA_KEY, (Object)model);
        FSMWizard wizard = new FSMWizard(this.createFSM(), ns);
        wizard.setWelcomePageAdded(false);
        wizard.setWizardTitle(Resource.get("MERGE_WIZARD_TITLE"));
        wizard.setRoadmapVisible(true);
        wizard.setLogoImage(ImageIconCache.get((URL)Resource.class.getResource(Resource.get("MERGE_WIZARD_GRAPHIC"))).getImage());
        Color[] WIZARD_HEADER_GRADIENT = new Color[]{new Color(255, 255, 255), new Color(206, 223, 230)};
        wizard.setHeaderGradientBackground(WIZARD_HEADER_GRADIENT);
        final WizardDialog wd = this.createWizardDialog(wizard, parent);
        wizard.addCommitListener(new CommitListener(){

            public void checkCommit(ApplyEvent event) {
            }

            public void commit(ApplyEvent event) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (!SVNMergeWizard.this.commitWizard((SVNMergeWizardModel)ns.get(DATA_KEY), context)) {
                            return;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                wd.dispose();
                            }
                        });
                    }
                }, "svn-merge-wizard-thread").start();
            }

            public void rollback(ApplyEvent event) {
            }

            public void cancel(ApplyEvent event) {
            }
        });
        return WizardLauncher.runDialog((JDialog)wd);
    }

    private boolean commitWizard(SVNMergeWizardModel mergeModel, Context context) {
        new MergeOperation(mergeModel, false).run();
        return true;
    }

    private WizardDialog createWizardDialog(FSMWizard wizard, Component parent) {
        Dialog dialog = SwingUtils.getAncestorDialog((Component)parent);
        if (dialog != null) {
            return wizard.getDialog(dialog);
        }
        return wizard.getDialog(SwingUtils.getAncestorFrame((Component)parent));
    }

    private SVNMergeWizardModel createModel(Context context) {
        Element[] elements = context.getSelection();
        if (elements.length == 0) {
            return null;
        }
        SVNMergeWizardModel model = new SVNMergeWizardModel(context);
        if (elements[0] instanceof Locatable) {
            model.setResourceUrl(((Locatable)elements[0]).getURL());
        } else {
            model.setResourceUrl(((Node)elements[0]).getURL());
        }
        return model;
    }

    private FSM createFSM() {
        Step typeStep = new Step(Resource.get("MERGE_WIZARD_TYPE_TITLE"), MergeTypePanel.class, "f1_svnmergetypepanel_html");
        Step revisionrangeStep = new Step(Resource.get("MERGE_WIZARD_RESOURCE_TITLE"), RevisionRangePanel.class, "f1_svnrevisionrange_html");
        Step reintegrateStep = new Step(Resource.get("MERGE_WIZARD_RESOURCE_TITLE"), ReintegratePanel.class, "f1_svnreintegrate_html");
        Step treemergeStep = new Step(Resource.get("MERGE_WIZARD_RESOURCE_TITLE"), TreeMergePanel.class, "f1_svntreemerge_html");
        Step optionsStep = new Step(Resource.get("MERGE_WIZARD_OPTIONS_TITLE"), MergeOptionsPanel.class, "f1_svnmergeoptions_html");
        FSMBuilder builder = new FSMBuilder();
        builder.newStartState(typeStep, null);
        builder.addStateTrans(FSM_TRANS_TO_REVISION_RANGE, FSM_STATE_REVISION_RANGE);
        builder.addStateTrans(FSM_TRANS_TO_REINTEGRATE, FSM_STATE_REINTEGRATE);
        builder.addStateTrans(FSM_TRANS_TO_TREE_MERGE, FSM_STATE_TREE_MERGE);
        builder.newState(FSM_STATE_REVISION_RANGE, revisionrangeStep, FSM_STATE_MERGE_OPTIONS);
        builder.addStateTrans(FSM_TRANS_TO_MERGE_OPTIONS, FSM_STATE_MERGE_OPTIONS);
        builder.newState(FSM_STATE_REINTEGRATE, reintegrateStep, FSM_STATE_MERGE_OPTIONS);
        builder.addStateTrans(FSM_TRANS_TO_MERGE_OPTIONS, FSM_STATE_MERGE_OPTIONS);
        builder.newState(FSM_STATE_TREE_MERGE, treemergeStep, FSM_STATE_MERGE_OPTIONS);
        builder.addStateTrans(FSM_TRANS_TO_MERGE_OPTIONS, FSM_STATE_MERGE_OPTIONS);
        builder.newFinalState(FSM_STATE_MERGE_OPTIONS, optionsStep);
        try {
            return builder.getFSM();
        }
        catch (FSMInvalidException fsmie) {
            this._profile.getLogger().warning(fsmie.getMessage());
            fsmie.printStackTrace();
            assert (false) : "Unexpected FSMInvalidException";
            return null;
        }
    }
}

