/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.mergewiz.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizard;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizardModel;
import oracle.jdevimpl.vcs.svn.res.Resource;

public class MergeTypePanel
extends DefaultTraversablePanel {
    private boolean _initialized = false;
    private JMultiLineLabel _hint;
    private ButtonGroup _group;
    private JRadioButton _revisionrangeOption;
    private JRadioButton _reintegrateOption;
    private JRadioButton _treemergeOption;
    private JMultiLineLabel _revisionrangeHintTxt;
    private JMultiLineLabel _reintegrateHintTxt;
    private JMultiLineLabel _treemergeHintTxt;

    public MergeTypePanel() {
        this.setLayout(new GridBagLayout());
    }

    public void onEntry(TraversableContext dataContext) {
        this.initialize();
        if (dataContext.getDirection() == 1) {
            dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.initialize();
        SVNMergeWizardModel model = (SVNMergeWizardModel)dataContext.get(SVNMergeWizard.DATA_KEY);
        if (this._revisionrangeOption.isSelected()) {
            model.setMergeType(0);
        }
        if (this._reintegrateOption.isSelected()) {
            model.setMergeType(1);
        }
        if (this._treemergeOption.isSelected()) {
            model.setMergeType(2);
        }
    }

    private synchronized void initialize() {
        if (this._initialized) {
            return;
        }
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
        this._initialized = true;
    }

    private void createComponents() {
        this._hint = new JMultiLineLabel();
        this._hint.setText(Resource.get("MERGE_UI_TYPE_HINT"));
        this._group = new ButtonGroup();
        this._revisionrangeOption = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._revisionrangeOption, (String)Resource.get("MERGE_UI_TYPE_OPTION_REVISIONRANGE"));
        this._revisionrangeOption.setSelected(true);
        this._group.add(this._revisionrangeOption);
        this._revisionrangeHintTxt = new JMultiLineLabel();
        this._revisionrangeHintTxt.setText(Resource.get("MERGE_WIZARD_SELECT_REVISIONRANGE_HINT"));
        this._reintegrateOption = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._reintegrateOption, (String)Resource.get("MERGE_UI_TYPE_OPTION_REINTEGRATE"));
        this._group.add(this._reintegrateOption);
        this._reintegrateHintTxt = new JMultiLineLabel();
        this._reintegrateHintTxt.setText(Resource.get("MERGE_WIZARD_SELECT_REINTEGRATE_HINT"));
        this._treemergeOption = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._treemergeOption, (String)Resource.get("MERGE_UI_TYPE_OPTION_TREEMERGE"));
        this._group.add(this._treemergeOption);
        this._treemergeHintTxt = new JMultiLineLabel();
        this._treemergeHintTxt.setText(Resource.get("MERGE_WIZARD_SELECT_TREEMERGE_HINT"));
    }

    private void layoutComponents() {
        Insets optionInsects = new Insets(5, 10, 5, 0);
        Insets hintInsects = new Insets(0, 28, 10, 0);
        this.add((Component)this._hint, this.gbc(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add(this._revisionrangeOption, this.gbc(0, 1, 1, 1, 0.0, 0.0, 17, 0, optionInsects, 0, 0));
        this.add((Component)this._revisionrangeHintTxt, this.gbc(0, 2, 1, 1, 0.0, 0.0, 17, 2, hintInsects, 0, 0));
        this.add(this._reintegrateOption, this.gbc(0, 3, 1, 1, 0.0, 0.0, 17, 0, optionInsects, 0, 0));
        this.add((Component)this._reintegrateHintTxt, this.gbc(0, 4, 1, 1, 0.0, 0.0, 17, 2, hintInsects, 0, 0));
        this.add(this._treemergeOption, this.gbc(0, 5, 1, 1, 0.0, 0.0, 17, 0, optionInsects, 0, 0));
        this.add((Component)this._treemergeHintTxt, this.gbc(0, 6, 1, 1, 0.0, 0.0, 17, 2, hintInsects, 0, 0));
        this.add(Box.createVerticalGlue(), this.gbc(0, 7, 1, 1, 0.0, 1.0, 16, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initListeners() {
    }

    public Object getExitTransition() {
        if (this._revisionrangeOption.isSelected()) {
            return SVNMergeWizard.FSM_TRANS_TO_REVISION_RANGE;
        }
        if (this._reintegrateOption.isSelected()) {
            return SVNMergeWizard.FSM_TRANS_TO_REINTEGRATE;
        }
        if (this._treemergeOption.isSelected()) {
            return SVNMergeWizard.FSM_TRANS_TO_TREE_MERGE;
        }
        return SVNMergeWizard.FSM_TRANS_TO_REVISION_RANGE;
    }
}

