/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.mergewiz.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNExecutorService;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizard;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizardModel;
import oracle.jdevimpl.vcs.svn.mergewiz.ui.RevisionSelectionPanel;
import oracle.jdevimpl.vcs.svn.mergewiz.ui.SVNUrlInputPanel;
import oracle.jdevimpl.vcs.svn.mergewiz.ui.WorkingCopyRevListerPanel;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RevisionRangePanel
extends DefaultTraversablePanel {
    private static final String TRANSIENT_COMBOBOX_VALUE_KEY = RevisionRangePanel.class.getName() + ".comboBox";
    private static final String TRANSIENT_WC_FILE_VALUE_KEY = RevisionRangePanel.class.getName() + ".wcfile";
    private SVNMergeWizardModel _model;
    private boolean _initialized = false;
    private JMultiLineLabel _hint;
    private SVNUrlInputPanel _urlInputPanel;
    private WorkingCopyRevListerPanel _wcRevListerPanel;
    private RevisionSelectionPanel _revSelectionPanel;
    private SVNUrl _svnurl;

    public RevisionRangePanel() {
        this.setLayout(new GridBagLayout());
    }

    public void onEntry(TraversableContext dataContext) {
        this._model = (SVNMergeWizardModel)dataContext.get(SVNMergeWizard.DATA_KEY);
        this.initialize();
        this.updateMergeURL();
        File resourceFile = SVNUtil.toFile(this._model.getResourceUrl());
        this._wcRevListerPanel.setWCFile(resourceFile.toString());
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this._model = (SVNMergeWizardModel)dataContext.get(SVNMergeWizard.DATA_KEY);
        URL resourceUrl = this._model.getResourceUrl();
        File resourceFile = SVNUtil.toFile(resourceUrl);
        this._model.setFromSVNUrl(this._urlInputPanel.getSVNUrl());
        this._model.setFromRevisionRanges(this._revSelectionPanel.getRevisionRanges());
        this._model.setLocalPath(resourceFile);
    }

    private void updateMergeURL() {
        SVNExecutorService executor = SVNExecutorService.getInstance();
        Thread suggestionThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                URL resourceUrl = RevisionRangePanel.this._model.getResourceUrl();
                File resourceFile = SVNUtil.toFile(resourceUrl);
                String[] suggestedStrs = null;
                String svnurlStr = null;
                try {
                    ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
                    RevisionRangePanel.this._svnurl = client.getInfoFromWorkingCopy(resourceFile).getUrl();
                    RevisionRangePanel.this._urlInputPanel.setComboBox(new String[]{RevisionRangePanel.this._svnurl.toString()}, RevisionRangePanel.this._svnurl.toString());
                    SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(RevisionRangePanel.this._svnurl);
                    SVNClientInteraction.getInstance().beginInteraction(client, repoInfo);
                    suggestedStrs = client.suggestMergeSources(resourceFile);
                    svnurlStr = RevisionRangePanel.this._svnurl.toString();
                    SVNClientInteraction.getInstance().endInteraction();
                }
                catch (SVNClientException e) {
                    try {
                        SVNProfile.getQualifiedLogger(RevisionRangePanel.class.getName()).warning(e.getMessage());
                        SVNClientInteraction.getInstance().endInteraction();
                    }
                    catch (Throwable throwable) {
                        SVNClientInteraction.getInstance().endInteraction();
                        List<String> suggestedList = Arrays.asList(suggestedStrs);
                        if (suggestedList.size() == 0 || !suggestedList.contains(svnurlStr)) {
                            suggestedList = new LinkedList(suggestedList);
                            ((LinkedList)suggestedList).addFirst(svnurlStr);
                            suggestedStrs = suggestedList.toArray(new String[0]);
                        }
                        RevisionRangePanel.this._urlInputPanel.setComboBox(suggestedStrs, svnurlStr);
                        throw throwable;
                    }
                    List<String> suggestedList = Arrays.asList(suggestedStrs);
                    if (suggestedList.size() == 0 || !suggestedList.contains(svnurlStr)) {
                        suggestedList = new LinkedList(suggestedList);
                        ((LinkedList)suggestedList).addFirst(svnurlStr);
                        suggestedStrs = suggestedList.toArray(new String[0]);
                    }
                    RevisionRangePanel.this._urlInputPanel.setComboBox(suggestedStrs, svnurlStr);
                }
                List<String> suggestedList = Arrays.asList(suggestedStrs);
                if (suggestedList.size() == 0 || !suggestedList.contains(svnurlStr)) {
                    suggestedList = new LinkedList<String>(suggestedList);
                    ((LinkedList)suggestedList).addFirst(svnurlStr);
                    suggestedStrs = suggestedList.toArray(new String[0]);
                }
                RevisionRangePanel.this._urlInputPanel.setComboBox(suggestedStrs, svnurlStr);
            }
        };
        executor.activate();
        executor.submit(suggestionThread);
    }

    private synchronized void initialize() {
        if (this._initialized) {
            return;
        }
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
        this._initialized = true;
    }

    private void createComponents() {
        this._hint = new JMultiLineLabel();
        this._hint.setText(Resource.get("MERGE_UI_REVISIONRANGE_HINT"));
        this._urlInputPanel = new SVNUrlInputPanel(Resource.get("UI_REVISIONRANGEPANEL_FROM_URL_TEXT"));
        this._urlInputPanel.setModel(this._model);
        this._revSelectionPanel = new RevisionSelectionPanel(this._urlInputPanel);
        this._wcRevListerPanel = new WorkingCopyRevListerPanel(Resource.get("UI_REVISIONRANGEPANEL_WCREVLISTER_TEXT"));
    }

    private void layoutComponents() {
        Insets insets = new Insets(5, 10, 5, 0);
        this.add((Component)this._hint, this.gbc(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add(this._urlInputPanel, this.gbc(0, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add(this._revSelectionPanel, this.gbc(0, 2, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add(this._wcRevListerPanel, this.gbc(0, 3, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add(Box.createVerticalGlue(), this.gbc(0, 4, 1, 1, 0.0, 1.0, 15, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initListeners() {
    }
}

