/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.mergewiz.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdevimpl.vcs.svn.mergewiz.ui.SVNUrlProvider;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRevisionLister;
import oracle.jdevimpl.vcs.svn.op.ui.ValidatedPanel;
import oracle.jdevimpl.vcs.svn.res.Resource;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;

public class RevisionSelectionPanel
extends ValidatedPanel
implements ActionListener {
    private JLabel _label;
    private JTextField _field;
    private JButton _button;
    private JCheckBox _reverseCheckBox;
    private SVNRevisionRange[] _revisionranges = new SVNRevisionRange[]{new SVNRevisionRange((SVNRevision)new SVNRevision.Number(0L), SVNRevision.HEAD)};
    private SVNUrlProvider _svnurlProvider;

    public RevisionSelectionPanel(SVNUrlProvider svnurlProvider) {
        super(new GridBagLayout());
        this._svnurlProvider = svnurlProvider;
        this.createComponents();
        this.layoutComponents();
    }

    @Override
    public void initListeners() {
    }

    @Override
    public boolean validateContent() {
        return true;
    }

    private void createComponents() {
        this._label = new JLabel();
        this._field = new JTextField();
        ResourceUtils.resLabel((JLabel)this._label, (Component)this._field, (String)Resource.get("UI_REVISIONSELECTIONPANEL_LABEL"));
        this._field.setEditable(true);
        this._field.setText("0-HEAD");
        this._button = new JButton();
        this._button.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._button, (String)Resource.get("UI_DEFAULT_REVLISTER_BTN_TEXT"));
        this._reverseCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._reverseCheckBox, (String)Resource.get("UI_REVISIONSELECTIONPANEL_REVERSE_CHECKBOX"));
    }

    private void layoutComponents() {
        Insets insets = new Insets(6, 2, 2, 6);
        this.add((Component)this._label, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._field, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._button, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 2, insets, 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SVNRevisionLister revLister = new SVNRevisionLister(this._svnurlProvider.getSVNUrl(), SVNRevision.HEAD, (SVNRevision)new SVNRevision.Number(0L));
        revLister.setAllowMultipleSelection(true);
        revLister.showLister();
        this._revisionranges = revLister.getSelectedRevisions();
        if (this._revisionranges != null && this._revisionranges.length > 0) {
            this._field.setText(this.toString(this._revisionranges));
        }
    }

    public SVNRevisionRange[] getRevisionRanges() {
        this._revisionranges = this.fromString(this._field.getText());
        return this._revisionranges;
    }

    private String toString(SVNRevisionRange[] _revisionranges) {
        String result = "";
        for (SVNRevisionRange range : _revisionranges) {
            result = result.concat(range.toString()).concat(", ");
        }
        if (result.lastIndexOf(44) > 0) {
            result = result.substring(0, result.lastIndexOf(44));
        }
        return result;
    }

    private SVNRevisionRange[] fromString(String rangeStr) {
        String[] rangeStrArr;
        ArrayList<SVNRevisionRange> rangeArrList = new ArrayList<SVNRevisionRange>();
        for (String range : rangeStrArr = rangeStr.split("[\\s,;]+")) {
            String toStr;
            String fromStr;
            int hyphen = range.indexOf(45);
            if (hyphen > 0) {
                fromStr = range.substring(0, hyphen).trim();
                toStr = range.substring(hyphen + 1).trim();
            } else {
                toStr = fromStr = range.trim();
            }
            try {
                SVNRevisionRange revRange = new SVNRevisionRange(SVNRevision.getRevision((String)fromStr), SVNRevision.getRevision((String)toStr));
                if (revRange.getFromRevision() == null || revRange.getToRevision() == null) {
                    throw new ParseException(revRange.toString(), 0);
                }
                rangeArrList.add(revRange);
            }
            catch (ParseException e) {
                MessageDialog.error((Component)this, (Object)Resource.get("UI_REVISIONSELECTIONPANEL_RANGE_ERR_MESSAGE"), (String)Resource.get("UI_REVISIONSELECTIONPANEL_RANGE_ERR_TITLE"), null);
                return new SVNRevisionRange[0];
            }
        }
        return rangeArrList.toArray(new SVNRevisionRange[rangeArrList.size()]);
    }
}

