/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.mergewiz.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizardModel;
import oracle.jdevimpl.vcs.svn.mergewiz.ui.SVNUrlProvider;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryWizard;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRepositoryBrowser;
import oracle.jdevimpl.vcs.svn.op.ui.ValidatedPanel;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNUrlInputPanel
extends ValidatedPanel
implements ActionListener,
SVNUrlProvider {
    private String _labelText;
    private String _browseButtonText;
    private JLabel _label;
    private JComboBox _combo;
    private JButton _button;
    private SVNUrl _svnurl = null;
    private SVNRepositoryInfo _repoInfo;
    private SVNMergeWizardModel _model;

    public SVNUrlInputPanel(String labelText) {
        super(new GridBagLayout());
        this._labelText = labelText;
        this._browseButtonText = Resource.get("UI_DEFAULT_BROWSE_BTN_TEXT");
        this.createComponents();
        this.layoutComponents();
    }

    public SVNUrlInputPanel(String labelText, String browseButtonText) {
        this._labelText = labelText;
        this._browseButtonText = browseButtonText;
        this.createComponents();
        this.layoutComponents();
    }

    private void createComponents() {
        this._label = new JLabel();
        this._combo = new JComboBox();
        ResourceUtils.resLabel((JLabel)this._label, (Component)this._combo, (String)this._labelText);
        this._combo.setEditable(true);
        this._button = new JButton();
        this._button.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._button, (String)this._browseButtonText);
    }

    private void layoutComponents() {
        Insets insets = new Insets(6, 2, 2, 6);
        this.add((Component)this._label, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._combo, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._button, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
    }

    @Override
    public void initListeners() {
        JTextComponent editor = (JTextComponent)this._combo.getEditor().getEditorComponent();
        editor.getDocument().addDocumentListener(new ValidatedPanel.FieldListener(this));
    }

    @Override
    public boolean validateContent() {
        if (this.getSVNUrl() != null) {
            this.getModel().setFromSVNUrl(this.getSVNUrl());
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this._button)) {
            SVNRepositoryBrowser repoBrowser = this.createRepositoryBrowser(this.getSVNUrl());
            repoBrowser.addObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    String selection = ((SVNUrl)arg).toString();
                    SVNUrlComboBoxModel model = (SVNUrlComboBoxModel)SVNUrlInputPanel.this._combo.getModel();
                    List<String> urlList = model.getUrlList();
                    urlList.add(selection);
                    SVNUrlInputPanel.this.setComboBox(urlList.toArray(new String[0]), selection);
                    SVNUrlInputPanel.this.getModel().setFromSVNUrl(SVNUrlInputPanel.this.getSVNUrl());
                }
            });
            repoBrowser.showBrowser();
            return;
        }
    }

    @Override
    public SVNUrl getSVNUrl() {
        try {
            String urltxt = (String)this._combo.getEditor().getItem();
            this._svnurl = new SVNUrl(urltxt);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return this._svnurl;
    }

    private SVNRepositoryBrowser createRepositoryBrowser(SVNUrl url) {
        boolean repoCreated = true;
        this._repoInfo = SVNUtil.resolveRepository(url);
        if (this._repoInfo == null && (repoCreated = this.createTheRepository())) {
            this._repoInfo = SVNUtil.resolveRepository(url);
        }
        return new SVNRepositoryBrowser(this._repoInfo, url);
    }

    private boolean createTheRepository() {
        Wizard reposWizard = WizardManager.getInstance().getWizard(SVNRepositoryWizard.class);
        Context ctx = new Context();
        boolean success = false;
        ctx.setProperty(SVNRepositoryWizard.PROPERTY_NAME_EDITING, (Object)Boolean.FALSE);
        ctx.setProperty("PRESET_REPO_URL", (Object)this._repoInfo.getURL().toString());
        if (reposWizard != null && reposWizard.isAvailable(ctx)) {
            success = reposWizard.invoke(ctx);
        }
        return success;
    }

    public void setComboBox(String[] urlStrings, String selection) {
        final SVNUrlComboBoxModel model = new SVNUrlComboBoxModel(urlStrings);
        model.setSelectedItem(selection);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SVNUrlInputPanel.this._combo.setModel(model);
            }
        });
    }

    public void setModel(SVNMergeWizardModel _model) {
        this._model = _model;
    }

    public SVNMergeWizardModel getModel() {
        return this._model;
    }

    protected class SVNUrlComboBoxModel
    implements ComboBoxModel {
        List<String> urlList;
        Object selected;
        List<ListDataListener> listenerLists;

        public SVNUrlComboBoxModel(String[] urlStrings) {
            this.urlList = new ArrayList<String>(Arrays.asList(urlStrings));
            this.listenerLists = new ArrayList<ListDataListener>();
        }

        public SVNUrlComboBoxModel(List<String> urlList) {
            urlList = new ArrayList<String>(urlList);
            this.listenerLists = new ArrayList<ListDataListener>();
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selected = anItem;
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        @Override
        public int getSize() {
            return this.urlList.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.urlList.get(index);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listenerLists.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listenerLists.remove(l);
        }

        public List<String> getUrlList() {
            return this.urlList;
        }
    }
}

