/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.migration;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oracle.ide.migration.ExtensionMigrator;
import oracle.jdeveloper.vcs.migrate.VCSPropertyMapMigrator;
import oracle.jdeveloper.vcs.spi.VCSPropertyMap;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.prefs.SVNClientsPreferences;
import oracle.jdevimpl.vcs.svn.prefs.SVNEnvironmentPrefs;
import oracle.jdevimpl.vcs.svn.prefs.SVNVersionToolsPreferences;

public class SVNExtensionMigrator
extends VCSPropertyMapMigrator {
    private static final String CLIENT_OPTIONS_DATA_KEY = SVNProfile.getQualifiedKey("CLIENT_TECHNOLOGY");
    private static final String ENVIRONMENT_OPTIONS_DATA_KEY = SVNProfile.getQualifiedKey("oracle.jdeveloper.vcs.data.COMMON_SETTINGS");
    private static final String VERSION_TOOLS_DATA_KEY = SVNProfile.getQualifiedKey("VTOOLS_SETTINGS");
    private static final String COMMENT_TEMPLATES_DATA_KEY = SVNProfile.getQualifiedKey("COMMENT_TEMPLATES");
    private static final String PROP_KEY_CLIENT_TYPE = "clientType";
    private static final String PROP_KEY_DIALOG_POLICY = "outgoingCommitDialog";
    private static final String PROP_KEY_INCOMING_INTERVAL = "incomingInterval";
    private static final String PROP_KEY_INCOMING_INTERVAL_UNIT = "incomingIntervalUnit";
    private static final String PROP_KEY_MERGE_EDITOR = "mergeEditor";
    private static final String KEY_USE_OVERLAYS = "useOverlays";
    private static final String KEY_USE_LABEL_DECORATIONS = "useLabelDecorations";
    private static final String KEY_AUTO_ADD_NEW_FILES = "autoAddFiles";
    private static final String KEY_AUTO_LOCK = "svnAutoLock";
    private static final String KEY_USE_MEREGE_TRACKING = "svnMergeTracking";
    private static final String KEY_OPERATION_TIMEOUT = "property_operation_timeout";

    protected List getSettingKeys() {
        Object[] keys = new Object[]{CLIENT_OPTIONS_DATA_KEY, ENVIRONMENT_OPTIONS_DATA_KEY, VERSION_TOOLS_DATA_KEY, COMMENT_TEMPLATES_DATA_KEY};
        return Arrays.asList(keys);
    }

    protected String getExtensionID() {
        return "oracle.jdeveloper.subversion";
    }

    protected ExtensionMigrator.AdjustedObject[] adjustPropertyMap(String inKey, VCSPropertyMap properties) {
        Map propertyMap = properties.getMap();
        if (inKey.equals(CLIENT_OPTIONS_DATA_KEY)) {
            SVNClientsPreferences prefs = SVNClientsPreferences.getInstance(null);
            if (propertyMap.containsKey(PROP_KEY_CLIENT_TYPE)) {
                prefs.setClientType((Integer)propertyMap.get(PROP_KEY_CLIENT_TYPE));
            }
            return new ExtensionMigrator.AdjustedObject[]{new ExtensionMigrator.AdjustedObject("oracle.jdevimpl.vcs.svn.prefs.SVNClientsPreferences", (Object)prefs)};
        }
        if (inKey.equals(ENVIRONMENT_OPTIONS_DATA_KEY)) {
            SVNEnvironmentPrefs prefs = SVNEnvironmentPrefs.getInstance(null);
            if (propertyMap.containsKey(KEY_AUTO_ADD_NEW_FILES)) {
                prefs.setAutoAddFiles((Boolean)propertyMap.get(KEY_AUTO_ADD_NEW_FILES));
            }
            if (propertyMap.containsKey(KEY_AUTO_LOCK)) {
                prefs.setAutoLock((Boolean)propertyMap.get(KEY_AUTO_LOCK));
            }
            if (propertyMap.containsKey(KEY_OPERATION_TIMEOUT)) {
                prefs.setOperationTimeout((Integer)propertyMap.get(KEY_OPERATION_TIMEOUT));
            }
            if (propertyMap.containsKey(KEY_USE_LABEL_DECORATIONS)) {
                prefs.setUseLabelDecorations((Boolean)propertyMap.get(KEY_USE_LABEL_DECORATIONS));
            }
            if (propertyMap.containsKey(KEY_USE_MEREGE_TRACKING)) {
                prefs.setUseMergeTracking((Boolean)propertyMap.get(KEY_USE_MEREGE_TRACKING));
            }
            if (propertyMap.containsKey(KEY_USE_OVERLAYS)) {
                prefs.setUseOverlays((Boolean)propertyMap.get(KEY_USE_OVERLAYS));
            }
            return new ExtensionMigrator.AdjustedObject[]{new ExtensionMigrator.AdjustedObject("oracle.jdevimpl.vcs.svn.prefs.SVNEnvironmentPrefs", (Object)prefs)};
        }
        if (inKey.equals(VERSION_TOOLS_DATA_KEY)) {
            SVNVersionToolsPreferences prefs = SVNVersionToolsPreferences.getInstance(null);
            if (propertyMap.containsKey(PROP_KEY_INCOMING_INTERVAL)) {
                prefs.setIncomingInterval((Integer)propertyMap.get(PROP_KEY_INCOMING_INTERVAL));
            }
            if (propertyMap.containsKey(PROP_KEY_INCOMING_INTERVAL_UNIT)) {
                prefs.setIncomingIntervalUnit((String)propertyMap.get(PROP_KEY_INCOMING_INTERVAL_UNIT));
            }
            if (propertyMap.containsKey(PROP_KEY_MERGE_EDITOR)) {
                prefs.setMergeEditor((Integer)propertyMap.get(PROP_KEY_MERGE_EDITOR));
            }
            if (propertyMap.containsKey(PROP_KEY_DIALOG_POLICY)) {
                prefs.setOutgoingCommitDialog((Integer)propertyMap.get(PROP_KEY_DIALOG_POLICY));
            }
            return new ExtensionMigrator.AdjustedObject[]{new ExtensionMigrator.AdjustedObject("oracle.jdevimpl.vcs.svn.prefs.SVNVersionToolsPreferences", (Object)prefs)};
        }
        if (inKey.equals(COMMENT_TEMPLATES_DATA_KEY)) {
            return this.createAdjustedCommentTemplatesObject(properties);
        }
        return new ExtensionMigrator.AdjustedObject[0];
    }
}

