/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;
import oracle.jdevimpl.vcs.svn.nav.NavPropertiesTableModel;
import oracle.jdevimpl.vcs.svn.properties.ui.PropertiesPanel;
import oracle.jdevimpl.vcs.svn.res.Resource;

public class NavPropertyPanel
extends JPanel {
    private JLabel _repositoryURLLabel;
    private JTextField _repositoryURLField;
    private JLabel _lastChangedRevLabel;
    private JTextField _lastChangedRevField;
    private JLabel _lastChangedDateLabel;
    private JTextField _lastChangedDateField;
    private JLabel _lastCommitAuthorLabel;
    private JTextField _lastCommitAuthorField;
    private JLabel _lockOwnerLabel;
    private JTextField _lockOwnerField;
    private JLabel _lockCreationDateLabel;
    private JTextField _lockCreationDateField;
    private JLabel _lockCommentLabel;
    private JTextArea _lockCommentField;
    private JLabel _propertyLabel;
    private JPanel _propertiesPanel;
    private GenericTable _table;
    private NavPropertiesTableModel _model;

    public NavPropertyPanel() {
        super(new GridBagLayout());
        this.createComponents();
        this.layoutComponents();
    }

    private void createComponents() {
        this._repositoryURLField = new JTextField();
        this._repositoryURLLabel = new JLabel();
        this.initTextField(this._repositoryURLField);
        ResourceUtils.resLabel((JLabel)this._repositoryURLLabel, (Component)this._repositoryURLField, (String)Resource.get("URL_PROPS_UI_REPOS_URL"));
        this._lastChangedRevField = new JTextField();
        this._lastChangedRevLabel = new JLabel();
        this.initTextField(this._lastChangedRevField);
        ResourceUtils.resLabel((JLabel)this._lastChangedRevLabel, (Component)this._lastChangedRevField, (String)Resource.get("URL_PROPS_UI_LAST_CHANGED_REV"));
        this._lastChangedDateField = new JTextField();
        this._lastChangedDateLabel = new JLabel();
        this.initTextField(this._lastChangedDateField);
        ResourceUtils.resLabel((JLabel)this._lastChangedDateLabel, (Component)this._lastChangedDateField, (String)Resource.get("URL_PROPS_UI_LAST_CHANGED_DATE"));
        this._lastCommitAuthorField = new JTextField();
        this._lastCommitAuthorLabel = new JLabel();
        this.initTextField(this._lastCommitAuthorField);
        ResourceUtils.resLabel((JLabel)this._lastCommitAuthorLabel, (Component)this._lastCommitAuthorField, (String)Resource.get("URL_PROPS_UI_LAST_COMMIT_AUTHOR"));
        this._lockOwnerField = new JTextField();
        this._lockOwnerLabel = new JLabel();
        this.initTextField(this._lockOwnerField);
        ResourceUtils.resLabel((JLabel)this._lockOwnerLabel, (Component)this._lockOwnerField, (String)Resource.get("URL_PROPS_UI_LOCK_OWNER"));
        this._lockCreationDateField = new JTextField();
        this._lockCreationDateLabel = new JLabel();
        this.initTextField(this._lockCreationDateField);
        ResourceUtils.resLabel((JLabel)this._lockCreationDateLabel, (Component)this._lockCreationDateField, (String)Resource.get("URL_PROPS_UI_LOCK_CREATION_DATE"));
        this._lockCommentField = new JTextArea();
        this._lockCommentLabel = new JLabel();
        this.initTextArea(this._lockCommentField);
        ResourceUtils.resLabel((JLabel)this._lockCommentLabel, (Component)this._lockCommentField, (String)Resource.get("URL_PROPS_UI_LOCK_COMMENT"));
        this._table = this.getTable();
        this._propertyLabel = new JLabel();
        this._propertiesPanel = new PropertiesPanel((JTable)this._table);
        ResourceUtils.resLabel((JLabel)this._propertyLabel, (Component)this._propertiesPanel, (String)Resource.get("NAV_PROPS_UI_SVN_PROPERTIES"));
        this._propertiesPanel.setMinimumSize(new Dimension(400, 80));
        this._propertiesPanel.setPreferredSize(new Dimension(400, 80));
    }

    private void layoutComponents() {
        Insets labelInsets = new Insets(3, 0, 3, 3);
        Insets fieldInsets = new Insets(3, 3, 3, 0);
        this.add((Component)this._repositoryURLLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._repositoryURLField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._lastChangedRevLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._lastChangedRevField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._lastChangedDateLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._lastChangedDateField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._lastCommitAuthorLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._lastCommitAuthorField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._lockOwnerLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._lockOwnerField, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._lockCreationDateLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._lockCreationDateField, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, fieldInsets, 0, 0));
        this.add((Component)this._lockCommentLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        JScrollPane panel = new JScrollPane(this._lockCommentField);
        panel.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)panel, new GridBagConstraints(1, 6, 1, 3, 1.0, 1.0, 17, 1, fieldInsets, 0, 0));
        this.add((Component)this._propertyLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0));
        this.add((Component)this._propertiesPanel, new GridBagConstraints(0, 10, 2, 5, 1.0, 1.0, 17, 1, fieldInsets, 0, 0));
    }

    private void initTextField(JTextField field) {
        if (field != null) {
            field.setBorder(BorderFactory.createEmptyBorder());
            field.setEditable(false);
        }
    }

    private void initTextArea(JTextArea field) {
        if (field != null) {
            field.setBorder(BorderFactory.createEmptyBorder());
            field.setEditable(false);
            field.setLineWrap(true);
            field.setWrapStyleWord(true);
            field.setRows(3);
        }
    }

    public void setRepositoryURLField(String url) {
        this._repositoryURLField.setText(url);
        this._repositoryURLField.setToolTipText(url);
    }

    public void setLastChangedRevField(String revision) {
        this._lastChangedRevField.setText(revision);
    }

    public void setLastChangedDateField(String date) {
        this._lastChangedDateField.setText(date);
    }

    public void setLastCommitAuthorField(String author) {
        this._lastCommitAuthorField.setText(author);
    }

    public void setLockOwnerField(String lockOwner) {
        this._lockOwnerField.setText(lockOwner);
    }

    public void setLockCreationDateField(String lockDate) {
        this._lockCreationDateField.setText(lockDate);
    }

    public void setLockCommentField(String lockComment) {
        this._lockCommentField.setText(lockComment);
    }

    private GenericTable getTable() {
        if (this._table == null) {
            this._table = new GenericTable((TableModel)((Object)this.getTableModel()));
            this._table.setAutoResizeMode(1);
            this._table.setSortColumn(0, false);
            Object[] prototypeValues = new String[]{"reasonablylongname", "reasonablelongpropertyvaluereasonablelongpropertyvalue"};
            this._table.autoSizeColumnsToFit(prototypeValues);
            TableColumn column = this._table.getColumnModel().getColumn(1);
            column.setCellEditor(new SVNPropTableCellEditor());
        }
        return this._table;
    }

    public NavPropertiesTableModel getTableModel() {
        if (this._model == null) {
            this._model = new NavPropertiesTableModel();
        }
        return this._model;
    }

    private static class PropertyDetailPanel
    extends JPanel {
        private JTextArea _field = new JTextArea();

        PropertyDetailPanel() {
            this._field.setEditable(false);
            this._field.setWrapStyleWord(false);
            this._field.setLineWrap(true);
            this.setLayout(new BorderLayout());
            this.add(new JScrollPane(this._field));
        }

        void setText(String text) {
            this._field.setText(text);
        }

        private Component getInitialFocus() {
            return this._field;
        }
    }

    private static class ColumnPropertyPanel
    extends JPanel {
        private JTextField _field = new JTextField();
        private JButton _button = new JButton(OracleIcons.getIcon((String)"text.png"));

        private ColumnPropertyPanel() {
            this.initLayout();
            this.initListeners();
        }

        private void initLayout() {
            this.setLayout(new BorderLayout());
            this._field.setEditable(false);
            this._button.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            this.add((Component)this._field, "Center");
            this.add((Component)this._button, "East");
        }

        private void initListeners() {
            this._button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertyDetailPanel detailPanel = new PropertyDetailPanel();
                    detailPanel.setText(ColumnPropertyPanel.this._field.getText());
                    JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)ColumnPropertyPanel.this, (Component)detailPanel, (Component)detailPanel.getInitialFocus(), (String)Resource.get("DETAIL_PROPERTY_TITLE"), (int)1);
                    dialog.setMinimumSize(450, 200);
                    dialog.runDialog();
                }
            });
        }

        void setText(String text) {
            this._field.setText(text);
        }

        String getText() {
            return this._field.getText();
        }
    }

    private static class SVNPropTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private ColumnPropertyPanel component = new ColumnPropertyPanel();

        private SVNPropTableCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.component.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.component.setText((String)value);
            return this.component;
        }
    }
}

