/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.net.URLFactory;
import oracle.ide.view.View;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.PropertyEditorPanel;
import oracle.jdevimpl.vcs.svn.op.ui.ValidatedPanel;
import oracle.jdevimpl.vcs.svn.properties.SVNPropertiesWindow;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import oracle.jdevimpl.vcs.util.ListFilesUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SVNOperationAddProperty
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.addproperty";
    private JEWTDialog _dialog;
    private PropertyEditorPanel _panel;
    private File[] _resourceFiles;
    private SVNPropertiesWindow _propertiesWindow;
    private URL[] _selectedUrls;

    public SVNOperationAddProperty() {
        super(COMMAND_ID);
    }

    public SVNOperationAddProperty(String commandID) {
        super(commandID);
    }

    @Override
    protected boolean isAvailableImpl() throws Exception {
        if (this.getContext() == null) {
            return super.isAvailableImpl();
        }
        View view = this.getContext().getView();
        if (this.isSVNPropertiesWindowView(view)) {
            this._propertiesWindow = (SVNPropertiesWindow)view;
            File[] files = this._propertiesWindow.getContextResources();
            if (this.isVersioned(files)) {
                return true;
            }
        }
        return super.isAvailableImpl();
    }

    @Override
    protected boolean invokeCommand(VCSProfile profile, CommandState commandState) throws Exception {
        if (commandState.getLocatables().length == 1) {
            return this.invokeCommandImpl(profile, commandState, VCSWindowUtils.getCurrentWindow(), null);
        }
        return super.invokeCommand(profile, commandState);
    }

    protected boolean invokeCommandImpl(VCSProfile profile, CommandState state, Component parentUi, Map options) throws Exception {
        this._selectedUrls = VCSModelUtils.convertNodesToURLs((Locatable[])state.getLocatables());
        this._resourceFiles = this.getResourceFiles(this._selectedUrls);
        if (this._resourceFiles == null || this._resourceFiles.length == 0) {
            return false;
        }
        this._panel = this.createPanel();
        if (this._panel == null) {
            return false;
        }
        this._dialog = this.createDialog();
        this.initListeners(state);
        if (this._dialog.runDialog()) {
            this.refreshSVNPropertiesWindowView();
            return true;
        }
        return false;
    }

    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        return this.invokeCommandImpl(profile, commandState, null, options);
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        View view = this.getContext().getView();
        if (this.isSVNPropertiesWindowView(view)) {
            Context context = ((SVNPropertiesWindow)view).getViewContext();
            Collection c = this.getActionInfo().getFilteredSelection(context);
            return c.toArray(new Locatable[c.size()]);
        }
        return super.getOperands(profile);
    }

    protected PropertyEditorPanel createPanel() {
        PropertyEditorPanel panel = new PropertyEditorPanel(this.isFolderSelected());
        if (this._resourceFiles != null && this._resourceFiles.length > 0) {
            panel.setResourceField(this._resourceFiles);
        }
        return panel;
    }

    protected JEWTDialog createDialog() {
        String title = Resource.get("UI_ADDPROPERTY_DIALOG_TITLE");
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), title, 7);
        dialog.setDefaultButton(1);
        dialog.setContent((Component)this.getPanel());
        dialog.setResizable(true);
        dialog.setOKButtonEnabled(false);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.getPanel(), "f1_svnaddproperty_html");
        return dialog;
    }

    protected void initListeners(final CommandState state) {
        this._dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
                if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                    return;
                }
                if (!SVNOperationAddProperty.this.executePropertySetting(state)) {
                    throw new PropertyVetoException("", pce);
                }
            }
        });
        this._panel.addListener(new ValidatedPanel.PanelValidationListener(){

            @Override
            public void onReceiveValidationResult(boolean validationResult) {
                SVNOperationAddProperty.this.setOKButton(validationResult);
            }
        });
    }

    protected JTable getTable() {
        JTable table = null;
        View view = this.getContext().getView();
        if (this.isSVNPropertiesWindowView(view)) {
            table = ((SVNPropertiesWindow)view).getTable();
        }
        return table;
    }

    private void setOKButton(final boolean containsValidContent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SVNOperationAddProperty.this._dialog.setOKButtonEnabled(containsValidContent);
            }
        });
    }

    protected PropertyEditorPanel getPanel() {
        return this._panel;
    }

    protected JEWTDialog getDialog() {
        return this._dialog;
    }

    protected URL[] getSelectedUrls() {
        return this._selectedUrls;
    }

    private File[] getResourceFiles(URL[] urls) {
        if (urls == null || urls.length == 0) {
            return new File[0];
        }
        File[] files = SVNUtil.toFiles(urls);
        return files;
    }

    private boolean isStringValue() {
        return this._panel.getStringRadioStatus();
    }

    protected boolean isProjectNavigatorView(View view) {
        return view == null ? false : view.getId().equals("_SUB_ApplicationNavigatorWindow._SUB_ApplicationNavigatorName");
    }

    protected boolean isSVNPropertiesWindowView(View view) {
        return view == null ? false : view.getId().equals(SVNPropertiesWindow.VIEW_ID.getId());
    }

    private boolean isFolderSelected() {
        Context context = this.getContext();
        if (context == null) {
            return false;
        }
        Element[] selectedElements = context.getSelection();
        if (selectedElements == null || selectedElements.length == 0) {
            return false;
        }
        return selectedElements[0] instanceof RelativeDirectoryContextFolder;
    }

    private void refreshSVNPropertiesWindowView() {
        SVNPropertiesWindow view = this.tryGetPropertyWindow();
        if (view != null) {
            view.refresh();
        }
    }

    private SVNPropertiesWindow tryGetPropertyWindow() {
        if (this._propertiesWindow != null) {
            return this._propertiesWindow;
        }
        List viewList = Ide.getMainWindow().getVisibleViews();
        for (View view : viewList) {
            if (!this.isSVNPropertiesWindowView(view)) continue;
            return (SVNPropertiesWindow)view;
        }
        return null;
    }

    private File[] parseResourceFiles(String resourcesStr) {
        String[] fileStr = resourcesStr.split(";");
        ArrayList<File> resourceFileArr = new ArrayList<File>();
        for (String str : fileStr) {
            File file = new File(str);
            if (!file.exists()) continue;
            resourceFileArr.add(file);
        }
        return resourceFileArr.toArray(new File[resourceFileArr.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executePropertySetting(CommandState state) {
        File[] resourceFiles = this.parseResourceFiles(this._panel.getResourceField());
        if (resourceFiles == null || resourceFiles.length == 0) {
            return false;
        }
        String propertyName = this._panel.getPropertyName();
        boolean isRecursive = this._panel.getRecursive();
        try {
            ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(svnClient, null);
            if (this.isStringValue()) {
                String propertyValueString = this._panel.getStringPropertyValue();
                for (File resourceFile : resourceFiles) {
                    svnClient.propertySet(resourceFile, propertyName, propertyValueString, isRecursive);
                }
            } else {
                File propertyValueFile = new File(this._panel.getFilePropertyValue());
                for (File resourceFile : resourceFiles) {
                    svnClient.propertySet(resourceFile, propertyName, propertyValueFile, isRecursive);
                }
            }
            this.getProcessedUrlsNotifier(state).addAll(this.listProcessedURLsFromFiles(resourceFiles, true));
        }
        catch (SVNClientException e) {
            this.getExceptionHandler().handleException(SVNExceptionWrapper.wrapException((Exception)((Object)e)));
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            this.getExceptionHandler().handleException((Exception)ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
        return true;
    }

    protected Collection<URL> listProcessedURLsFromFiles(File[] resourceFiles, boolean isRecursive) {
        ArrayList<URL> processedUrls = new ArrayList<URL>();
        for (File resourceFile : resourceFiles) {
            URL url = resourceFile.isDirectory() ? URLFactory.newDirURL((File)resourceFile) : URLFactory.newFileURL((File)resourceFile);
            processedUrls.add(url);
            if (!isRecursive || !resourceFile.isDirectory()) continue;
            processedUrls.addAll(ListFilesUtil.listFiles((URL)url, (int)7, (String)".svn"));
        }
        return processedUrls;
    }

    private boolean isVersioned(File[] files) throws Exception {
        if (files == null) {
            return false;
        }
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
        for (File file : files) {
            if (!((VCSStatus)profile.getPolicyStatusCache().get(URLFactory.newFileURL((File)file))).isVersioned()) continue;
            return true;
        }
        return false;
    }
}

