/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.vcs.annotations.Annotations;
import oracle.jdeveloper.vcs.annotations.AnnotationsCommand;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SVNOperationViewAnnotation
extends AnnotationsCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.viewannotation";

    public SVNOperationViewAnnotation() {
        super(Ide.findOrCreateCmdID((String)COMMAND_ID));
    }

    protected boolean isUnmodifiedStatus(VCSStatus status) {
        return status == VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion").getStatusInstance("UNMODIFIED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Annotations getAnnotations(File file) {
        try {
            final HashMap<Long, String> msgs = new HashMap<Long, String>();
            URL url = URLFactory.newFileURL((File)file);
            SVNRepositoryInfo repos = SVNUtil.getFirstAssociatedRepository(url);
            SVNLogClient lclient = SVNUtil.getLogClient(repos);
            File[] files = new File[]{file};
            lclient.doLog(files, SVNRevision.WORKING, SVNRevision.create((long)1L), true, false, 100L, new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                    msgs.put(new Long(logEntry.getRevision()), logEntry.getMessage());
                }
            });
            ISVNAnnotateHandlerImpl handler = new ISVNAnnotateHandlerImpl(msgs);
            lclient.doAnnotate(file, SVNRevision.BASE, SVNRevision.create((long)1L), SVNRevision.WORKING, (ISVNAnnotateHandler)handler);
            ISVNAnnotateHandlerImpl iSVNAnnotateHandlerImpl = handler;
            return iSVNAnnotateHandlerImpl;
        }
        catch (SVNException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
            Annotations annotations = null;
            return annotations;
        }
        catch (IOException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
            Annotations annotations = null;
            return annotations;
        }
        finally {
            SVNProfile.getQualifiedLogger(SVNOperationViewAnnotation.class.getName()).log(Level.INFO, "Annotations for " + file.getPath());
        }
    }

    protected Annotations getAnnotations(URL url) {
        return null;
    }

    private class SVNAnnotation {
        private Date _date;
        private long _revision;
        private String _author;
        private String _line;

        private SVNAnnotation() {
        }
    }

    private class ISVNAnnotateHandlerImpl
    extends Annotations
    implements ISVNAnnotateHandler {
        private List<SVNAnnotation> _annotates = new ArrayList<SVNAnnotation>();
        private Map<Long, String> _msgs = new HashMap<Long, String>();

        ISVNAnnotateHandlerImpl(Map<Long, String> msgs) {
            this._msgs.putAll(msgs);
        }

        public Date getChanged(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                return this._annotates.get(lineNumber)._date;
            }
            return null;
        }

        public String getRevision(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                return String.valueOf(this._annotates.get(lineNumber)._revision);
            }
            return null;
        }

        public String getAuthor(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                return this._annotates.get(lineNumber)._author;
            }
            return null;
        }

        public String getLine(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                return this._annotates.get(lineNumber)._line;
            }
            return null;
        }

        public int getLineCount() {
            return this._annotates.size();
        }

        public String getComment(int lineNumber) {
            if (lineNumber < this.getLineCount()) {
                Long rev = this._annotates.get(lineNumber)._revision;
                return this._msgs.get(rev);
            }
            return null;
        }

        public void handleLine(Date date, long revision, String author, String line) throws SVNException {
            SVNAnnotation annotation = new SVNAnnotation();
            annotation._date = date;
            annotation._author = author;
            annotation._line = line;
            annotation._revision = revision;
        }

        public void handleLine(Date date, long revision, String author, String line, Date mergedDate, long mergedRevision, String mergedAuthor, String mergedPath, int lineNumber) throws SVNException {
            SVNAnnotation annotation = new SVNAnnotation();
            annotation._date = date;
            annotation._author = author;
            annotation._line = line;
            annotation._revision = revision;
            this._annotates.add(lineNumber, annotation);
        }

        public boolean handleRevision(Date date, long revision, String author, File contents) throws SVNException {
            return false;
        }

        public void handleEOF() throws SVNException {
        }
    }
}

