/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizerAdapter;
import oracle.jdevimpl.vcs.svn.op.ui.DepthOperationPanel;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRevisionLister;
import oracle.jdevimpl.vcs.svn.res.Resource;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class UpdateCustomizer
extends VCSOptionsCustomizerAdapter {
    private final SVNRevision _revisionStart = SVNRevision.HEAD;
    private final SVNRevision _revisionEnd = new SVNRevision.Number(0L);
    private SVNUrl _reposUrl;
    private UI _ui;

    public Component getComponent() {
        if (this._ui == null) {
            this._ui = new UI();
        }
        return this._ui;
    }

    public Map getOptions() {
        UI ui = (UI)this.getComponent();
        HashMap<String, Object> opts = new HashMap<String, Object>(7);
        opts.put("oracle.jdeveloper.subversion.REVISION", ui.getRevision());
        opts.put("oracle.jdeveloper.subversion.IGNORE_EXTERNALS", ui.isIgnoreExternalsSelected());
        opts.put("oracle.jdeveloper.subversion.FORCE_UPDATE", ui.isForceSelected());
        opts.put("oracle.jdeveloper.subversion.DEPTH", ui.getDepth());
        opts.put("oracle.jdeveloper.subversion.FORCE_UPDATE", ui.isForceSelected());
        return opts;
    }

    public void setOptions(Map map) {
        SVNUrl r;
        Integer i;
        Boolean b;
        UI ui = (UI)this.getComponent();
        SVNRevision revision = (SVNRevision)map.get("oracle.jdeveloper.subversion.REVISION");
        if (revision != null) {
            ui.setRevision(revision);
        }
        if ((b = (Boolean)map.get("oracle.jdeveloper.subversion.IGNORE_EXTERNALS")) != null) {
            ui.setIgnoreExternals(b);
        }
        if ((b = (Boolean)map.get("oracle.jdeveloper.subversion.FORCE_UPDATE")) != null) {
            ui.setForceSelected(b);
        }
        ui.setDepth((i = (Integer)map.get("oracle.jdeveloper.subversion.DEPTH")) != null ? i : 3);
        this._reposUrl = r = (SVNUrl)map.get("oracle.jdeveloper.subversion.LIST_REVISION_URL");
    }

    public void validateOptions() throws VCSException {
        if (SVNRevision.INVALID_REVISION.equals((Object)((UI)this.getComponent()).getRevision())) {
            throw new VCSException(Resource.get("INVALID_REVISION_ERROR_TITLE"), Resource.get("INVALID_REVISION_ERROR_MESSAGE"));
        }
    }

    private SVNUrl getFromURL() {
        return this._reposUrl;
    }

    private final class UI
    extends JPanel
    implements ActionListener {
        private JCheckBox _revisionCheck;
        private JTextField _revisionField;
        private JCheckBox _ignoreExternalsCheck;
        private DepthOperationPanel _depthPanel;
        private JCheckBox _forceCheck;
        private JButton _revisionList;

        private UI() {
            super(new GridBagLayout());
            this.createComponents();
            this.layoutComponents();
            this.listen();
        }

        public void setRevision(SVNRevision revision) {
            if (SVNRevision.HEAD.equals((Object)revision)) {
                this._revisionCheck.setSelected(false);
                this._revisionField.setText("");
                this._revisionField.setEnabled(false);
            } else {
                this._revisionCheck.setSelected(true);
                this._revisionField.setText(revision.toString());
                this._revisionField.setEnabled(true);
            }
        }

        public SVNRevision getRevision() {
            if (this._revisionCheck.isSelected()) {
                try {
                    return SVNRevision.getRevision((String)this._revisionField.getText()) != null ? SVNRevision.getRevision((String)this._revisionField.getText()) : SVNRevision.INVALID_REVISION;
                }
                catch (ParseException pe) {
                    return SVNRevision.INVALID_REVISION;
                }
            }
            return SVNRevision.HEAD;
        }

        public void setIgnoreExternals(boolean ignore) {
            this._ignoreExternalsCheck.setSelected(ignore);
        }

        public boolean isIgnoreExternalsSelected() {
            return this._ignoreExternalsCheck.isSelected();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this._revisionCheck) {
                this._revisionField.setEnabled(this._revisionCheck.isSelected());
            }
        }

        private void createComponents() {
            this._revisionCheck = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._revisionCheck, (String)Resource.get("UI_UPDATE_LABEL_REVISION"));
            this._revisionCheck.setSelected(false);
            this._revisionField = new JTextField();
            this._revisionField.setEnabled(false);
            this._ignoreExternalsCheck = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._ignoreExternalsCheck, (String)Resource.get("UI_UPDATE_LABEL_IGNORE_EXTERNALS"));
            this._ignoreExternalsCheck.setSelected(false);
            this._forceCheck = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._forceCheck, (String)Resource.get("UI_UPDATE_LABEL_FORCE"));
            this._forceCheck.setSelected(false);
            this._depthPanel = new DepthOperationPanel();
            this._revisionList = new JButton();
            ResourceUtils.resButton((AbstractButton)this._revisionList, (String)Resource.get("BUTTON_LIST_REV"));
        }

        private void layoutComponents() {
            this.add((Component)this._revisionCheck, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
            this.add((Component)this._revisionField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._revisionList, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
            this.add((Component)this._ignoreExternalsCheck, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
            this.add((Component)this._forceCheck, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
            this.add((Component)this._depthPanel, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        }

        private void listen() {
            this._revisionCheck.addActionListener(this);
            this._revisionList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SVNRevisionLister revLister = new SVNRevisionLister(UpdateCustomizer.this.getFromURL(), UpdateCustomizer.this._revisionStart, UpdateCustomizer.this._revisionEnd);
                    revLister.addObserver(new Observer(){

                        @Override
                        public void update(Observable o, Object arg) {
                            UI.this.setRevisionField((SVNRevision)arg);
                            UI.this._revisionField.setEnabled(true);
                            UI.this._revisionCheck.setSelected(true);
                        }
                    });
                    revLister.showLister();
                }
            });
        }

        public int getDepth() {
            return this._depthPanel.getDepthSelected();
        }

        public void setDepth(int depth) {
            this._depthPanel.setDepthSelected(depth);
        }

        public void setForceSelected(boolean forceSelected) {
            this._forceCheck.setSelected(forceSelected);
        }

        public boolean isForceSelected() {
            return this._forceCheck.isSelected();
        }

        private void setRevisionField(SVNRevision svnRevision) {
            this._revisionField.setText(svnRevision.toString());
        }
    }
}

