/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.prefs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.PlatformUtils;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSPreferencesTraversable;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.prefs.SVNEnvironmentPrefs;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;

public final class SVNEnvironmentTraversable
extends VCSPreferencesTraversable<SVNEnvironmentPrefs> {
    private final VCSProfile _profile;
    private UI _propertyPage;
    private static final int TIMEOUT_SCALE_SECONDS = 1;
    private static final int TIMEOUT_SCALE_MINUTES = 2;
    private static final int TIMEOUT_SCALE_HOURS = 3;

    public SVNEnvironmentTraversable() {
        this.setHelpID("f1_svnpreferencesgeneral_html");
        this._profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.subversion");
        assert (this._profile != null);
    }

    protected SVNEnvironmentPrefs getPreferences(PropertyStorage prefs) {
        return SVNEnvironmentPrefs.getInstance(prefs);
    }

    protected Component getPage() {
        if (this._propertyPage == null) {
            this._propertyPage = new UI();
        }
        return this._propertyPage;
    }

    protected void validatePreferences() throws TraversalException {
    }

    protected void savePreferences(SVNEnvironmentPrefs prefs) {
        Integer quantity;
        Integer quantity0;
        UI ui = (UI)this.getPage();
        prefs.setUseOverlays(ui.getUseOverlays());
        prefs.setUseLabelDecorations(ui.getUseLabelDecorations());
        prefs.setAutoAddFiles(ui.getAutoAddNewFiles());
        prefs.setAutoLock(ui.getAutoLock());
        prefs.setUseMergeTracking(ui.getUseMergeTracking());
        int scale = 1;
        if (ui.getOperationTimeoutHours().isSelected()) {
            scale = 3;
        }
        if (ui.getOperationTimeoutMinutes().isSelected()) {
            scale = 2;
        }
        Integer n = quantity0 = (quantity = (Integer)ui.getOperationTimeoutQuantity().getNumber()) != null ? new Integer(this.calculateTimeoutSeconds(quantity, scale)) : null;
        if (quantity0 != null) {
            prefs.setOperationTimeout(quantity0);
        }
        prefs.setShowSVNConsole(ui.getShowSVNConsole());
    }

    protected void loadPreferences(SVNEnvironmentPrefs prefs) {
        UI ui = (UI)this.getPage();
        ui.setUseOverlays(prefs.getUseOverlays());
        ui.setUseLabelDecorations(prefs.getUseLabelDecorations());
        ui.setAutoAddNewFiles(prefs.getAutoAddFiles());
        ui.setAutoLock(prefs.getAutoLock());
        ui.setUseMergeTracking(prefs.getUseMergeTracking());
        ui.setShowSVNConsole(prefs.getShowSVNConsole());
        int seconds = prefs.getOperationTimeout();
        int scale = this.calculateTimeoutScale(seconds);
        ui.getOperationTimeoutQuantity().setNumber((Number)new Integer(this.calculateTimeoutQuantity(seconds, scale)));
        if (scale == 3) {
            ui.getOperationTimeoutHours().setSelected(true);
        }
        if (scale == 2) {
            ui.getOperationTimeoutMinutes().setSelected(true);
        }
        if (scale == 1) {
            ui.getOperationTimeoutSeconds().setSelected(true);
        }
    }

    private int calculateTimeoutScale(int seconds) {
        if (seconds > 0 && seconds % 3600 == 0) {
            return 3;
        }
        if (seconds > 0 && seconds % 60 == 0) {
            return 2;
        }
        return 1;
    }

    private int calculateTimeoutQuantity(int seconds, int scale) {
        if (scale == 3) {
            return seconds / 3600;
        }
        if (scale == 2) {
            return seconds / 60;
        }
        return seconds;
    }

    private int calculateTimeoutSeconds(int quantity, int scale) {
        if (scale == 3) {
            return quantity * 3600;
        }
        if (scale == 2) {
            return quantity * 60;
        }
        return quantity;
    }

    private final class ConfigEditUI
    extends JPanel {
        Component _parent;
        File _file;
        JLabel _editLabel;
        JTextArea _editArea;
        JScrollPane _scrollPane;
        JButton _resetButton;

        public ConfigEditUI(Component parent, File file) {
            super(new GridBagLayout());
            this._parent = parent;
            this._file = file;
            this.createComponents();
            this.layoutComponents();
            this.initListeners();
            this.readFile();
        }

        private void createComponents() {
            this._editLabel = new JLabel();
            this._editArea = new JTextArea();
            ResourceUtils.resLabel((JLabel)this._editLabel, (Component)this._editArea, (String)Resource.format("PREFERENCES_EDITCONFIG_LABLE", this._file.getAbsolutePath()));
            this._editArea.setText("");
            this._editArea.setRows(25);
            this._editArea.setEditable(true);
            this._editArea.setLineWrap(false);
            this._scrollPane = new JScrollPane(this._editArea, 22, 32);
            this._scrollPane.setPreferredSize(new Dimension(400, 450));
            this._resetButton = new JButton();
            ResourceUtils.resButton((AbstractButton)this._resetButton, (String)Resource.get("PREFERENCES_EDITCONFIG_RESET"));
        }

        private void layoutComponents() {
            Insets insets = new Insets(6, 2, 2, 6);
            this.add((Component)this._editLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.add((Component)this._scrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, insets, 0, 0));
            this.add((Component)this._resetButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        }

        private void initListeners() {
            this._resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigEditUI.this.readFile();
                }
            });
        }

        void readFile() {
            Runnable readFileRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FileReader reader = null;
                    try {
                        reader = new FileReader(ConfigEditUI.this._file);
                        ConfigEditUI.this._editArea.read(reader, "");
                    }
                    catch (FileNotFoundException e) {
                        new VCSExceptionHandler().handleException((Exception)e);
                    }
                    catch (IOException e) {
                        new VCSExceptionHandler().handleException((Exception)e);
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException io) {}
                        }
                    }
                }
            };
            new Thread(readFileRunnable).start();
        }

        void writeFile() {
            Runnable writeFileRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FileWriter writer = null;
                    try {
                        writer = new FileWriter(ConfigEditUI.this._file);
                        ConfigEditUI.this._editArea.write(writer);
                    }
                    catch (IOException e) {
                        new VCSExceptionHandler().handleException((Exception)e);
                    }
                    finally {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            };
            new Thread(writeFileRunnable).start();
        }
    }

    private final class UI
    extends JPanel {
        private JLabel _envSettingsLabel;
        private JCheckBox _useOverlaysCheck;
        private JCheckBox _useDecorationsCheck;
        private JCheckBox _autoAddNewFilesCheck;
        private JCheckBox _autoLockCheck;
        private JCheckBox _useMergeTrackingCheck;
        private JCheckBox _showSVNConsoleCheck;
        private JLabel _operationTimeoutLabel;
        private JRadioButton _operationTimeoutSeconds;
        private JRadioButton _operationTimeoutMinutes;
        private JRadioButton _operationTimeoutHours;
        private NumberTextField _operationTimeoutQuantity;
        private JLabel _editConfigLable;
        private JButton _editButton;

        private UI() {
            this.createComponents();
            this.layoutComponents();
            this.initListeners();
        }

        private boolean getUseOverlays() {
            return this._useOverlaysCheck.isSelected();
        }

        private void setUseOverlays(boolean useOverlays) {
            this._useOverlaysCheck.setSelected(useOverlays);
        }

        private boolean getUseLabelDecorations() {
            return this._useDecorationsCheck.isSelected();
        }

        private void setUseLabelDecorations(boolean useDecorations) {
            this._useDecorationsCheck.setSelected(useDecorations);
        }

        private boolean getAutoAddNewFiles() {
            return this._autoAddNewFilesCheck.isSelected();
        }

        private void setAutoAddNewFiles(boolean autoAddNewFiles) {
            this._autoAddNewFilesCheck.setSelected(autoAddNewFiles);
        }

        private boolean getAutoLock() {
            return this._autoLockCheck.isSelected();
        }

        private void setAutoLock(boolean autoLock) {
            this._autoLockCheck.setSelected(autoLock);
        }

        private void setUseMergeTracking(boolean useMergeTracking) {
            this._useMergeTrackingCheck.setSelected(useMergeTracking);
        }

        private boolean getUseMergeTracking() {
            return this._useMergeTrackingCheck.isSelected();
        }

        private void setShowSVNConsole(boolean showSVNConsole) {
            this._showSVNConsoleCheck.setSelected(showSVNConsole);
        }

        private boolean getShowSVNConsole() {
            return this._showSVNConsoleCheck.isSelected();
        }

        private void createComponents() {
            this._envSettingsLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)this._envSettingsLabel, (Component)this._envSettingsLabel, (String)VCSArb.get((String)"ENVIRONMENT_SETTINGS"));
            this._useOverlaysCheck = new JCheckBox();
            this._useOverlaysCheck.setSelected(true);
            this._useOverlaysCheck.setText(VCSArb.get((String)"USE_OVERLAYS_CHECKBOX_TEXT"));
            this._useOverlaysCheck.setMnemonic(VCSArb.get((String)"USE_OVERLAYS_CHECKBOX_MNEMONIC").charAt(0));
            this._useDecorationsCheck = new JCheckBox();
            this._useDecorationsCheck.setSelected(true);
            this._useDecorationsCheck.setText(VCSArb.get((String)"USE_LABEL_DECORATIONS_TEXT"));
            this._useDecorationsCheck.setMnemonic(VCSArb.get((String)"USE_LABEL_DECORATIONS_MNEMONIC").charAt(0));
            this._autoAddNewFilesCheck = new JCheckBox();
            this._autoAddNewFilesCheck.setSelected(false);
            ResourceUtils.resButton((AbstractButton)this._autoAddNewFilesCheck, (String)Resource.get("PREFERENCES_GENERAL_AUTOADD"));
            this._autoLockCheck = new JCheckBox();
            this._autoLockCheck.setSelected(false);
            ResourceUtils.resButton((AbstractButton)this._autoLockCheck, (String)Resource.get("PREFERENCES_GENERAL_AUTOLOCK"));
            this._useMergeTrackingCheck = new JCheckBox();
            this._useMergeTrackingCheck.setSelected(false);
            ResourceUtils.resButton((AbstractButton)this._useMergeTrackingCheck, (String)Resource.get("PREFERENCES_GENERAL_MERGETRACKING"));
            this._showSVNConsoleCheck = new JCheckBox();
            this._showSVNConsoleCheck.setSelected(false);
            ResourceUtils.resButton((AbstractButton)this._showSVNConsoleCheck, (String)Resource.get("PREFERENCES_GENERAL_SVNCONSOLE"));
            this._operationTimeoutLabel = new JLabel();
            this._operationTimeoutSeconds = new JRadioButton();
            this._operationTimeoutMinutes = new JRadioButton();
            this._operationTimeoutHours = new JRadioButton();
            this._operationTimeoutQuantity = new NumberTextField();
            ResourceUtils.resLabel((JLabel)this._operationTimeoutLabel, (Component)this._operationTimeoutQuantity, (String)VCSArb.get((String)"OPERATION_TIMEOUT"));
            ResourceUtils.resButton((AbstractButton)this._operationTimeoutSeconds, (String)VCSArb.get((String)"OPERATION_TIMEOUT_SECONDS"));
            ResourceUtils.resButton((AbstractButton)this._operationTimeoutMinutes, (String)VCSArb.get((String)"OPERATION_TIMEOUT_MINUTES"));
            ResourceUtils.resButton((AbstractButton)this._operationTimeoutHours, (String)VCSArb.get((String)"OPERATION_TIMEOUT_HOURS"));
            ButtonGroup operationTimeoutButtonGroup = new ButtonGroup();
            operationTimeoutButtonGroup.add(this._operationTimeoutSeconds);
            operationTimeoutButtonGroup.add(this._operationTimeoutMinutes);
            operationTimeoutButtonGroup.add(this._operationTimeoutHours);
            operationTimeoutButtonGroup = null;
            this._operationTimeoutQuantity.setColumns(10);
            this._operationTimeoutQuantity.setDecimal(true);
            this._operationTimeoutQuantity.setSigned(false);
            this._operationTimeoutQuantity.setDataType(Integer.class);
            this._editConfigLable = new JLabel();
            this._editButton = new JButton();
            ResourceUtils.resLabel((JLabel)this._editConfigLable, (Component)this._editButton, (String)Resource.get("PREFERENCES_GENERAL_EDITCONFIG_LABLE"));
            ResourceUtils.resButton((AbstractButton)this._editButton, (String)Resource.get("PREFERENCES_GENERAL_EDITCONFIG_BUTTON"));
        }

        private void layoutComponents() {
            Insets insets = new Insets(2, 2, 2, 2);
            LayoutBuilder builder = new LayoutBuilder();
            builder.setDefaultAnchor(18);
            builder.add((Component)this._envSettingsLabel, insets, 3, false, true);
            builder.nl();
            builder.setDefaultAnchor(18);
            builder.addHGap();
            builder.add((Component)this._useOverlaysCheck, insets, 3, false, true);
            builder.nl();
            builder.addHGap();
            builder.add((Component)this._useDecorationsCheck, insets, 3, false, true);
            builder.nl();
            builder.addHGap();
            builder.add((Component)this._autoAddNewFilesCheck, insets, 30, false, true);
            builder.nl();
            builder.addHGap();
            builder.add((Component)this._autoLockCheck, insets, 30, false, true);
            builder.nl();
            builder.addHGap();
            builder.add((Component)this._useMergeTrackingCheck, insets, 30, false, true);
            builder.nl();
            builder.addHGap();
            builder.add((Component)this._showSVNConsoleCheck, insets, 30, false, true);
            builder.nl();
            builder.setDefaultAnchor(18);
            builder.addVGap();
            builder.nl();
            builder.add((Component)this._operationTimeoutLabel, insets, 4, false, true);
            builder.nl();
            builder.addHGap();
            builder.add((Component)this._operationTimeoutQuantity, insets, 1, false, true);
            builder.add((Component)this._operationTimeoutSeconds, insets, 1, false, true);
            builder.add((Component)this._operationTimeoutMinutes, insets, 1, false, true);
            builder.add((Component)this._operationTimeoutHours, insets, 1, false, true);
            builder.addHFiller();
            builder.nl();
            builder.addVGap();
            builder.nl();
            builder.add((Component)this._editConfigLable, insets, 4, false, true);
            builder.nl();
            builder.addHGap();
            builder.add((Component)this._editButton, insets, 2, false, true, 13, 0);
            builder.nl();
            builder.addVGap();
            builder.nl();
            builder.addToPanel((Container)this);
        }

        private void initListeners() {
            this._editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigEditUI configEditUI;
                    File _serversFile = null;
                    try {
                        _serversFile = UI.this.locateServersFile();
                    }
                    catch (IOException ex) {
                        SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(ex.getMessage());
                        MessageDialog.error((Component)UI.this, (Object)ex.getMessage(), (String)Resource.get("PREFERENCES_EDITCONFIG_NOSERVERS_TITLE"), null);
                    }
                    if (_serversFile != null && this.createDialog(configEditUI = new ConfigEditUI(UI.this, _serversFile)).runDialog()) {
                        configEditUI.writeFile();
                    }
                }

                private JEWTDialog createDialog(JPanel configEditUI) {
                    JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)configEditUI, null, (String)Resource.get("PREFERENCES_EDITCONFIG_DIALOG_TITLE"), (int)7);
                    HelpSystem.getHelpSystem().registerTopic((JComponent)configEditUI, "f1_svneditconfig_html");
                    return dialog;
                }
            });
        }

        private File locateServersFile() throws IOException {
            String currentUserDir = System.getProperty("user.home");
            File currentUserDirFile = new File(currentUserDir);
            String serversFilePath = null;
            File serversFile = null;
            URL configURL = SVNUtil.getConfigDirectory();
            serversFilePath = configURL != null ? URLFactory.newURL((URL)configURL, (String)"servers").getPath() : (PlatformUtils.isWindows() ? currentUserDirFile.getCanonicalPath().concat("\\Application Data\\Subversion\\servers") : currentUserDirFile.getCanonicalPath().concat("/.subversion/servers"));
            serversFile = new File(serversFilePath);
            if (serversFile.exists()) {
                return serversFile;
            }
            if (MessageDialog.confirm((Component)this, (Object)Resource.get("PREFERENCES_EDITCONFIG_NOSERVERS_MSG"), (String)Resource.get("PREFERENCES_EDITCONFIG_NOSERVERS_TITLE"), null)) {
                URLChooser chooser = DialogUtil.newURLChooser();
                chooser.setSelectionMode(0);
                chooser.setSelectionScope(0);
                if (chooser.showOpenDialog((Component)this) == 0) {
                    serversFile = SVNUtil.toFile(chooser.getSelectedURL());
                }
            }
            return null;
        }

        private JRadioButton getOperationTimeoutSeconds() {
            return this._operationTimeoutSeconds;
        }

        private JRadioButton getOperationTimeoutMinutes() {
            return this._operationTimeoutMinutes;
        }

        private JRadioButton getOperationTimeoutHours() {
            return this._operationTimeoutHours;
        }

        private NumberTextField getOperationTimeoutQuantity() {
            return this._operationTimeoutQuantity;
        }
    }
}

